/*
**  This file is part of Vidalia, and is subject to the license terms in the
**  LICENSE file, found in the top level directory of this distribution. If you
**  did not receive the LICENSE file with this file, you may obtain it from the
**  Vidalia source package distributed by the Vidalia Project at
**  http://www.vidalia-project.net/. No part of Vidalia, including this file,
**  may be copied, modified, propagated, or distributed except according to the
**  terms described in the LICENSE file.
*/

/*
** \file streamitem.cpp
** \version $Id: streamitem.cpp 2362 2008-02-29 04:30:11Z edmanm $
** \brief Item representing a stream through Tor and its status
*/

#include "streamitem.h"
#include "circuitlistwidget.h"


/** Constructor */
StreamItem::StreamItem(const Stream &stream)
{
  /* Save the stream's id */
  _id = stream.id();
  
  /* Update the status and target */
  update(stream);
}

/** Updates the status of this stream item. */
void
StreamItem::update(const Stream &stream)
{
  setText(CircuitListWidget::ConnectionColumn, stream.target());
  setToolTip(CircuitListWidget::ConnectionColumn, stream.target());
  setText(CircuitListWidget::StatusColumn, stream.statusString());
  setToolTip(CircuitListWidget::StatusColumn, stream.statusString());
}

