/*
                       Model Viewport Display Windows
 */


#ifndef VIEW_H
#define VIEW_H

#include <gtk/gtk.h>
#include "vmatypes.h"
#include "v3dtex.h"
#include "viewbg.h"

#ifndef gbool
# define gbool  gboolean
#endif


#ifndef PI
# define PI	3.14159265359
#endif


/*
 *	View attributes flags:
 */
#define VMA_VIEW_FLAG_ENABLED	(1 << 0)
#define VMA_VIEW_FLAG_MAXIMIZED	(1 << 1)
#define VMA_VIEW_FLAG_SHOW_GRID	(1 << 2)
#define VMA_VIEW_FLAG_RENDER	(1 << 3)	/* 3D views only. */

#define VMA_VIEW_FLAG_FLIP_I	(1 << 8)
#define VMA_VIEW_FLAG_FLIP_J	(1 << 9)

#define VMA_VIEW_FLAG_POINTER_EMULATE_2BUTTON	(1 << 10)

#define VMA_VIEW_FLAG_BUTTON1	(1 << 11)	/* Button1 is down. */
#define VMA_VIEW_FLAG_BUTTON2	(1 << 12)	/* Button2 is down. */
#define VMA_VIEW_FLAG_BUTTON3	(1 << 13)	/* Button3 is down. */
#define VMA_VIEW_FLAG_BUTTON4	(1 << 14)	/* Button4 is down. */
#define VMA_VIEW_FLAG_BUTTON5	(1 << 15)	/* Button5 is down. */


/*
 *	Pointer drag states:
 */
#define VMA_VIEW2D_DRAG_NONE			0
#define VMA_VIEW2D_DRAG_TRANSLATE		1
#define VMA_VIEW2D_DRAG_ZOOM			2
#define VMA_VIEW2D_DRAG_SELECT_RECTANGLE	3
#define VMA_VIEW2D_DRAG_SET_CURSOR		4
#define VMA_VIEW2D_DRAG_SET_VERTEX		5
#define VMA_VIEW2D_DRAG_SET_NORMAL		6
#define VMA_VIEW2D_DRAG_SET_TEXCOORD		7

#define VMA_VIEW3D_DRAG_NONE		0
#define VMA_VIEW3D_DRAG_MOVE_TURN	1	/* Move f/b, turn l/r. */
#define VMA_VIEW3D_DRAG_MOVE_STRAFE	2	/* Move f/b/l/r. */
#define VMA_VIEW3D_DRAG_TURN		3	/* Turn u/d/l/r. */
#define VMA_VIEW3D_DRAG_VERTICAL	4	/* Move u/d/l/r. */

/*
 *	Palette structure:
 *
 *	Contains a bunch of vma_color_struct pointers, used to
 *	set the colors when drawing the views.
 *
 *	When adding new members to this structure, be sure to update
 *	prefwinop.c to ensure it updates all the members and to
 *	update all view*.c functions as well.
 */
typedef struct {
	vma_color_struct	*background,
				*point,
				*line,
				*line_strip,
				*line_loop,
				*triangle,
				*triangle_strip,
				*triangle_fan,
				*quad,
				*quad_strip,
				*polygon,
				*texture_outline,
				*texture_outline_selected,
				*heightfield,
				*grid,
				*selected,	/* Selected primitive. */
				*selected_vertex,
				*cursory,	/* Ie: rectangular select. */
				*normal_vector;

} vma_view_palette_struct;


/*
 *	2D view structure:
 */
typedef struct {

#define VMA_VIEW2D_TYPE_XY	1	/* Top-down. */
#define VMA_VIEW2D_TYPE_YZ	2	/* Side. */
#define VMA_VIEW2D_TYPE_XZ	3	/* Back. */

	gint type;	/* One of VMA_VIEW2D_TYPE_*. */
	gbool initialized;
	guint flags;	/* One of VMA_VIEW_FLAG_*. */

	GtkWidget	*toplevel,	/* A table widget. */
			*restored_parent,
			*maximized_parent,
			*menu_map_btn,
			*enabled_da,	/* `Enabled' drawing area. */
			*label_i, *label_j,
			*text_i, *text_j,
                        *maximize_btn,                                
                        *restore_btn,
			*view,
			*menu;

        GtkAdjustment *grid_spacing_adj, *viewable_dim_adj;

        /* Important menu items. */
        GtkWidget	*enabled_micheck,
			*undo_mi, *undo_milabel,
			*redo_mi, *redo_milabel,
			*jump_to_vertex_mi,
			*set_to_cursor_mi,
			*set_bgimg_mi,
			*clear_bgimg_mi,
			*maximize_restore_mi;

	gbool view_realized;

	/* Background image data. */
	view_bgimage_struct *bg_image;
	/* Original background image values, these values specify the last
	 * values used to load a background image.
	 */
	gchar *bgimage_filename;
	gdouble bgimage_offset_i,	/* Offset in meters. */
		bgimage_offset_j,
		bgimage_scale_i,	/* Pixels to meters coeff. */
		bgimage_scale_j;

	/* Cursors used on view widget. */
	GdkCursor	*translate_cur,
			*zoom_cur,
			*select_cur;

	/* Precision, in number of decimals. */
	guint position_decimals, angle_decimals;

	/* View dimension in meters, this is the square size of
	 * what's being displayed in the view.
	 */
	gdouble viewable_dim;

	/* View translation in meters. */
	gdouble v_ti, v_tj;

	/* Cursor (not pointer) positions. */
	gint w_cur_i, w_cur_j;		/* May not be correct, do not trust. */
	gdouble v_cur_i, v_cur_j;	/* Gauranteed to be accurate. */

	/* Drag information. */
	gint drag_state;		/* One of VMA_VIEW2D_DRAG_*. */
	gint w_last_i, w_last_j;
	gint w_di, w_dj;		/* Movement to last position. */

	/* Select rectangle (if drag_state is set to
	 * VMA_VIEW2D_DRAG_SELECT_RECTANGLE).
	 */
	gint w_sel_rect_i0, w_sel_rect_j0;
	gint w_sel_rect_i1, w_sel_rect_j1;

        /* Grid spacing in meters. */
        gdouble grid_spacing;

	/* Pointer back to editor. */
	gpointer editor_ptr;

        /* Callback data. Argument 1 is the client_data and argument 2
         * is the vma_view_event_*_struct.
         */
	gpointer client_data;
        void (*event_cb)(gpointer, gpointer);

	/* Color palette (pointers on color palette point to shared color
	 * structures so do not deallocate).
	 */
	vma_view_palette_struct palette;

} vma_view2d_struct;

/*
 *	3D view structure:
 */
typedef struct {

#define VMA_VIEW3D_TYPE_STANDARD	1

	gint type;	/* Always VMA_VIEW3D_TYPE_STANDARD. */
	gbool initialized;
        guint flags;	/* One of VMA_VIEW_FLAG_*. */

	GtkWidget	*toplevel,	/* A table widget. */
			*menu_map_btn,
			*enabled_da,    /* `Enabled' drawing area. */
			*render_toggle,
			*cull_toggle,
			*translations_toggle,
                        *restored_parent,
                        *maximized_parent,
			*label_x, *label_y, *label_z,
                        *text_x, *text_y, *text_z,
			*label_h, *label_p, *label_b,
			*text_h, *text_p, *text_b,
			*maximize_btn,
			*restore_btn,
			*view,
			*menu;

	GtkAdjustment *grid_spacing_adj, *move_rate_adj;

	/* Important menu items. */
        GtkWidget       *enabled_micheck,
			*undo_mi, *undo_milabel,
                        *redo_mi, *redo_milabel,
			*render_micheck,
			*cull_micheck,
			*translations_micheck,
			*enable_alpha_channel_micheck,
                        *set_bgimg_mi, 
                        *clear_bgimg_mi,
			*maximize_restore_mi;

        gbool view_realized;

        /* View background image data. */
        view_bgimage_struct *bg_image;

        /* Cursors used on view widget. */
        GdkCursor       *move_strafe_cur,
			*move_rotate_cur,
			*move_height_cur,
			*rotate_cur;

        /* Precision, in number of decimals. */
        guint position_decimals, angle_decimals;

	/* Camera perspective. */
	gdouble cam_clip_near, cam_clip_far;
	gdouble cam_fov;				/* In radians. */

	/* Camera position in meters. */
	gdouble cam_x, cam_y, cam_z;

	/* Camera attitude in radians. */
	gdouble cam_h, cam_p, cam_b;

        /* Drag information. */
        gint drag_state;
        gint w_last_i, w_last_j;


	/* Rendering states. */
	gbool	render_state,
		cull_state,
		cull_direction,	/* TRUE = counter clockwise. */
		translations_state,
		enable_alpha_channel;

	/* Grid spacing in meters. */
	gdouble grid_spacing;

	/* Move rate in meters per pixel. */
	gdouble move_rate;



        /* Pointer back to editor. */
        gpointer editor_ptr;

	/* Callback data. Argument 1 is the client_data and argument 2
         * is the vma_view_event_*_struct.
         */
	gpointer client_data;
        void (*event_cb)(gpointer, gpointer);

        /* Color palette (pointers on color palette point to shared color
         * structures so do not deallocate).
         */
        vma_view_palette_struct palette;

} vma_view3d_struct;


/*
 *      View event structures:
 */
/* 2D cursor update. */
typedef struct {
#define VMA_VIEW_EVENT_TYPE_CURSOR2D		1
        gint type;
        vma_view2d_struct *view2d;
        gint wi, wj;
        gdouble vi, vj;
        gdouble vdi, vdj;	/* Delta movement from last position. */
        gbool is_initial;       /* Reported at start of drag. */
        gbool is_final;         /* Reported at end of drag. */
} vma_view_event_cursor2d_struct;
/* 2D set vertex. */
typedef struct {
#define VMA_VIEW_EVENT_TYPE_SET2D		2
        gint type;
	vma_view2d_struct *view2d;
	gint vertex_type;	/* 0 = vertex, 1 = normal, 2 = texcoord. */
	gint wi, wj;
	gdouble vi, vj;
	gdouble vdi, vdj;	/* Delta movement from last position. */
	gbool is_initial;	/* Reported at start of drag. */
	gbool is_final;		/* Reported at end of drag. */
} vma_view_event_set2d_struct;
/* 2D set vertex to editor's 3D cursor. */
typedef struct {
#define VMA_VIEW_EVENT_TYPE_SETTOCURSOR2D	3
	gint type;
	vma_view2d_struct *view2d;
	gint vertex_type;	/* 0 = vertex, 1 = normal, 2 = texcoord. */
	gbool is_initial;
	gbool is_final;
} vma_view_event_settocursor2d_struct;
/* 2D select rectangular. */
typedef struct {
#define VMA_VIEW_EVENT_TYPE_SELECT2D		4
        gint type;
        vma_view2d_struct *view2d;
	gbool is_area;
        gint wi0, wj0;
        gdouble vi0, vj0;
        gint wi1, wj1;
        gdouble vi1, vj1;
} vma_view_event_select2d_struct;

/* No events for 3D views as of yet. */


extern gdouble ViewSanitizeDegrees(gdouble d);
extern gdouble ViewSanitizeRadians(gdouble r);

extern gbool ViewIsToolTipsEnabled(void);
extern guint ViewPositionDecimals(void);
extern guint ViewAngleDecimals(void);
extern gbool ViewRenderState(void);
extern gbool ViewCullState(void);
extern gbool ViewCullDirection(void);
extern gbool ViewTranslationsState(void);
extern gbool ViewEnableAlphaChannel(void);
extern gdouble ViewCameraClipNear(void);
extern gdouble ViewCameraClipFar(void);
extern gdouble ViewCameraFOV(void);

extern vma_view2d_struct *View2DCreate(
	void *core_ptr, void *editor,
	gint type,
	GtkWidget *restored_parent, GtkWidget *maximized_parent,
	void *client_data,
	void (*event_cb)(void *, void *)
);
extern void View2DSetPalette(
	vma_view2d_struct *v, vma_view_palette_struct *palette
);
extern gdouble View2DGetVToWCoeff(vma_view2d_struct *v);
extern gdouble View2DGetWToVCoeff(vma_view2d_struct *v);
extern gint View2DGLEnableContext(vma_view2d_struct *v);
extern void View2DUpdateMenus(vma_view2d_struct *v);
extern void View2DResetDragMods(vma_view2d_struct *v);
extern void View2DReset(vma_view2d_struct *v);
extern void View2DDestroy(vma_view2d_struct *v);

extern vma_view3d_struct *View3DCreate(
	void *core_ptr, void *editor, gint type,
	GtkWidget *restored_parent, GtkWidget *maximized_parent,
        void *client_data,
        void (*event_cb)(void *, void *)
);
extern void View3DSetPalette(
        vma_view3d_struct *v, vma_view_palette_struct *palette
);
extern gint View3DGLEnableContext(vma_view3d_struct *v);
extern void View3DUpdateMenus(vma_view3d_struct *v);
extern void View3DResetDragMods(vma_view3d_struct *v);
extern void View3DReset(vma_view3d_struct *v);
extern void View3DDestroy(vma_view3d_struct *v);


#endif	/* VIEW_H */
