/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DefaultModuleRevision;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.Status;
import fr.jayasoft.ivy.event.EndDownloadEvent;
import fr.jayasoft.ivy.event.StartDownloadEvent;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.ResourceHelper;
import fr.jayasoft.ivy.resolver.AbstractResolver;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorParser;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class BasicResolver
extends AbstractResolver {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected String _workspaceName;
    private boolean _envDependent = true;
    private List _ivyattempts = new ArrayList();
    private Map _artattempts = new HashMap();
    private Boolean _checkmodified = null;
    private boolean _checkconsistency = true;

    public BasicResolver() {
        this._workspaceName = Ivy.getLocalHostName();
    }

    public String getWorkspaceName() {
        return this._workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this._workspaceName = workspaceName;
    }

    public boolean isEnvDependent() {
        return this._envDependent;
    }

    public void setEnvDependent(boolean envDependent) {
        this._envDependent = envDependent;
    }

    public boolean isCheckmodified() {
        if (this._checkmodified == null) {
            if (this.getIvy() != null) {
                String check = this.getIvy().getVariable("ivy.resolver.default.check.modified");
                return check != null ? Boolean.valueOf(check) : false;
            }
            return false;
        }
        return this._checkmodified;
    }

    public void setCheckmodified(boolean check) {
        this._checkmodified = check;
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        ModuleRevisionId resolvedMrid;
        ModuleDescriptor md;
        ModuleDescriptorParser parser;
        ResolvedModuleRevision rmr;
        DependencyDescriptor systemDd = dd;
        dd = this.fromSystem(dd);
        this.clearIvyAttempts();
        boolean downloaded = false;
        boolean searched = false;
        Date cachedPublicationDate = null;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        int index = mrid.getRevision().indexOf("@");
        if (index != -1 && !mrid.getRevision().substring(index + 1).equals(this._workspaceName)) {
            Message.verbose("\t" + this.getName() + ": unhandled revision => " + mrid.getRevision());
            return null;
        }
        if (!mrid.isExactRevision() && !this.acceptLatest()) {
            Message.error("latest revisions not handled by " + this.getClass().getName() + ". impossible to resolve " + mrid);
            return null;
        }
        if (mrid.isExactRevision() && !this.isCheckmodified() && !dd.isChanging() && (rmr = this.findModuleInCache(data, mrid)) != null) {
            if (rmr.getDescriptor().isDefault() && rmr.getResolver() != this && this.isResolved(data, mrid)) {
                Message.verbose("\t" + this.getName() + ": found revision in cache: " + mrid + " (resolved by " + rmr.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
            } else {
                Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                return this.toSystem(rmr);
            }
        }
        URL cachedIvyURL = null;
        ResolvedResource ivyRef = this.findIvyFileRef(dd, data);
        searched = true;
        ModuleDescriptor systemMd = null;
        if (ivyRef == null) {
            parser = XmlModuleDescriptorParser.getInstance();
            md = DefaultModuleDescriptor.newDefaultInstance(mrid, dd.getAllDependencyArtifactsIncludes());
            ResolvedResource artifactRef = this.findFirstArtifactRef(md, dd, data);
            if (artifactRef == null) {
                Message.verbose("\t" + this.getName() + ": no ivy file nor artifact found for " + mrid);
                this.logIvyNotFound(mrid);
                String[] conf = md.getConfigurationsNames();
                for (int i = 0; i < conf.length; ++i) {
                    Artifact[] artifacts = md.getArtifacts(conf[i]);
                    for (int j = 0; j < artifacts.length; ++j) {
                        this.logArtifactNotFound(artifacts[j]);
                    }
                }
                return null;
            }
            Message.verbose("\t" + this.getName() + ": no ivy file found for " + mrid + ": using default data");
            this.logIvyNotFound(mrid);
            if (!mrid.isExactRevision()) {
                md.setResolvedModuleRevisionId(new ModuleRevisionId(mrid.getModuleId(), artifactRef.getRevision()));
            }
        } else {
            ResolvedModuleRevision rmr2;
            IvyNode node;
            parser = ModuleDescriptorParserRegistry.getInstance().getParser(ivyRef.getResource());
            if (parser == null) {
                Message.warn("no module descriptor parser available for " + ivyRef.getResource());
                return null;
            }
            Message.verbose("\t" + this.getName() + ": found md file for " + mrid);
            Message.verbose("\t\t=> " + ivyRef);
            Message.debug("\tparser = " + parser);
            resolvedMrid = mrid;
            if (!mrid.isExactRevision() && ModuleRevisionId.isExactRevision(ivyRef.getRevision()) && (node = this.getSystemNode(data, resolvedMrid = new ModuleRevisionId(mrid.getModuleId(), ivyRef.getRevision()))) != null && node.getModuleRevision() != null) {
                if (node.getDescriptor() != null && node.getDescriptor().isDefault()) {
                    Message.verbose("\t" + this.getName() + ": found already resolved revision: " + resolvedMrid + ": but it's a default one, maybe we can find a better one");
                } else {
                    Message.verbose("\t" + this.getName() + ": revision already resolved: " + resolvedMrid);
                    return this.toSystem(this.searchedRmr(node.getModuleRevision()));
                }
            }
            if ((rmr2 = this.findModuleInCache(data, resolvedMrid)) != null) {
                if (rmr2.getDescriptor().isDefault() && rmr2.getResolver() != this && this.isResolved(data, resolvedMrid)) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + mrid + " (resolved by " + rmr2.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    if (!this.isCheckmodified() && !dd.isChanging()) {
                        Message.verbose("\t" + this.getName() + ": revision in cache: " + mrid);
                        return this.toSystem(this.searchedRmr(rmr2));
                    }
                    long repLastModified = ivyRef.getLastModified();
                    long cacheLastModified = rmr2.getDescriptor().getLastModified();
                    if (!rmr2.getDescriptor().isDefault() && repLastModified <= cacheLastModified) {
                        Message.verbose("\t" + this.getName() + ": revision in cache (not updated): " + resolvedMrid);
                        return this.toSystem(this.searchedRmr(rmr2));
                    }
                    Message.verbose("\t" + this.getName() + ": revision in cache is not up to date: " + resolvedMrid);
                    if (dd.isChanging()) {
                        cachedPublicationDate = rmr2.getDescriptor().getResolvedPublicationDate();
                    }
                }
            }
            try {
                if (ResourceHelper.equals(ivyRef.getResource(), data.getIvy().getIvyFileInCache(data.getCache(), this.toSystem(resolvedMrid)))) {
                    Message.error("invalid configuration for resolver '" + this.getName() + "': pointing ivy files to ivy cache is forbidden !");
                    return null;
                }
                File ivyTempFile = File.createTempFile("ivy", "xml");
                ivyTempFile.deleteOnExit();
                Message.debug("\t" + this.getName() + ": downloading " + ivyRef.getResource());
                this.get(ivyRef.getResource(), ivyTempFile);
                downloaded = true;
                try {
                    cachedIvyURL = ivyTempFile.toURL();
                }
                catch (MalformedURLException ex) {
                    Message.warn("malformed url exception for temp file: " + ivyTempFile + ": " + ex.getMessage());
                    return null;
                }
            }
            catch (IOException ex) {
                Message.warn("problem while downloading ivy file: " + ivyRef.getResource() + ": " + ex.getMessage());
                return null;
            }
            try {
                md = parser.parseDescriptor(data.getIvy(), cachedIvyURL, ivyRef.getResource(), this.doValidate(data));
                Message.debug("\t" + this.getName() + ": parsed downloaded md file for " + mrid + " parsed=" + md.getModuleRevisionId());
                systemMd = this.toSystem(md);
                if (this._checkconsistency) {
                    this.checkDescriptorConsistency(mrid, md, ivyRef);
                    this.checkDescriptorConsistency(systemDd.getDependencyRevisionId(), systemMd, ivyRef);
                } else if (md instanceof DefaultModuleDescriptor) {
                    ((DefaultModuleDescriptor)md).setModuleRevisionId(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName(), ivyRef.getRevision()));
                } else {
                    Message.warn("consistency disabled with non default module descriptor... module info can't be updated, so consistency check will be done");
                    this.checkDescriptorConsistency(mrid, md, ivyRef);
                    this.checkDescriptorConsistency(systemDd.getDependencyRevisionId(), systemMd, ivyRef);
                }
                boolean deleteOldArtifacts = false;
                if (cachedPublicationDate != null && !cachedPublicationDate.equals(md.getResolvedPublicationDate())) {
                    Message.verbose(dd + " has changed: deleting old artifacts");
                    deleteOldArtifacts = true;
                }
                if (deleteOldArtifacts) {
                    String[] confs = rmr2.getDescriptor().getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        Artifact[] arts = rmr2.getDescriptor().getArtifacts(confs[i]);
                        for (int j = 0; j < arts.length; ++j) {
                            File artFile = data.getIvy().getArchiveFileInCache(data.getCache(), this.toSystem(arts[j]));
                            if (!artFile.exists()) continue;
                            Message.debug("deleting " + artFile);
                            artFile.delete();
                        }
                    }
                } else if (dd.isChanging()) {
                    Message.verbose(dd + " is changing, but has not changed: will trust cached artifacts if any");
                }
            }
            catch (IOException ex) {
                Message.warn("io problem while parsing ivy file: " + ivyRef.getResource() + ": " + ex.getMessage());
                return null;
            }
        }
        if (mrid.getRevision().startsWith("latest.")) {
            String askedStatus = mrid.getRevision().substring("latest.".length());
            if (Status.getPriority(askedStatus) < Status.getPriority(md.getStatus())) {
                Message.info("\t" + this.getName() + ": unacceptable status => was=" + md.getStatus() + " required=" + askedStatus);
                return null;
            }
        } else if (!mrid.acceptRevision(md.getModuleRevisionId().getRevision())) {
            Message.info("\t" + this.getName() + ": unacceptable revision => was=" + md.getModuleRevisionId().getRevision() + " required=" + mrid.getRevision());
            return null;
        }
        if (systemMd == null) {
            systemMd = this.toSystem(md);
        }
        if (!(resolvedMrid = mrid).isExactRevision()) {
            resolvedMrid = md.getResolvedModuleRevisionId();
            if (resolvedMrid.getRevision() == null || resolvedMrid.getRevision().length() == 0) {
                resolvedMrid = ivyRef.getRevision() == null || ivyRef.getRevision().length() == 0 || !ModuleRevisionId.isExactRevision(ivyRef.getRevision()) ? new ModuleRevisionId(resolvedMrid.getModuleId(), (this._envDependent ? "##" : "") + DATE_FORMAT.format(data.getDate()) + "@" + this._workspaceName) : new ModuleRevisionId(resolvedMrid.getModuleId(), ivyRef.getRevision());
            }
            Message.verbose("\t\t[" + resolvedMrid.getRevision() + "] " + mrid.getModuleId());
        }
        md.setResolvedModuleRevisionId(resolvedMrid);
        systemMd.setResolvedModuleRevisionId(this.toSystem(resolvedMrid));
        if (data.getDate() != null) {
            long pubDate = this.getPublicationDate(md, dd, data);
            if (pubDate > data.getDate().getTime()) {
                Message.info("\t" + this.getName() + ": unacceptable publication date => was=" + new Date(pubDate) + " required=" + data.getDate());
                return null;
            }
            if (pubDate == -1L) {
                Message.info("\t" + this.getName() + ": impossible to guess publication date: artifact missing for " + mrid);
                return null;
            }
            md.setResolvedPublicationDate(new Date(pubDate));
            systemMd.setResolvedPublicationDate(new Date(pubDate));
        }
        try {
            File ivyFile = data.getIvy().getIvyFileInCache(data.getCache(), systemMd.getResolvedModuleRevisionId());
            if (ivyRef == null) {
                XmlModuleDescriptorWriter.write(systemMd, ivyFile);
            } else {
                if (md instanceof DefaultModuleDescriptor) {
                    DefaultModuleDescriptor dmd = md;
                    if (data.getIvy().logNotConvertedExclusionRule() && dmd.isNamespaceUseful()) {
                        Message.warn("the module descriptor " + ivyRef.getResource() + " has information which can't be converted into the system namespace. It will require the availability of the namespace '" + this.getNamespace().getName() + "' to be fully usable.");
                    }
                }
                parser.toIvyFile(cachedIvyURL, ivyRef.getResource(), ivyFile, systemMd);
                long repLastModified = ivyRef.getLastModified();
                if (repLastModified > 0L) {
                    ivyFile.setLastModified(repLastModified);
                }
            }
        }
        catch (Exception e) {
            Message.warn("impossible to copy ivy file to cache : " + ivyRef.getResource());
        }
        data.getIvy().saveResolver(data.getCache(), systemMd, this.getName());
        return new DefaultModuleRevision(this, systemMd, searched, downloaded);
    }

    private boolean isResolved(ResolveData data, ModuleRevisionId mrid) {
        IvyNode node = this.getSystemNode(data, mrid);
        return node != null && node.getModuleRevision() != null;
    }

    private void checkDescriptorConsistency(ModuleRevisionId mrid, ModuleDescriptor md, ResolvedResource ivyRef) throws ParseException {
        boolean ok = true;
        if (!mrid.getOrganisation().equals(md.getModuleRevisionId().getOrganisation())) {
            Message.error("\t" + this.getName() + ": bad organisation found in " + ivyRef.getResource() + ": expected=" + mrid.getOrganisation() + " found=" + md.getModuleRevisionId().getOrganisation());
            ok = false;
        }
        if (!mrid.getName().equals(md.getModuleRevisionId().getName())) {
            Message.error("\t" + this.getName() + ": bad module name found in " + ivyRef.getResource() + ": expected=" + mrid.getName() + " found=" + md.getModuleRevisionId().getName());
            ok = false;
        }
        if (ivyRef.getRevision() != null && !ivyRef.getRevision().startsWith("working@") && !ModuleRevisionId.acceptRevision(ivyRef.getRevision(), md.getModuleRevisionId().getRevision())) {
            Message.error("\t" + this.getName() + ": bad revision found in " + ivyRef.getResource() + ": expected=" + ivyRef.getRevision() + " found=" + md.getModuleRevisionId().getRevision());
            ok = false;
        }
        if (!ok) {
            throw new ParseException("inconsistent module descriptor file found for " + mrid, 0);
        }
    }

    protected void clearIvyAttempts() {
        this._ivyattempts.clear();
        this.clearArtifactAttempts();
    }

    protected ResolvedModuleRevision searchedRmr(final ResolvedModuleRevision rmr) {
        return new ResolvedModuleRevision(){

            public boolean isSearched() {
                return true;
            }

            public boolean isDownloaded() {
                return rmr.isDownloaded();
            }

            public ModuleDescriptor getDescriptor() {
                return rmr.getDescriptor();
            }

            public Date getPublicationDate() {
                return rmr.getPublicationDate();
            }

            public ModuleRevisionId getId() {
                return rmr.getId();
            }

            public DependencyResolver getResolver() {
                return rmr.getResolver();
            }
        };
    }

    protected void logIvyAttempt(String attempt) {
        this._ivyattempts.add(attempt);
        Message.verbose("\t\ttried " + attempt);
    }

    protected void logArtifactAttempt(Artifact art, String attempt) {
        ArrayList<String> attempts = (ArrayList<String>)this._artattempts.get(art);
        if (attempts == null) {
            attempts = new ArrayList<String>();
            this._artattempts.put(art, attempts);
        }
        attempts.add(attempt);
        Message.verbose("\t\ttried " + attempt);
    }

    public void reportFailure() {
        Iterator<Object> iter = this._ivyattempts.listIterator();
        while (iter.hasNext()) {
            String m = (String)iter.next();
            Message.warn("\t\t" + this.getName() + ": tried " + m);
        }
        iter = this._artattempts.keySet().iterator();
        while (iter.hasNext()) {
            Artifact art = (Artifact)iter.next();
            List attempts = (List)this._artattempts.get(art);
            if (attempts == null) continue;
            Message.warn("\t\t" + this.getName() + ": tried artifact " + art + ":");
            ListIterator iterator = attempts.listIterator();
            while (iterator.hasNext()) {
                String m = (String)iterator.next();
                Message.warn("\t\t\t" + m);
            }
        }
    }

    public void reportFailure(Artifact art) {
        List attempts = (List)this._artattempts.get(art);
        if (attempts != null) {
            ListIterator iter = attempts.listIterator();
            while (iter.hasNext()) {
                String m = (String)iter.next();
                Message.warn("\t\t" + this.getName() + ": tried " + m);
            }
        }
    }

    protected boolean acceptLatest() {
        return true;
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache) {
        this.clearArtifactAttempts();
        DownloadReport dr = new DownloadReport();
        for (int i = 0; i < artifacts.length; ++i) {
            ArtifactDownloadReport adr;
            block10: {
                adr = new ArtifactDownloadReport(artifacts[i]);
                dr.addArtifactReport(adr);
                ivy.fireIvyEvent(new StartDownloadEvent(this, artifacts[i]));
                File archiveFile = ivy.getArchiveFileInCache(cache, artifacts[i]);
                if (archiveFile.exists()) {
                    Message.verbose("\t[NOT REQUIRED] " + artifacts[i]);
                    adr.setDownloadStatus(DownloadStatus.NO);
                    adr.setSize(archiveFile.length());
                } else {
                    ResolvedResource artifactRef;
                    Artifact artifact = this.fromSystem(artifacts[i]);
                    if (!artifact.equals(artifacts[i])) {
                        Message.verbose("\t" + this.getName() + "looking for artifact " + artifact + " (is " + artifacts[i] + " in system namespace)");
                    }
                    if ((artifactRef = this.findArtifactRef(artifact, null)) != null) {
                        if (ResourceHelper.equals(artifactRef.getResource(), archiveFile)) {
                            Message.error("invalid configuration for resolver '" + this.getName() + "': pointing artifacts to ivy cache is forbidden !");
                            return null;
                        }
                        long start = System.currentTimeMillis();
                        try {
                            Message.info("downloading " + artifactRef.getResource() + " ...");
                            File tmp = ivy.getArchiveFileInCache(cache, new DefaultArtifact(artifacts[i].getModuleRevisionId(), artifacts[i].getPublicationDate(), artifacts[i].getName(), artifacts[i].getType(), artifacts[i].getExt() + ".part"));
                            adr.setSize(this.get(artifactRef.getResource(), tmp));
                            if (!tmp.renameTo(archiveFile)) {
                                Message.warn("\t[FAILED     ] " + artifacts[i] + " impossible to move temp file to definitive one (" + (System.currentTimeMillis() - start) + "ms)");
                                adr.setDownloadStatus(DownloadStatus.FAILED);
                                break block10;
                            }
                            Message.info("\t[SUCCESSFUL ] " + artifacts[i] + " (" + (System.currentTimeMillis() - start) + "ms)");
                            adr.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                        }
                        catch (Exception ex) {
                            Message.warn("\t[FAILED     ] " + artifacts[i] + " : " + ex.getMessage() + " (" + (System.currentTimeMillis() - start) + "ms)");
                            adr.setDownloadStatus(DownloadStatus.FAILED);
                        }
                    } else {
                        this.logArtifactNotFound(artifacts[i]);
                        adr.setDownloadStatus(DownloadStatus.FAILED);
                    }
                }
            }
            ivy.fireIvyEvent(new EndDownloadEvent(this, artifacts[i], adr));
        }
        return dr;
    }

    protected void clearArtifactAttempts() {
        this._artattempts.clear();
    }

    public boolean exists(Artifact artifact) {
        ResolvedResource artifactRef = this.findArtifactRef(artifact, null);
        if (artifactRef != null) {
            return artifactRef.getResource().exists();
        }
        return false;
    }

    protected long getPublicationDate(ModuleDescriptor md, DependencyDescriptor dd, ResolveData data) {
        if (md.getPublicationDate() != null) {
            return md.getPublicationDate().getTime();
        }
        ResolvedResource artifactRef = this.findFirstArtifactRef(md, dd, data);
        if (artifactRef != null) {
            return artifactRef.getLastModified();
        }
        return -1L;
    }

    public String toString() {
        return this.getName();
    }

    public OrganisationEntry[] listOrganisations() {
        Collection names = this.findNames(Collections.EMPTY_MAP, "organisation");
        OrganisationEntry[] ret = new OrganisationEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String org = (String)iter.next();
            ret[i] = new OrganisationEntry(this, org);
            ++i;
        }
        return ret;
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        Collection names = this.findNames(tokenValues, "module");
        ModuleEntry[] ret = new ModuleEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new ModuleEntry(org, name);
            ++i;
        }
        return ret;
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", mod.getOrganisation());
        tokenValues.put("module", mod.getModule());
        Collection names = this.findNames(tokenValues, "revision");
        RevisionEntry[] ret = new RevisionEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new RevisionEntry(mod, name);
            ++i;
        }
        return ret;
    }

    protected abstract Collection findNames(Map var1, String var2);

    protected abstract ResolvedResource findIvyFileRef(DependencyDescriptor var1, ResolveData var2);

    protected ResolvedResource findFirstArtifactRef(ModuleDescriptor md, DependencyDescriptor dd, ResolveData data) {
        ResolvedResource ret = null;
        String[] conf = md.getConfigurationsNames();
        for (int i = 0; i < conf.length; ++i) {
            Artifact[] artifacts = md.getArtifacts(conf[i]);
            for (int j = 0; j < artifacts.length; ++j) {
                ret = this.findArtifactRef(artifacts[j], data.getDate());
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    protected abstract ResolvedResource findArtifactRef(Artifact var1, Date var2);

    protected abstract long get(Resource var1, File var2) throws IOException;

    protected abstract void logIvyNotFound(ModuleRevisionId var1);

    protected abstract void logArtifactNotFound(Artifact var1);

    public boolean isCheckconsistency() {
        return this._checkconsistency;
    }

    public void setCheckconsistency(boolean checkConsitency) {
        this._checkconsistency = checkConsitency;
    }
}

