/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;

public class PDFStream
extends PDFObject {
    protected ByteArrayOutputStream _data = new ByteArrayOutputStream();
    private Vector _filters = new Vector();

    public PDFStream(int n) {
        super(n);
    }

    public void add(String string) {
        try {
            this._data.write(string.getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void addDefaultFilters() {
        Vector vector = Configuration.getListValue("stream-filter-list", 1);
        if (vector == null) {
            String string = Configuration.getStringValue("stream-filter-list", 1);
            if (string == null) {
                this.addFilter(new FlateFilter());
            } else {
                this.addFilter(string);
            }
        } else {
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                this.addFilter(string);
                ++n;
            }
        }
    }

    public void addFilter(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (string.equals("ascii-85")) {
            this.addFilter(new ASCII85Filter());
        } else if (string.equals("ascii-hex")) {
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (string.equals("")) {
                return;
            }
            MessageHandler.errorln("Unsupported filter type in stream-filter-list: " + string);
        }
    }

    public void addFilter(PDFFilter pDFFilter) {
        if (pDFFilter != null) {
            this._filters.addElement(pDFFilter);
        }
    }

    public void addImageArray(int[] nArray, int n, int n2) {
        try {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = nArray[n3 * n + n4];
                    int n6 = n5 >> 16 & 0xFF;
                    int n7 = n5 >> 8 & 0xFF;
                    int n8 = n5 & 0xFF;
                    if (n6 < 16) {
                        this._data.write(48);
                    }
                    this._data.write(Integer.toHexString(n6).getBytes());
                    if (n7 < 16) {
                        this._data.write(48);
                    }
                    this._data.write(Integer.toHexString(n7).getBytes());
                    if (n8 < 16) {
                        this._data.write(48);
                    }
                    this._data.write(Integer.toHexString(n8).getBytes());
                    this._data.write(32);
                    ++n4;
                }
                ++n3;
            }
            this._data.write(">\n".getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected String applyFilters() throws IOException {
        if (this._filters.size() > 0) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = this._filters.elements();
            while (enumeration.hasMoreElements()) {
                PDFFilter pDFFilter = (PDFFilter)enumeration.nextElement();
                if (!pDFFilter.isApplied()) {
                    byte[] byArray = pDFFilter.encode(this._data.toByteArray());
                    this._data.reset();
                    this._data.write(byArray);
                    pDFFilter.setApplied(true);
                }
                vector.insertElementAt(pDFFilter.getName(), 0);
                vector2.insertElementAt(pDFFilter.getDecodeParms(), 0);
            }
            return String.valueOf(this.buildFilterEntries(vector)) + this.buildDecodeParms(vector2);
        }
        return "";
    }

    private String buildDecodeParms(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append("/DecodeParms ");
        if (vector.size() > 1) {
            stringBuffer.append("[ ");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string != null) {
                stringBuffer.append(string);
                bl = true;
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(" ");
        }
        if (vector.size() > 1) {
            stringBuffer.append("]");
        }
        stringBuffer.append("\n");
        if (bl) {
            return stringBuffer.toString();
        }
        return "";
    }

    private String buildFilterEntries(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/Filter ");
        if (vector.size() > 1) {
            stringBuffer.append("[ ");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            stringBuffer.append(" ");
        }
        if (vector.size() > 1) {
            stringBuffer.append("]");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public byte[] getData() {
        return this._data.toByteArray();
    }

    public int getDataLength() {
        return this._data.size();
    }

    protected int output(OutputStream outputStream) throws IOException {
        int n = 0;
        String string = this.applyFilters();
        byte[] byArray = (String.valueOf(this.number) + " " + this.generation + " obj\n<< /Length " + (this._data.size() + 1) + " " + string + " >>\n").getBytes();
        outputStream.write(byArray);
        n += byArray.length;
        n += this.outputStreamData(outputStream);
        byArray = "endobj\n".getBytes();
        outputStream.write(byArray);
        return n += byArray.length;
    }

    protected int outputStreamData(OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = "stream\n".getBytes();
        outputStream.write(byArray);
        n += byArray.length;
        this._data.writeTo(outputStream);
        n += this._data.size();
        byArray = "\nendstream\n".getBytes();
        outputStream.write(byArray);
        return n += byArray.length;
    }

    public void setData(byte[] byArray) throws IOException {
        this._data.reset();
        this._data.write(byArray);
    }

    public byte[] toPDF() {
        throw new RuntimeException();
    }
}

