/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.LengthRange;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.LengthRangeProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;

public class LeaderLengthMaker
extends LengthRangeProperty.Maker {
    private static final Property.Maker s_MinimumMaker = new SP_MinimumMaker("leader-length.minimum");
    private static final Property.Maker s_OptimumMaker = new SP_OptimumMaker("leader-length.optimum");
    private static final Property.Maker s_MaximumMaker = new SP_MaximumMaker("leader-length.maximum");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("minimum");

    protected LeaderLengthMaker(String string) {
        super(string);
    }

    public Property checkEnumValues(String string) {
        return this.m_shorthandMaker.checkEnumValues(string);
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws FOPException {
        if (property instanceof LengthRangeProperty) {
            return property;
        }
        if (!(property instanceof EnumProperty)) {
            property = this.m_shorthandMaker.convertProperty(property, propertyList, fObj);
        }
        if (property != null) {
            Property property2 = this.makeCompound(propertyList, fObj);
            LengthRange lengthRange = property2.getLengthRange();
            lengthRange.setComponent("minimum", property, false);
            lengthRange.setComponent("optimum", property, false);
            lengthRange.setComponent("maximum", property, false);
            return property2;
        }
        return null;
    }

    protected String getDefaultForMaximum() {
        return "100%";
    }

    protected String getDefaultForMinimum() {
        return "0pt";
    }

    protected String getDefaultForOptimum() {
        return "12.0pt";
    }

    public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
        return new LengthBase(fObj, propertyList, 3);
    }

    protected Property.Maker getSubpropMaker(String string) {
        if (string.equals("minimum")) {
            return s_MinimumMaker;
        }
        if (string.equals("optimum")) {
            return s_OptimumMaker;
        }
        if (string.equals("maximum")) {
            return s_MaximumMaker;
        }
        return super.getSubpropMaker(string);
    }

    public Property getSubpropValue(Property property, String string) {
        LengthRange lengthRange = property.getLengthRange();
        return lengthRange.getComponent(string);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    public boolean isInherited() {
        return true;
    }

    public Property make(PropertyList propertyList) throws FOPException {
        return this.makeCompound(propertyList, propertyList.getParentFObj());
    }

    protected Property makeCompound(PropertyList propertyList, FObj fObj) throws FOPException {
        LengthRange lengthRange = new LengthRange();
        Property property = this.getSubpropMaker("minimum").make(propertyList, this.getDefaultForMinimum(), fObj);
        lengthRange.setComponent("minimum", property, true);
        property = this.getSubpropMaker("optimum").make(propertyList, this.getDefaultForOptimum(), fObj);
        lengthRange.setComponent("optimum", property, true);
        property = this.getSubpropMaker("maximum").make(propertyList, this.getDefaultForMaximum(), fObj);
        lengthRange.setComponent("maximum", property, true);
        return new LengthRangeProperty(lengthRange);
    }

    public static Property.Maker maker(String string) {
        return new LeaderLengthMaker(string);
    }

    protected Property setSubprop(Property property, String string, Property property2) {
        LengthRange lengthRange = property.getLengthRange();
        lengthRange.setComponent(string, property2, false);
        return property;
    }

    private static class SP_MinimumMaker
    extends LengthProperty.Maker {
        SP_MinimumMaker(String string) {
            super(string);
        }

        public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
            return new LengthBase(fObj, propertyList, 3);
        }
    }

    private static class SP_OptimumMaker
    extends LengthProperty.Maker {
        SP_OptimumMaker(String string) {
            super(string);
        }

        public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
            return new LengthBase(fObj, propertyList, 3);
        }
    }

    private static class SP_MaximumMaker
    extends LengthProperty.Maker {
        SP_MaximumMaker(String string) {
            super(string);
        }

        public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
            return new LengthBase(fObj, propertyList, 3);
        }
    }
}

