/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MIFCommandLine {
    private String foFile = null;
    private String mifFile = null;
    private String userConfigFile = null;
    private String baseDir = null;
    private boolean dumpConfiguration = false;
    private static boolean errorDump = false;

    public MIFCommandLine(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d") || stringArray[n].equals("--full-error-dump")) {
                errorDump = true;
            } else if (stringArray[n].equals("-x")) {
                this.dumpConfiguration = true;
            } else if (stringArray[n].charAt(0) == '-' && stringArray[n].charAt(1) == 'c') {
                this.userConfigFile = stringArray[n].substring(2);
            } else if (stringArray[n].charAt(0) == '-') {
                this.printUsage(stringArray[n]);
            } else if (this.foFile == null) {
                this.foFile = stringArray[n];
            } else if (this.mifFile == null) {
                this.mifFile = stringArray[n];
            } else {
                this.printUsage(stringArray[n]);
            }
            ++n;
        }
        if (this.foFile == null || this.mifFile == null) {
            this.printUsage(null);
        }
    }

    static XMLReader createParser() {
        block9: {
            String string = System.getProperty("org.xml.sax.parser");
            if (string == null) {
                string = "org.apache.xerces.parsers.SAXParser";
            }
            MessageHandler.logln("using SAX parser " + string);
            try {
                return (XMLReader)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageHandler.errorln("Could not find " + string);
                if (errorDump) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                MessageHandler.errorln("Could not instantiate " + string);
                if (errorDump) {
                    instantiationException.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                MessageHandler.errorln("Could not access " + string);
                if (errorDump) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (ClassCastException classCastException) {
                MessageHandler.errorln(String.valueOf(string) + " is not a SAX driver");
                if (!errorDump) break block9;
                classCastException.printStackTrace();
            }
        }
        return null;
    }

    public static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        MIFCommandLine mIFCommandLine = new MIFCommandLine(stringArray);
        mIFCommandLine.run();
    }

    public void printUsage(String string) {
        if (string != null) {
            MessageHandler.errorln("Unknown argument: '" + string + "'");
        }
        MessageHandler.errorln("Usage: java [-d] [-x][-cMyConfigFile] \n            org.apache.fop.apps.CommandLine formatting-object-file pdf-file");
        MessageHandler.errorln("Options:\n  -d or --full-error-dump      Show stack traces upon error");
        MessageHandler.errorln("  -x                           dump configuration information");
        MessageHandler.errorln("  -cMyConfigFile               use configuration file MyConfigFile");
        System.exit(1);
    }

    public void run() {
        Driver driver = new Driver();
        if (errorDump) {
            driver.setErrorDump(true);
        }
        if (this.userConfigFile != null) {
            driver.loadUserconfiguration(this.userConfigFile);
        }
        driver.setBaseDir(this.foFile);
        if (this.dumpConfiguration) {
            Configuration.dumpConfiguration();
            System.exit(0);
        }
        String string = Version.getVersion();
        MessageHandler.logln(string);
        XMLReader xMLReader = MIFCommandLine.createParser();
        if (xMLReader == null) {
            MessageHandler.errorln("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            MessageHandler.errorln("Error in setting up parser feature namespace-prefixes");
            MessageHandler.errorln("You need a parser which supports SAX version 2");
            if (errorDump) {
                sAXException.printStackTrace();
            }
            System.exit(1);
        }
        try {
            driver.setRenderer("org.apache.fop.render.mif.MIFRenderer", Version.getVersion());
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.addPropertyList("org.apache.fop.fo.StandardPropertyListMapping");
            driver.addPropertyList("org.apache.fop.svg.SVGPropertyListMapping");
            driver.buildFOTree(xMLReader, MIFCommandLine.fileInputSource(this.foFile));
            driver.format();
            driver.setOutputStream(new FileOutputStream(this.mifFile));
            driver.render();
        }
        catch (Exception exception) {
            MessageHandler.errorln("FATAL ERROR: " + exception.getMessage());
            if (errorDump) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }
}

