/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class CollectionUtils {
    public static Collection union(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = 0;
            int n2 = Math.max(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            while (n < n2) {
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = 0;
            int n2 = Math.min(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            while (n < n2) {
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public static Collection disjunction(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = 0;
            int n2 = Math.max(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2)) - Math.min(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            while (n < n2) {
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public static Collection subtract(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ((AbstractCollection)arrayList).remove(iterator.next());
        }
        return arrayList;
    }

    public static Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Integer n = (Integer)hashMap.get(e);
            if (null == n) {
                hashMap.put(e, new Integer(1));
                continue;
            }
            hashMap.put(e, new Integer(n + 1));
        }
        return hashMap;
    }

    public static boolean isSubCollection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (CollectionUtils.getFreq(e, map) <= CollectionUtils.getFreq(e, map2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection collection, Collection collection2) {
        return CollectionUtils.isSubCollection(collection, collection2) && !CollectionUtils.isEqualCollection(collection, collection2);
    }

    public static boolean isEqualCollection(Collection collection, Collection collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (CollectionUtils.getFreq(k, map) == CollectionUtils.getFreq(k, map2)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object object, Collection collection) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if ((null != object || null != e) && !object.equals(e)) continue;
            ++n;
        }
        return n;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!predicate.evaluate(e)) continue;
                return e;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection, Closure closure) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                closure.execute(e);
            }
        }
    }

    public static Collection select(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.select(collection, predicate, arrayList);
        return arrayList;
    }

    public static void select(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!predicate.evaluate(e)) continue;
                collection2.add(e);
            }
        }
    }

    public static Collection collect(Collection collection, Transformer transformer) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.collect(collection, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Iterator iterator, Transformer transformer) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.collect(iterator, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Collection collection, Transformer transformer, Collection collection2) {
        if (collection != null) {
            return CollectionUtils.collect(collection.iterator(), transformer, collection2);
        }
        return collection2;
    }

    public static Collection collect(Iterator iterator, Transformer transformer, Collection collection) {
        if (iterator != null && transformer != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object object = transformer.transform(e);
                collection.add(object);
            }
        }
        return collection;
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            collection.add(objectArray[n]);
            ++n;
        }
    }

    private static final int getFreq(Object object, Map map) {
        try {
            return (Integer)map.get(object);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 0;
    }
}

