#ifndef BOOST_PREPROCESSOR_LIST_FOR_EACH_PRODUCT_HPP
#define BOOST_PREPROCESSOR_LIST_FOR_EACH_PRODUCT_HPP

/* Copyright (C) 2002
 * Housemarque Oy
 * http://www.housemarque.com
 *
 * Permission to copy, use, modify, sell and distribute this software is
 * granted provided this copyright notice appears in all copies. This
 * software is provided "as is" without express or implied warranty, and
 * with no claim as to its suitability for any purpose.
 *
 * See http://www.boost.org for most recent version.
 */

#include <boost/preprocessor/list/adt.hpp>
#include <boost/preprocessor/list/to_tuple.hpp>
#include <boost/preprocessor/tuple/to_list.hpp>
#include <boost/preprocessor/tuple/reverse.hpp>
#include <boost/preprocessor/for.hpp>

/** <p>Repeats <code>MACRO(R,X)</code> for each element <code>X</code> of the
cartesian product of the lists of the <code>SIZE_OF_TUPLE</code>-tuple <code>TUPLE_OF_LISTS</code>.</p>

<p>This macro is useful for generating code to avoid combinatorial
explosion.</p>

<p>For example,</p>

<pre>
  #define TEST(R,X) X
  BOOST_PP_LIST_FOR_EACH_PRODUCT
  ( TEST
  , 2
  , ( BOOST_PP_TUPLE_TO_LIST(3,(A,B,C))
    , BOOST_PP_TUPLE_TO_LIST(2,(1,2))
    )
  )
</pre>

<p>expands to:</p>

<pre>
  (A,1) (A,2) (B,1) (B,2) (C,1) (C,2) 
</pre>

<h3>Example</h3>
<ul>
  <li><a href="../../example/is_integral.cpp">is_integral.cpp</a></li>
  <li><a href="../../example/array_arithmetic.c">array_arithmetic.c</a></li>
</ul>

<h3>Uses</h3>
<ul>
  <li>BOOST_PP_FOR() (see for explanation of the R parameter)</li>
</ul>

<h3>Test</h3>
<ul>
  <li><a href="../../test/list_test.cpp">list_test.cpp</a></li>
</ul>
*/
#define BOOST_PP_LIST_FOR_EACH_PRODUCT(MACRO,SIZE_OF_TUPLE,TUPLE_OF_LISTS) BOOST_PP_LIST_FOR_EACH_PRODUCT_R(0,MACRO,SIZE_OF_TUPLE,TUPLE_OF_LISTS)

/** <p>Can be used inside BOOST_PP_FOR().</p> */
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_R(R,MACRO,SIZE_OF_TUPLE,TUPLE_OF_LISTS) BOOST_PP_LIST_FOR_EACH_PRODUCT_R2(0,MACRO,BOOST_PP_TUPLE_TO_LIST(SIZE_OF_TUPLE,BOOST_PP_TUPLE_REVERSE(SIZE_OF_TUPLE,TUPLE_OF_LISTS)))
#if !defined(BOOST_NO_COMPILER_CONFIG) && defined(__MWERKS__) ||\
  !defined(BOOST_NO_COMPILER_CONFIG) && defined(_MSC_VER)
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_R2(R,F,LL) BOOST_PP_FOR##R((BOOST_PP_TUPLE_ELEM(3,0,LL),BOOST_PP_TUPLE_ELEM(3,1,LL),(_,_,0),F),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I0)
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_C(R,P) BOOST_PP_TUPLE_ELEM(3,2,BOOST_PP_TUPLE_ELEM(4,0,P))
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_F(R,P) (BOOST_PP_LIST_REST(BOOST_PP_TUPLE_ELEM(4,0,P)),BOOST_PP_TUPLE_ELEM(4,1,P),BOOST_PP_TUPLE_ELEM(4,2,P),BOOST_PP_TUPLE_ELEM(4,3,P))

#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_I(R,P) BOOST_PP_TUPLE_ELEM(4,3,P)(R,BOOST_PP_LIST_TO_TUPLE_R(R,(BOOST_PP_TUPLE_ELEM(3,0,BOOST_PP_TUPLE_ELEM(4,0,P)),BOOST_PP_TUPLE_ELEM(4,2,P),1)))
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,I) BOOST_PP_IF(BOOST_PP_TUPLE_ELEM(3,2,BOOST_PP_TUPLE_ELEM(4,1,P)),BOOST_PP_LIST_FOR_EACH_PRODUCT_I##I##_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_I)
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P) (BOOST_PP_TUPLE_ELEM(3,0,BOOST_PP_TUPLE_ELEM(4,1,P)),BOOST_PP_TUPLE_ELEM(3,1,BOOST_PP_TUPLE_ELEM(4,1,P)),(BOOST_PP_TUPLE_ELEM(3,0,BOOST_PP_TUPLE_ELEM(4,0,P)),BOOST_PP_TUPLE_ELEM(4,2,P),1),BOOST_PP_TUPLE_ELEM(4,3,P))
#else
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_R2(R,F,LL) BOOST_PP_FOR##R((BOOST_PP_TUPLE3_ELEM0 LL,BOOST_PP_TUPLE3_ELEM1 LL,(_,_,0),F),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I0)
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_C(R,P) BOOST_PP_TUPLE3_ELEM2 BOOST_PP_TUPLE4_ELEM0 P
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_F(R,P) (BOOST_PP_LIST_REST(BOOST_PP_TUPLE4_ELEM0 P),BOOST_PP_TUPLE4_ELEM1 P,BOOST_PP_TUPLE4_ELEM2 P,BOOST_PP_TUPLE4_ELEM3 P)

#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_I(R,P) BOOST_PP_TUPLE4_ELEM3 P(R,BOOST_PP_LIST_TO_TUPLE_R(R,(BOOST_PP_TUPLE3_ELEM0 BOOST_PP_TUPLE4_ELEM0 P,BOOST_PP_TUPLE4_ELEM2 P,1)))
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,I) BOOST_PP_IF(BOOST_PP_TUPLE3_ELEM2 BOOST_PP_TUPLE4_ELEM1 P,BOOST_PP_LIST_FOR_EACH_PRODUCT_I##I##_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_I)
#  define BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P) (BOOST_PP_TUPLE3_ELEM0 BOOST_PP_TUPLE4_ELEM1 P,BOOST_PP_TUPLE3_ELEM1 BOOST_PP_TUPLE4_ELEM1 P,(BOOST_PP_TUPLE3_ELEM0 BOOST_PP_TUPLE4_ELEM0 P,BOOST_PP_TUPLE4_ELEM2 P,1),BOOST_PP_TUPLE4_ELEM3 P)
#endif
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I0_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I1)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I0(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,0)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I1_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I2)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I1(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,1)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I2_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I3)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I2(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,2)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I3_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I4)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I3(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,3)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I4_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I5)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I4(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,4)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I5_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I6)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I5(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,5)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I6_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I7)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I6(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,6)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I7_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I8)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I7(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,7)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I8_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I9)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I8(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,8)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I9_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I10)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I9(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,9)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I10_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I11)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I10(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,10)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I11_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I12)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I11(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,11)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I12_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I13)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I12(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,12)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I13_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I14)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I13(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,13)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I14_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I15)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I14(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,14)(R,P)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I15_C(R,P) BOOST_PP_FOR##R(BOOST_PP_LIST_FOR_EACH_PRODUCT_I_H(P),BOOST_PP_LIST_FOR_EACH_PRODUCT_C,BOOST_PP_LIST_FOR_EACH_PRODUCT_F,BOOST_PP_LIST_FOR_EACH_PRODUCT_I16)
#define BOOST_PP_LIST_FOR_EACH_PRODUCT_I15(R,P) BOOST_PP_LIST_FOR_EACH_PRODUCT_I_C(P,15)(R,P)
#endif
