/*
  Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
  All rights reserved.

  Redistribution and use in source and binary forms,
  with or without modification, are permitted provided that the
  following conditions are met:
   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the Sony Computer Entertainment Inc nor the names
     of its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#define _VECTORMATH_SOA_TEST

#include "vectormath_soa.h"
#include "test.h"

int iteration = 0;

void
Vector3_methods_test()
{
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathVector3 aos_Vector3_0, aos_Vector3_1, aos_Vector3_2, aos_Vector3_3;
    VmathSoaVector3 soa_Vector3;
    VmathVector4 aos_Vector4_0, aos_Vector4_1, aos_Vector4_2;
    VmathSoaVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3;
    VmathSoaPoint3 tmpP3_0;
    VmathSoaVector3 tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7, tmpV3_8, tmpV3_9, tmpV3_10, tmpV3_11, tmpV3_12, tmpV3_13, tmpV3_14, tmpV3_15, tmpV3_16, tmpV3_17, tmpV3_18, tmpV3_19;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4;
    float xyz4[12] __attribute__ ((aligned(16)));
    xyz4[0] = getfloat(randfloat());
    xyz4[1] = getfloat(randfloat());
    xyz4[2] = getfloat(randfloat());
    xyz4[3] = getfloat(randfloat());
    xyz4[4] = getfloat(randfloat());
    xyz4[5] = getfloat(randfloat());
    xyz4[6] = getfloat(randfloat());
    xyz4[7] = getfloat(randfloat());
    xyz4[8] = getfloat(randfloat());
    xyz4[9] = getfloat(randfloat());
    xyz4[10] = getfloat(randfloat());
    xyz4[11] = getfloat(randfloat());
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3MakeFromScalar( &c_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &d_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &e_Vector3, (vec_float4){0.0f} );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4MakeFromScalar( &c_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &d_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &e_Vector4, (vec_float4){0.0f} );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3MakeFromScalar( &c_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &d_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &e_Point3, (vec_float4){0.0f} );
    vmathSoaP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQMakeFromScalar( &c_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &d_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &e_Quat, (vec_float4){0.0f} );
    vmathSoaQPrints( &c_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &d_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &e_Quat, "set Quat elements to zero" );
    vmathSoaV3MakeFromP3( &a_Vector3, &a_Point3 );
    vmathSoaV3Prints( &a_Vector3, "construct Vector3 with Point3" );
    vmathSoaV3MakeFromScalar( &a_Vector3, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with float" );
    vmathSoaV3MakeFromScalar( &a_Vector3, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with float" );
    vmathV3MakeFromElems( &aos_Vector3_0, 0.0f, 1.0f, 2.0f );
    vmathV3MakeFromElems( &aos_Vector3_1, 3.0f, 4.0f, 5.0f );
    vmathV3MakeFromElems( &aos_Vector3_2, 6.0f, 7.0f, 8.0f );
    vmathV3MakeFromElems( &aos_Vector3_3, 9.0f, 10.0f, 11.0f );
    vmathSoaV3MakeFrom4Aos( &soa_Vector3, &aos_Vector3_0, &aos_Vector3_1, &aos_Vector3_2, &aos_Vector3_3 );
    vmathSoaV3Get4Aos( &soa_Vector3, &aos_Vector3_3, &aos_Vector3_2, &aos_Vector3_1, &aos_Vector3_0 );
    vmathV3Prints( &aos_Vector3_0, "aos type 0" );
    vmathV3Prints( &aos_Vector3_1, "aos type 1" );
    vmathV3Prints( &aos_Vector3_2, "aos type 2" );
    vmathV3Prints( &aos_Vector3_3, "aos type 3" );
    vmathSoaV3Select( &a_Vector3, &a_Vector3, &b_Vector3, ((vec_uint4){0,0xffffffff,0,0xffffffff}) );
    vmathSoaV3Get4Aos( &a_Vector3, &aos_Vector3_0, &aos_Vector3_1, &aos_Vector3_2, &aos_Vector3_3 );
    vmathV3Prints( &aos_Vector3_0, "select 0" );
    vmathV3Prints( &aos_Vector3_1, "select 1" );
    vmathV3Prints( &aos_Vector3_2, "select 2" );
    vmathV3Prints( &aos_Vector3_3, "select 3" );
    vmathSoaV3LoadXYZArray( &a_Vector3, (const vec_float4 *)xyz4 );
    vmathSoaV3Prints( &a_Vector3, "load XYZ array" );
    vmathSoaV3Copy( &tmpV3_0, &a_Vector3 );
    vmathSoaV3Neg( &tmpV3_1, &tmpV3_0 );
    vmathSoaV3Copy( &a_Vector3, &tmpV3_1 );
    vmathSoaV3StoreXYZArray( &a_Vector3, (vec_float4 *)xyz4 );
    vmathV4MakeFromElems( &aos_Vector4_0, xyz4[0], xyz4[1], xyz4[2], xyz4[3] );
    vmathV4MakeFromElems( &aos_Vector4_1, xyz4[4], xyz4[5], xyz4[6], xyz4[7] );
    vmathV4MakeFromElems( &aos_Vector4_2, xyz4[8], xyz4[9], xyz4[10], xyz4[11] );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
    printf("storeXYZ:-1.0 -2.0 -3.0 0.4\n");
    vmathSoaV3Copy( &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &a_Vector3, "assign to Vector3 from Vector3" );
    vmathSoaV3MakeFromScalar( &a_Vector3, (vec_float4){0.0f} );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3MakeXAxis( &a_Vector3 );
    vmathSoaV3Prints( &a_Vector3, "set to x axis" );
    vmathSoaV3MakeYAxis( &a_Vector3 );
    vmathSoaV3Prints( &a_Vector3, "set to y axis" );
    vmathSoaV3MakeZAxis( &a_Vector3 );
    vmathSoaV3Prints( &a_Vector3, "set to z axis" );
    vmathSoaV3SetElem( &a_Vector3, 0, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "Vector3::set( 0, float )" );
    vmathSoaV3SetElem( &a_Vector3, 0, randfloat() );
    vmathSoaV3SetElem( &a_Vector3, 0, vec_mul_float( vmathSoaV3GetElem( &a_Vector3, 0 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 0, divf4( vmathSoaV3GetElem( &a_Vector3, 0 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 0, vec_add_float( vmathSoaV3GetElem( &a_Vector3, 0 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 0, vec_sub_float( vmathSoaV3GetElem( &a_Vector3, 0 ), randfloat() ) );
    vmathSoaV3Prints( &a_Vector3, "Vector3::operator [](0)" );
    vmathSoaV3SetX( &a_Vector3, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "Vector3::setX()" );
    vmathSoaV3SetElem( &a_Vector3, 1, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "Vector3::set( 1, float )" );
    vmathSoaV3SetElem( &a_Vector3, 1, randfloat() );
    vmathSoaV3SetElem( &a_Vector3, 1, vec_mul_float( vmathSoaV3GetElem( &a_Vector3, 1 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 1, divf4( vmathSoaV3GetElem( &a_Vector3, 1 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 1, vec_add_float( vmathSoaV3GetElem( &a_Vector3, 1 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 1, vec_sub_float( vmathSoaV3GetElem( &a_Vector3, 1 ), randfloat() ) );
    vmathSoaV3Prints( &a_Vector3, "Vector3::operator [](1)" );
    vmathSoaV3SetY( &a_Vector3, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "Vector3::setY()" );
    vmathSoaV3SetElem( &a_Vector3, 2, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "Vector3::set( 2, float )" );
    vmathSoaV3SetElem( &a_Vector3, 2, randfloat() );
    vmathSoaV3SetElem( &a_Vector3, 2, vec_mul_float( vmathSoaV3GetElem( &a_Vector3, 2 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 2, divf4( vmathSoaV3GetElem( &a_Vector3, 2 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 2, vec_add_float( vmathSoaV3GetElem( &a_Vector3, 2 ), randfloat() ) );
    vmathSoaV3SetElem( &a_Vector3, 2, vec_sub_float( vmathSoaV3GetElem( &a_Vector3, 2 ), randfloat() ) );
    vmathSoaV3Prints( &a_Vector3, "Vector3::operator [](2)" );
    vmathSoaV3SetZ( &a_Vector3, randfloat() );
    vmathSoaV3Prints( &a_Vector3, "Vector3::setZ()" );
    printf("Vector3::get( 0 ): %f\n", getfloat(vmathSoaV3GetElem( &a_Vector3, 0 )) );
    printf("Vector3::operator []( 0 ): %f\n", getfloat(vmathSoaV3GetElem( &a_Vector3, 0 )) );
    printf("Vector3::getX(): %f\n", getfloat(vmathSoaV3GetX( &a_Vector3 )) );
    printf("Vector3::get( 1 ): %f\n", getfloat(vmathSoaV3GetElem( &a_Vector3, 1 )) );
    printf("Vector3::operator []( 1 ): %f\n", getfloat(vmathSoaV3GetElem( &a_Vector3, 1 )) );
    printf("Vector3::getY(): %f\n", getfloat(vmathSoaV3GetY( &a_Vector3 )) );
    printf("Vector3::get( 2 ): %f\n", getfloat(vmathSoaV3GetElem( &a_Vector3, 2 )) );
    printf("Vector3::operator []( 2 ): %f\n", getfloat(vmathSoaV3GetElem( &a_Vector3, 2 )) );
    printf("Vector3::getZ(): %f\n", getfloat(vmathSoaV3GetZ( &a_Vector3 )) );
    vmathSoaV3Add( &tmpV3_2, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_2, "Vector3 + Vector3" );
    vmathSoaV3Sub( &tmpV3_3, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_3, "Vector3 - Vector3" );
    vmathSoaV3AddP3( &tmpP3_0, &a_Vector3, &b_Point3 );
    vmathSoaP3Prints( &tmpP3_0, "Vector3 + Point3" );
    vmathSoaV3ScalarMul( &tmpV3_4, &a_Vector3, randfloat() );
    vmathSoaV3Prints( &tmpV3_4, "Vector3 * float" );
    vmathSoaV3ScalarDiv( &tmpV3_5, &a_Vector3, randfloat() );
    vmathSoaV3Prints( &tmpV3_5, "Vector3 / float" );
    vmathSoaV3ScalarMul( &tmpV3_6, &a_Vector3, randfloat() );
    vmathSoaV3Prints( &tmpV3_6, "float * Vector3" );
    vmathSoaV3Neg( &tmpV3_7, &a_Vector3 );
    vmathSoaV3Prints( &tmpV3_7, "Vector3 negate" );
    vmathSoaV3MulPerElem( &tmpV3_8, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_8, "mulPerElem( Vector3, Vector3 )" );
    vmathSoaV3DivPerElem( &tmpV3_9, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_9, "divPerElem( Vector3, Vector3 )" );
    vmathSoaV3RecipPerElem( &tmpV3_10, &a_Vector3 );
    vmathSoaV3Prints( &tmpV3_10, "Vector3 recip" );
    vmathSoaV3AbsPerElem( &tmpV3_11, &a_Vector3 );
    vmathSoaV3SqrtPerElem( &tmpV3_12, &tmpV3_11 );
    vmathSoaV3Prints( &tmpV3_12, "Vector3 sqrt" );
    vmathSoaV3AbsPerElem( &tmpV3_13, &a_Vector3 );
    vmathSoaV3RsqrtPerElem( &tmpV3_14, &tmpV3_13 );
    vmathSoaV3Prints( &tmpV3_14, "Vector3 rsqrt" );
    vmathSoaV3AbsPerElem( &tmpV3_15, &a_Vector3 );
    vmathSoaV3Prints( &tmpV3_15, "Vector3 abs" );
    vmathSoaV3CopySignPerElem( &tmpV3_16, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_16, "Vector3 copySign" );
    vmathSoaV3MaxPerElem( &tmpV3_17, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_17, "Vector3 maximum Vector3" );
    vmathSoaV3MinPerElem( &tmpV3_18, &a_Vector3, &b_Vector3 );
    vmathSoaV3Prints( &tmpV3_18, "Vector3 minimum Vector3" );
    printf("Vector3 maximum of elements: %f\n", getfloat(vmathSoaV3MaxElem( &a_Vector3 )));
    printf("Vector3 minimum of elements: %f\n", getfloat(vmathSoaV3MinElem( &a_Vector3 )));
    printf("Vector3 sum of elements: %f\n", getfloat(vmathSoaV3Sum( &a_Vector3 )));
    printf("Vector3 dot Vector3: %f\n", getfloat(vmathSoaV3Dot( &a_Vector3, &b_Vector3 )));
    printf("Vector3 lengthSqr: %f\n", getfloat(vmathSoaV3LengthSqr( &a_Vector3 )));
    printf("Vector3 length: %f\n", getfloat(vmathSoaV3Length( &a_Vector3 )));
    vmathSoaV3Normalize( &tmpV3_19, &a_Vector3 );
    vmathSoaV3Prints( &tmpV3_19, "Vector3 normalized" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &e_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Normalize( &b_Vector3, &b_Vector3 );
    vmathSoaV3Normalize( &c_Vector3, &c_Vector3 );
    vmathSoaV3Normalize( &d_Vector3, &d_Vector3 );
    vmathSoaV3Normalize( &e_Vector3, &e_Vector3 );
    vmathSoaV3Lerp( &a_Vector3, randfloat(), &b_Vector3, &c_Vector3 );
    vmathSoaV3Prints( &a_Vector3, "Vector3 lerp" );
    vmathSoaV3Slerp( &a_Vector3, randfloat(), &b_Vector3, &c_Vector3 );
    vmathSoaV3Prints( &a_Vector3, "Vector3 slerp" );
}

void
Vector4_methods_test()
{
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathVector4 aos_Vector4_0, aos_Vector4_1, aos_Vector4_2, aos_Vector4_3;
    VmathSoaVector4 soa_Vector4;
    VmathSoaVector3 tmpV3_0;
    VmathSoaVector4 tmpV4_0, tmpV4_1, tmpV4_2, tmpV4_3, tmpV4_4, tmpV4_5, tmpV4_6, tmpV4_7, tmpV4_8, tmpV4_9, tmpV4_10, tmpV4_11, tmpV4_12, tmpV4_13, tmpV4_14, tmpV4_15, tmpV4_16, tmpV4_17;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3MakeFromScalar( &c_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &d_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &e_Vector3, (vec_float4){0.0f} );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4MakeFromScalar( &c_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &d_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &e_Vector4, (vec_float4){0.0f} );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3MakeFromScalar( &c_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &d_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &e_Point3, (vec_float4){0.0f} );
    vmathSoaP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQMakeFromScalar( &c_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &d_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &e_Quat, (vec_float4){0.0f} );
    vmathSoaQPrints( &c_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &d_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &e_Quat, "set Quat elements to zero" );
    vmathSoaV4MakeFromV3Scalar( &a_Vector4, &a_Vector3, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with Vector3, float" );
    vmathSoaV4MakeFromV3( &a_Vector4, &a_Vector3 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with Vector3" );
    vmathSoaV4MakeFromP3( &a_Vector4, &a_Point3 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with Point3" );
    vmathSoaV4MakeFromQ( &a_Vector4, &a_Quat );
    vmathSoaV4Prints( &a_Vector4, "construct Vector4 with Quat" );
    vmathSoaV4MakeFromScalar( &a_Vector4, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with float" );
    vmathSoaV4MakeFromScalar( &a_Vector4, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with float" );
    vmathV4MakeFromElems( &aos_Vector4_0, 0.0f, 1.0f, 2.0f, 3.0f );
    vmathV4MakeFromElems( &aos_Vector4_1, 4.0f, 5.0f, 6.0f, 7.0f );
    vmathV4MakeFromElems( &aos_Vector4_2, 8.0f, 9.0f, 10.0f, 11.0f );
    vmathV4MakeFromElems( &aos_Vector4_3, 12.0f, 13.0f, 14.0f, 15.0f );
    vmathSoaV4MakeFrom4Aos( &soa_Vector4, &aos_Vector4_0, &aos_Vector4_1, &aos_Vector4_2, &aos_Vector4_3 );
    vmathSoaV4Get4Aos( &soa_Vector4, &aos_Vector4_3, &aos_Vector4_2, &aos_Vector4_1, &aos_Vector4_0 );
    vmathV4Prints( &aos_Vector4_0, "aos type 0" );
    vmathV4Prints( &aos_Vector4_1, "aos type 1" );
    vmathV4Prints( &aos_Vector4_2, "aos type 2" );
    vmathV4Prints( &aos_Vector4_3, "aos type 3" );
    vmathSoaV4Select( &a_Vector4, &a_Vector4, &b_Vector4, ((vec_uint4){0,0xffffffff,0,0xffffffff}) );
    vmathSoaV4Get4Aos( &a_Vector4, &aos_Vector4_0, &aos_Vector4_1, &aos_Vector4_2, &aos_Vector4_3 );
    vmathV4Prints( &aos_Vector4_0, "select 0" );
    vmathV4Prints( &aos_Vector4_1, "select 1" );
    vmathV4Prints( &aos_Vector4_2, "select 2" );
    vmathV4Prints( &aos_Vector4_3, "select 3" );
    vmathSoaV4Copy( &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "assign to Vector4 from Vector4" );
    vmathSoaV4SetXYZ( &a_Vector4, &a_Vector3 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 xyz" );
    vmathSoaV4GetXYZ( &tmpV3_0, &a_Vector4 );
    vmathSoaV3Prints( &tmpV3_0, "get Vector4 xyz" );
    vmathSoaV4MakeFromScalar( &a_Vector4, (vec_float4){0.0f} );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4MakeXAxis( &a_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "set to x axis" );
    vmathSoaV4MakeYAxis( &a_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "set to y axis" );
    vmathSoaV4MakeZAxis( &a_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "set to z axis" );
    vmathSoaV4MakeWAxis( &a_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "set to w axis" );
    vmathSoaV4SetElem( &a_Vector4, 0, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::set( 0, float )" );
    vmathSoaV4SetElem( &a_Vector4, 0, randfloat() );
    vmathSoaV4SetElem( &a_Vector4, 0, vec_mul_float( vmathSoaV4GetElem( &a_Vector4, 0 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 0, divf4( vmathSoaV4GetElem( &a_Vector4, 0 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 0, vec_add_float( vmathSoaV4GetElem( &a_Vector4, 0 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 0, vec_sub_float( vmathSoaV4GetElem( &a_Vector4, 0 ), randfloat() ) );
    vmathSoaV4Prints( &a_Vector4, "Vector4::operator [](0)" );
    vmathSoaV4SetX( &a_Vector4, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::setX()" );
    vmathSoaV4SetElem( &a_Vector4, 1, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::set( 1, float )" );
    vmathSoaV4SetElem( &a_Vector4, 1, randfloat() );
    vmathSoaV4SetElem( &a_Vector4, 1, vec_mul_float( vmathSoaV4GetElem( &a_Vector4, 1 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 1, divf4( vmathSoaV4GetElem( &a_Vector4, 1 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 1, vec_add_float( vmathSoaV4GetElem( &a_Vector4, 1 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 1, vec_sub_float( vmathSoaV4GetElem( &a_Vector4, 1 ), randfloat() ) );
    vmathSoaV4Prints( &a_Vector4, "Vector4::operator [](1)" );
    vmathSoaV4SetY( &a_Vector4, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::setY()" );
    vmathSoaV4SetElem( &a_Vector4, 2, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::set( 2, float )" );
    vmathSoaV4SetElem( &a_Vector4, 2, randfloat() );
    vmathSoaV4SetElem( &a_Vector4, 2, vec_mul_float( vmathSoaV4GetElem( &a_Vector4, 2 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 2, divf4( vmathSoaV4GetElem( &a_Vector4, 2 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 2, vec_add_float( vmathSoaV4GetElem( &a_Vector4, 2 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 2, vec_sub_float( vmathSoaV4GetElem( &a_Vector4, 2 ), randfloat() ) );
    vmathSoaV4Prints( &a_Vector4, "Vector4::operator [](2)" );
    vmathSoaV4SetZ( &a_Vector4, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::setZ()" );
    vmathSoaV4SetElem( &a_Vector4, 3, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::set( 3, float )" );
    vmathSoaV4SetElem( &a_Vector4, 3, randfloat() );
    vmathSoaV4SetElem( &a_Vector4, 3, vec_mul_float( vmathSoaV4GetElem( &a_Vector4, 3 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 3, divf4( vmathSoaV4GetElem( &a_Vector4, 3 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 3, vec_add_float( vmathSoaV4GetElem( &a_Vector4, 3 ), randfloat() ) );
    vmathSoaV4SetElem( &a_Vector4, 3, vec_sub_float( vmathSoaV4GetElem( &a_Vector4, 3 ), randfloat() ) );
    vmathSoaV4Prints( &a_Vector4, "Vector4::operator [](3)" );
    vmathSoaV4SetW( &a_Vector4, randfloat() );
    vmathSoaV4Prints( &a_Vector4, "Vector4::setW()" );
    printf("Vector4::get( 0 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 0 )) );
    printf("Vector4::operator []( 0 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 0 )) );
    printf("Vector4::getX(): %f\n", getfloat(vmathSoaV4GetX( &a_Vector4 )) );
    printf("Vector4::get( 1 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 1 )) );
    printf("Vector4::operator []( 1 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 1 )) );
    printf("Vector4::getY(): %f\n", getfloat(vmathSoaV4GetY( &a_Vector4 )) );
    printf("Vector4::get( 2 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 2 )) );
    printf("Vector4::operator []( 2 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 2 )) );
    printf("Vector4::getZ(): %f\n", getfloat(vmathSoaV4GetZ( &a_Vector4 )) );
    printf("Vector4::get( 3 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 3 )) );
    printf("Vector4::operator []( 3 ): %f\n", getfloat(vmathSoaV4GetElem( &a_Vector4, 3 )) );
    printf("Vector4::getW(): %f\n", getfloat(vmathSoaV4GetW( &a_Vector4 )) );
    vmathSoaV4Add( &tmpV4_0, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_0, "Vector4 + Vector4" );
    vmathSoaV4Sub( &tmpV4_1, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_1, "Vector4 - Vector4" );
    vmathSoaV4ScalarMul( &tmpV4_2, &a_Vector4, randfloat() );
    vmathSoaV4Prints( &tmpV4_2, "Vector4 * float" );
    vmathSoaV4ScalarDiv( &tmpV4_3, &a_Vector4, randfloat() );
    vmathSoaV4Prints( &tmpV4_3, "Vector4 / float" );
    vmathSoaV4ScalarMul( &tmpV4_4, &a_Vector4, randfloat() );
    vmathSoaV4Prints( &tmpV4_4, "float * Vector4" );
    vmathSoaV4Neg( &tmpV4_5, &a_Vector4 );
    vmathSoaV4Prints( &tmpV4_5, "Vector4 negate" );
    vmathSoaV4MulPerElem( &tmpV4_6, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_6, "mulPerElem( Vector4, Vector4 )" );
    vmathSoaV4DivPerElem( &tmpV4_7, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_7, "divPerElem( Vector4, Vector4 )" );
    vmathSoaV4RecipPerElem( &tmpV4_8, &a_Vector4 );
    vmathSoaV4Prints( &tmpV4_8, "Vector4 recip" );
    vmathSoaV4AbsPerElem( &tmpV4_9, &a_Vector4 );
    vmathSoaV4SqrtPerElem( &tmpV4_10, &tmpV4_9 );
    vmathSoaV4Prints( &tmpV4_10, "Vector4 sqrt" );
    vmathSoaV4AbsPerElem( &tmpV4_11, &a_Vector4 );
    vmathSoaV4RsqrtPerElem( &tmpV4_12, &tmpV4_11 );
    vmathSoaV4Prints( &tmpV4_12, "Vector4 rsqrt" );
    vmathSoaV4AbsPerElem( &tmpV4_13, &a_Vector4 );
    vmathSoaV4Prints( &tmpV4_13, "Vector4 abs" );
    vmathSoaV4CopySignPerElem( &tmpV4_14, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_14, "Vector4 copySign" );
    vmathSoaV4MaxPerElem( &tmpV4_15, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_15, "Vector4 maximum Vector4" );
    vmathSoaV4MinPerElem( &tmpV4_16, &a_Vector4, &b_Vector4 );
    vmathSoaV4Prints( &tmpV4_16, "Vector4 minimum Vector4" );
    printf("Vector4 maximum of elements: %f\n", getfloat(vmathSoaV4MaxElem( &a_Vector4 )));
    printf("Vector4 minimum of elements: %f\n", getfloat(vmathSoaV4MinElem( &a_Vector4 )));
    printf("Vector4 sum of elements: %f\n", getfloat(vmathSoaV4Sum( &a_Vector4 )));
    printf("Vector4 dot Vector4: %f\n", getfloat(vmathSoaV4Dot( &a_Vector4, &b_Vector4 )));
    printf("Vector4 lengthSqr: %f\n", getfloat(vmathSoaV4LengthSqr( &a_Vector4 )));
    printf("Vector4 length: %f\n", getfloat(vmathSoaV4Length( &a_Vector4 )));
    vmathSoaV4Normalize( &tmpV4_17, &a_Vector4 );
    vmathSoaV4Prints( &tmpV4_17, "Vector4 normalized" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &e_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Normalize( &b_Vector4, &b_Vector4 );
    vmathSoaV4Normalize( &c_Vector4, &c_Vector4 );
    vmathSoaV4Normalize( &d_Vector4, &d_Vector4 );
    vmathSoaV4Normalize( &e_Vector4, &e_Vector4 );
    vmathSoaV4Lerp( &a_Vector4, randfloat(), &b_Vector4, &c_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "Vector4 lerp" );
    vmathSoaV4Slerp( &a_Vector4, randfloat(), &b_Vector4, &c_Vector4 );
    vmathSoaV4Prints( &a_Vector4, "Vector4 slerp" );
}

void
Point3_methods_test()
{
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathPoint3 aos_Point3_0, aos_Point3_1, aos_Point3_2, aos_Point3_3;
    VmathSoaPoint3 soa_Point3;
    VmathVector4 aos_Vector4_0, aos_Vector4_1, aos_Vector4_2;
    VmathSoaVector3 tmpV3_0, tmpV3_1, tmpV3_2;
    VmathSoaPoint3 tmpP3_0, tmpP3_1, tmpP3_2, tmpP3_3, tmpP3_4, tmpP3_5, tmpP3_6, tmpP3_7, tmpP3_8, tmpP3_9, tmpP3_10, tmpP3_11, tmpP3_12;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4;
    float xyz4[12] __attribute__ ((aligned(16)));
    xyz4[0] = getfloat(randfloat());
    xyz4[1] = getfloat(randfloat());
    xyz4[2] = getfloat(randfloat());
    xyz4[3] = getfloat(randfloat());
    xyz4[4] = getfloat(randfloat());
    xyz4[5] = getfloat(randfloat());
    xyz4[6] = getfloat(randfloat());
    xyz4[7] = getfloat(randfloat());
    xyz4[8] = getfloat(randfloat());
    xyz4[9] = getfloat(randfloat());
    xyz4[10] = getfloat(randfloat());
    xyz4[11] = getfloat(randfloat());
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3MakeFromScalar( &c_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &d_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &e_Vector3, (vec_float4){0.0f} );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4MakeFromScalar( &c_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &d_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &e_Vector4, (vec_float4){0.0f} );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3MakeFromScalar( &c_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &d_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &e_Point3, (vec_float4){0.0f} );
    vmathSoaP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQMakeFromScalar( &c_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &d_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &e_Quat, (vec_float4){0.0f} );
    vmathSoaQPrints( &c_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &d_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &e_Quat, "set Quat elements to zero" );
    vmathSoaP3MakeFromV3( &a_Point3, &a_Vector3 );
    vmathSoaP3Prints( &a_Point3, "construct Point3 with Vector3" );
    vmathSoaP3MakeFromScalar( &a_Point3, randfloat() );
    vmathSoaP3Prints( &a_Point3, "set Point3 with float" );
    vmathSoaP3MakeFromScalar( &a_Point3, randfloat() );
    vmathSoaP3Prints( &a_Point3, "set Point3 with float" );
    vmathP3MakeFromElems( &aos_Point3_0, 0.0f, 1.0f, 2.0f );
    vmathP3MakeFromElems( &aos_Point3_1, 3.0f, 4.0f, 5.0f );
    vmathP3MakeFromElems( &aos_Point3_2, 6.0f, 7.0f, 8.0f );
    vmathP3MakeFromElems( &aos_Point3_3, 9.0f, 10.0f, 11.0f );
    vmathSoaP3MakeFrom4Aos( &soa_Point3, &aos_Point3_0, &aos_Point3_1, &aos_Point3_2, &aos_Point3_3 );
    vmathSoaP3Get4Aos( &soa_Point3, &aos_Point3_3, &aos_Point3_2, &aos_Point3_1, &aos_Point3_0 );
    vmathP3Prints( &aos_Point3_0, "aos type 0" );
    vmathP3Prints( &aos_Point3_1, "aos type 1" );
    vmathP3Prints( &aos_Point3_2, "aos type 2" );
    vmathP3Prints( &aos_Point3_3, "aos type 3" );
    vmathSoaP3Select( &a_Point3, &a_Point3, &b_Point3, ((vec_uint4){0,0xffffffff,0,0xffffffff}) );
    vmathSoaP3Get4Aos( &a_Point3, &aos_Point3_0, &aos_Point3_1, &aos_Point3_2, &aos_Point3_3 );
    vmathP3Prints( &aos_Point3_0, "select 0" );
    vmathP3Prints( &aos_Point3_1, "select 1" );
    vmathP3Prints( &aos_Point3_2, "select 2" );
    vmathP3Prints( &aos_Point3_3, "select 3" );
    vmathSoaP3LoadXYZArray( &a_Point3, (const vec_float4 *)xyz4 );
    vmathSoaP3Prints( &a_Point3, "load XYZ array" );
    vmathSoaV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathSoaV3Neg( &tmpV3_1, &tmpV3_0 );
    vmathSoaP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathSoaP3StoreXYZArray( &a_Point3, (vec_float4 *)xyz4 );
    vmathV4MakeFromElems( &aos_Vector4_0, xyz4[0], xyz4[1], xyz4[2], xyz4[3] );
    vmathV4MakeFromElems( &aos_Vector4_1, xyz4[4], xyz4[5], xyz4[6], xyz4[7] );
    vmathV4MakeFromElems( &aos_Vector4_2, xyz4[8], xyz4[9], xyz4[10], xyz4[11] );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
    printf("storeXYZ:-1.0 -2.0 -3.0 0.4\n");
    vmathSoaP3Copy( &a_Point3, &b_Point3 );
    vmathSoaP3Prints( &a_Point3, "assign to Point3 from Point3" );
    vmathSoaP3MakeFromScalar( &a_Point3, (vec_float4){0.0f} );
    vmathSoaP3Prints( &a_Point3, "set Point3 elements to zero" );
    vmathSoaP3SetElem( &a_Point3, 0, randfloat() );
    vmathSoaP3Prints( &a_Point3, "Point3::set( 0, float )" );
    vmathSoaP3SetElem( &a_Point3, 0, randfloat() );
    vmathSoaP3SetElem( &a_Point3, 0, vec_mul_float( vmathSoaP3GetElem( &a_Point3, 0 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 0, divf4( vmathSoaP3GetElem( &a_Point3, 0 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 0, vec_add_float( vmathSoaP3GetElem( &a_Point3, 0 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 0, vec_sub_float( vmathSoaP3GetElem( &a_Point3, 0 ), randfloat() ) );
    vmathSoaP3Prints( &a_Point3, "Point3::operator [](0)" );
    vmathSoaP3SetX( &a_Point3, randfloat() );
    vmathSoaP3Prints( &a_Point3, "Point3::setX()" );
    vmathSoaP3SetElem( &a_Point3, 1, randfloat() );
    vmathSoaP3Prints( &a_Point3, "Point3::set( 1, float )" );
    vmathSoaP3SetElem( &a_Point3, 1, randfloat() );
    vmathSoaP3SetElem( &a_Point3, 1, vec_mul_float( vmathSoaP3GetElem( &a_Point3, 1 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 1, divf4( vmathSoaP3GetElem( &a_Point3, 1 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 1, vec_add_float( vmathSoaP3GetElem( &a_Point3, 1 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 1, vec_sub_float( vmathSoaP3GetElem( &a_Point3, 1 ), randfloat() ) );
    vmathSoaP3Prints( &a_Point3, "Point3::operator [](1)" );
    vmathSoaP3SetY( &a_Point3, randfloat() );
    vmathSoaP3Prints( &a_Point3, "Point3::setY()" );
    vmathSoaP3SetElem( &a_Point3, 2, randfloat() );
    vmathSoaP3Prints( &a_Point3, "Point3::set( 2, float )" );
    vmathSoaP3SetElem( &a_Point3, 2, randfloat() );
    vmathSoaP3SetElem( &a_Point3, 2, vec_mul_float( vmathSoaP3GetElem( &a_Point3, 2 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 2, divf4( vmathSoaP3GetElem( &a_Point3, 2 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 2, vec_add_float( vmathSoaP3GetElem( &a_Point3, 2 ), randfloat() ) );
    vmathSoaP3SetElem( &a_Point3, 2, vec_sub_float( vmathSoaP3GetElem( &a_Point3, 2 ), randfloat() ) );
    vmathSoaP3Prints( &a_Point3, "Point3::operator [](2)" );
    vmathSoaP3SetZ( &a_Point3, randfloat() );
    vmathSoaP3Prints( &a_Point3, "Point3::setZ()" );
    printf("Point3::get( 0 ): %f\n", getfloat(vmathSoaP3GetElem( &a_Point3, 0 )) );
    printf("Point3::operator []( 0 ): %f\n", getfloat(vmathSoaP3GetElem( &a_Point3, 0 )) );
    printf("Point3::getX(): %f\n", getfloat(vmathSoaP3GetX( &a_Point3 )) );
    printf("Point3::get( 1 ): %f\n", getfloat(vmathSoaP3GetElem( &a_Point3, 1 )) );
    printf("Point3::operator []( 1 ): %f\n", getfloat(vmathSoaP3GetElem( &a_Point3, 1 )) );
    printf("Point3::getY(): %f\n", getfloat(vmathSoaP3GetY( &a_Point3 )) );
    printf("Point3::get( 2 ): %f\n", getfloat(vmathSoaP3GetElem( &a_Point3, 2 )) );
    printf("Point3::operator []( 2 ): %f\n", getfloat(vmathSoaP3GetElem( &a_Point3, 2 )) );
    printf("Point3::getZ(): %f\n", getfloat(vmathSoaP3GetZ( &a_Point3 )) );
    vmathSoaP3Sub( &tmpV3_2, &a_Point3, &b_Point3 );
    vmathSoaV3Prints( &tmpV3_2, "Point3 - Point3" );
    vmathSoaP3AddV3( &tmpP3_0, &a_Point3, &b_Vector3 );
    vmathSoaP3Prints( &tmpP3_0, "Point3 + Vector3" );
    vmathSoaP3SubV3( &tmpP3_1, &a_Point3, &b_Vector3 );
    vmathSoaP3Prints( &tmpP3_1, "Point3 - Vector3" );
    vmathSoaP3MulPerElem( &tmpP3_2, &a_Point3, &b_Point3 );
    vmathSoaP3Prints( &tmpP3_2, "mulPerElem( Point3, Point3 )" );
    vmathSoaP3DivPerElem( &tmpP3_3, &a_Point3, &b_Point3 );
    vmathSoaP3Prints( &tmpP3_3, "divPerElem( Point3, Point3 )" );
    vmathSoaP3RecipPerElem( &tmpP3_4, &a_Point3 );
    vmathSoaP3Prints( &tmpP3_4, "Point3 recip" );
    vmathSoaP3AbsPerElem( &tmpP3_5, &a_Point3 );
    vmathSoaP3SqrtPerElem( &tmpP3_6, &tmpP3_5 );
    vmathSoaP3Prints( &tmpP3_6, "Point3 sqrt" );
    vmathSoaP3AbsPerElem( &tmpP3_7, &a_Point3 );
    vmathSoaP3RsqrtPerElem( &tmpP3_8, &tmpP3_7 );
    vmathSoaP3Prints( &tmpP3_8, "Point3 rsqrt" );
    vmathSoaP3AbsPerElem( &tmpP3_9, &a_Point3 );
    vmathSoaP3Prints( &tmpP3_9, "Point3 abs" );
    vmathSoaP3CopySignPerElem( &tmpP3_10, &a_Point3, &b_Point3 );
    vmathSoaP3Prints( &tmpP3_10, "Point3 copySign" );
    vmathSoaP3MaxPerElem( &tmpP3_11, &a_Point3, &b_Point3 );
    vmathSoaP3Prints( &tmpP3_11, "Point3 maximum Point3" );
    vmathSoaP3MinPerElem( &tmpP3_12, &a_Point3, &b_Point3 );
    vmathSoaP3Prints( &tmpP3_12, "Point3 minimum Point3" );
    printf("Point3 maximum of elements: %f\n", getfloat(vmathSoaP3MaxElem( &a_Point3 )));
    printf("Point3 minimum of elements: %f\n", getfloat(vmathSoaP3MinElem( &a_Point3 )));
    printf("Point3 sum of elements: %f\n", getfloat(vmathSoaP3Sum( &a_Point3 )));
    printf("Point projection: %f\n", getfloat(vmathSoaP3Projection( &a_Point3, &b_Vector3 )));
    printf("Point distSqrFromOrigin: %f\n", getfloat(vmathSoaP3DistSqrFromOrigin( &a_Point3 )) );
    printf("Point distFromOrigin: %f\n", getfloat(vmathSoaP3DistFromOrigin( &a_Point3 )) );
    printf("Point distSqr: %f\n", getfloat(vmathSoaP3DistSqr( &a_Point3, &b_Point3 )) );
    printf("Point dist: %f\n", getfloat(vmathSoaP3Dist( &a_Point3, &b_Point3 )) );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &e_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Lerp( &a_Point3, randfloat(), &b_Point3, &c_Point3 );
    vmathSoaP3Prints( &a_Point3, "Point3 lerp" );
}

void
Quat_methods_test()
{
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathQuat aos_Quat_0, aos_Quat_1, aos_Quat_2, aos_Quat_3;
    VmathSoaQuat soa_Quat;
    VmathSoaVector3 tmpV3_0;
    VmathSoaQuat tmpQ_0, tmpQ_1, tmpQ_2, tmpQ_3, tmpQ_4, tmpQ_5, tmpQ_6, tmpQ_7;
    VmathSoaVector3 tmpV3_1;
    VmathSoaQuat tmpQ_8;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3MakeFromScalar( &c_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &d_Vector3, (vec_float4){0.0f} );
    vmathSoaV3MakeFromScalar( &e_Vector3, (vec_float4){0.0f} );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathSoaV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4MakeFromScalar( &c_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &d_Vector4, (vec_float4){0.0f} );
    vmathSoaV4MakeFromScalar( &e_Vector4, (vec_float4){0.0f} );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathSoaV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3MakeFromScalar( &c_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &d_Point3, (vec_float4){0.0f} );
    vmathSoaP3MakeFromScalar( &e_Point3, (vec_float4){0.0f} );
    vmathSoaP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathSoaP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQMakeFromScalar( &c_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &d_Quat, (vec_float4){0.0f} );
    vmathSoaQMakeFromScalar( &e_Quat, (vec_float4){0.0f} );
    vmathSoaQPrints( &c_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &d_Quat, "set Quat elements to zero" );
    vmathSoaQPrints( &e_Quat, "set Quat elements to zero" );
    vmathSoaQMakeFromV3Scalar( &a_Quat, &a_Vector3, randfloat() );
    vmathSoaQPrints( &a_Quat, "set Quat with Vector3, float" );
    vmathSoaQMakeFromV4( &a_Quat, &a_Vector4 );
    vmathSoaQPrints( &a_Quat, "construct Quat with Vector4" );
    vmathSoaQMakeFromScalar( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "set Quat with float" );
    vmathSoaQMakeFromScalar( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "set Quat with float" );
    vmathQMakeFromElems( &aos_Quat_0, 0.0f, 1.0f, 2.0f, 3.0f );
    vmathQMakeFromElems( &aos_Quat_1, 4.0f, 5.0f, 6.0f, 7.0f );
    vmathQMakeFromElems( &aos_Quat_2, 8.0f, 9.0f, 10.0f, 11.0f );
    vmathQMakeFromElems( &aos_Quat_3, 12.0f, 13.0f, 14.0f, 15.0f );
    vmathSoaQMakeFrom4Aos( &soa_Quat, &aos_Quat_0, &aos_Quat_1, &aos_Quat_2, &aos_Quat_3 );
    vmathSoaQGet4Aos( &soa_Quat, &aos_Quat_3, &aos_Quat_2, &aos_Quat_1, &aos_Quat_0 );
    vmathQPrints( &aos_Quat_0, "aos type 0" );
    vmathQPrints( &aos_Quat_1, "aos type 1" );
    vmathQPrints( &aos_Quat_2, "aos type 2" );
    vmathQPrints( &aos_Quat_3, "aos type 3" );
    vmathSoaQSelect( &a_Quat, &a_Quat, &b_Quat, ((vec_uint4){0,0xffffffff,0,0xffffffff}) );
    vmathSoaQGet4Aos( &a_Quat, &aos_Quat_0, &aos_Quat_1, &aos_Quat_2, &aos_Quat_3 );
    vmathQPrints( &aos_Quat_0, "select 0" );
    vmathQPrints( &aos_Quat_1, "select 1" );
    vmathQPrints( &aos_Quat_2, "select 2" );
    vmathQPrints( &aos_Quat_3, "select 3" );
    vmathSoaQCopy( &a_Quat, &b_Quat );
    vmathSoaQPrints( &a_Quat, "assign to Quat from Quat" );
    vmathSoaQSetXYZ( &a_Quat, &a_Vector3 );
    vmathSoaQPrints( &a_Quat, "set Quat xyz" );
    vmathSoaQGetXYZ( &tmpV3_0, &a_Quat );
    vmathSoaV3Prints( &tmpV3_0, "get Quat xyz" );
    vmathSoaQMakeFromScalar( &a_Quat, (vec_float4){0.0f} );
    vmathSoaQPrints( &a_Quat, "set Quat elements to zero" );
    vmathSoaQSetElem( &a_Quat, 0, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::set( 0, float )" );
    vmathSoaQSetElem( &a_Quat, 0, randfloat() );
    vmathSoaQSetElem( &a_Quat, 0, vec_mul_float( vmathSoaQGetElem( &a_Quat, 0 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 0, divf4( vmathSoaQGetElem( &a_Quat, 0 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 0, vec_add_float( vmathSoaQGetElem( &a_Quat, 0 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 0, vec_sub_float( vmathSoaQGetElem( &a_Quat, 0 ), randfloat() ) );
    vmathSoaQPrints( &a_Quat, "Quat::operator [](0)" );
    vmathSoaQSetX( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::setX()" );
    vmathSoaQSetElem( &a_Quat, 1, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::set( 1, float )" );
    vmathSoaQSetElem( &a_Quat, 1, randfloat() );
    vmathSoaQSetElem( &a_Quat, 1, vec_mul_float( vmathSoaQGetElem( &a_Quat, 1 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 1, divf4( vmathSoaQGetElem( &a_Quat, 1 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 1, vec_add_float( vmathSoaQGetElem( &a_Quat, 1 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 1, vec_sub_float( vmathSoaQGetElem( &a_Quat, 1 ), randfloat() ) );
    vmathSoaQPrints( &a_Quat, "Quat::operator [](1)" );
    vmathSoaQSetY( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::setY()" );
    vmathSoaQSetElem( &a_Quat, 2, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::set( 2, float )" );
    vmathSoaQSetElem( &a_Quat, 2, randfloat() );
    vmathSoaQSetElem( &a_Quat, 2, vec_mul_float( vmathSoaQGetElem( &a_Quat, 2 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 2, divf4( vmathSoaQGetElem( &a_Quat, 2 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 2, vec_add_float( vmathSoaQGetElem( &a_Quat, 2 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 2, vec_sub_float( vmathSoaQGetElem( &a_Quat, 2 ), randfloat() ) );
    vmathSoaQPrints( &a_Quat, "Quat::operator [](2)" );
    vmathSoaQSetZ( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::setZ()" );
    vmathSoaQSetElem( &a_Quat, 3, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::set( 3, float )" );
    vmathSoaQSetElem( &a_Quat, 3, randfloat() );
    vmathSoaQSetElem( &a_Quat, 3, vec_mul_float( vmathSoaQGetElem( &a_Quat, 3 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 3, divf4( vmathSoaQGetElem( &a_Quat, 3 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 3, vec_add_float( vmathSoaQGetElem( &a_Quat, 3 ), randfloat() ) );
    vmathSoaQSetElem( &a_Quat, 3, vec_sub_float( vmathSoaQGetElem( &a_Quat, 3 ), randfloat() ) );
    vmathSoaQPrints( &a_Quat, "Quat::operator [](3)" );
    vmathSoaQSetW( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat::setW()" );
    printf("Quat::get( 0 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 0 )) );
    printf("Quat::operator []( 0 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 0 )) );
    printf("Quat::getX(): %f\n", getfloat(vmathSoaQGetX( &a_Quat )) );
    printf("Quat::get( 1 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 1 )) );
    printf("Quat::operator []( 1 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 1 )) );
    printf("Quat::getY(): %f\n", getfloat(vmathSoaQGetY( &a_Quat )) );
    printf("Quat::get( 2 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 2 )) );
    printf("Quat::operator []( 2 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 2 )) );
    printf("Quat::getZ(): %f\n", getfloat(vmathSoaQGetZ( &a_Quat )) );
    printf("Quat::get( 3 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 3 )) );
    printf("Quat::operator []( 3 ): %f\n", getfloat(vmathSoaQGetElem( &a_Quat, 3 )) );
    printf("Quat::getW(): %f\n", getfloat(vmathSoaQGetW( &a_Quat )) );
    vmathSoaQAdd( &tmpQ_0, &a_Quat, &b_Quat );
    vmathSoaQPrints( &tmpQ_0, "Quat + Quat" );
    vmathSoaQSub( &tmpQ_1, &a_Quat, &b_Quat );
    vmathSoaQPrints( &tmpQ_1, "Quat - Quat" );
    vmathSoaQMul( &tmpQ_2, &a_Quat, &b_Quat );
    vmathSoaQPrints( &tmpQ_2, "Quat * Quat" );
    vmathSoaQScalarMul( &tmpQ_3, &a_Quat, randfloat() );
    vmathSoaQPrints( &tmpQ_3, "Quat * float" );
    vmathSoaQScalarDiv( &tmpQ_4, &a_Quat, randfloat() );
    vmathSoaQPrints( &tmpQ_4, "Quat / float" );
    vmathSoaQScalarMul( &tmpQ_5, &a_Quat, randfloat() );
    vmathSoaQPrints( &tmpQ_5, "float * Quat" );
    vmathSoaQNeg( &tmpQ_6, &a_Quat );
    vmathSoaQPrints( &tmpQ_6, "Quat negate" );
    printf("Quat dot Quat: %f\n", getfloat(vmathSoaQDot( &a_Quat, &b_Quat )));
    printf("Quat lengthSqr: %f\n", getfloat(vmathSoaQNorm( &a_Quat )));
    printf("Quat length: %f\n", getfloat(vmathSoaQLength( &a_Quat )));
    vmathSoaQNormalize( &tmpQ_7, &a_Quat );
    vmathSoaQPrints( &tmpQ_7, "Quat normalized" );
    vmathSoaQMakeIdentity( &a_Quat );
    vmathSoaQPrints( &a_Quat, "set to identity" );
    vmathSoaQMakeRotationArc( &a_Quat, &a_Vector3, &b_Vector3 );
    vmathSoaQPrints( &a_Quat, "Quat rotation between vectors" );
    vmathSoaQMakeRotationAxis( &a_Quat, randfloat(), &a_Vector3 );
    vmathSoaQPrints( &a_Quat, "Quat rotation axis angle" );
    vmathSoaQMakeRotationX( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat rotationX" );
    vmathSoaQMakeRotationY( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat rotationY" );
    vmathSoaQMakeRotationZ( &a_Quat, randfloat() );
    vmathSoaQPrints( &a_Quat, "Quat rotationZ" );
    vmathSoaQRotate( &tmpV3_1, &a_Quat, &a_Vector3 );
    vmathSoaV3Prints( &tmpV3_1, "Quat rotate Vector3" );
    vmathSoaQConj( &tmpQ_8, &a_Quat );
    vmathSoaQPrints( &tmpQ_8, "Quat conj" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &e_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQNormalize( &b_Quat, &b_Quat );
    vmathSoaQNormalize( &c_Quat, &c_Quat );
    vmathSoaQNormalize( &d_Quat, &d_Quat );
    vmathSoaQNormalize( &e_Quat, &e_Quat );
    vmathSoaQLerp( &a_Quat, randfloat(), &b_Quat, &c_Quat );
    vmathSoaQPrints( &a_Quat, "Quat lerp" );
    vmathSoaQSlerp( &a_Quat, randfloat(), &b_Quat, &c_Quat );
    vmathSoaQPrints( &a_Quat, "Quat slerp" );
    vmathSoaQSquad( &a_Quat, randfloat(), &b_Quat, &c_Quat, &d_Quat, &e_Quat );
    vmathSoaQPrints( &a_Quat, "Quat squad" );
}

int main()
{
    printf("\n __begin__ \n");
    for ( iteration = 0; iteration < 2; iteration++ ) {
        Vector3_methods_test();
        Vector4_methods_test();
        Point3_methods_test();
        Quat_methods_test();
    }
    printf("\n __end__ \n");
    return 0;
}
