#include "gui/gui.h"
#include "gui/multi_image.h"
using namespace VGUI;


MultiImage::MultiImage( Widget* w )
{
	center = w->GetCenter();
	name = w->GetName();
	text = w->GetText();
	type = w->GetType();
	tip = w->GetTip();
	rel_width = w->GetRelWidth();
	rel_height = w->GetRelHeight();
	enabled = w->GetEnabled();
	selected = w->GetSelected();
	is_default = w->GetDefault();
	is_cancel = w->GetCancel();
	has_icon = w->GetHasIcon();
	width_auto = w->GetWidthAuto();
	height_auto = w->GetHeightAuto();
	font_size = w->GetFontSize();
	color_r = w->GetColorR();
	color_g = w->GetColorG();
	color_b = w->GetColorB();
	cur_option = 0;
	last_option = 10000;
}

MultiImage::~MultiImage()
{
}

void MultiImage::Load()
{
	//img_tex_list.reserve(256);
	string filename;
	int img_width, img_height;
	for( unsigned int i = 0; i < filename_list.size(); i++ )
	{
		filename = settings.GetDataDir() + "/tracks/" + filename_list[i] + "/trackshot.png";
		//img_tex.Load( filename.c_str(), false, img_width, img_height );
		TEXTURE_HANDLE img_tex;
		//img_tex.Load( filename.c_str(), false, img_width, img_height );
		img_tex_list.push_back( img_tex );
		img_tex_list.back().Load( filename.c_str(), false, img_width, img_height );
		
		//cout << "cur_option: " << cur_option << ", filename_list[i]: " << filename_list[i] << ", img_tex_list[i]: " << img_tex_list[i] << ", value_list[i]: " << value_list[i] << endl;
		//if( width_auto )
		//{
			//rel_width = (float)img_width / 1280.0f;
		//}

		//if( height_auto )
		//{
			//rel_height = (float)img_height / 1024.0f;
		//}
	}
			//rel_width = (float)img_width / 1280.0f;
			//rel_height = (float)img_height / 1024.0f;
}

void MultiImage::ResetValue()
{
	string default_val;
	settings.Get( setting, default_val );
	SetValue( default_val );
}

void MultiImage::Draw()
{
	Draw( 1.0 );
}

void MultiImage::Draw( float opacity )
{
	float cur_opacity = 1.0;
	float center_x = center.GetXPercent();
	float center_y = center.GetYPercent();
	float rel_width_half = rel_width / 2.0f;
	float rel_height_half = rel_height / 2.0f;
	//cout << "cur_option: " << cur_option << ", filename_list[cur_option]: " << filename_list[cur_option] << ", img_tex_list[cur_option]: " << img_tex_list[cur_option] << ", value_list[cur_option]: " << value_list[cur_option] << endl;
	//cout << "rel_width: " << rel_width << ", rel_height: " << rel_height << endl;
	TEXTURE_HANDLE * img1 = &(img_tex_list[cur_option]);

	if( last_option != 10000 )
	{
		float elapsed_time = ( (float)( SDL_GetTicks() - press_time ) / 1000.0 );
		if( elapsed_time <= 0.2 )
		{
			TEXTURE_HANDLE * img2 = &(img_tex_list[last_option]);
			cur_opacity = ( elapsed_time / 0.2 );
			float last_opacity = 1.0 - cur_opacity;
			utility.Draw2D( center_x - rel_width_half, center_y - rel_height_half, center_x + rel_width_half, center_y + rel_height_half, img2, 0.0, 0, last_opacity * opacity );
		}
		else
		{
			last_option = 10000;
		}
	}
	utility.Draw2D( center_x - rel_width_half, center_y - rel_height_half, center_x + rel_width_half, center_y + rel_height_half, img1, 0.0, 0, cur_opacity * opacity );
}

void MultiImage::HookIncValuePress()
{
	Release();
	r_down = true;
}

void MultiImage::HookIncValueRelease()
{
	Release();
	if( cur_option < filename_list.size() - 1 )
	{
		press_time = SDL_GetTicks();
		last_option = cur_option;
		cur_option++;
	}
}

void MultiImage::HookDecValuePress()
{
	Release();
	l_down = true;
	press_time = SDL_GetTicks();
}

void MultiImage::HookDecValueRelease()
{
	Release();
	if( cur_option > 0 )
	{
		press_time = SDL_GetTicks();
		last_option = cur_option;
		cur_option--;
	}
}

void MultiImage::Release()
{
	r_down = l_down = false;
}

bool MultiImage::MouseOver( float x, float y )
{
/*	float min_x, min_y, max_x, max_y;
	min_x = center.GetXPercent() - ( rel_width / 2.0f );
	min_y = center.GetYPercent() - ( rel_height / 2.0f );
	max_x = center.GetXPercent() + ( rel_width / 2.0f );
	max_y = center.GetYPercent() + ( rel_height / 2.0f );

	return ( x > min_x ) && ( x < max_x ) && ( y > min_y ) && ( y < max_y );
*/	return false;
}

string MultiImage::MousePress( float x, float y )
{
/*	float l_min_x, l_min_y, l_max_x, l_max_y;
	float r_min_x, r_min_y, r_max_x, r_max_y;
	l_min_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing;
	l_min_y = center.GetYPercent() - ( rel_height / 2.0f );
	l_max_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing + tex_width;
	l_max_y = center.GetYPercent() + ( rel_height / 2.0f );
	r_min_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing  + 0.15;
	r_min_y = center.GetYPercent() - ( rel_height / 2.0f );
	r_max_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing  + 0.15 + tex_width;
	r_max_y = center.GetYPercent() + ( rel_height / 2.0f );

	if( ( x > l_min_x ) && ( x < l_max_x ) && ( y > l_min_y ) && ( y < l_max_y ) )
	{
		l_down = true;
	}
	else if( ( x > r_min_x ) && ( x < r_max_x ) && ( y > r_min_y ) && ( y < r_max_y ) )
	{
		r_down = true;
	}
*/
	return "";
}

string MultiImage::MouseRelease( float x, float y )
{
/*	float l_min_x, l_min_y, l_max_x, l_max_y;
	float r_min_x, r_min_y, r_max_x, r_max_y;
	l_min_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing;
	l_min_y = center.GetYPercent() - ( rel_height / 2.0f );
	l_max_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing + tex_width;
	l_max_y = center.GetYPercent() + ( rel_height / 2.0f );
	r_min_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing  + 0.15;
	r_min_y = center.GetYPercent() - ( rel_height / 2.0f );
	r_max_x = center.GetXPercent() - ( rel_width / 2.0f ) + spacing  + 0.15 + tex_width;
	r_max_y = center.GetYPercent() + ( rel_height / 2.0f );


	if( ( x > l_min_x ) && ( x < l_max_x ) && ( y > l_min_y ) && ( y < l_max_y ) && l_down )
	{
		DecValueRelease();
	}
	else if( ( x > r_min_x ) && ( x < r_max_x ) && ( y > r_min_y ) && ( y < r_max_y ) && r_down )
	{
		IncValueRelease();
	}
	else
	{
		Release();
	}
*/
	return "";
}
