#include "gui/gui.h"
#include "gui/button.h"
using namespace VGUI;


Button::Button( Widget* w )
{
	action = "";
	center = w->GetCenter();
	name = w->GetName();
	text = w->GetText();
	type = w->GetType();
	tip = w->GetTip();
	rel_width = w->GetRelWidth();
	rel_height = w->GetRelHeight();
	enabled = w->GetEnabled();
	selected = w->GetSelected();
	is_default = w->GetDefault();
	is_cancel = w->GetCancel();
	has_icon = w->GetHasIcon();
	width_auto = w->GetWidthAuto();
	height_auto = w->GetHeightAuto();
	down = false;
	font_size = w->GetFontSize();
	color_r = w->GetColorR();
	color_g = w->GetColorG();
	color_b = w->GetColorB();

	string skin_path = settings.GetSkinPath();
	btn_up.Load( skin_path + "/textures/widgets/btn_up.png", false );
	btn_down.Load( skin_path + "/textures/widgets/btn_down.png", false );

	tex_width = 0.0555;
	tex_height = 0.0740;

	// width = font width + width of the end caps + width of 0.01 between each cap and text
	if( width_auto )
	{
		rel_width = font.Width( text.c_str(), 1, font_size ) + tex_width;
	}

	// height = button texture height
	if( height_auto )
	{
		rel_height = tex_height;
	}
}

Button::~Button()
{
}

void Button::Draw()
{
	Draw( 1.0 );
}

void Button::Draw( float opacity )
{
	float center_x = center.GetXPercent();
	float center_y = center.GetYPercent();
	float rel_height_half = rel_height / 2.0f;
	float text_width = font.Width( text.c_str(), 1, font_size );
	float text_width_half = text_width / 2.0f;
	float text_height = font.Height( text.c_str(), 1, font_size );
	float text_height_half = text_height / 2.0f;
	float opacity_txt = selected ? 1.0 : enabled ? 0.6 : 0.4;
	float btn_opacity = selected ? 0.9 : enabled ? 0.6 : 0.4;

	TEXTURE_HANDLE * btn_tex = down ? &btn_down : &btn_up;

	// draw button face
	utility.DrawButton( center_x - text_width_half,
	                    center_y - rel_height_half,
	                    center_x + text_width_half,
	                    center_y + rel_height_half,
	                    0.02777, btn_tex, btn_opacity * opacity );

	// draw text
	font.Print( center_x - text_width_half, center_y - text_height_half, text.c_str(), 1, font_size, color_r, color_g, color_b, opacity_txt * opacity );

	// draw tip
	if( selected && ( tip != "" ) )
		font.Print( 0.5 - ( font.Width( tip.c_str(), 1, 6 ) / 2.0f ), 0.90, tip.c_str(), 1, 6, 0.7, 0.7, 0.7, 0.9 * opacity );
}

bool Button::MouseOver( float x, float y )
{
	float min_x, min_y, max_x, max_y;
	min_x = center.GetXPercent() - ( rel_width / 2.0f );
	min_y = center.GetYPercent() - ( rel_height / 2.0f );
	max_x = center.GetXPercent() + ( rel_width / 2.0f );
	max_y = center.GetYPercent() + ( rel_height / 2.0f );

	return ( x > min_x ) && ( x < max_x ) && ( y > min_y ) && ( y < max_y );
}

string Button::MousePress( float x, float y )
{
	down = true;
	return "";
}

string Button::MouseRelease( float x, float y )
{
	down = false;
	return "";
}

void Button::Press()
{
	down = true;
}

void Button::Release()
{
	down = false;
}
