/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gamestate.h"

GAMESTATE::GAMESTATE()
{
	state = STATE_INIT;
}

void GAMESTATE::UpdateSettings()
{
	int m;
	settings.Get( "game.game_mode", m );
	mode = (MODES)m;
}

STATES GAMESTATE::GetGameState()
{
	return state;
}

void GAMESTATE::SetGameState(STATES newstate)
{
	state = newstate;
}

void GAMESTATE::SetCarName(int p, string cn)
{
	players[p].carname = cn;
	//cout << p << "," << cn << endl;
	if (p == 0) 
		settings.Set("game.selected_car",cn);
}

void GAMESTATE::SetCarPaint(int p, int cp)
{
	players[p].carpaint = cp;
	if (p == 0)
		settings.Set("game.car_paint",cp);
}
