//	Vamos Automotive Simulator
//  Copyright (C) 2001--2003 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _TEXTURE_IMAGE_H_
#define _TEXTURE_IMAGE_H_

#include <string>
#include <fstream>
#include <iostream>

#include <stdio.h>

namespace Vamos_Geometry
{
  // Exception class for texture files that can't be found.
  class Missing_Texture_File
  {
	std::string m_file;
  public:
	Missing_Texture_File (std::string file) : m_file (file) {};
	std::string message () const { return m_file; }
  };

  class Texture_Image
  {
//	unsigned char* m_data;
    protected:
	int m_data_size;
	int m_width_pixels;
	int m_height_pixels;
	double m_width;
	double m_height;
	int m_channels;

  public:
	Texture_Image (std::string file_name, 
				   double width = 1.0,
				   double height = 1.0);
	Texture_Image (const Texture_Image& image);
	//virtual ~Texture_Image ();

	const Texture_Image& operator = (const Texture_Image& image);
	//const unsigned char* data () const { return m_data; }
	int width_pixels () const { return m_width_pixels; }
    int height_pixels () const { return m_height_pixels; }
    double aspect_ratio () const 
    { return double (m_width_pixels) / m_height_pixels; }

    void set_width (double width) { m_width = width; }
    void set_height (double height) { m_height = height; }
	
 	double height () const { return m_height; }
 	double width () const { return m_width; }
	int channels () const { return m_channels; }
  };
  
  
}

#endif
