//	Vamos Automotive Simulator
//  Copyright (C) 2001--2002 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _SURFACE_H_
#define _SURFACE_H_

#include <vamos/geometry/Gl_Texture_Image.h>
#include <vamos/geometry/Handle.h>

#include <string>

namespace Vamos_Geometry
{
  class Material;
  typedef Handle <Material> Material_Handle;

  class Material
  {
  public:
	enum Material_Type
	  {
		RUBBER,
		METAL,
		ASPHALT,
		CONCRETE,
		GRASS,
		GRAVEL,
		DIRT,
		UNKNOWN
	  };

  private:
	Material_Type m_type;

	// The frictional properties of the car are muliplied by these factors
	// for this particular surface.  They should all be 1.0 for pavement.
	double m_friction_factor;
	double m_restitution_factor;
	double m_rolling_resistance_factor;
	double m_drag_factor;

	double m_bump_amplitude;
	double m_bump_wavelength;

	// The texture that gets mapped to this surface.
	Gl_Texture_Image* mp_texture_image;

  public:
	Material (Material_Type type, double friction, double restitution,
			  double rolling = 0.0, double drag = 0.0, 
			  double bump_amplitude = 0.0, double bump_wavelength = 0.0,
			  Gl_Texture_Image* image = 0);
	Material ();
	Material (const Material& material);
	~Material ();

	const Material& operator = (const Material& material);

	Gl_Texture_Image* texture_image () { return mp_texture_image; }
	double friction_factor () const { return m_friction_factor; }
	double rolling_resistance_factor () const 
	{ return m_rolling_resistance_factor; }
	double drag_factor () const { return m_drag_factor; }
	double restitution_factor () const { return m_restitution_factor; }
	double bump (double distance) const;
	Material_Type type () const { return m_type; }
  };
}

#endif
