//	Vamos - a driving simulator
//  Copyright (C) 2001 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _CONVERSIONS_H_
#define _CONVERSIONS_H_

#include <vamos/geometry/Constants.h>

#include <algorithm>

// Windows' normal build config defines these as macros.
// Undefine these to get real std::min() and std::max() usuable.
#ifdef WIN32
# undef min
# undef max
#endif

namespace Vamos_Geometry
{
  inline double rad_to_deg (double rad) { return rad * 180.0 / pi; }
  inline double deg_to_rad (double deg) { return deg * pi / 180.0; }

  inline double rad_s_to_rpm (double rad_s) { return rad_s * 30.0 / pi; }
  inline double rpm_to_rad_s (double rpm) { return rpm * pi / 30.0; }

  inline double m_s_to_km_h (double m_s) { return m_s * 3.6; } 
  inline double km_h_to_m_s (double km_h) { return km_h / 3.6; } 

  template <typename T> T clip (T value, T low, T high)
  { return std::max (std::min (value, high), low); }
  
  template <typename T> T  sign (T value)
  { return value == 0 ? 0 : (value > 0 ? 1 : -1); }
}

#endif
