#ifndef _VGUI_TOGGLE_H
#define _VGUI_TOGGLE_H

/* toggle.h */
#include "gui.h"

namespace VGUI
{
	class Toggle : public Widget
	{
	private:
		TEXTURE_HANDLE on_up, on_down, off_up, off_down;
		bool value, default_value;
		string setting;
		string true_txt;
		string false_txt;
		float tex_width, tex_height, spacing;
		bool down;

	public:
		Toggle();
		Toggle( Widget* w );
		~Toggle();
		void Draw();
		void Draw( float opacity );
		void Save();
		bool MouseOver( float x, float y );
		string MousePress( float x, float y );
		string MouseRelease( float x, float y );
		void Press();
		void Release();
		void ResetValue();

		bool GetValue() { return value; }
		bool GetDefaultValue() { return default_value; }
		string GetTrueText() { return true_txt; }
		string GetFalseText() { return false_txt; }
		float GetSpacing() { return spacing; }
		void SetValue( bool new_value ) { value = new_value; }
		void SetDefaultValue( bool new_value ) { default_value = new_value; }
		void SetTrueText( string txt ) { true_txt = txt; }
		void SetFalseText( string txt ) { false_txt = txt; }
		void SetSetting( string new_setting ) { setting = new_setting; }
		void SetSpacing( float new_spacing );
		void TogValue() { value = !value; }
	};
}


#endif // _VGUI_TOGGLE_H
