#ifndef _VGUI_SLIDER_H
#define _VGUI_SLIDER_H

/* slider.h */
#include "gui.h"

namespace VGUI
{
	class Slider : public Widget
	{
	public:
		Slider() { }
		Slider( Widget* w );
		~Slider();
		void Draw();
		void Draw( float opacity );
		void Save();
		bool MouseOver( float x, float y );
		string MousePress( float x, float y );
		string MouseRelease( float x, float y );
		void ResetValue();

		float GetValue() { return value; }
		float GetDefaultValue() { return default_value; }
		void SetValue( float new_value ) { value = new_value; }
		void SetDefaultValue( float new_value ) { default_value = new_value; }
		void SetSetting( string new_setting ) { setting = new_setting; }
		void IncValuePress();
		void DecValuePress();
		void IncValueRelease();
		void DecValueRelease();
		void Release() { }

	private:
		TEXTURE_HANDLE slider, cursor;
		float value, default_value;
		string setting;
		float wedge_tex_width, wedge_width, wedge_height, cursor_width, cursor_height, cursor_offset;
	};
}


#endif // _VGUI_SLIDER_H
