/***************************************************************************
 * vim: set noet sw=8 cino=:
 * Copyright (c) 2006  Matthew Nicholson <matt@matt-land.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _EXCEPTION_H
#define _EXCEPTION_H

#include <exception>
#include <string>

namespace VDrift
{

class EXCEPTION : public std::exception 
{
	public:
		explicit EXCEPTION(const std::string& description) : std::exception(), description(description)
		{
		}

		virtual const char* what() const throw()
		{
			return description.c_str();
		}

		virtual ~EXCEPTION() throw() { }
	private:
		std::string description;
		
};

class INIT_ERROR : public EXCEPTION
{
	public:
		INIT_ERROR() : EXCEPTION("Initilization error") { }
		explicit INIT_ERROR(const std::string& description) : EXCEPTION(description) { }
		virtual ~INIT_ERROR() throw() { }
};

}


#endif /* _EXCEPTION_H */
