/*
 * Sudoku: A plug-in for the Video Disk Recorder
 *
 * Copyright (C) 2005-2008, Thomas Gnther <tom@toms-cafe.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * $Id: i18n.cpp 164 2008-11-27 00:00:38Z tom $
 *
 *
 * Translations provided by:
 *
 * Italian     Diego Pierotto <vdr-italian@tiscali.it>
 * French      Patrice Staudt <patr.staudt@laposte.net>
 *             NIVAL Michal <mnival@vdrbox.lautre.net>
 * Finnish     Ville Skytt <ville.skytta@iki.fi>
 * Spanish     Bittor Corl <bittor7x0 _at_ gmail.com>
 *
 */

#include "i18n.h"
#include <vdr/config.h>


#if VDRVERSNUM < 10507

const tI18nPhrase SudokuPlugin::Phrases[] = {
  { "Sudoku", // English
    "Sudoku", // Deutsch / German
    "", // Slovenski / Slovenian
    "Sudoku", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Sudoku", // Franais / French
    "", // Norsk / Norwegian
    "Sudoku", // suomi / Finnish
    "", // Polski / Polish
    "Sudoku", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Sudoku - generate and solve Number Place puzzles", // English
    "Sudoku - Erzeugen und Lsen von Zahlenpuzzles", // Deutsch / German
    "", // Slovenski / Slovenian
    "Sudoku - Genera e risolvi il rompicapo dei numeri", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Sudoku - crer et rsoudre des puzzles de chiffres", // Franais / French
    "", // Norsk / Norwegian
    "Sudoku-numeroristikot", // suomi / Finnish
    "", // Polski / Polish
    "Solucionar rompecabezas numrico", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Generate a new puzzle", // English
    "Neues Puzzle erzeugen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Genera nuova partita", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Crer un nouveau puzzle", // Franais / French
    "", // Norsk / Norwegian
    "Uusi ristikko", // suomi / Finnish
    "", // Polski / Polish
    "Generar nuevo rompecabezas", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Load a puzzle", // English
    "Puzzle laden", // Deutsch / German
    "", // Slovenski / Slovenian
    "Carica partita", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Charger un puzzle", // Franais / French
    "", // Norsk / Norwegian
    "Lataa ristikko", // suomi / Finnish
    "", // Polski / Polish
    "Cargar un rompecabezas", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Save the puzzle", // English
    "Puzzle speichern", // Deutsch / German
    "", // Slovenski / Slovenian
    "Salva partita", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Sauvegarder le puzzle", // Franais / French
    "", // Norsk / Norwegian
    "Tallenna ristikko", // suomi / Finnish
    "", // Polski / Polish
    "Guardar rompecabezas", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Undo last action", // English
    "Letzte Aktion zurcknehmen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Annulla ultima azione", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Annuler la dernire action", // Franais / French
    "", // Norsk / Norwegian
    "Peru viimeisin", // suomi / Finnish
    "", // Polski / Polish
    "Deshacer ltima accin", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Redo last action", // English
    "Letzte Aktion wiederholen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Ripeti ultima azione", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Rpter la dernire action", // Franais / French
    "", // Norsk / Norwegian
    "Toista viimeisin", // suomi / Finnish
    "", // Polski / Polish
    "Rehacer ltima accin", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Mark/unmark", // English
    "Markierung setzen/lschen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Marca/Smarca", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Marquer/Dmarquer", // Franais / French
    "", // Norsk / Norwegian
    "Merkitse/poista merkint", // suomi / Finnish
    "", // Polski / Polish
    "Marcar/desmarcar", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Next cell", // English
    "Nchste Zelle", // Deutsch / German
    "", // Slovenski / Slovenian
    "Cella successiva", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Cellule suivante", // Franais / French
    "", // Norsk / Norwegian
    "Seuraava ruutu", // suomi / Finnish
    "", // Polski / Polish
    "Celda siguiente", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Next number", // English
    "Nchste Zahl", // Deutsch / German
    "", // Slovenski / Slovenian
    "Num. successivo", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Nombre suivant", // Franais / French
    "", // Norsk / Norwegian
    "Seuraava numero", // suomi / Finnish
    "", // Polski / Polish
    "Nmero siguiente", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Reset the puzzle", // English
    "Puzzle zurcksetzen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Ricomincia partita", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Remise  zro du puzzle", // Franais / French
    "", // Norsk / Norwegian
    "Tyhjenn ristikko", // suomi / Finnish
    "", // Polski / Polish
    "Reiniciar el rompecabezas", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Open setup menu", // English
    "Einstellungsmen ffnen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Apri menu opzioni", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Ouvrir le menu de configuration", // Franais / French
    "", // Norsk / Norwegian
    "Asetukset", // suomi / Finnish
    "", // Polski / Polish
    "Abrir men de opciones", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Exit", // English
    "Beenden", // Deutsch / German
    "", // Slovenski / Slovenian
    "Esci", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Terminer", // Franais / French
    "", // Norsk / Norwegian
    "Poistu", // suomi / Finnish
    "", // Polski / Polish
    "Salir", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Sudoku list", // English
    "Sudoku-Liste", // Deutsch / German
    "", // Slovenski / Slovenian
    "Elenco Sudoku", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Liste Sudoku", // Franais / French
    "", // Norsk / Norwegian
    "Tallennetut ristikot", // suomi / Finnish
    "", // Polski / Polish
    "Lista Sudoku", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Delete the puzzle?", // English
    "Puzzle lschen?", // Deutsch / German
    "", // Slovenski / Slovenian
    "Eliminare la partita?", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Supprimer le puzzle ?", // Franais / French
    "", // Norsk / Norwegian
    "Poistetaanko ristikko?", // suomi / Finnish
    "", // Polski / Polish
    "Borrar el rompecabezas?", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Button$Load", // English
    "Laden", // Deutsch / German
    "", // Slovenski / Slovenian
    "Carica", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Charger", // Franais / French
    "", // Norsk / Norwegian
    "Lataa", // suomi / Finnish
    "", // Polski / Polish
    "Cargar", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Button$Back", // English
    "Zurck", // Deutsch / German
    "", // Slovenski / Slovenian
    "Indietro", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Retour", // Franais / French
    "", // Norsk / Norwegian
    "Takaisin", // suomi / Finnish
    "", // Polski / Polish
    "Volver", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Edit sudoku list", // English
    "Sudoku-Liste bearbeiten", // Deutsch / German
    "", // Slovenski / Slovenian
    "Modifica elenco Sudoku", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Editer la liste Sudoku", // Franais / French
    "", // Norsk / Norwegian
    "Ristikon tiedot", // suomi / Finnish
    "", // Polski / Polish
    "Editar lista Sudoku", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Description", // English
    "Beschreibung", // Deutsch / German
    "", // Slovenski / Slovenian
    "Descrizione", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Description", // Franais / French
    "", // Norsk / Norwegian
    "Kuvaus", // suomi / Finnish
    "", // Polski / Polish
    "Descripcin", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Givens count", // English
    "Anzahl vorgegebener Zahlen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Numero cifre assegnate", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Nombre de chiffre donn", // Franais / French
    "", // Norsk / Norwegian
    "Annettujen numeroiden lukumr", // suomi / Finnish
    "", // Polski / Polish
    "Celdas rellenadas", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Symmetric givens", // English
    "Vorgegebene Zahlen symmetrisch anordnen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Cifre simmetriche assegnate", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Chiffre donn symtrique", // Franais / French
    "", // Norsk / Norwegian
    "Jrjest annetut symmetrisesti", // suomi / Finnish
    "", // Polski / Polish
    "Nmeros simtricos rellenados", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Mark errors", // English
    "Fehler markieren", // Deutsch / German
    "", // Slovenski / Slovenian
    "Segna errori", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Marquer les erreurs", // Franais / French
    "", // Norsk / Norwegian
    "Merkitse virheet", // suomi / Finnish
    "", // Polski / Polish
    "Marcar errores", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Mark ambiguous numbers", // English
    "Unklare Zahlen markieren", // Deutsch / German
    "", // Slovenski / Slovenian
    "Segna numeri ambigui", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Marquer les chiffres anbigus", // Franais / French
    "", // Norsk / Norwegian
    "Merkitse epvarmat", // suomi / Finnish
    "", // Polski / Polish
    "Marcar nmeros ambiguos", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Show possible numbers as pattern", // English
    "Mgliche Zahlen als Muster anzeigen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Mostra num. possibili in valori", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Afficher les chiffres possible comme modle", // Franais / French
    "", // Norsk / Norwegian
    "Nyt mahdolliset kuviona", // suomi / Finnish
    "", // Polski / Polish
    "Mostrar posibles nm. como patrn", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Show possible numbers as digits", // English
    "Mgliche Zahlen als Ziffern anzeigen", // Deutsch / German
    "", // Slovenski / Slovenian
    "Mostra num. possibili in cifre", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Afficher les chiffres possible comme chiffre", // Franais / French
    "", // Norsk / Norwegian
    "Nyt mahdolliset numeroina", // suomi / Finnish
    "", // Polski / Polish
    "Mostrar posibles nm. como dgitos", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Clear marks on reset", // English
    "Markierungen lschen beim Reset", // Deutsch / German
    "", // Slovenski / Slovenian
    "Pulisci segni al riavvio", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Effacer les marques lors de la mise  zro", // Franais / French
    "", // Norsk / Norwegian
    "Poista merkinnt aloitettaessa", // suomi / Finnish
    "", // Polski / Polish
    "Quitar marcas al reiniciar", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Key Red", // English
    "Taste Rot", // Deutsch / German
    "", // Slovenski / Slovenian
    "Tasto Rosso", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Bouton rouge", // Franais / French
    "", // Norsk / Norwegian
    "Punainen nppin", // suomi / Finnish
    "", // Polski / Polish
    "Botn Rojo", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Key Green", // English
    "Taste Grn", // Deutsch / German
    "", // Slovenski / Slovenian
    "Tasto Verde", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Bouton vert", // Franais / French
    "", // Norsk / Norwegian
    "Vihre nppin", // suomi / Finnish
    "", // Polski / Polish
    "Botn Verde", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Key Yellow", // English
    "Taste Gelb", // Deutsch / German
    "", // Slovenski / Slovenian
    "Tasto Giallo", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Bouton jaune", // Franais / French
    "", // Norsk / Norwegian
    "Keltainen nppin", // suomi / Finnish
    "", // Polski / Polish
    "Botn Amarillo", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Large font", // English
    "Groe Schriftart", // Deutsch / German
    "", // Slovenski / Slovenian
    "Caratteri grandi", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Grande police", // Franais / French
    "", // Norsk / Norwegian
    "Suuri kirjasin", // suomi / Finnish
    "", // Polski / Polish
    "Fuente grande", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Large font height (pixel)", // English
    "Groe Schrifthhe (pixel)", // Deutsch / German
    "", // Slovenski / Slovenian
    "Altezza car. grandi (pixel)", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Hauteur grande police (pixel)", // Franais / French
    "", // Norsk / Norwegian
    "Suuren kirjasimen korkeus (pikseleit)", // suomi / Finnish
    "", // Polski / Polish
    "Alto fuente grande (pixel)", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Large font width (pixel)", // English
    "Groe Schriftbreite (pixel)", // Deutsch / German
    "", // Slovenski / Slovenian
    "Larghezza car. grandi (pixel)", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Largeur grande police (pixel)", // Franais / French
    "", // Norsk / Norwegian
    "Suuren kirjasimen leveys (pikseleit)", // suomi / Finnish
    "", // Polski / Polish
    "Ancho fuente grande (pixel)", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Small font", // English
    "Kleine Schriftart", // Deutsch / German
    "", // Slovenski / Slovenian
    "Caratteri piccoli", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Petite police", // Franais / French
    "", // Norsk / Norwegian
    "Pieni kirjasin", // suomi / Finnish
    "", // Polski / Polish
    "Fuente pequea", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Small font height (pixel)", // English
    "Kleine Schrifthhe (pixel)", // Deutsch / German
    "", // Slovenski / Slovenian
    "Altezza car. piccoli (pixel)", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Hauteur petite police (pixel)", // Franais / French
    "", // Norsk / Norwegian
    "Pienen kirjasimen korkeus (pikseleit)", // suomi / Finnish
    "", // Polski / Polish
    "Alto fuente pequea (pixel)", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Small font width (pixel)", // English
    "Kleine Schriftbreite (pixel)", // Deutsch / German
    "", // Slovenski / Slovenian
    "Larghezza car. piccoli (pixel)", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Largeur petite police (pixel)", // Franais / French
    "", // Norsk / Norwegian
    "Pienen kirjasimen leveys (pikseleit)", // suomi / Finnish
    "", // Polski / Polish
    "Ancho fuente pequea (pixel)", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Transparency (%)", // English
    "Transparenz (%)", // Deutsch / German
    "", // Slovenski / Slovenian
    "Trasparenza (%)", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Transparence (%)", // Franais / French
    "", // Norsk / Norwegian
    "Lpinkyvyys (%)", // suomi / Finnish
    "", // Polski / Polish
    "Transparencia (%)", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { "Congratulations!\nPress OK to start a new puzzle", // English
    "Herzlichen Glckwunsch!\nOK startet ein neues Puzzle", // Deutsch / German
    "", // Slovenski / Slovenian
    "Complimenti!\nPremi OK per iniziare una nuova partita", // Italiano / Italian
    "", // Nederlands / Dutch
    "", // Portugus / Portuguese
    "Flicitation!\nAvec OK vous lancez un nouveau puzzle", // Franais / French
    "", // Norsk / Norwegian
    "Onnittelut!\nValitse 'OK' aloittaaksesi uuden ristikon", // suomi / Finnish
    "", // Polski / Polish
    "Enhorabuena!\nPulse OK para iniciar un nuevo rompecabezas", // Espaol / Spanish
    "", //  / Greek
    "", // Svenska / Swedish
    "", // Romn / Romanian
    "", // Magyar / Hungarian
    "", // Catal / Catalanian
    "", //  / Russian
    "", // Hrvatski / Croatian
    "", // Eesti / Estonian
    "", // Dansk / Danish
    "", // esky / Czech
  },
  { NULL }
};

#endif
