#!/usr/bin/perl

use strict;
use warnings;

sub find_used_i18n
{
	my $filename = shift;
	my %used_i18n = ();

	open F, "<$filename" or die "couldn't open $filename: $!";
	while (defined(local $_ = <F>)) {
		while (/\btr\s*\(\s*"(.+?)"\s*\)/g) {
			$used_i18n{$1} = $1;
		}
	}
	close F;

	return %used_i18n;
}

sub find_avail_i18n
{
	my %avail_i18n = ();

	open F, "<i18n.c" or die "couldn't open i18n.c: $!";
	while (defined(local $_ = <F>)) {
		if (/{\s*"(.+?)",/) {
			$avail_i18n{$1} = $1;
		}
	}

	return %avail_i18n;
}

my %all_used_i18n = ();
foreach (glob("*.[ch]")) {
	%all_used_i18n = ( %all_used_i18n, find_used_i18n($_) );
}

my %avail_i18n = find_avail_i18n();

foreach (keys %all_used_i18n) {
	if (!defined($avail_i18n{$_})) {
		print "Unavailable i18n '$_'\n";
	}
}
