/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#include <vdk/vdkdate.h>
#include <vdkxdb/vdkxclist.h>
#include <vdkxdb/vdkxdb.h>

VDKXCustomList::VDKXCustomList(VDKForm* owner, 
		 int columns,
		 char** titles,
		 GtkSelectionMode mode): 
  VDKCustomList(owner,columns,titles,mode), VDKXControl()
{
  fieldArray = FieldArray(columns);
}
/*
 */
bool
VDKXCustomList::AssignTable(VDKXTable* t)
{
  if(t)
    {
      int z;
      xbLong l = t->FieldCount();
      for(z = 0; z < l; z++)
	{
	  char name[16];
	  strcpy(name,t->GetFieldName(z));
	  AssignTableFieldToColumn(z,t,name);
	}
      return true;      
    }
  else
    return false;
}
/*
 */
bool 
VDKXCustomList::AssignTableFieldToColumn(int column,VDKXTable* t,
			    char* fname)
{
  if(t)
    {
      xbShort id = t->GetFieldNo(fname);
      xbShort type = t->GetFieldType(id);
      xbShort len = t->GetFieldLen(id);
      fieldArray[column] = ClistField(fname,id,type,len);
      table = t;
      return true;
    }
  else
    return false;
}

/*
 */
bool
VDKXCustomList::AssignTableFieldToColumn(int column,
				VDKXDatabase* xdb,
				char* tablename,
				char* fieldname)
{
  VDKXTable* t = (*xdb)[tablename];
  if(t)
    return AssignTableFieldToColumn(column,t,fieldname);
  else
    return false;
}
/*
 */
xbShort
VDKXCustomList::Read()
{
  int t;
  xbShort rc= XB_NOT_OPEN;
  char* current_key = NULL;
  int order;
  xbLong recno = 0;
  VDKXTableIndex* index = NULL;
  if(! table)
    return rc;
  // initialize tuple
  char** tuple = new char*[fieldArray.size()];
  for(t = 0; t < fieldArray.size(); t++)
    tuple[t] = new char[fieldArray[t].len+1];
  // stores table pointer
  if ((order = table->Order) >= 0)
    index = table->Index(order);
  if(index)
    {
      current_key = new char[512];
      index->GetCurrentKey(current_key);
    }
  else
    recno = table->GetCurRecNo();
  // clears list
  Freeze();
  Clear();
  for(rc =  table->First();
      rc == XB_NO_ERROR;
      rc = table->Next())
    {
      int z;
      for(z = 0; z < fieldArray.size(); z++)
	{
	if(fieldArray[z].name.isNull())
	  *tuple[z] = '\0';
	else
	  PrepareTupleTh(tuple,z);
	}
      AddRow(tuple);
    }
  Thaw();
  // restores pointer
  if(index)
    index->FindKey(current_key);
  else
    table->GetRecord(recno);
  // deletes tuple
  for(t = 0; t < fieldArray.size(); t++)
    delete[] tuple[t];
  delete[] tuple;
  if(current_key)
    delete[] current_key;
  return XB_NO_ERROR;
}

void
VDKXCustomList::PrepareTupleTh(
			       char** tuple, 
			       int z)
{
  calendardate d;
  xbShort rc;
  char* buffer = NULL;
  xbShort id = fieldArray[z].id;
  xbShort type = fieldArray[z].type;
  xbShort len = fieldArray[z].len;
  buffer = new char[len+1];
  rc = table->GetField(id,buffer);
  if(rc == len)
    {
      switch(type)
	{
	case 'D':
	  d = MakeDate(buffer);
	  strcpy(tuple[z], (char*) d);
	  break;
	case 'N':
	case 'F':
	  strcpy(tuple[z],table->xbase->LTRIM(buffer));
	  break;
	case 'L':
	  rc = table->GetLogicalField(id);
	  strcpy(tuple[z], rc == 0 ? "F" : "T");
	  break;
	default:
	  strcpy(tuple[z],table->xbase->RTRIM(buffer));
	  break;
	}
    }
  else
    *tuple[z] = '\0';
  if(buffer)
    delete[] buffer;
}













