/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * January 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_prjpref.h>
#include <vdkb2/vdkb_locale.h>
#include <vdkb2/vdkb.h>
static char buff[256];
extern VDKBuilder* TheApp;
DEFINE_SIGNAL_MAP(VDKBPrjPrefForm,VDKForm)
  ON_SIGNAL(ok,clicked_signal,Ok),
  ON_SIGNAL(cancel,clicked_signal,Cancel)
END_SIGNAL_MAP
//=======================================
/*
  checks if debugger exists on default paths
 */
static char* search_paths[] = 
{
"/usr/bin",
"/usr/local/bin",
"/usr/X11R6/bin/",
"/usr/bin/X11/"
"/usr/X11/bin/",
0
};


bool
CheckDebugger(char* exe)
{
  bool exists = false;
  int t;
  if(exe && *exe)
   {
     for(t = 0; search_paths[t]; t++)
       {
	 sprintf(buff,"%s/%s",search_paths[t],exe);
	 exists =  !access(buff,F_OK);
	 if(exists)
	   break;
       }
   }
return exists;
}


bool
VDKBPrjPrefForm::Ok(VDKObject*)
{
  options->c_compiler = c_compiler->Text;
  options->cc_compiler = cc_compiler->Text;
  options->link = link->Text;
  options->c_flags = c_flags->Text;
  options->defines = defines->Text;
  options->includes = includes->Text;
  options->libs = libs->Text;
  // checks if debugger exists on /usr/bin or /usr/local/bin
  // otherwise warns user and let "debug" field blank.
  char* p = (char*) debugger->Text;
  if(CheckDebugger(p))
      options->debugger = debugger->Text;
  else if(p && *p)
    {
      sprintf(buff,
_("<%s> does not exists on default paths\n\
please enter a complete pathname for debugger executable"),p);
       Application()->MessageBox(
				 APPNAME,
				 buff,
				 MB_ICONINFORMATION|MB_OK,
				 _(user_messages[user_ok]),
				 NULL,
				 5000);
       options->debugger = "";
    }
  else
    options->debugger = "";
  options->runargs = runargs->Text;
  options->version = version->Text;
  options->package = package->Text;
  options->nls_support = nls_support->Checked ? "yes" : "no";
  options->Save();
  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>(Owner());
  // reset menu/options flag
  if(mainform)
    mainform->Automa(automa_prjman_on);
  // update whole gui files
  VDKBProjectManager* prjman = mainform ? mainform->PrjManager(): NULL;
  if(prjman)
    {
      
      GuiFormListIterator lf(*(prjman->FormList()));
      for(;lf;lf++)
	  lf.current()->Changed = true;
      // update gui files without ask user
      prjman->WriteGuiFiles(false);
    }
  Close();
  return true;
}
/*
 */
bool
VDKBPrjPrefForm::Cancel(VDKObject*)
{
Close();
return true;
}
//=======================================
/*
 */
VDKBPrjPrefForm::VDKBPrjPrefForm(VDKForm* owner, 
				 VDKBProjectOptions *options):
  VDKForm(owner),options(options)
{

}
/*
 */
VDKBPrjPrefForm:: ~VDKBPrjPrefForm()
{
}

/*
 */
void 
VDKBPrjPrefForm::Setup()
{
  
  int t;
  sprintf(buff,"%s - <%s>",
	  _(prjoptions_prompts[0]),
	  (char*) options->filename);
  Title = buff;
  VDKBox* vbox = new VDKBox(this,v_box);
  table = new VDKTable(this,9,2);
  for(t = 0; t < 9 ;t++)
    table->AddToCell(new VDKLabel(this,_(prjoptions_prompts[t+1])),t,0);
  c_compiler = new VDKEntry(this,0,options->c_compiler);
  c_compiler->SetSize(300,-1); 
  table->AddToCell(c_compiler,0,1); 
  cc_compiler = new VDKEntry(this,0,options->cc_compiler);
  table->AddToCell(cc_compiler,1,1); 
  link = new VDKEntry(this,0,options->link);
  table->AddToCell(link,2,1); 
  c_flags = new VDKEntry(this,0,options->c_flags);
  table->AddToCell(c_flags,3,1); 
  defines = new VDKEntry(this,0,options->defines);
  table->AddToCell(defines,4,1); 
  includes = new VDKEntry(this,0,options->includes);
  table->AddToCell(includes,5,1); 
  libs = new VDKEntry(this,0,options->libs);
  table->AddToCell(libs,6,1);
  debugger = new VDKEntry(this,0,options->debugger);
  table->AddToCell(debugger,7,1);
  runargs = new VDKEntry(this,0,options->runargs);
  table->AddToCell(runargs,8,1);
  vbox->Add(table);
  // autoconf/automake section
  VDKFrame* frame1 = new VDKFrame(this," * Autoconf/Automake *",
				 v_box,shadow_etched_out);
  VDKTable* table1 = new VDKTable(this,3,2);
  table1->AddToCell(new VDKLabel(this,_(prjoptions_prompts[13])),0,0);
  package = new VDKEntry(this,0,options->package);
  package->SetTip(_("If left empty package name will be as project name"));
  table1->AddToCell(package,0,1);
  table1->AddToCell(new VDKLabel(this,_(prjoptions_prompts[10])),1,0);
  version = new VDKEntry(this,0,options->version);
  table1->AddToCell(version,1,1);
  nls_support = new VDKCheckButton(this,_(prjoptions_prompts[14]));
  nls_support->SetTip(_("Check to enable Native Language Support"));
  nls_support ->Checked = options->nls_support == VDKString("yes");
  table1->AddToCell(nls_support,2,0);
  frame1->Add(table1);
  vbox->Add(frame1,l_justify,false,false,false);
  // button section
  VDKFrame *frame = new VDKFrame(this,NULL,h_box);
  ok = new VDKCustomButton(this,_(prjoptions_prompts[11]));
  cancel = new VDKCustomButton(this,_(prjoptions_prompts[12]));
  frame->Add(ok);
  frame->Add(cancel);
  vbox->Add(frame,l_justify,false,false,false);
  Add(vbox);
}
