/*
 * ===========================
 * VDK Builder
 * Version 2.0
 * March 2001
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>

#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_Env.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_cbrowse.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "pixmaps/gnome-search.xpm"
#include "pixmaps/stop.xpm"
#include "pixmaps/stock_button_ok.xpm"
extern void create_font_selection (void);
extern char* selected_font;
static char buff[256];
// Vdkb_Env MAIN FORM  CLASS
/*
main form constructor
*/
Vdkb_EnvForm::Vdkb_EnvForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
  forceToClose = false;
}  

/*
main form destructor
*/
Vdkb_EnvForm::~Vdkb_EnvForm()
{
}


/*
main form setup
*/
char * tokens[] = { N_("Key words"),N_("GTK+/VDK words"),"Macro",N_("Preprocessor"),
		    N_("Constants"), N_("Comments"), NULL };

void
Vdkb_EnvForm::Setup(void)
{
  int t = 0;
  char* p = NULL;
  GUISetup();
  Changed = false;
  // locks 'changed' flag so even if a "changed" signal will be received
  // by widgets nothing happens.
  LockChanged = true;
  VDKString Yes = CHECK_YES;
  // page 1 - General IDE
  workdir->Text = (char*) VDKBuilder::ideDefaults.project.startupdir;
  float savetime = atof((char*) VDKBuilder::ideDefaults.editor.timedsave);
  savingtime->ValueAsFloat = savetime;
  p = (char*) VDKBuilder::ideDefaults.project.vdk_ref_path;
  vdk_ref_path->Text = p;
  p = (char*) VDKBuilder::ideDefaults.project.vdk_ref_browser;
  vdk_ref_browser->Text = p;
  hide_on_run->Checked = VDKBuilder::ideDefaults.project.hide_on_run == Yes;
  wi_resizeable->Checked =  VDKBuilder::ideDefaults.project.wi_resizeable == Yes;
  int layout = atoi(VDKBuilder::ideDefaults.project.wi_layout);
  rgroup->Selected = layout;
  autosave->Checked = VDKBuilder::ideDefaults.project.autosave == Yes;
  backup->Checked = VDKBuilder::ideDefaults.editor.backup == Yes;
  run_modal->Checked = VDKBuilder::ideDefaults.project.run_modal == Yes;
  emacs->Checked = VDKBuilder::ideDefaults.project.emacs == Yes;
  save_session->Checked = VDKBuilder::ideDefaults.project.save_session == Yes;
  theme->Checked = VDKBuilder::ideDefaults.project.theme == Yes;
  enable_class_browser->Checked = VDKBuilder::ideDefaults.project.enable_class_browser == Yes;
  // page 2 - general editor
  cc_ext->Text = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  h_ext->Text = (char*) VDKBuilder::ideDefaults.unit.h_ext; 
  editor_font->Text = (char*) VDKBuilder::ideDefaults.editor.font;
  editor_bg->Text = (char*) VDKBuilder::ideDefaults.editor.bg;
  editor_fg->Text = (char*) VDKBuilder::ideDefaults.editor.fg;
  editor_size_x->ValueAsFloat = float(VDKBuilder::ideDefaults.editor.size.x);
  editor_size_y->ValueAsFloat = float(VDKBuilder::ideDefaults.editor.size.y); 
  float tabNo = atof((char*) VDKBuilder::ideDefaults.editor.tab);
  editortab->ValueAsFloat = float(tabNo);
  code_autoindent->Checked = VDKBuilder::ideDefaults.project.code_autoindent == Yes;
  showln->Checked = VDKBuilder::ideDefaults.project.showln == Yes;
  // page 3 - syntax colors
  // load tokens type into tokens list box
  for(; tokens[t];t++)
    {
      char* p = _(tokens[t]);
      tokenlistbox->AddRow(&p);
    }
  // select first token type
  tokenlistbox->SelectRow(0,0);
  /*
  VDKFont* font = new VDKFont(this,(char*) VDKBuilder::ideDefaults.editor.key_font);
  syntfont->Font = font;
  */
  syntfont->Text =  (char*) VDKBuilder::ideDefaults.editor.key_font;
  // unlocks 'changed' flag
  LockChanged = false;
}


//signal response method
bool 
Vdkb_EnvForm::OnshowlnToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.showln =
    showln->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Oncode_autoindentToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.code_autoindent =
    code_autoindent->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Oneditor_size_yValueChanged(VDKObject* sender) 
{
  int y = editor_size_y->ValueAsInt;
  int x = VDKBuilder::ideDefaults.editor.size.x;
  if(y > 0 )
    VDKBuilder::ideDefaults.editor.size = VDKPoint(x,y);
  if(!LockChanged)
    OnOptionChanged ();
  return true;
}
 
//signal response method
bool 
Vdkb_EnvForm::Oneditor_size_xValueChanged(VDKObject* sender) 
{
  int x = editor_size_x->ValueAsInt;
  int y = VDKBuilder::ideDefaults.editor.size.y;
  if(x > 0 )
    VDKBuilder::ideDefaults.editor.size = VDKPoint(x,y);
  if(!LockChanged)
    OnOptionChanged ();
  return true;
}
//signal response method
bool 
Vdkb_EnvForm::OneditortabValueChanged(VDKObject* sender) 
{
  int tab = editortab->ValueAsInt;
  sprintf(buff,"%d",tab);
  VDKBuilder::ideDefaults.editor.tab = buff;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
//signal response method
bool 
Vdkb_EnvForm::Onh_extChanged(VDKObject* sender) 
{
if(strlen(h_ext->Text) > 0)
  {
    VDKBuilder::ideDefaults.unit.h_ext = h_ext->Text;
    if(!LockChanged)
      OnOptionChanged ();
  }
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Oncc_extChanged(VDKObject* sender) 
{
  if(strlen(cc_ext->Text) > 0)
    {
      VDKBuilder::ideDefaults.unit.cc_ext = cc_ext->Text;
      if(!LockChanged)
	OnOptionChanged ();
    }
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Onvdk_ref_pathChanged(VDKObject* sender) 
{
  char* path = vdk_ref_path->Text;
  if(strlen(path))
    VDKBuilder::ideDefaults.project.vdk_ref_path = path;
  else
    VDKBuilder::ideDefaults.project.vdk_ref_path = PROJECT_VDK_REF_PATH;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Onvdk_ref_browserChanged(VDKObject* sender) 
{
  char* browser = vdk_ref_browser->Text;
  if(strlen(browser))
    VDKBuilder::ideDefaults.project.vdk_ref_browser = browser;
  else
    VDKBuilder::ideDefaults.project.vdk_ref_browser = PROJECT_VDK_REF_BROWSER;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }

//signal response method
bool 
Vdkb_EnvForm::OnsavingtimeValueChanged(VDKObject* sender) 
{
  int value = savingtime->ValueAsInt;
  sprintf(buff,"%d",value);
  VDKBuilder::ideDefaults.editor.timedsave = buff;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnworkdirChanged(VDKObject* sender) 
{
  if(strlen(workdir->Text) > 0)
    {
      VDKBuilder::ideDefaults.project.startupdir = workdir->Text;
      if(!LockChanged)
	OnOptionChanged ();
    }
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Onsave_sessionToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.save_session =
    save_session->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnemacsToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.emacs =
    emacs->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Onrun_modalToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.run_modal =
    run_modal->Checked ? CHECK_YES : CHECK_NO;
  // disables hide on run (probably user wants see editors to
  // make appropriate changes during runs)
  if(!(run_modal->Checked))
    hide_on_run->Checked = false;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnbackupToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.editor.backup =
    backup->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnautosaveToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.autosave =
    autosave->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::Onwi_resizeableToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.wi_resizeable =
    wi_resizeable->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnRgroupToggled(VDKObject* sender) 
{
  char local[16];
  sprintf(local,"%d", int(rgroup->Selected));
  VDKBuilder::ideDefaults.project.wi_layout = local;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }

//signal response method
bool 
Vdkb_EnvForm::OnthemeToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.theme =
    theme->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
//signal response method
bool 
Vdkb_EnvForm::Onenable_class_browserToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.enable_class_browser =
    enable_class_browser->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
//signal response method
bool 
Vdkb_EnvForm::Onhide_on_runToggled(VDKObject* sender) 
{
  VDKBuilder::ideDefaults.project.hide_on_run =
    hide_on_run->Checked ? CHECK_YES : CHECK_NO;
  if(!LockChanged)
    OnOptionChanged ();
 return true;
 }
 
//asks user before closing
bool
Vdkb_EnvForm::CanClose(void)
{
  if (Changed && !forceToClose)
    {
      int result = Application ()->MessageBox(APPNAME,
	   _("Options changed,  save ?"), 
          MB_ICONQUESTION|MB_YESNO, NULL, NULL, 7000) ==  IDYES;
      // save changes
      if(result)
	SaveEnvironment();
    }
  return true;
}

//signal response method

void
Vdkb_EnvForm::OnOptionChanged ()
{
  if(!Changed)
    {
      VDKRgb color = CHANGED_COLOR;
      done->Foreground = color;
      Changed = true;
    }
}

//signal response method
static char *text_example = 
"/*\n\
  this is a remark\n\
*/\n\
#include <hello.h>\n\
#define AMACRO \"a macro\"\n\
int constant = 9;\n\
int main (int argc,  char** argv)\n\
{\n\
  // another remark\n\
  gtk_verbose_call ();\n\
  VDKMyApplication* app = new VDKMyApplication;\n\
}\n\
void MyClass::MyClass ()\n\
{\n\
}\
";
bool 
Vdkb_EnvForm::Oncode_exampleRealize(VDKObject* sender)
{
  code_example->ShowLineNumbers = false;
  WriteSyntaxSampleText();
  return true;
 }

/*
 */
void 
Vdkb_EnvForm::WriteSyntaxSampleText()
{
  char* font = (char*) VDKBuilder::ideDefaults.editor.font;
  code_example->Font = new VDKFont (this, font);
  code_example->Foreground = VDKRgb((char*) VDKBuilder::ideDefaults.editor.fg);
  code_example->NormalBackground = VDKRgb((char*) VDKBuilder::ideDefaults.editor.bg);
  
  VDKColor* key_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.key_color);
  VDKFont*  key_font = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.key_font);

  VDKColor *gtk_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.gtk_color);
  VDKFont  *gtk_font  = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.gtk_font);

  VDKColor* macro_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.macro_color);
  VDKFont*  macro_font = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.macro_font);

  VDKColor* preprocessor_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.preprocess_color);
  VDKFont*  preprocessor_font = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.preprocess_font);

  VDKColor *const_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.const_color);
  VDKFont  *const_font = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.const_font);

  VDKColor *comment_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.comment_color);
  VDKFont  *comment_font  = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.comment_font);

  // install syntax and patterns table
  code_example->InstallSyntaxTable (
			    key_color,key_font, // keywords 
			    gtk_color,gtk_font, // gtk+ names
			    macro_color,macro_font, // macros
			    preprocessor_color,preprocessor_font, // preprocessor directives
			    const_color,const_font, // constants
			    comment_color,comment_font); // remarks
  code_example->TextInsert (text_example);
}
 
//signal response method
bool 
Vdkb_EnvForm::OnsyntcolorbuttonClick(VDKObject* sender) 
{
  int ndx = tokenlistbox->Selected.Row();
  if(ndx >= 0)
    {
      VDKDefaultColor color;
      VDKBColorBrowser* dlg = new VDKBColorBrowser(this,&color);
      dlg->Setup();
      dlg->ShowModal(GTK_WIN_POS_CENTER);
      // calls GC now
      CollectGarbage();
      if(color.red >= 0)
	{
	  switch(ndx)
	    {
	    case 0:  // key words
	      VDKBuilder::ideDefaults.editor.key_color = (char*) color.name;
	      break;
	    case 1:  // gtk+/vdk words
	      VDKBuilder::ideDefaults.editor.gtk_color = (char*) color.name;
	      break;
	    case 2: // macro
	      VDKBuilder::ideDefaults.editor.macro_color = (char*) color.name;
	      break;
	    case 3: // preprocessor
	      VDKBuilder::ideDefaults.editor.preprocess_color = (char*) color.name;
	      break;
	    case 4: // const
	      VDKBuilder::ideDefaults.editor.const_color =  (char*) color.name;
	      break;
	    case 5: // comments
	      VDKBuilder::ideDefaults.editor.comment_color =  (char*) color.name;
	    }
	  // code_example->ClearSyntaxTable();
	  code_example->Clear();
	  
	  WriteSyntaxSampleText();
	  if(!LockChanged)
	    OnOptionChanged ();
	}
    }
  return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnsyntfontbuttonClick(VDKObject* sender) 
{
 create_font_selection ();
 if(selected_font)
   {
     syntfont->Text = selected_font;
     OnsyntfontActivate (NULL);
   }
  return true;
 }

//signal response method
bool 
Vdkb_EnvForm::OnsyntfontActivate (VDKObject* sender) 
{
  int ndx = tokenlistbox->Selected.Row();
  int len;
  if(ndx >= 0 && ( (len = strlen(syntfont->Text)) > 0 ))
    {
      VDKFont* newfont = NULL;
      GdkFont* gdkfont;
      char* font = new char[len+1];
      strcpy(font,syntfont->Text);
      newfont = new VDKFont(this,font);
      if((gdkfont = newfont->AsGdkFont()))
	{
	  // update entry font
	  /*
	  GtkRcStyle *rc_style;
	  rc_style = gtk_rc_style_new ();
	  rc_style->font_desc = 
	    pango_font_description_copy (newfont->AsPangoFontDescription());
	  gtk_widget_modify_style (syntfont->WrappedWidget(), rc_style);
	  gtk_rc_style_unref (rc_style);
	  gtk_widget_size_request (syntfont->WrappedWidget(), NULL);
	  */
	  syntfont->Text = font;
	  syntfont->Font = newfont;
	  switch(ndx)
	    {
	    case 0:  // key words
	      VDKBuilder::ideDefaults.editor.key_font = font;
	      break;
	    case 1:  // gtk+/vdk words
	      VDKBuilder::ideDefaults.editor.gtk_font =  font;
	      break;
	    case 2: // macro
	      VDKBuilder::ideDefaults.editor.macro_font =  font;
	      break;
	    case 3: // preprocessor
	      VDKBuilder::ideDefaults.editor.preprocess_font =  font;
	      break;
	    case 4: // const
	      VDKBuilder::ideDefaults.editor.const_font =   font;
	      break;
	    case 5: // comments
	      VDKBuilder::ideDefaults.editor.comment_font =   font;
	    }
	  code_example->Clear();
	  // code_example->ClearSyntaxTable();
	  WriteSyntaxSampleText();
	  if(!LockChanged)
	    OnOptionChanged ();
	  gdk_font_unref(gdkfont);
	}
      else
	{
	  sprintf(buff,_("font:\"%s\" not available or mispelled"),font);
	  Application()->MessageBox(
			      APPNAME,
			      buff,
			      MB_ICONSTOP|MB_OK,
			      _(user_messages[user_ok]),
			      NULL,
			      5000);
	}
    } 
  return true;
 } 
//signal response method
bool 
Vdkb_EnvForm::OnfgbuttonClick(VDKObject* sender) 
{
  VDKDefaultColor color;
  VDKBColorBrowser* dlg = new VDKBColorBrowser(this,&color);
  dlg->Setup();
  dlg->ShowModal(GTK_WIN_POS_CENTER);
  // calls GC now
  CollectGarbage();
  if(color.red >= 0)
    {
      VDKBuilder::ideDefaults.editor.fg = color.name; 
      editor_fg->Text = (char*) color.name;
      if(!LockChanged)
	OnOptionChanged ();
    }
  return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnbgbuttonClick(VDKObject* sender) 
{
  VDKDefaultColor color;
  VDKBColorBrowser* dlg = new VDKBColorBrowser(this,&color);
  dlg->Setup();
  dlg->ShowModal(GTK_WIN_POS_CENTER);
  // calls GC now
  CollectGarbage();
  if(color.red >= 0)
    {
      VDKBuilder::ideDefaults.editor.bg = color.name; 
      editor_bg->Text = (char*) color.name;
      if(!LockChanged)
	OnOptionChanged ();
    }
  return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OnfontbuttonClick(VDKObject* sender) 
{
 create_font_selection ();
 if(selected_font)
   {
    editor_font->Text = selected_font;
    VDKBuilder::ideDefaults.editor.font = selected_font;
    g_free(selected_font);
    if(!LockChanged)
      OnOptionChanged ();
  } 
  return true;
 }

//signal response method
bool 
Vdkb_EnvForm::Oneditor_fontActivate (VDKObject* sender) 
{
if(strlen(editor_font->Text) > 0)
  {
    char* font = editor_font->Text;
    VDKBuilder::ideDefaults.editor.font = font;
    if(!LockChanged)
      OnOptionChanged ();
  } 
  return true;
 }

//signal response method
bool 
Vdkb_EnvForm::OncancelClick(VDKObject* sender) 
{
  forceToClose = true;
  Close ();
  return true;
 }
 
//signal response method
bool 
Vdkb_EnvForm::OndoneClick(VDKObject* sender) 
{
  Close ();
 return true;
 }

//signal response method
bool 
Vdkb_EnvForm::OntokenlistboxSelectRow (VDKObject* sender) 
{
  int ndx = tokenlistbox->Selected.Row();
  if(ndx >= 0)
    {
      char* font = NULL;
      switch(ndx)
	{
	case 0:  // key words
	  font = VDKBuilder::ideDefaults.editor.key_font;
	  break;
	case 1:  // gtk+/vdk words
	  font = VDKBuilder::ideDefaults.editor.gtk_font;
	  break;
	case 2: // macro
	  font = VDKBuilder::ideDefaults.editor.macro_font;
	  break;
	case 3: // preprocessor
	  font = VDKBuilder::ideDefaults.editor.preprocess_font;
	  break;
	case 4: // const
	  font = VDKBuilder::ideDefaults.editor.const_font;
	  break;
	case 5: // comments
	  font = VDKBuilder::ideDefaults.editor.comment_font;
	}
      if(font)
	{
	  VDKFont* newfont = new VDKFont(this,font);
	  GdkFont* gdkfont;
	  if((gdkfont = newfont->AsGdkFont()))
	    {
	      syntfont->Text = font;
	      syntfont->Font = newfont;
	      newfont->Destroy();
	    }
	}
    } 
  return true;
}

/*
 */
void
Vdkb_EnvForm::SaveEnvironment()
{
  char local[256];
  FILE* fp;
  VDKString home = ((VDKBuilder*)Application())->user_home;
  VDKString rcfile = DEFAULTS_FILE;
  sprintf(local,"%s/.vdkb2/%s",(char*) home,(char*) rcfile);
  if(access(local,F_OK) < 0)
    {
      sprintf(buff,
	      _("%s\ndoes not exists\
\ncreate %s/.vdkb/res/ and\
\ncopy %s there\
\n(operation aborted)"),
	      local,(char*) home,(char*) rcfile);
      Application()->MessageBox(APPNAME,
				buff,
				MB_ICONINFORMATION|MB_OK,
				_(user_messages[user_ok]));
      return;
    }
  fp = fopen(local,"w+");
  if(!fp)
    return;

  fprintf(fp,
"=======================\
\nVDKBuilder\
\n=======================\
\nIDE defaults file\
\n- file is divided in sections\
\n- all text  outside {} is a remark\
\n- case sensitive\
\n- be careful file parser is'nt protected\
\n against syntax errors !\
\n- section format:\
\nsection_name\
\n{\
\nkey: value ;\
\nkey: value ;\
\n,....\
\n}\
\n------------------\
\nSECTIONS BEGIN HERE\
\n------------------\
\nvdkb_units\
\n{\
\ncount: 1;\
\nname: unit;"
);

  fprintf(fp,"\ncc_ext:%s;",
	  (char*)VDKBuilder::ideDefaults.unit.cc_ext);
  fprintf(fp,"\nh_ext:%s;",
	  (char*)VDKBuilder::ideDefaults.unit.h_ext);
fprintf(fp,
"\nobj_ext: o;\n}");

  fprintf(fp,
"-----------------------\
\ndefaults for\
\nproject\
\nTIP:\
\ndo not change prj_ext\
\nmust be fixed to .prj\
\n----------------------\
\nvdkb_project\
\n{\
\ncount: 1;\
\nname: project;\
\nprj_ext: prj;\
");
fprintf(fp,"\nhide_on_run:%s;",
	(char*)VDKBuilder::ideDefaults.project.hide_on_run);
fprintf(fp,"\nautosave:%s;",
	(char*)VDKBuilder::ideDefaults.project.autosave);
fprintf(fp,"\nstartup_dir:%s;",
	(char*)VDKBuilder::ideDefaults.project.startupdir);
fprintf(fp,"\nwi_resizeable:%s;",
	(char*)VDKBuilder::ideDefaults.project.wi_resizeable);
fprintf(fp,"\nwi_layout:%s;",
	(char*)VDKBuilder::ideDefaults.project.wi_layout);
fprintf(fp,"\nvdk_ref_path:%s;",
	(char*)VDKBuilder::ideDefaults.project.vdk_ref_path);
fprintf(fp,"\nvdk_ref_browser:%s;",
	(char*)VDKBuilder::ideDefaults.project.vdk_ref_browser);
fprintf(fp,"\nsave_session:%s;",
	(char*)VDKBuilder::ideDefaults.project.save_session);
fprintf(fp,"\ncode_indent:%s;",
	(char*)VDKBuilder::ideDefaults.project.code_indent);
fprintf(fp,"\ncode_autoindent:%s;",
	(char*)VDKBuilder::ideDefaults.project.code_autoindent);
fprintf(fp,"\nrun_modal:%s;",
	(char*)VDKBuilder::ideDefaults.project.run_modal);
fprintf(fp,"\nemacs:%s;",
	(char*)VDKBuilder::ideDefaults.project.emacs);
fprintf(fp,"\nshow_line_numbers:%s;",
	(char*)VDKBuilder::ideDefaults.project.showln);
fprintf(fp,"\next_ascii:%s;",
	(char*)VDKBuilder::ideDefaults.project.extascii);
fprintf(fp,"\ntheme:%s;",
	(char*)VDKBuilder::ideDefaults.project.theme);
fprintf(fp,"\nenable_class_browser:%s;",
	(char*)VDKBuilder::ideDefaults.project.enable_class_browser);
fprintf(fp,"\n}");

fprintf(fp,
"\n-------------------\
\ndefaults for editor\
\n-------------------\
\nfont keyword accepts pango description\
\nfg,bg accept standard X color names\
\n--------------------\
\nvdkb_editor\
\n{");
fprintf(fp,"\nfont:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.font);

fprintf(fp,"\nfg:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.fg);
fprintf(fp,"\nbg:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.bg);

fprintf(fp,"\nh_size:%d;",
	VDKBuilder::ideDefaults.editor.size.X());
fprintf(fp,"\nv_size:%d;",
	VDKBuilder::ideDefaults.editor.size.Y());

fprintf(fp,"\nkey_font:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.key_font);
fprintf(fp,"\nkey_color:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.key_color);

fprintf(fp,"\ngtk_font:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.gtk_font);
fprintf(fp,"\ngtk_color:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.gtk_color);

fprintf(fp,"\nmacro_font:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.macro_font);
fprintf(fp,"\nmacro_color:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.macro_color);

fprintf(fp,"\npreprocess_font:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.preprocess_font);
fprintf(fp,"\npreprocess_color:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.preprocess_color);

fprintf(fp,"\nconst_font:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.const_font);
fprintf(fp,"\nconst_color:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.const_color);

fprintf(fp,"\ncomment_color:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.comment_color);
fprintf(fp,"\ncomment_font:\"%s\";",
	(char*)VDKBuilder::ideDefaults.editor.comment_font);

fprintf(fp,"\ntimed_save:%s;",
	(char*)VDKBuilder::ideDefaults.editor.timedsave);
fprintf(fp,"\nbackup:%s;",
	(char*)VDKBuilder::ideDefaults.editor.backup);
fprintf(fp,"\ntab:%s;",
	(char*)VDKBuilder::ideDefaults.editor.tab);
fprintf(fp,"\n}");
fclose(fp);
}
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(Vdkb_EnvForm,VDKForm);
DEFINE_EVENT_LIST(Vdkb_EnvForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(Vdkb_EnvForm,VDKForm)
ON_SIGNAL(done,clicked_signal,OndoneClick),
ON_SIGNAL(cancel,clicked_signal,OncancelClick),
ON_SIGNAL(fontbutton,clicked_signal,OnfontbuttonClick),
ON_SIGNAL(editor_font,activate_signal,Oneditor_fontActivate),
ON_SIGNAL(syntfont,activate_signal,OnsyntfontActivate),
ON_SIGNAL(bgbutton,clicked_signal,OnbgbuttonClick),
ON_SIGNAL(fgbutton,clicked_signal,OnfgbuttonClick),
ON_SIGNAL(syntfontbutton,clicked_signal,OnsyntfontbuttonClick),
ON_SIGNAL(syntcolorbutton,clicked_signal,OnsyntcolorbuttonClick),
ON_SIGNAL(code_example,realize_signal,Oncode_exampleRealize),
ON_SIGNAL(hide_on_run,toggled_signal,Onhide_on_runToggled),
ON_SIGNAL(wi_resizeable,toggled_signal,Onwi_resizeableToggled),
ON_SIGNAL(autosave,toggled_signal,OnautosaveToggled),
ON_SIGNAL(backup,toggled_signal,OnbackupToggled),
ON_SIGNAL(run_modal,toggled_signal,Onrun_modalToggled),
ON_SIGNAL(emacs,toggled_signal,OnemacsToggled),
ON_SIGNAL(save_session,toggled_signal,Onsave_sessionToggled),
ON_SIGNAL(theme,toggled_signal,OnthemeToggled),
ON_SIGNAL(enable_class_browser,toggled_signal,Onenable_class_browserToggled),
ON_SIGNAL(workdir,changed_signal,OnworkdirChanged),
ON_SIGNAL(savingtime,value_changed_signal,OnsavingtimeValueChanged),
ON_SIGNAL(vdk_ref_path,changed_signal,Onvdk_ref_pathChanged),
ON_SIGNAL(vdk_ref_browser,changed_signal,Onvdk_ref_browserChanged),
ON_SIGNAL(cc_ext,changed_signal,Oncc_extChanged),
ON_SIGNAL(h_ext,changed_signal,Onh_extChanged),
ON_SIGNAL(editor_size_x,value_changed_signal,Oneditor_size_xValueChanged),
ON_SIGNAL(editor_size_y,value_changed_signal,Oneditor_size_yValueChanged),
ON_SIGNAL(editortab,value_changed_signal,OneditortabValueChanged),
ON_SIGNAL(code_autoindent,toggled_signal,Oncode_autoindentToggled),
ON_SIGNAL(showln,toggled_signal,OnshowlnToggled),
ON_SIGNAL(rgroup,toggled_signal,OnRgroupToggled),
ON_SIGNAL(tokenlistbox,select_row_signal,OntokenlistboxSelectRow)
END_SIGNAL_MAP
/*
main form setup
*/
void
Vdkb_EnvForm::GUISetup(void)
{
	SetSize(318,350);
	Title = _("VDKBuilder environment options");
vbox2 = new VDKBox(this,v_box);
Add(vbox2,0,1,1,0);
vbox3 = new VDKBox(this,v_box);
vbox2->Add(vbox3,0,1,1,0);
vbox3->BorderWidth(0);
nbook = new VDKNotebook(this);
vbox3->Add(nbook,0,1,1,0);
Nbook0_Page0 = new VDKBox(this,v_box);
nbook->AddPage(Nbook0_Page0,_("General IDE"));
fixed0 = new VDKFixed(this);
Nbook0_Page0->Add(fixed0,0,1,1,0);
label0 = new VDKLabel(this,_("Default working\ndirectory"));
label0->SetSize(96,32);
fixed0->Add(label0,6,9,1,0);
workdir = new VDKEntry(this,0);
workdir->SetTip(_("Enter here default start up directory"));
workdir->SetSize(168,20);
workdir->Editable = true;
fixed0->Add(workdir,121,16,1,0);
hide_on_run = new VDKCheckButton(this,_("Hide VDKbuilder on run"));
hide_on_run->SetTip(_("Hides VDKBuilder when running application"));
hide_on_run->SetSize(280,20);
fixed0->Add(hide_on_run,0,112,1,0);
wi_resizeable = new VDKCheckButton(this,_("WI resizable"));
wi_resizeable->SetTip(_("Makes Widget Inspector resizable"));
wi_resizeable->SetSize(80,20);
fixed0->Add(wi_resizeable,0,136,1,0);

 rgroup = new VDKRadioButtonGroup(this,h_box);
 VDKRadioButton* rb = new VDKRadioButton(rgroup,_("WI layout V"));
 rb->SetTip(_("WI shows a vertical layout"));
 rb = new VDKRadioButton(rgroup,_("WI layout H"));
 rb->SetTip(_("WI shows an horizontal layout"));
 fixed0->Add(rgroup,150,136,1,0);

autosave = new VDKCheckButton(this,_("Auto save modified files"));
autosave->SetTip(_("Autosave modified files without asking user"));
fixed0->Add(autosave,0,160,1,0);
label2 = new VDKLabel(this,_("Timed saving"));
label2->SetSize(104,16);
fixed0->Add(label2,8,51,1,0);
savingtime = new VDKSpinButton(this,0.000000,0.000000,20.000000,1.000000,0.000000);
savingtime->Digits = 0;
savingtime->SetTip(_("Timed (in minutes) saving of source files (0 means no timed saving)"));
fixed0->Add(savingtime,120,48,1,0);
backup = new VDKCheckButton(this,_("Makes source backup files"));
backup->SetTip(_("Makes a sources back-up file"));
backup->SetSize(288,20);
fixed0->Add(backup,0,184,1,0);

label3 = new VDKLabel(this,_("VDK reference path"));
label3->SetSize(99,15);
fixed0->Add(label3,5,75,1,0);
vdk_ref_path = new VDKEntry(this,0,"?");
vdk_ref_path->SetTip(_("Put here where_VDK_reference_is\
\nmost likely:/usr/src/vdk-2.x.y/doc/doxy/html"));
vdk_ref_path->SetSize(168,20);
vdk_ref_path->Editable = true;
fixed0->Add(vdk_ref_path,120,72,1,0);

label9 = new VDKLabel(this,_("VDK ref browser"));
label9->SetSize(99,15);
fixed0->Add(label9,6,95,1,0);
vdk_ref_browser = new VDKEntry(this,0,"netscape");
vdk_ref_browser->SetTip(_("Put here your path to preferred html browser"));
vdk_ref_browser->SetSize(160,20);
vdk_ref_browser->Editable = true;
fixed0->Add(vdk_ref_browser,120,94,1,0);

run_modal = new VDKCheckButton(this,_("VDKMaker - Application modal"));
run_modal->SetTip(_("Application runs modal, if unchecked allows\ncode/design modifications during application run"));
run_modal->SetSize(288,20);
fixed0->Add(run_modal,0,208,1,0);

emacs = new VDKCheckButton(this,_("Supports Emacs"));
emacs->SetTip(_("Supports Emacs as external editor\nall sources opened in builder editor\nwill be opened in emacs as well"));
fixed0->Add(emacs,0,232,1,0);

save_session = new VDKCheckButton(this,_("Saves last work session"));
fixed0->Add(save_session,0,256,1,0);

theme = new VDKCheckButton(this,_("Use vdkb theme"));
theme->SetTip(_("Allows user to override default and\nuse a nice \"Air Force Blue\" theme"));
fixed0->Add(theme,200,256,1,0);

enable_class_browser = new VDKCheckButton(this,_("Enables class browser"));
enable_class_browser->SetTip(
_("Enabling class browser can slown down VDKBuilder\nduring loading of very big projects"));
fixed0->Add(enable_class_browser,200,232,1,0);
// comment to show checkbox
enable_class_browser->Visible= false;
nbook_page2 = new VDKBox(this,v_box);
nbook->AddPage(nbook_page2,_("Sources editor"));
fixed1 = new VDKFixed(this);
nbook_page2->Add(fixed1,0,1,1,0);
label4 = new VDKLabel(this,_("Default source files extension"));
label4->SetSize(176,16);
fixed1->Add(label4,0,7,1,0);
label1 = new VDKLabel(this,_("Default  header files extension"));
label1->SetSize(176,16);
fixed1->Add(label1,0,32,1,0);
label5 = new VDKLabel(this,_("Default object files extension"));
label5->SetSize(176,16);
fixed1->Add(label5,0,59,1,0);
cc_ext = new VDKEntry(this,0,"cc");
cc_ext->SetSize(64,20);
cc_ext->Editable = true;
fixed1->Add(cc_ext,184,2,1,0);
h_ext = new VDKEntry(this,0,"h");
h_ext->SetSize(64,20);
h_ext->Editable = true;
fixed1->Add(h_ext,184,29,1,0);
o_ext = new VDKEntry(this,0,"o");
o_ext->Enabled = false;
o_ext->SetTip(_("Fixed to be 'o'"));
o_ext->SetSize(64,20);
o_ext->Editable = true;
fixed1->Add(o_ext,184,56,1,0);
editor_font = new VDKEntry(this,0);
 editor_font->SetTip(_("Enter here font name or use the Font... button"));
//editor_font->Enabled = false;
editor_font->SetSize(192,24);
// editor_font->Editable = true;
fixed1->Add(editor_font,112,80,1,0);
fontbutton = new VDKCustomButton(this,(const char**) gnome_search_xpm,"_Font...",16,(GtkPositionType) 1);
fontbutton->SetTip("Changes default font");
fontbutton->SetSize(104,22);
fixed1->Add(fontbutton,0,80,1,0);
bgbutton = new VDKCustomButton(this,(const char**) gnome_search_xpm,_("_Background"),16,(GtkPositionType) 1);
bgbutton->SetTip(_("Changes background color"));
bgbutton->SetSize(104,22);
fixed1->Add(bgbutton,0,104,1,0);
editor_bg = new VDKEntry(this,0);
editor_bg->Enabled = false;
editor_bg->SetSize(192,22);
editor_bg->Editable = true;
fixed1->Add(editor_bg,112,104,1,0);
fgbutton = new VDKCustomButton(this,(const char**) gnome_search_xpm,("F_oreground"),16,(GtkPositionType) 1);
fgbutton->SetTip(_("Changes foreground color"));
fgbutton->SetSize(104,22);
fixed1->Add(fgbutton,0,128,1,0);
editor_fg = new VDKEntry(this,0);
editor_fg->Enabled = false;
editor_fg->SetSize(192,22);
editor_fg->Editable = true;
fixed1->Add(editor_fg,112,128,1,0);
label6 = new VDKLabel(this,_("Minimum width"));
label6->SetSize(88,16);
fixed1->Add(label6,0,160,1,0);
editor_size_x = new VDKSpinButton(this,400.000000,100.000000,1000.000000,10.000000,0.000000);
editor_size_x->Digits = 0;
editor_size_x->SetSize(64,20);
fixed1->Add(editor_size_x,88,156,1,0);
label7 = new VDKLabel(this,_("Minimum height"));
label7->SetSize(88,16);
fixed1->Add(label7,1,184,1,0);
editor_size_y = new VDKSpinButton(this,400.000000,100.000000,1000.000000,10.000000,0.000000);
editor_size_y->Digits = 0;
editor_size_y->SetSize(64,20);
fixed1->Add(editor_size_y,88,181,1,0);
code_autoindent = new VDKCheckButton(this,_("code auto indent"));
code_autoindent->SetSize(144,20);
fixed1->Add(code_autoindent,162,157,1,0);
showln = new VDKCheckButton(this,_("shows lines number"));
showln->SetSize(144,20);
fixed1->Add(showln,162,181,1,0);
editortab = new VDKSpinButton(this,2.000000,2.000000,10.000000,1.000000,0.000000);
editortab->Digits = 0;
editortab->SetSize(64,20);
fixed1->Add(editortab,88,208,1,0);
label8 = new VDKLabel(this,_("Editor tabs"));
label8->SetSize(88,16);
fixed1->Add(label8,1,211,1,0);
nbook_page3 = new VDKBox(this,v_box);
nbook->AddPage(nbook_page3,_("Syntax colors"));
fixed2 = new VDKFixed(this);
nbook_page3->Add(fixed2,0,1,1,0);
syntfontbutton = new VDKCustomButton(this,(const char**) gnome_search_xpm,"_Font...",16,(GtkPositionType) 1);
syntfontbutton->SetTip(_("Changes default font"));
syntfontbutton->SetSize(80,22);
fixed2->Add(syntfontbutton,132,168,1,0);
syntcolorbutton = new VDKCustomButton(this,(const char**) gnome_search_xpm,_("_Color..."),16,(GtkPositionType) 1);
syntcolorbutton->SetTip(_("Changes foreground color"));
syntcolorbutton->SetSize(80,22);
fixed2->Add(syntcolorbutton,218,168,1,0);
 syntfont = new VDKEntry(this,0);
 syntfont->SetSize(165,22);
fixed2->Add(syntfont,132,200,1,0);
frame0 = new VDKFrame(this,_("Code example"),v_box,shadow_etched_in);
frame0->Shadow = shadow_etched_in;
frame0->Align = c_justify;
frame0->SetSize(312,160);
fixed2->Add(frame0,0,0,1,0);
code_example = new VDKEditor(this);
frame0->Add(code_example,0,1,1,0);
char* tokenlistboxTitles[] = { _("tokens") };
tokenlistbox = new VDKCustomList(this,1,tokenlistboxTitles,(GtkSelectionMode) 0);
tokenlistbox->SetSize(127,112);
tokenlistbox->AutoResize = true;
fixed2->Add(tokenlistbox,0,160,1,0);
separator0 = new VDKSeparator(this,h_separator);
vbox3->Add(separator0,0,0,0,0);
hbox4 = new VDKBox(this,h_box);
vbox2->Add(hbox4,0,0,0,0);
hbox4->BorderWidth(0);
done = new VDKCustomButton(this, (const char**) stock_button_ok_xpm,_("_Close and save"),16,(GtkPositionType) 1);
hbox4->Add(done,0,1,0,0);
cancel = new VDKCustomButton(this, (const char**) stop_xpm,_("_Cancel"),16,(GtkPositionType) 1);
hbox4->Add(cancel,0,1,0,0);
}
