/*
 * ===========================
 * VDK Visual Developement Kit
 * Version 0.5
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998, Ionutz Borcoman
 * Developed by Ionutz Borcoman <borco@borco-ei.eng.hokudai.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <shaped_button.h>

int
VDKShapedButton::onPress(GtkWidget *, GdkEvent*, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKShapedButton* button = reinterpret_cast<VDKShapedButton*>(gp);
  if(button->_down==false){
	button->_down=true;
	button->_pixmap->SetPixmap(button->_pixH);
  }
  return 0;
}

int 
VDKShapedButton::onRelease(GtkWidget *, GdkEvent *ev, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  GdkEventButton* bev = (GdkEventButton*) ev;
  printf("\nbutton:%d\nSHIFT:%d\nCTRL:%d\nLOCK:%d\n",
	 bev->button,
	 bev->state&GDK_SHIFT_MASK,
	 bev->state&GDK_CONTROL_MASK,
	 bev->state&GDK_LOCK_MASK);
  fflush(stdout);
  VDKShapedButton* button = reinterpret_cast<VDKShapedButton*>(gp);
  if(button->_down==true && button->_in==true){
	button->SignalEmitParent(clicked_signal);
	button->_pixmap->SetPixmap(button->_pix);
  }
  button->_down=false;
  return 0;
}

int 
VDKShapedButton::onEnter(GtkWidget *, GdkEvent*, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKShapedButton* button = reinterpret_cast<VDKShapedButton*>(gp);
  if(button->_down==true){
	button->_pixmap->SetPixmap(button->_pixH);
  }
  button->_in=true;
  return 0;
}

int 
VDKShapedButton::onLeave(GtkWidget *, GdkEvent*, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKShapedButton* button = reinterpret_cast<VDKShapedButton*>(gp);
  if(button->_down==true){
	button->_pixmap->SetPixmap(button->_pix);
  }
  button->_in=false;
  return 0;
}

VDKShapedButton::VDKShapedButton(VDKForm* owner,char* pixfile,char* pixHfile, char * tooltip)
  :VDKFixed(owner)
{
  // The next line will sigsegv
  // _pix = SetPixmap();
  
  // Therefore we use this and create an additional pixmap
  // This should not be necessary and the above line should 
  // work, isn't it ?
  // Other solution would be a constructor with a RawPixmap 
  // as an argument.
  _pix = new VDKRawPixmap(owner, pixfile);
  _pixH = new VDKRawPixmap(owner, pixHfile);
  
  _pixmap = new VDKPixmap(owner, pixfile, tooltip);
  
  GtkWidget *pixWidget = _pixmap->Widget();
  
  // add the _pixmap
  Put(_pixmap,0,0);
  
  // mask the widget with the image itself
  gtk_widget_shape_combine_mask( pixWidget, _pix->Mask(), 0, 0);
  
  
  gtk_signal_connect (GTK_OBJECT (pixWidget), "enter_notify_event",
					  GTK_SIGNAL_FUNC(VDKShapedButton::onEnter),this);
  gtk_signal_connect (GTK_OBJECT (pixWidget), "leave_notify_event",
					  GTK_SIGNAL_FUNC(VDKShapedButton::onLeave),this);
  gtk_signal_connect (GTK_OBJECT (pixWidget), "button_press_event",
					  GTK_SIGNAL_FUNC(VDKShapedButton::onPress),this);
  gtk_signal_connect (GTK_OBJECT (pixWidget), "button_release_event",
					  GTK_SIGNAL_FUNC(VDKShapedButton::onRelease),this);
  
  _down = false;
  _in = false;
};
