/* most of the code here is taken from xawtv */
#include	<config.h>
#include	<stdio.h>
#include	<unistd.h>
#ifdef		HAVE_STDLIB_H
#include	<stdlib.h>
#endif		/* HAVE_STDLIB_H */
#include	<errno.h>
#include	<ctype.h>
#include	<fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

/* Custom headerfiles */
 
#include "grab.h"
#include "frequencies.h"

/* External variables/functions */

/* Function prototypes */

/* Global variables */

int get_freq(int i)
{
    if (i < 0 || i >= chancount)
	return -1;
    return chanlist[i].freq*16/1000;
}

int
lookup_channel(char *channel)
{
    int    i,nr1,nr2;
    char   tag1[5],tag2[5];

    if (isdigit(channel[0]))
    {
	tag1[0] = 0;
	nr1  = atoi(channel);
    } else {
	sscanf(channel,"%4[A-Za-z]%d",tag1,&nr1);
    }

    for (i = 0; i < chancount; i++) {
	if (isdigit(chanlist[i].name[0])) {
	    tag2[0] = 0;
	    nr2  = atoi(chanlist[i].name);
	} else {
	    sscanf(chanlist[i].name,"%4[A-Za-z]%d",tag2,&nr2);
	}
	if (tag1[0] && tag2[0])
	    if (nr1 == nr2 && 0 == strcmp(tag1,tag2))
		break;
	if (!tag1[0] && !tag2[0])
	    if (nr1 == nr2)
		break;
    }
    if (i == chancount)
	return -1;

    return i;
}
