#include <queue>
#include <string>
#include <sstream>
#include <pthread.h>
#include "v4lxif.h"
#include "vcr.h"

#ifndef _HEADER_CAPPROC_H_
#define _HEADER_CAPPROC_H_

enum Sound_Freqs
{
	NoAudio	=-1,
	F44	=0,
	F22	=1,
	F11	=2
};
enum Sample_Sizes
{
	S16	=0,
	S8	=1
};
enum Sound_Chans
{
	Mono	=0,
	Stereo	=1
};
enum Resolutions
{
	WNONE	=-1,
	W384	=0,
	W320	=1,
	W192	=2,
	W160	=3,
	W768	=4,
	W640	=5,
	W400	=6
};		

struct restable_t
{
	enum Resolutions res;
	int width;
	int height;
};

static struct restable_t restable[] = {
	{ W768, 768, 576 },
	{ W640, 640, 480 },
	{ W400, 400, 300 },
	{ W384, 384, 288 },
	{ W320, 320, 240 },
	{ W192, 192, 144 },
	{ W160, 160, 120 },
	{ WNONE, 0, 0 }
};

struct window_t
{
	int x;
	int y;
	int width;
	int height;
};

struct chunk
{
	char* data;
	double timestamp;
};		
class CaptureProcess
{
public:
protected:
	static void* vidcap(void*);
	static void* audcap(void*);
	static void* writer(void*);
protected:
	v4lxif* m_v4l;
	pthread_t m_vidc;
	pthread_t m_audc;
	pthread_t m_writer;
	int m_quit;
	std::queue<chunk> m_vidq;
	std::queue<chunk> m_audq;
	int cnt;
	int cap_drop;
	int comp_drop;
	long long starttime;

	std::ostringstream *messenger;
	std::ostringstream def_mess;

	std::string filename;
	int segment_size;			
	int compressor;				
	int quality;				
	int keyframes;
	int frequency;
	int samplesize;
	int chan;
	int res_w;
	int res_h;
	int timelimit;		
	int sizelimit;
	int audiocodec;
	int audiobitrate;
	int vertical_flip;
	const char *sound_dev;
	float fps;	
	
	/* added to specify the _window_ in the frame which will be captured */
	window_t window;
	
	int segment_flag;

	int vid_clear;
	int aud_clear;
	
	void Create(v4lxif* v4l, std::string filename, int segment_size,	
	int compressor, int quality, int keyframes,
	enum Sound_Freqs frequency, enum Sample_Sizes samplesize,
	enum Sound_Chans chan, enum Resolutions res, int timelimit,			
	int sizelimit, float fps, window_t window, int audiocodec = 0, 
	int audiobitrate = 0, int vertical_flip = 0,
	const char *sound_dev = "/dev/dsp");

public:
	CaptureProcess(v4lxif* v4l,			// v4lx interface pointer
		std::string filename,
		int segment_size,				// Segmentation is implicit finishing one
								// file and starting next one when old file
								// grows to specified size
								//Kbytes
								//-1 for no segmentation
		int compressor,			// fourcc
		int quality,			//0..10000
		int keyframes,			// compressor-dependent
								// for IV 5.0 Quick it's ignored
		enum Sound_Freqs frequency,				// frequency ID
								// Available:
								//-1 for no audio
								//0 for 44100 Hz
								//1 for 22050 Hz
								//2 for 11025 Hz
		enum Sample_Sizes samplesize,			//0 for 16 bit
								//1 for 8 bit
		enum Sound_Chans chan,
		enum Resolutions res,
		int timelimit,			//in seconds. -1 if no limit
		int sizelimit,			//in Kbytes. -1 if no limit
		float fps,
		window_t window,
		int audiocodec = 0, // 0 => no audio compression
		int audiobitrate = 0,
		int vertical_flip = 0,
		const char *sound_dev = "/dev/dsp"): messenger(&def_mess),
		segment_flag(0), vid_clear(0), aud_clear(0)
	{
		Create(v4l, filename, 
			segment_size, compressor, quality, keyframes,				
			frequency, samplesize, chan, res, timelimit, sizelimit, fps, window,
						audiocodec, audiobitrate, vertical_flip, sound_dev);
	}
	CaptureProcess(int v4l,		// initialized v4l device
		std::string filename,
		int segment_size,				
		int compressor,			
		int quality,			
		int keyframes,			
		enum Sound_Freqs frequency,		
		enum Sample_Sizes samplesize,
		enum Sound_Chans chan,
		enum Resolutions res,
		int timelimit,			
		int sizelimit,
		float fps,
		window_t window): messenger(&def_mess), segment_flag(0), vid_clear(0), aud_clear(0)
	{
		Create((v4lxif*)(new v4l1if(v4l)), filename, 
			segment_size, compressor, quality, keyframes,				
			frequency, samplesize, chan, res, timelimit, sizelimit, fps, window);
	}
	~CaptureProcess();
	void getState(int& processed, int& cap_drop, int& comp_drop, int& finished)
	{
		processed=cnt;
		cap_drop=this->cap_drop;
		comp_drop=this->comp_drop;
		finished=m_quit;
	}
	void stopRecord(void)
	{
		m_quit = 1;
	}
	void setMessenger(std::ostringstream& mess)
	{
		messenger=&mess;
	}
	void Segment()
	{
		segment_flag=1;
//		vid_clear=1;
//		aud_clear=1;
	}	
};
#endif /* _HEADER_CAPPROC_H_ */
