/*
   Signals handling
   --------------------------------------------------------------------
   VCHE - Virtual Console Hex Editor

   Copyright (C) 1998, 1999 Diego Javier Grigna <diego@grigna.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

static void signals_ctrl_c_handler(int signalnumber);

void signals_init( void)
{
 signal( SIGINT   , signals_ctrl_c_handler);
 signal( SIGQUIT  , SIG_IGN);
 signal( SIGTSTP  , SIG_IGN);
}

static void signals_ctrl_c_handler( int signalnumber)
{
 signal( SIGINT, SIG_IGN);
#if defined(VCHE_VC) || defined(VCHE_RAW)
 term_noraw();
 term_color( VC_COLOR_OFF);
#endif
 fprintf( stderr, "Interrupted by user\n");
 do_exit( 1);
}

