#
# VCHE (Virtual Console Hex Editor)
#
# Virtual Console version Makefile
#

include ./VERSION

PROG_VC  = vche
LIB_VC   = vclib.o
PROG_RAW = vche-raw
LIB_RAW  = rawlib.o
PROG_NC  = vche-nc
LIB_NC   = nclib.o

VC_PROGRAMS = $(PROG_VC) $(PROG_RAW) $(PROG_NC)

ifdef VCHE_VC
      VC_OBJ  = $(LIB_VC)
      VC_PROG = $(PROG_VC)
      CFLAGS  = -DVCHE_VC
      LIBS    =
endif

ifdef VCHE_RAW
      VC_OBJ  = $(LIB_RAW)
      VC_PROG = $(PROG_RAW)
      CFLAGS  = -DVCHE_RAW
      LIBS    =
endif

ifdef VCHE_NC
      VC_OBJ  = $(LIB_NC)
      VC_PROG = $(PROG_NC)
      CFLAGS  = -DVCHE_NC
      LIBS    = -lncurses
endif

# Base installation dir, some distributions change it to /usr
BASEDIR = /usr/local

# The place where binaries will be installed
BINDIR = $(BASEDIR)/bin

# The place to find the source man pages
# Don't change it unless you know..
DOCDIR = ../doc

# VCHE configuration file
CONFIG_FILE = vche.conf

# It's the place to install the vche config file
LIBDIR = /etc

# Paths to section 1 and 5 of the man pages
# VCHE man pages will be installed here
MANDIR1 = $(BASEDIR)/man/man1
MANDIR5 = $(BASEDIR)/man/man5

MKDIR = mkdir -p

# Mode for binaries
BINMODE=755

# The C Compiler
CC=gcc

# Compiler warnings
WARNINGS= -pedantic -Wall

# Compiler flags
CCOPTS = -O2 -fomit-frame-pointer

# It's the shell that make will use.
SHELL = /bin/sh

# Install program
INSTALL = install

# sed commands
SEDCMDS = "s/@version@/$(VCHE_VERSION)/g;s/@releasedate@/$(VCHE_RELEASEDATE)/g;s%@libdir@%$(LIBDIR)%g;s%@configfile@%$(CONFIG_FILE)%g"

# Clear and set suffixes
.SUFFIXES:
.SUFFIXES: .c .o

OBJS = edit.o file.o help.o hex.o init.o\
	keyboard.o linkedlist.o main.o misc.o search.o\
	signals.o term.o $(VC_OBJ)

all: $(VC_PROG)

$(VC_PROG): $(OBJS)
	$(CC) $(CFLAGS) $(CCOPTS) $(WARNINGS) $(OBJS) -o $@ $(LIBS)

clean: mostly_clean
	rm -f $(VC_PROGRAMS)

mostly_clean:
	rm -f core config.h $(OBJS)
	rm -f $(LIB_VC) $(LIB_RAW) $(LIB_NC)


strip:
	strip $(VC_PROGRAMS)

install:
	$(INSTALL) -g root -m $(BINMODE) -o root -s $(VC_PROGRAMS) $(BINDIR)
	$(MKDIR) $(LIBDIR)
	cp $(DOCDIR)/$(CONFIG_FILE) $(LIBDIR)
	sed $(SEDCMDS) $(DOCDIR)/vche.1.in      > $(MANDIR1)/vche.1
	cp             $(DOCDIR)/vche-raw.1       $(MANDIR1)/vche-raw.1
	cp             $(DOCDIR)/vche-nc.1        $(MANDIR1)/vche-nc.1
	sed $(SEDCMDS) $(DOCDIR)/vche.conf.5.in > $(MANDIR5)/vche.conf.5

uninstall:
	rm -f $(BINDIR)/$(PROG_VC)
	rm -f $(BINDIR)/$(PROG_RAW)
	rm -f $(BINDIR)/$(PROG_NC)
	rm -f $(LIBDIR)/$(CONFIG_FILE)
	rm -f $(MANDIR1)/vche.1
	rm -f $(MANDIR1)/vche-raw.1
	rm -f $(MANDIR1)/vche-nc.1
	rm -f $(MANDIR5)/vche.conf.5

.c.o:
	$(CC) $(CFLAGS) $(CCOPTS) $(WARNINGS) -c $<

$(OBJS): common.h config.h Makefile Rules.make VERSION

config.h:
	@echo "Creating file \"config.h\""
	@echo "/*"                                                           >> config.h
	@echo "   Config file for VCHE"                                      >> config.h
	@echo "   Copyright (C) 1999 Diego Javier Grigna <diego@grigna.com>" >> config.h
	@echo ""                                                             >> config.h
	@echo "   File automatically created by the Makefile."               >> config.h
	@echo "   Do not edit by hand, modify the Makefile instead."         >> config.h
	@echo "*/"                                                           >> config.h
	@echo ""                                                             >> config.h
	@echo "#define VCHE_VERSION      \"$(VCHE_VERSION)\""                >> config.h
	@echo ""                                                             >> config.h
	@echo "#define VCHE_CONFIG_FILE  \"$(LIBDIR)/$(CONFIG_FILE)\""       >> config.h
	@echo ""                                                             >> config.h
	@echo ""                                                             >> config.h

