#!/bin/csh
#
# SCCS-info %W% %E%
# $Id: demo.csh.tpl,v 1.9 1994/08/09 09:17:11 sander Exp sander $
#
# ====================== Change area ============================

alias OUTP  /bin/echo

# ================== End of Change area =========================

OUTP "Configuring ..."

set mvcgn = "../src/xvcg"

if (! -x $mvcgn) then
	set mvcgn = "`echo $BINDIR`xvcg"
endif
if (! -x $mvcgn) then
	set mvcgn = "/usr/local/bin/xvcg"
endif
if (! -x $mvcgn) then
	set mvcgn = "xvcg"
endif
if (! -x $mvcgn) then
	OUTP "Sorry, I cannot find a " $mvcgn
	exit 1
endif

OUTP "Vcg is" $mvcgn

OUTP ""
loop:
  OUTP "Please select the window system."
  OUTP "If the VCG tool has problems with colors on "
  OUTP "your display installation, please select a  "
  OUTP "monochromatic version even on a color screen."
  OUTP "1 : X11 with colors      2 : Sunview with colors  "
  OUTP "3 : X11 monochromatic    4 : Sunview monochromatic"
  set wsys = $<
  switch ($wsys)
  case 1:
	alias MYVCG $mvcgn -geometry 700x700+20-20
	breaksw
  case 2:
	alias MYVCG $mvcgn
	breaksw
  case 3:
	alias MYVCG $mvcgn -geometry 700x700+20-20 -nocolors
	breaksw
  case 4:
	alias MYVCG $mvcgn -nocolors
	breaksw
  default:
	OUTP ""
	OUTP "*** invalid input ***"	
	goto loop
  endsw

set mycat   = "/bin/cat"
set myrm    = "/bin/rm"
set mysleep = "/bin/sleep"
set mysed   = "/bin/sed"
set mywc    = "/bin/wc"
set mygrep  = "/usr/bin/fgrep"
set myclear = "/usr/bsd/clear"

alias CAT   $mycat
alias RM    $myrm
alias SLEEP $mysleep
alias SED   $mysed
alias WCNT  $mywc
alias GREP  $mygrep
alias CLEAR $myclear


OUTP
OUTP "Cleanup ..."
OUTP "Test" > demoaaa.vcg
OUTP "Test" > animaaa.vcg
OUTP "Test" > rbtreeaaa.vcg
RM demo*.vcg anim*.vcg rbtree*.vcg

OUTP ""
OUTP "Press Carriage Return key to start the demonstration ..."
set f = $<
if ("$f" == "QUIT") goto finishup

CLEAR
OUTP "DEMONSTRATION OF THE VCG TOOL"
OUTP "============================="
OUTP ""
OUTP "Welcome to a tour around the VCG tool ..."
OUTP ""
OUTP "NOTE: you can leave the tour at any point by answering"
OUTP "      QUIT (uppercase) on a request of input."

OUTP ""
OUTP "In the following, we will show several visualizations"
OUTP "from different applications. Not all features of the "
OUTP "VCG tool can be demonstrated, but the important once."
OUTP "Some of the demonstrations are generated by the program"
OUTP "vcgdemomaker, others are from the directory expl, others"
OUTP "are animations."
OUTP ""
OUTP "To go from one demonstration to the next demonstration,"
OUTP "you should finish the VCG tool by pressing the key q "
OUTP "or selecting the menu item Quit."
OUTP "The menu is shown when pressing the (left) mouse button"
OUTP "in the VCG window."
OUTP "Press Carriage Return key to continue ..."

set f = $<
if ("$f" == "QUIT") goto finishup

OUTP "The keyboard commands of the VCG tool are:"
OUTP ""
OUTP "        q                - quit the VCG tool"
OUTP "        r                - show or hide the ruler"
OUTP "        f                - load another file"
OUTP "        g                - reload the same file"
OUTP "        l                - display/hide labels of edges"
OUTP "        1..9             - hide/expose corresponding edge class"
OUTP "        i or I or J      - show info fields of nodes"
OUTP ""
OUTP "Press Carriage Return key to continue ..."
set f = $<
if ("$f" == "QUIT") goto finishup
OUTP ""
OUTP "Scrolling commands:"
OUTP ""
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        o                - go to the origin (0,0) "
OUTP "        p                - pick position with the mouse"
OUTP "        P                - enter position by co-ordinates"
OUTP "        n                - position such that a node is centered"
OUTP "        e                - follow an edge (center target/source)"
OUTP ""
OUTP "Scaling commands"
OUTP ""
OUTP "        +  or =          - stretch          "
OUTP "        -  or _          - shrink           "
OUTP "        0                - (null) set scale factor to normal"
OUTP ""
OUTP ""
OUTP "Press Carriage Return key to start ..."
set f = $<
if ("$f" == "QUIT") goto finishup

CLEAR
OUTP "Example from the sociology: Theory of civilisation"
OUTP "--------------------------------------------------"
OUTP "This graph shows the dependencies between the     "
OUTP "invention of wheels, the modern comunism and the  "
OUTP "computer science, etc."
OUTP "The following graph is scaled by a factor 0.5 and"
OUTP "uses the layoutalgorithm MINBACKWARD (-D0)."
OUTP "Other possible layoutalgorithms are MINDEPTH, MAXDEPTH"
OUTP "and TREE (-D-, -D+ and -Dtree) and many more."
OUTP ""
vcgcount < ../expl/civ.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/civ.vcg

CLEAR
OUTP "Example: Color test"
OUTP "-------------------"
OUTP "This examples shows the default colors that are available."
OUTP "If your X11 installation has problems with colors, "
OUTP "use -nocolors. In this case, or if the display is "
OUTP "monochrom, you will not see the colors."
OUTP ""
vcgcount < ../expl/colors.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/colors.vcg

CLEAR
OUTP "Example: More Colors"
OUTP "--------------------"
OUTP "This examples show how to access to the color map."
OUTP "Up to 256 colors can be used at the same time."
OUTP "It is even possible to replace the default colors by"
OUTP "other red/green/blue values."
OUTP ""
vcgcount < ../expl/morecol.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/morecol.vcg


CLEAR
OUTP "Example: Character set"
OUTP "----------------------"
OUTP "The VCG tool uses a fully scalable character set. This character"
OUTP "set is compatible to the ISO Latin 1 PostScript Encoding Vector"
OUTP "and contains the special national characters for the most"
OUTP "European and North American countrys."
OUTP "If the computer system does not support 8 Bit character codes,"
OUTP "the special characters can be accessed by ISO code escapes."
OUTP "For instance, \\fi252 is the german umlaut ue."
OUTP "Next, we will see the character set."
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/charset.vcg


CLEAR
OUTP "Example: Form test"
OUTP "------------------"
OUTP "This examples shows the different forms of nodes and"
OUTP "edges that  are available."
OUTP "Nodes can be stretched and shrinked individually,"
OUTP "width, height, textmode and border can be set to "
OUTP "many values. Edges can be dashed or dotted, at   "
OUTP "different sizes with different arrow sizes."
OUTP ""
vcgcount < ../expl/forms.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/forms.vcg

CLEAR
OUTP "Example: More forms"
OUTP "-------------------"
OUTP "This examples shows further forms of nodes and"
OUTP "edges that  are available: boxes, ellipses, rhombs"
OUTP "and triangles."
OUTP ""
vcgcount < ../expl/forms2.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/forms2.vcg


CLEAR
OUTP "Example: Ports and Arrow Modes"
OUTP "------------------------------"
OUTP "Edge arrows appear at the port of nodes. Port sharing"
OUTP "means that multiple edges may be adjacent to one port."
OUTP "This occurs, if the arrows of all these edges have the"
OUTP "same visual appearance (size, color, ...)."
OUTP "If we use port sharing, it is recommended to use only"
OUTP "a fixed set of rotated arrows. Otherwise, the port looks"
OUTP "like a thick spot since all arrows are differently rotated"
OUTP "and overlap. This is the arrow mode 'fixed'."
OUTP "If we don't use port sharing, arrows can be rotated individually."
OUTP "This is the arrow mode 'free'."
OUTP ""
OUTP "Next, we see four times the same graph. At the left examples,"
OUTP "we use port sharing, but at the right examples, there is no"
OUTP "port sharing. At the upper examples, we use arrow mode fixed,"
OUTP "and at the lower examples, we use arrow mode free."
OUTP ""
vcgcount < ../expl/pshar1.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG windows at the left sides."
OUTP "Then, press q into the right VCG windows to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent ../expl/pshar1.vcg &
SLEEP 2
MYVCG -silent ../expl/pshar3.vcg &
SLEEP 2
MYVCG -silent ../expl/pshar2.vcg &
SLEEP 2
MYVCG ../expl/pshar4.vcg
SLEEP 1



CLEAR
OUTP "Example: A diagram"
OUTP "------------------"
OUTP "This examples shows the influences of different computer"
OUTP "systems in the context of the development of the computer"
OUTP "Xerox Star (see Johnson, Roberts, e.a.: The Xerox Star,"
OUTP "a Retrospective, IEEE Computer; 11-29, Sept. 1989)."
OUTP "We did some changes in the diagram in order to show the "
OUTP "possibilities of visualization, but not in order to "
OUTP "clarify information in the diagram."
OUTP ""
vcgcount < ../expl/xerox.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/xerox.vcg

CLEAR
OUTP "Example: A flow diagram"
OUTP "-----------------------"
OUTP "This examples shows a funny flow diagram about the actions"
OUTP "of a software maintainer if something does not work."
OUTP "The text is in german. If I tried to translate it, the gags"
OUTP "would probably disappear."
OUTP "One speciality here: the centers of the nodes are aligned onto"
OUTP "a raster by using the attributes xraster and yraster."
OUTP "Thus, we have many rectangular edges."
OUTP ""
vcgcount < ../expl/softmain.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/softmain.vcg


CLEAR
OUTP "Example: Orthogonal layout"
OUTP "--------------------------"
OUTP "Flowcharts look much better if all edges consist of"
OUTP "orthogonal line segments. This is the orthogonal layout"
OUTP "or manhatten layout."
OUTP "For the manhatten layout, we use a special method to"
OUTP "place the nodes: the priority method with the straight"
OUTP "line detection. It is recommended to use these methods"
OUTP "when manhatten layout is switched on."
OUTP ""
OUTP "Next, we see the previous flow diagram at the left side"
OUTP "and the same diagram with manhatten layout at the right side."
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent ../expl/softmain.vcg &
SLEEP 2
MYVCG ../expl/softmain2.vcg
SLEEP 1


CLEAR
OUTP "Example: A control flow graph of a program"
OUTP "------------------------------------------"
OUTP "This example shows the control flow graph of a program."
OUTP "The decision branches are formed by rhombs and bent nearedges."
OUTP "Nearedges are horizontal edges that constain the two adjacent"
OUTP "nodes to be placed directly neighbored at the same level."
OUTP "Bent nearedges are edges that are bent at the label, and"
OUTP "the source node and the edge label form a near edge. This gives"
OUTP "the typical appearance of decision branches."
OUTP ""
vcgcount < ../expl/cfg.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/cfg.vcg


CLEAR
OUTP "Example: Another control flow graph"
OUTP "-----------------------------------"
OUTP "The next example shows another control flow graph."
OUTP "Here, the bent nearedges are simulated by some nearedges and"
OUTP "auxiliary nodes. Again, we use manhatten layout with the"
OUTP "priority method and the straight line detection."
OUTP ""
vcgcount < ../expl/flchrt.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/flchrt.vcg


CLEAR
OUTP "Example: Anchorpoint test"
OUTP "-------------------------"
OUTP "This example shows how to use anchorpoints."
OUTP "It is possible to anchor an edge at each labelline"
OUTP "of a node. Nodes representing structs look nice"
OUTP "in this mode. Note but this restricts of course"
OUTP "the usage of nearedges."
OUTP "If you select one of the submenus of the menu item"
OUTP "Node Information and then pick into the large node"
OUTP "you can see how to use background text."
OUTP ""
vcgcount < ../expl/anchors.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/anchors.vcg


CLEAR
OUTP "Example: More anchorpoints"
OUTP "--------------------------"
OUTP "This example shows a list of C structs. It demonstrates"
OUTP "the usage of anchorpoints for visualized debugging"
OUTP "of data structures."
OUTP ""
vcgcount < ../expl/structs.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/structs.vcg

CLEAR
OUTP "Example: Level test"
OUTP "-------------------"
OUTP "This examples shows how to use level specifications."
OUTP "It is possible to give the nodes arbitrary levels"
OUTP "for instance to place a node artificially on the top"
OUTP "of the graph. Normally, the following would be layouted"
OUTP "as a tree with the root at level 0. But we have specified"
OUTP "which nodes are at level 0, 1 and 2, such that the root"
OUTP "is in the center."
OUTP ""
vcgcount < ../expl/levels.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/levels.vcg


CLEAR
OUTP "Example: Horizantal layer sorting"
OUTP "---------------------------------"

OUTP "The VCG tool reorders the nodes in the levels to avoid"
OUTP "crossings. But sometimes, the writer of a graph specification"
OUTP "knows a better order of the nodes into the levels."
OUTP "He can specify this by the attribute horizontal_order at"
OUTP "the nodes. If all nodes of a level have this attribute,"
OUTP "the reordering of this level is suppressed."
OUTP ""
OUTP "Warning: this feature works only for connected graphs."
OUTP "Nonconnected parts are layouted separately, such that"
OUTP "the order of the nodes of a connected component is predictable",
OUTP "at a level, but not the order of all nodes at a level."
OUTP "Is is recommended to use this feature only together with"
OUTP "level specifications, or at trees, where it is clear at"
OUTP "which level a node apprears."
OUTP ""
OUTP "Next, we see a graph where we want to have the nodes"
OUTP "sorted at the levels in alphabethic order."
OUTP "Left, we see the original graph by the standard layout"
OUTP "algorithm. Here, the ordering at the levels is arbitrary."
OUTP "At the right side, we use the attribute horizontal_order"
OUTP "on the same graph to yield an alphabethic ordering at the"
OUTP "Levels."

OUTP ""
vcgcount < ../expl/hsort.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent ../expl/hunsort.vcg &
SLEEP 2
MYVCG ../expl/hsort.vcg
SLEEP 1


CLEAR
OUTP "Example: Unary tree of depth 100"
OUTP "--------------------------------"

vcgdemomaker demo001.vcg -unarytree 100

OUTP "This graph is very simple. All edges have class 2."
OUTP "You can try to hide the edges, expose them or to"
OUTP "fold regions."
OUTP ""
vcgcount < demo001.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo001.vcg

CLEAR
OUTP "Example: Binary tree of depth 5"
OUTP "-------------------------------"

vcgdemomaker demo002.vcg -binarytree 5
CAT demo002.vcg  | SED -e "s/xmax/shrink: 2 &/" > demo003.vcg

OUTP "This graph is very simple. All edges have class 2."
OUTP "Ary-trees look very nice if we use a layout_downfactor."
OUTP "Here, we used layout_downfactor: 8."
OUTP ""
vcgcount < demo003.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo003.vcg

CLEAR
OUTP "Example: Binary tree of depth 5"
OUTP "-------------------------------"

CAT demo003.vcg  | SED -e "s/layout_downfactor: 8/layout_downfactor: 1/" > demo004.vcg

OUTP "To compare with, we show the same binary tree with"
OUTP "layout_downfactor: 1."
OUTP ""
vcgcount < demo004.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo004.vcg


CLEAR
OUTP "Example: Layout of trees"
OUTP "-------------------------"

OUTP "Beside the normal layout algorithm, there is a specialized"
OUTP "algorithm TREE, that lays out trees even without specifying"
OUTP "a layout_downfactor."
OUTP "This specialized algorithm can be used for all graphs that"
OUTP "can be layouted like downward trees, i.e. their edges form"
OUTP "unshared branches."
OUTP "This specialized algorithm is often faster than then normal."
OUTP "algorithm with layout_downfactor."

OUTP "Left, we see a syntax tree by the standard layout algorithm."
OUTP "At the right side, we see the same tree with the specialized"
OUTP "algorithm for trees."

OUTP ""
vcgcount < ../expl/tree1.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent ../expl/tree1.vcg &
SLEEP 2
MYVCG ../expl/tree2.vcg
SLEEP 1


CLEAR
OUTP "Example: More trees"
OUTP "-------------------"

OUTP "Trees look very nice, if a special version of the manhatten"
OUTP "layout method is used: the single line manhatten layout."
OUTP "Here, all horizontal edge segments share the same"
OUTP "horizontal line. If the graph is not a tree, then this"
OUTP "will confuse the user, since it might be not anymore clear,"
OUTP "which vertical lines are connected by the horizontal"
OUTP "line. But for trees, it looks nice."

OUTP "We see the same syntax tree as before, but now, we use the"
OUTP "single line manhatten tree layout for the left graph."

OUTP ""
vcgcount < ../expl/tree2.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent -dtree -smanhatten ../expl/tree1.vcg &
SLEEP 2
MYVCG ../expl/tree2.vcg
SLEEP 1




CLEAR
OUTP "Example: Edge priorities"
OUTP "------------------------"

OUTP "Sometimes, we have a graph consisting of two intermixed"
OUTP "graphs. Or we have one basic graph and additionally, we have"
OUTP "edges as annotations. In these cases, we want to recognize  "
OUTP "the structure of the basic graph, but the structure is"
OUTP "interwoven with the additional edges. But the layout is based"
OUTP "on all edges, which may result in visualizations where "
OUTP "the structure of the basic graph is not recognizable anymore."
OUTP ""
OUTP "In this case, edge priority comes in. We give the edges of"
OUTP "the basic graph a higher priority. Then, the additional "
OUTP "annotation edges are neglected during the layout and are"
OUTP "drawn rather ugly, but the basic graph is visualized nicely."
OUTP ""
OUTP "Next, we will see a tree (thick edges) interwoven with some"
OUTP "additional edges. Left, we show this graph by the standard"
OUTP "layout algorithm, where the tree is not recognizable."
OUTP "At the right side, we use priorities, and then we will recognize"
OUTP "the tree structure."

OUTP ""
vcgcount < ../expl/annot1.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent ../expl/annot1.vcg &
SLEEP 2
MYVCG -silent ../expl/annot2.vcg
SLEEP 1


CLEAR
OUTP "Example: Fisheyes"
OUTP "-----------------"

OUTP "Large graphs have normally the disadvantage that we either"
OUTP "see the whole graph but no details, because the graph is"
OUTP "shrinked very much, or we see some details at the point of"
OUTP "interest but lose the overview of the entire graph structure,"
OUTP "because the window is too small. A good solution of this"
OUTP "conflict is the fisheye view that distorts the graph such"
OUTP "that the focus point is magnified while the remaining parts"
OUTP "of the graph are demagnified smoothly such that the whole"
OUTP "graph is visible."
OUTP "A fisheye view is a coordinate transformation and has"
OUTP "similiarities with the corresponding photo camera lenses."
OUTP ""
OUTP "Next, we will see a large graph. Left, we show the graph"
OUTP "by the standard view. Right, we see the same graph by the"
OUTP "cartesian fisheye view. The focus point can be selected"
OUTP "interactively by the operation Pick Position."

OUTP ""
vcgcount < ../expl/fishex3c.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent -ypos 170 ../expl/fishex3c.vcg &
SLEEP 2
MYVCG -silent -xpos 518 -ypos 1790 -view cfish ../expl/fishex3b.vcg
SLEEP 1


CLEAR
OUTP "Example: Cartesian fisheyes and polar fisheyes"
OUTP "----------------------------------------------"

OUTP "Cartesian fisheyes transform the cartesian coordinate system"
OUTP "while polar fisheyes transform the polar coordinate system."
OUTP "A polar fisheye can be seen as a mapping of the space onto a"
OUTP "spheric ball. The polar fisheye does not preserve horizontal"
OUTP "and vertical lines, while the cartesian fisheye does."
OUTP "Note that fisheyes may introduce additional bendings of lines"
OUTP "and crossings that do not appear in the plane view."
OUTP "However, these effects are seldom and occur due to efficiency"
OUTP "reasons."
OUTP ""
OUTP "Next, we will see the same graph as before. Left, we show the"
OUTP "graph by the polar fisheye view. Right, we see the graph again"
OUTP "by the carthesian fisheye view."

OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent -xpos 518 -ypos 1790 -view pfish ../expl/fishex3a.vcg &
SLEEP 2
MYVCG -silent -xpos 518 -ypos 1790 -view cfish ../expl/fishex3b.vcg
SLEEP 1


CLEAR
OUTP "Example: Fisheyes with fixed radius"
OUTP "-----------------------------------"

OUTP "If not the whole graph but only a fixed area around the focus"
OUTP "point is of interest, we use the fisheyes with fixed radius."
OUTP "Then, not the whole graph is visible but only the region around"
OUTP "the focus point."
OUTP "While for normal (self adaptable) fisheyes, the location of the"
OUTP "focus point moves in the window relatively to its movement in"
OUTP "the graph, the focus point of the fisheyes with fixed radius is"
OUTP "always centered in the window."
OUTP ""
OUTP "Next, we will see a graph with fisheyes of fixed radius. Left,"
OUTP "we show the graph by the cartesian fisheye view. Right, we see"
OUTP "the graph again by the polar fisheye view."

OUTP ""
vcgcount < ../expl/fishex2a.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After visualization of this, first, press q into"
OUTP "the VCG window at the left side."
OUTP "Then, press q into the right VCG window to go to "
OUTP "the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -silent -xpos 2300 -ypos 253 -view fcfish ../expl/fishex2a.vcg &
SLEEP 2
MYVCG -silent -xpos 2300 -ypos 253 -view fpfish ../expl/fishex2b.vcg 
SLEEP 1


CLEAR
OUTP "Example: Another diagram"
OUTP "-------------------------"

OUTP "This diagram (Gansner, Koutsofios, e.a.: A Technique"
OUTP "for Drawing Graphs; IEEE Trans. Soft. Eng. 19, 3, March 93)"
OUTP "shows the dependencies of different shells."
OUTP "Here we see a combination of features of the VCG tool."
OUTP "First, the graph is made connected by 3 invisible edges."
OUTP "The priority of these edges is set to zero such that"
OUTP "they do not influence the layout too much. As contrast,"
OUTP "the layout_downfactor and layout_upfactor is set to 100."
OUTP "The attribute level is used to set the nodes at the"
OUTP "appropriate time axis. The attribute horizontal_order"
OUTP "is used to get the time axis at the left side of the"
OUTP "graph. Further, we have used splines for the edges."

OUTP ""
vcgcount < ../expl/shells.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/shells.vcg


CLEAR
OUTP "Example: Ternary tree of depth 7"
OUTP "---------------------------------"
OUTP "Wait half a minute ..."

vcgdemomaker demo005.vcg -ternarytree 7
CAT demo005.vcg  | SED -e "s/xmax/shrink: 2 &/" > demo006.vcg

OUTP "Now a first torture test. This graph is a ternary tree"
OUTP "with about 3000 nodes and 3000 edges."
OUTP "We use the normal algorithm with downfactor: 8."
OUTP "We need about 20 seconds (on a Sparc ELC) to layout it."
OUTP "WARNING: the visualization may fail on small computers"
OUTP "         because of memory exhausted."
OUTP ""
vcgcount < demo006.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo006.vcg


CLEAR
OUTP "Example: Two level cross graph"
OUTP "------------------------------"

vcgdemomaker demo007.vcg -twolevelcross 1000

OUTP "This is a torture test for bary centering."
OUTP "This graph is specified in an ugly format with a lot"
OUTP "of unnecessary crossings. The tool removes these    "
OUTP "crossings."
OUTP ""
vcgcount < demo007.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo007.vcg

CLEAR
OUTP "Example: Nearedge test"
OUTP "----------------------"

vcgdemomaker demo008.vcg -leveltree 4
CAT demo008.vcg  | SED -e "s/xmax/shrink: 4 &/" > demo009.vcg

OUTP "This is a torture test for near edge layout."
OUTP "This tree is has a lot of near edges, i.e.  "
OUTP "edges between nodes at the same level."
OUTP "The nodes of a near edge should be neighboured."
OUTP ""
vcgcount < demo009.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo009.vcg

CLEAR
OUTP "Example: Complete graphs"
OUTP "------------------------"

vcgdemomaker demo010.vcg -allconnect 5

OUTP "The complete graph has edges between all nodes."
OUTP "If we have n nodes, then we have about n*n/2 edges."
OUTP "Here we test the speed of the VCG tool, because "
OUTP "such graphs are very difficult to layout."
OUTP "An complete graph of 5 nodes is layouted very fast."
OUTP ""
vcgcount < demo010.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo010.vcg

CLEAR
OUTP "Example: Complete graphs"
OUTP "------------------------"

vcgdemomaker demo011.vcg -allconnect 10
CAT demo011.vcg  | SED -e "s/xmax/shrink: 10 stretch: 7 &/" > demo012.vcg

OUTP "An complete graph of 10 nodes needs a few seconds."
OUTP ""
vcgcount < demo012.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo012.vcg

CLEAR
OUTP "Example: Complete graphs"
OUTP "------------------------"

vcgdemomaker demo013.vcg -allconnect 20
CAT demo013.vcg  | SED -e "s/xmax/shrink: 100 stretch: 32 &/" > demo014.vcg

OUTP "An complete graph of 20 nodes needs about 25 seconds"
OUTP "on a Sparc ELC."
OUTP ""
vcgcount < demo014.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo014.vcg

CLEAR
OUTP "Example: Complete graphs"
OUTP "------------------------"

vcgdemomaker demo015.vcg -allconnect 30
CAT demo015.vcg  | SED -e "s/xmax/shrink: 10 stretch: 2 &/" > demo016.vcg

OUTP "An complete graph of 30 nodes needs about 110 seconds"
OUTP "on a Sparc ELC."
OUTP ""
vcgcount < demo016.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG demo016.vcg

CLEAR
OUTP "Example: Complete graphs"
OUTP "------------------------"

OUTP "If we have such complex graphs, it is often not necessary"
OUTP "to have a nice layout, because the graphs are to large   "
OUTP "to see all details at the same time."
OUTP "In this case, we set the fast flag (option -f) that reduces"
OUTP "the number of iterations of various layout steps."
OUTP "Next, we see the same complete graph of 30 nodes as before, however"
OUTP "now the fast flag is set."
OUTP "Then, we need only 15 seconds (compared to 100 seconds before),"
OUTP "but the layout is very ugly."

OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG -f demo016.vcg


CLEAR
OUTP "Example: Intermediate representation of a compiler (HIR)"
OUTP "--------------------------------------------------------"

OUTP "The next example comes from the REAL WORLD."
OUTP "It shows the High Intermediate Representation (HIR)"
OUTP "of a CLaX program. It is a syntax tree annotated by"
OUTP "types."
OUTP "You see the procedure declarations. The main module is"
OUTP "actually folded (see the green triangle)."
OUTP "If you select the menu point Hide edges, you will recognize"
OUTP "that the edge classes are named in this example."
OUTP "We use the layout algorithm TREE."
OUTP ""
vcgcount < ../expl/tstree.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "We need a few seconds to visualize this. Please wait."
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/tstree.vcg

CLEAR
OUTP "Example: Intermediate representation of a compiler (CCMIR)"
OUTP "----------------------------------------------------------"

OUTP "The next example again comes from the REAL WORLD."
OUTP "It shows the Common Compare Medium Intermediate"
OUTP "Representation (CCMIR) of a very simple C program."
OUTP "This graph was generated by the ACE C frontend and a trivial"
OUTP "additional visualization engine. The edge classes 1-5"
OUTP "are hidden, otherwise the layout would be to ugly."
OUTP "They can be exposed by menu selections."
OUTP ""
vcgcount < ../expl/ccmir.vcg
OUTP ""
OUTP "Remind: most important keybord commands of vcg"
OUTP "        q                - quit the VCG tool"
OUTP "        a                                   "
OUTP "      d   c (arrow keys) - scroll to the left/right/up/down"
OUTP "        b                                   "
OUTP "        +                - stretch          "
OUTP "        -                - shrink           "
OUTP ""
OUTP "After the visualization of this, press q into "
OUTP "the VCG window to go to the next demonstration."

OUTP "Press Carriage Return key to start visualization ..."
set f = $<
if ("$f" == "QUIT") goto finishup

MYVCG ../expl/ccmir.vcg


CLEAR
OUTP "Example: Animation demo 1 (communication by touching)"
OUTP "-----------------------------------------------------"
OUTP "We show a small animation that demonstrate the "
OUTP "communication between the VCG tool and a controller "
OUTP "program called animation3."
OUTP "The controller program sends signals to the VCG tool."
OUTP "The VCG tool indicates the completion of vizualization"
OUTP "by touching its input file."
OUTP "This demonstration shows a sequence of insertions into"
OUTP "a red black tree. We see rotations that rebalance the tree."
OUTP "IMPORTANT: Do not quit the VCG tool. Do not give any "
OUTP "           input (keypress, menu selection) to the VCG tool."
OUTP "           Wait !  The animation is finished automatically."

OUTP ""
OUTP "Press Carriage Return key to start the animation ..."
set f = $<
if ("$f" == "QUIT") goto finishup

animation3

OUTP "Ready ! Press Carriage Return key to continue ..."
set f = $<
if ("$f" == "QUIT") goto finishup

CLEAR
OUTP "Example: Animation demo 2 (communication by signals)"
OUTP "----------------------------------------------------"
OUTP "We show another small animation that demonstrate the "
OUTP "communication between the VCG tool and a controller "
OUTP "program called animation1."
OUTP "The controller program sends signals to the VCG tool."
OUTP "The VCG tool indicates the completion of vizualization"
OUTP "by sending a signal back to the controlling program."
OUTP "IMPORTANT: Do not quit the VCG tool. Do not give any "
OUTP "           input (keypress, menu selection) to the VCG tool."
OUTP "           Wait !  The animation is finished automatically."

OUTP ""
OUTP "Press Carriage Return key to start the animation ..."
set f = $<
if ("$f" == "QUIT") goto finishup

animation2

OUTP "Ready ! Press Carriage Return key to finish the demonstration."


finishup:
CLEAR
OUTP "This was the demonstration of the vcg tool"

OUTP ""
loopa:
  OUTP "Should the directory be cleaned ?"
  OUTP "1 : yes   0 : no "
  OUTP "y : yes   n : no "
  set wsys = $<
  switch ($wsys)
  case y:
  case 1:
	OUTP "Cleanup ..."
	OUTP "Test" > demoaaa.vcg
	OUTP "Test" > animaaa.vcg
	OUTP "Test" > rbtreeaaa.vcg
	RM demo*.vcg anim*.vcg rbtree*.vcg
	breaksw
  case n:
  case 0:
	breaksw
  default:
	OUTP ""
	OUTP "*** invalid input ***"	
	goto loopa
  endsw
OUTP "Goodbye ..."

