#!/usr/bin/env python
# -*- coding: utf-8 -*-


"""
Distutils installation script.

Three extended classes inspired by (shamelessly ripped from) gaupol:
InstallLib fixes the paths in paths.py, initially set for local execution.
InstallData compiles .mo files and installs them in locale/LC_MESSAGES.
Clean removes the translations, .pyc and .pyo files and some other things.
"""


import textwrap
import glob
import os
from distutils import dir_util
from distutils.core import setup
from distutils.command.install_lib import install_lib
from distutils.command.install_data import install_data
from distutils.command.clean import clean


data_files = []


def fill_data_files():
    add = lambda directory, files: data_files.append((directory, files))
    add('share/vboxgtk/xml', glob.glob('data/xml/*.xml'))
    for size in ('16x16', '22x22', '24x24', '32x32', 'scalable'):
        files = glob.glob('data/icons/hicolor/%s/apps/*.png' % size)
        files += glob.glob('data/icons/hicolor/%s/apps/*.svg' % size)
        add('share/icons/hicolor/%s/apps' % size, files)


class InstallLib(install_lib):

    def install(self):
        prefix = self.distribution.get_command_obj('install').install_data
        root = self.distribution.get_command_obj('install').root
        if root is not None:
            root = os.path.abspath(root)
            prefix = os.path.abspath(prefix).replace(root, '')
        paths_module = os.path.join(self.build_dir, 'vboxgtk/paths.py')
        with open(paths_module, 'w') as f:
            data_path = os.path.join(prefix, 'share/vboxgtk')
            locale_path = os.path.join(prefix, 'share/locale')
            icons_path = os.path.join(prefix, 'share/icons')
            content = """\
            import os
            
            data_path = %r
            locale_path = %r
            icons_path = %r
            """ % (data_path, locale_path, icons_path)
            f.write(textwrap.dedent(content))
        return install_lib.install(self)


class InstallData(install_data):

    def add_desktop_file(self):
        file = 'data/vboxgtk.desktop'
        os.system("intltool-merge -d po %s.in %s" % (file, file))
        self.data_files.append(('share/applications', [file]))

    def add_mo_files(self):
        mo_files = []
        for po_file in glob.glob('po/*.po'):
            locale = os.path.basename(po_file[:-3])
            mo_dir = os.path.join('locale', locale, 'LC_MESSAGES')
            mo_file = os.path.join(mo_dir, 'vboxgtk.mo')
            dest_dir = os.path.join('share', mo_dir)
            if not os.path.isdir(mo_dir): 
                os.makedirs(mo_dir)
            os.system("msgfmt %s -o %s" % (po_file, mo_file))
            if os.path.isfile(mo_file): 
                mo_files.append((dest_dir, [mo_file]))
        self.data_files.extend(mo_files)

    def run(self):
        self.add_desktop_file()
        self.add_mo_files()
        install_data.run(self)


class Clean(clean):

    def run(self):
        clean.run(self)
        for file in ('MANIFEST', 'data/vboxgtk.desktop'):
            if os.path.isfile(file):
                os.remove(file)
        for dir in ('build', 'dist', 'locale'):
            if os.path.isdir(dir):
                dir_util.remove_tree(dir)
        for (root, dirs, files) in os.walk('vboxgtk'):
            for file in (x for x in files if x.endswith(('.pyc', '.pyo'))):
                os.remove(os.path.join(root, file))


## End of definitions

fill_data_files()
setup(
    name='vboxgtk',
    version='0.5.0',
    author="Francisco J. Vázquez Araújo",
    author_email="franjva@gmail.com",
    url="http://vboxgtk.sourceforge.net",
    description="VirtualBox GTK+ frontend",
    long_description="VirtualBox GTK+ frontend",
    platforms=['Platform Independent'],
    license='GPL',
    requires=['pygtk (>= 2.14.0)'],
    packages=['vboxgtk'],
    scripts=['bin/vboxgtk'],
    data_files=data_files,
    cmdclass={'install_lib': InstallLib,
              'install_data': InstallData,
              'clean': Clean}
)
