/* genprojectdialog.c generated by valac 0.10.0, the Vala compiler
 * generated from genprojectdialog.vala, do not modify */

/* genprojectdialog.vala
 *
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Andrea Del Signore <sejerpz@tin.it>
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gen-project.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_GEN_PROJECT_DIALOG (vala_gen_project_dialog_get_type ())
#define VALA_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialog))
#define VALA_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))
#define VALA_IS_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_IS_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_GEN_PROJECT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))

typedef struct _ValaGenProjectDialog ValaGenProjectDialog;
typedef struct _ValaGenProjectDialogClass ValaGenProjectDialogClass;
typedef struct _ValaGenProjectDialogPrivate ValaGenProjectDialogPrivate;

#define VALA_TYPE_TAG_CLOUD (vala_tag_cloud_get_type ())
#define VALA_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloud))
#define VALA_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))
#define VALA_IS_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD))
#define VALA_IS_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD))
#define VALA_TAG_CLOUD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))

typedef struct _ValaTagCloud ValaTagCloud;
typedef struct _ValaTagCloudClass ValaTagCloudClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define VALA_TYPE_TAG_CLOUD_ITEM (vala_tag_cloud_item_get_type ())
#define VALA_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItem))
#define VALA_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))
#define VALA_IS_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_IS_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_TAG_CLOUD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))

typedef struct _ValaTagCloudItem ValaTagCloudItem;
typedef struct _ValaTagCloudItemClass ValaTagCloudItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecGenProjectDialog ValaParamSpecGenProjectDialog;

struct _ValaGenProjectDialog {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGenProjectDialogPrivate * priv;
};

struct _ValaGenProjectDialogClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGenProjectDialog *self);
};

struct _ValaGenProjectDialogPrivate {
	GtkDialog* config_dialog;
	GtkFileChooserButton* project_folder_button;
	GtkIconView* project_type_iconview;
	GtkComboBox* license_combobox;
	GtkEntry* name_entry;
	GtkEntry* email_entry;
	GtkButton* button_create_project;
	ValaTagCloud* tag_cloud;
	GenProjectTemplates* templates;
};

struct _ValaParamSpecGenProjectDialog {
	GParamSpec parent_instance;
};


extern GenProjectProjectLicense option_project_license;
static gpointer vala_gen_project_dialog_parent_class = NULL;

gpointer vala_gen_project_dialog_ref (gpointer instance);
void vala_gen_project_dialog_unref (gpointer instance);
GParamSpec* vala_param_spec_gen_project_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_gen_project_dialog (GValue* value, gpointer v_object);
void vala_value_take_gen_project_dialog (GValue* value, gpointer v_object);
gpointer vala_value_get_gen_project_dialog (const GValue* value);
GType vala_gen_project_dialog_get_type (void) G_GNUC_CONST;
GType vala_tag_cloud_get_type (void) G_GNUC_CONST;
#define VALA_GEN_PROJECT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogPrivate))
enum  {
	VALA_GEN_PROJECT_DIALOG_DUMMY_PROPERTY
};
static void vala_gen_project_dialog_initialize_ui (ValaGenProjectDialog* self, GenProjectProjectOptions* options);
static void _lambda0_ (GtkTreePath* sender, ValaGenProjectDialog* self);
static void _g_list_free_gtk_tree_path_free (GList* self);
static void __lambda0__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
ValaTagCloud* vala_tag_cloud_new (void);
ValaTagCloud* vala_tag_cloud_construct (GType object_type);
static void _lambda1_ (ValaTagCloud* sender, ValaGenProjectDialog* self);
static void __lambda1__vala_tag_cloud_selected_items_changed (ValaTagCloud* _sender, gpointer self);
GType vala_tag_cloud_item_get_type (void) G_GNUC_CONST;
ValaTagCloudItem* vala_tag_cloud_get_item_with_text (ValaTagCloud* self, const char* text);
ValaTagCloudItem* vala_tag_cloud_item_new (const char* text, gint occourrences, gboolean selected);
ValaTagCloudItem* vala_tag_cloud_item_construct (GType object_type, const char* text, gint occourrences, gboolean selected);
void vala_tag_cloud_add_item (ValaTagCloud* self, ValaTagCloudItem* item);
gint vala_tag_cloud_item_get_occourrences (ValaTagCloudItem* self);
void vala_tag_cloud_item_set_occourrences (ValaTagCloudItem* self, gint value);
static gboolean _lambda2_ (GtkTreeModel* model, GtkTreeIter* iter, ValaGenProjectDialog* self);
gboolean vala_tag_cloud_item_get_selected (ValaTagCloudItem* self);
static gboolean __lambda2__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
GtkResponseType vala_gen_project_dialog_ask_parameters (ValaGenProjectDialog* self, GenProjectProjectOptions* options);
ValaGenProjectDialog* vala_gen_project_dialog_new (void);
ValaGenProjectDialog* vala_gen_project_dialog_construct (GType object_type);
static void vala_gen_project_dialog_finalize (ValaGenProjectDialog* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static void _lambda0_ (GtkTreePath* sender, ValaGenProjectDialog* self) {
	GList* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (sender != NULL);
	if ((_tmp1_ = g_list_length (_tmp0_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview)) > 0, __g_list_free_gtk_tree_path_free0 (_tmp0_), _tmp1_)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, FALSE);
	}
}


static void __lambda0__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	_lambda0_ (path, self);
}


static void _lambda1_ (ValaTagCloud* sender, ValaGenProjectDialog* self) {
	GtkTreeModel* _tmp0_;
	GtkTreeModelFilter* model;
	GList* _tmp1_;
	gboolean _tmp2_;
	GList* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (sender != NULL);
	model = _g_object_ref0 ((_tmp0_ = gtk_icon_view_get_model (self->priv->project_type_iconview), GTK_IS_TREE_MODEL_FILTER (_tmp0_) ? ((GtkTreeModelFilter*) _tmp0_) : NULL));
	if (model != NULL) {
		gtk_tree_model_filter_refilter (model);
	}
	if ((_tmp2_ = g_list_length (_tmp1_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview)) <= 0, __g_list_free_gtk_tree_path_free0 (_tmp1_), _tmp2_)) {
		GtkTreePath* _tmp3_;
		gtk_icon_view_select_path (self->priv->project_type_iconview, _tmp3_ = gtk_tree_path_new_from_string ("0"));
		_gtk_tree_path_free0 (_tmp3_);
	}
	if ((_tmp5_ = g_list_length (_tmp4_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview)) > 0, __g_list_free_gtk_tree_path_free0 (_tmp4_), _tmp5_)) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, FALSE);
	}
	_g_object_unref0 (model);
}


static void __lambda1__vala_tag_cloud_selected_items_changed (ValaTagCloud* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static gboolean _lambda2_ (GtkTreeModel* model, GtkTreeIter* iter, ValaGenProjectDialog* self) {
	gboolean result = FALSE;
	GenProjectTemplateDefinition* definition;
	gboolean visible;
	g_return_val_if_fail (model != NULL, FALSE);
	definition = NULL;
	visible = FALSE;
	gtk_tree_model_get (model, iter, 1, &definition, -1);
	{
		GList* tag_collection;
		GList* tag_it;
		tag_collection = gen_project_template_definition_get_tags (definition);
		for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
			char* tag;
			tag = g_strdup ((const char*) tag_it->data);
			{
				ValaTagCloudItem* tag_item;
				gboolean _tmp0_ = FALSE;
				tag_item = vala_tag_cloud_get_item_with_text (self->priv->tag_cloud, tag);
				if (tag_item != NULL) {
					_tmp0_ = vala_tag_cloud_item_get_selected (tag_item);
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					visible = TRUE;
					_g_object_unref0 (tag_item);
					_g_free0 (tag);
					break;
				}
				_g_object_unref0 (tag_item);
				_g_free0 (tag);
			}
		}
	}
	result = visible;
	_g_object_unref0 (definition);
	return result;
}


static gboolean __lambda2__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = _lambda2_ (model, iter, self);
	return result;
}


static void vala_gen_project_dialog_initialize_ui (ValaGenProjectDialog* self, GenProjectProjectOptions* options) {
	GenProjectTemplates* _tmp0_;
	GtkBuilder* builder;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	self->priv->templates = (_tmp0_ = gen_project_templates_load (NULL, 0), _g_object_unref0 (self->priv->templates), _tmp0_);
	builder = gtk_builder_new ();
	{
		char* _tmp1_;
		GObject* _tmp2_;
		GtkDialog* _tmp3_;
		GObject* _tmp4_;
		GtkButton* _tmp5_;
		GObject* _tmp6_;
		GtkFileChooserButton* _tmp7_;
		GtkHBox* hbox;
		GtkCellRenderer* renderer;
		GObject* _tmp10_;
		GtkIconView* _tmp11_;
		GtkCellRenderer* _tmp12_;
		GObject* _tmp13_;
		GtkScrolledWindow* tags;
		ValaTagCloud* _tmp14_;
		GtkTreeModel* _tmp15_;
		GtkListStore* model;
		gint selected_id;
		gint count;
		GtkTreeModelFilter* filtered_model;
		char* _tmp21_;
		GtkTreePath* _tmp22_;
		GObject* _tmp23_;
		GtkComboBox* _tmp24_;
		GtkCellRenderer* _tmp25_;
		GtkTreeModel* _tmp26_;
		GtkListStore* _tmp27_;
		GtkTreeIter item = {0};
		GObject* _tmp28_;
		GtkEntry* _tmp29_;
		GObject* _tmp30_;
		GtkEntry* _tmp31_;
		gtk_builder_add_from_file (builder, _tmp1_ = g_build_filename (PACKAGE_DATADIR, "ui", "gen-project.ui", NULL), &_inner_error_);
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		self->priv->config_dialog = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "dialog-gen-project"), GTK_IS_DIALOG (_tmp2_) ? ((GtkDialog*) _tmp2_) : NULL)), _g_object_unref0 (self->priv->config_dialog), _tmp3_);
		g_assert (self->priv->config_dialog != NULL);
		gtk_window_set_title ((GtkWindow*) self->priv->config_dialog, _ ("Vala Project Generator"));
		self->priv->button_create_project = (_tmp5_ = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "button-create-project"), GTK_IS_BUTTON (_tmp4_) ? ((GtkButton*) _tmp4_) : NULL)), _g_object_unref0 (self->priv->button_create_project), _tmp5_);
		g_assert (self->priv->button_create_project != NULL);
		self->priv->project_folder_button = (_tmp7_ = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "filechooserbutton-project-folder"), GTK_IS_FILE_CHOOSER_BUTTON (_tmp6_) ? ((GtkFileChooserButton*) _tmp6_) : NULL)), _g_object_unref0 (self->priv->project_folder_button), _tmp7_);
		g_assert (self->priv->project_folder_button != NULL);
		hbox = NULL;
		if (options->path != NULL) {
			GObject* _tmp8_;
			GtkHBox* _tmp9_;
			hbox = (_tmp9_ = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (builder, "hbox-project-folder"), GTK_IS_HBOX (_tmp8_) ? ((GtkHBox*) _tmp8_) : NULL)), _g_object_unref0 (hbox), _tmp9_);
			g_assert (hbox != NULL);
			gtk_widget_set_visible ((GtkWidget*) hbox, FALSE);
		}
		renderer = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
		self->priv->project_type_iconview = (_tmp11_ = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (builder, "iconview-project-type"), GTK_IS_ICON_VIEW (_tmp10_) ? ((GtkIconView*) _tmp10_) : NULL)), _g_object_unref0 (self->priv->project_type_iconview), _tmp11_);
		g_assert (self->priv->project_type_iconview != NULL);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->project_type_iconview, renderer, FALSE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->project_type_iconview, renderer, "pixbuf", 2);
		renderer = (_tmp12_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp12_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->project_type_iconview, renderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->project_type_iconview, renderer, "text", 0);
		g_signal_connect (self->priv->project_type_iconview, "item-activated", (GCallback) __lambda0__gtk_icon_view_item_activated, self);
		tags = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (builder, "scrolledwindow-tags"), GTK_IS_SCROLLED_WINDOW (_tmp13_) ? ((GtkScrolledWindow*) _tmp13_) : NULL));
		g_assert (tags != NULL);
		self->priv->tag_cloud = (_tmp14_ = g_object_ref_sink (vala_tag_cloud_new ()), _g_object_unref0 (self->priv->tag_cloud), _tmp14_);
		g_signal_connect (self->priv->tag_cloud, "selected-items-changed", (GCallback) __lambda1__vala_tag_cloud_selected_items_changed, self);
		gtk_widget_show_all ((GtkWidget*) self->priv->tag_cloud);
		gtk_scrolled_window_add_with_viewport (tags, (GtkWidget*) self->priv->tag_cloud);
		model = _g_object_ref0 ((_tmp15_ = gtk_icon_view_get_model (self->priv->project_type_iconview), GTK_IS_LIST_STORE (_tmp15_) ? ((GtkListStore*) _tmp15_) : NULL));
		g_assert (model != NULL);
		selected_id = 0;
		count = 0;
		{
			GList* definition_collection;
			GList* definition_it;
			definition_collection = gen_project_templates_get_definitions (self->priv->templates);
			for (definition_it = definition_collection; definition_it != NULL; definition_it = definition_it->next) {
				GenProjectTemplateDefinition* definition;
				definition = _g_object_ref0 ((GenProjectTemplateDefinition*) definition_it->data);
				{
					GtkTreeIter item = {0};
					GdkPixbuf* icon;
					gboolean _tmp18_ = FALSE;
					gtk_list_store_append (model, &item);
					icon = NULL;
					if (gen_project_template_definition_get_icon_filename (definition) != NULL) {
						GdkPixbuf* _tmp16_;
						GdkPixbuf* _tmp17_;
						_tmp16_ = gdk_pixbuf_new_from_file_at_size (gen_project_template_definition_get_icon_filename (definition), 24, 24, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (icon);
							_g_object_unref0 (definition);
							_g_object_unref0 (model);
							_g_object_unref0 (tags);
							_g_object_unref0 (renderer);
							_g_object_unref0 (hbox);
							goto __catch1_g_error;
						}
						icon = (_tmp17_ = _tmp16_, _g_object_unref0 (icon), _tmp17_);
					}
					gtk_list_store_set (model, &item, 0, gen_project_template_definition_get_name (definition), 1, definition, 2, icon, -1);
					if (options->template != NULL) {
						_tmp18_ = gen_project_template_definition_get_id (definition) == gen_project_template_definition_get_id (options->template);
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						selected_id = count;
					}
					{
						GList* tag_collection;
						GList* tag_it;
						tag_collection = gen_project_template_definition_get_tags (definition);
						for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
							char* tag;
							tag = g_strdup ((const char*) tag_it->data);
							{
								ValaTagCloudItem* tag_item;
								gint _tmp20_;
								tag_item = vala_tag_cloud_get_item_with_text (self->priv->tag_cloud, tag);
								if (tag_item == NULL) {
									ValaTagCloudItem* _tmp19_;
									tag_item = (_tmp19_ = vala_tag_cloud_item_new (tag, 0, TRUE), _g_object_unref0 (tag_item), _tmp19_);
									vala_tag_cloud_add_item (self->priv->tag_cloud, tag_item);
								}
								_tmp20_ = vala_tag_cloud_item_get_occourrences (tag_item);
								vala_tag_cloud_item_set_occourrences (tag_item, _tmp20_ + 1);
								_tmp20_;
								_g_object_unref0 (tag_item);
								_g_free0 (tag);
							}
						}
					}
					count++;
					_g_object_unref0 (icon);
					_g_object_unref0 (definition);
				}
			}
		}
		filtered_model = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) model, NULL);
		gtk_tree_model_filter_set_visible_func (filtered_model, __lambda2__gtk_tree_model_filter_visible_func, vala_gen_project_dialog_ref (self), vala_gen_project_dialog_unref);
		gtk_icon_view_set_model (self->priv->project_type_iconview, (GtkTreeModel*) filtered_model);
		gtk_icon_view_select_path (self->priv->project_type_iconview, _tmp22_ = gtk_tree_path_new_from_string (_tmp21_ = g_strdup_printf ("%i", selected_id)));
		_gtk_tree_path_free0 (_tmp22_);
		_g_free0 (_tmp21_);
		self->priv->license_combobox = (_tmp24_ = _g_object_ref0 ((_tmp23_ = gtk_builder_get_object (builder, "combobox-project-license"), GTK_IS_COMBO_BOX (_tmp23_) ? ((GtkComboBox*) _tmp23_) : NULL)), _g_object_unref0 (self->priv->license_combobox), _tmp24_);
		g_assert (self->priv->license_combobox != NULL);
		renderer = (_tmp25_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp25_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->license_combobox, renderer, TRUE);
		gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->license_combobox, renderer, "text", 0);
		model = (_tmp27_ = _g_object_ref0 ((_tmp26_ = gtk_combo_box_get_model (self->priv->license_combobox), GTK_IS_LIST_STORE (_tmp26_) ? ((GtkListStore*) _tmp26_) : NULL)), _g_object_unref0 (model), _tmp27_);
		g_assert (model != NULL);
		gtk_list_store_append (model, &item);
		gtk_list_store_set (model, &item, 0, _ ("GNU General Public License, version 2 or later"), 1, GEN_PROJECT_PROJECT_LICENSE_GPL2, -1);
		gtk_list_store_append (model, &item);
		gtk_list_store_set (model, &item, 0, _ ("GNU General Public License, version 3 or later"), 1, GEN_PROJECT_PROJECT_LICENSE_GPL3, -1);
		gtk_list_store_append (model, &item);
		gtk_list_store_set (model, &item, 0, _ ("GNU Lesser General Public License, version 2.1 or later"), 1, GEN_PROJECT_PROJECT_LICENSE_LGPL2, -1);
		gtk_list_store_append (model, &item);
		gtk_list_store_set (model, &item, 0, _ ("GNU Lesser General Public License, version 3 or later"), 1, GEN_PROJECT_PROJECT_LICENSE_LGPL3, -1);
		gtk_combo_box_set_active (self->priv->license_combobox, (gint) option_project_license);
		self->priv->name_entry = (_tmp29_ = _g_object_ref0 ((_tmp28_ = gtk_builder_get_object (builder, "entry-author-name"), GTK_IS_ENTRY (_tmp28_) ? ((GtkEntry*) _tmp28_) : NULL)), _g_object_unref0 (self->priv->name_entry), _tmp29_);
		g_assert (self->priv->name_entry != NULL);
		if (options->author != NULL) {
			gtk_entry_set_text (self->priv->name_entry, options->author);
		}
		self->priv->email_entry = (_tmp31_ = _g_object_ref0 ((_tmp30_ = gtk_builder_get_object (builder, "entry-author-email"), GTK_IS_ENTRY (_tmp30_) ? ((GtkEntry*) _tmp30_) : NULL)), _g_object_unref0 (self->priv->email_entry), _tmp31_);
		if (options->email != NULL) {
			gtk_entry_set_text (self->priv->email_entry, options->email);
		}
		_g_object_unref0 (filtered_model);
		_g_object_unref0 (model);
		_g_object_unref0 (tags);
		_g_object_unref0 (renderer);
		_g_object_unref0 (hbox);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("genprojectdialog.vala:184: can't build dialog ui: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (builder);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


GtkResponseType vala_gen_project_dialog_ask_parameters (ValaGenProjectDialog* self, GenProjectProjectOptions* options) {
	GtkResponseType result = 0;
	GtkResponseType response = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (options != NULL, 0);
	vala_gen_project_dialog_initialize_ui (self, options);
	response = (GtkResponseType) gtk_dialog_run (self->priv->config_dialog);
	if (response == GTK_RESPONSE_OK) {
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		GList* _tmp4_;
		gboolean _tmp5_;
		if (options->path == NULL) {
			char* _tmp0_;
			options->path = (_tmp0_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) self->priv->project_folder_button), _g_free0 (options->path), _tmp0_);
		}
		options->name = (_tmp1_ = g_path_get_basename (options->path), _g_free0 (options->name), _tmp1_);
		options->author = (_tmp2_ = g_strdup (gtk_entry_get_text (self->priv->name_entry)), _g_free0 (options->author), _tmp2_);
		options->email = (_tmp3_ = g_strdup (gtk_entry_get_text (self->priv->email_entry)), _g_free0 (options->email), _tmp3_);
		options->license = (GenProjectProjectLicense) gtk_combo_box_get_active (self->priv->license_combobox);
		if ((_tmp5_ = g_list_length (_tmp4_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview)) > 0, __g_list_free_gtk_tree_path_free0 (_tmp4_), _tmp5_)) {
			GtkTreeIter iter = {0};
			GList* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreePath* path;
			GtkTreeModel* _tmp8_;
			GtkTreeModelFilter* model;
			path = (_tmp7_ = _gtk_tree_path_copy0 ((GtkTreePath*) g_list_nth_data (_tmp6_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview), (guint) 0)), __g_list_free_gtk_tree_path_free0 (_tmp6_), _tmp7_);
			model = _g_object_ref0 ((_tmp8_ = gtk_icon_view_get_model (self->priv->project_type_iconview), GTK_IS_TREE_MODEL_FILTER (_tmp8_) ? ((GtkTreeModelFilter*) _tmp8_) : NULL));
			if (gtk_tree_model_get_iter ((GtkTreeModel*) model, &iter, path)) {
				GenProjectTemplateDefinition* template;
				GenProjectTemplateDefinition* _tmp9_;
				template = NULL;
				gtk_tree_model_get ((GtkTreeModel*) model, &iter, 1, &template, -1);
				options->template = (_tmp9_ = _g_object_ref0 (template), _g_object_unref0 (options->template), _tmp9_);
				_g_object_unref0 (template);
			}
			_g_object_unref0 (model);
			_gtk_tree_path_free0 (path);
		}
	}
	result = response;
	return result;
}


ValaGenProjectDialog* vala_gen_project_dialog_construct (GType object_type) {
	ValaGenProjectDialog* self;
	self = (ValaGenProjectDialog*) g_type_create_instance (object_type);
	return self;
}


ValaGenProjectDialog* vala_gen_project_dialog_new (void) {
	return vala_gen_project_dialog_construct (VALA_TYPE_GEN_PROJECT_DIALOG);
}


static void vala_value_gen_project_dialog_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_gen_project_dialog_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_gen_project_dialog_unref (value->data[0].v_pointer);
	}
}


static void vala_value_gen_project_dialog_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gen_project_dialog_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_gen_project_dialog_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_gen_project_dialog_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaGenProjectDialog* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gen_project_dialog_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_gen_project_dialog_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaGenProjectDialog** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gen_project_dialog_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_gen_project_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecGenProjectDialog* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_GEN_PROJECT_DIALOG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_gen_project_dialog (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_GEN_PROJECT_DIALOG), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_gen_project_dialog (GValue* value, gpointer v_object) {
	ValaGenProjectDialog* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_GEN_PROJECT_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_GEN_PROJECT_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gen_project_dialog_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gen_project_dialog_unref (old);
	}
}


void vala_value_take_gen_project_dialog (GValue* value, gpointer v_object) {
	ValaGenProjectDialog* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_GEN_PROJECT_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_GEN_PROJECT_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gen_project_dialog_unref (old);
	}
}


static void vala_gen_project_dialog_class_init (ValaGenProjectDialogClass * klass) {
	vala_gen_project_dialog_parent_class = g_type_class_peek_parent (klass);
	VALA_GEN_PROJECT_DIALOG_CLASS (klass)->finalize = vala_gen_project_dialog_finalize;
	g_type_class_add_private (klass, sizeof (ValaGenProjectDialogPrivate));
}


static void vala_gen_project_dialog_instance_init (ValaGenProjectDialog * self) {
	self->priv = VALA_GEN_PROJECT_DIALOG_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_gen_project_dialog_finalize (ValaGenProjectDialog* obj) {
	ValaGenProjectDialog * self;
	self = VALA_GEN_PROJECT_DIALOG (obj);
	_g_object_unref0 (self->priv->config_dialog);
	_g_object_unref0 (self->priv->project_folder_button);
	_g_object_unref0 (self->priv->project_type_iconview);
	_g_object_unref0 (self->priv->license_combobox);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->email_entry);
	_g_object_unref0 (self->priv->button_create_project);
	_g_object_unref0 (self->priv->tag_cloud);
	_g_object_unref0 (self->priv->templates);
}


GType vala_gen_project_dialog_get_type (void) {
	static volatile gsize vala_gen_project_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gen_project_dialog_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_gen_project_dialog_init, vala_value_gen_project_dialog_free_value, vala_value_gen_project_dialog_copy_value, vala_value_gen_project_dialog_peek_pointer, "p", vala_value_gen_project_dialog_collect_value, "p", vala_value_gen_project_dialog_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenProjectDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gen_project_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenProjectDialog), 0, (GInstanceInitFunc) vala_gen_project_dialog_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gen_project_dialog_type_id;
		vala_gen_project_dialog_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenProjectDialog", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gen_project_dialog_type_id__volatile, vala_gen_project_dialog_type_id);
	}
	return vala_gen_project_dialog_type_id__volatile;
}


gpointer vala_gen_project_dialog_ref (gpointer instance) {
	ValaGenProjectDialog* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_gen_project_dialog_unref (gpointer instance) {
	ValaGenProjectDialog* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GEN_PROJECT_DIALOG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




