/* symbol.c generated by valac 0.10.0, the Vala compiler
 * generated from symbol.vala, do not modify */

/* symbol.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;
typedef struct _AfroditeSymbolPrivate AfroditeSymbolPrivate;

#define AFRODITE_TYPE_MEMBER_BINDING (afrodite_member_binding_get_type ())

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;

#define AFRODITE_TYPE_SOURCE_REFERENCE (afrodite_source_reference_get_type ())
#define AFRODITE_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReference))
#define AFRODITE_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))
#define AFRODITE_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))

typedef struct _AfroditeSourceReference AfroditeSourceReference;
typedef struct _AfroditeSourceReferenceClass AfroditeSourceReferenceClass;

#define AFRODITE_TYPE_SYMBOL_ACCESSIBILITY (afrodite_symbol_accessibility_get_type ())

#define AFRODITE_TYPE_VOID_TYPE (afrodite_void_type_get_type ())
#define AFRODITE_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidType))
#define AFRODITE_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))
#define AFRODITE_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))

typedef struct _AfroditeVoidType AfroditeVoidType;
typedef struct _AfroditeVoidTypeClass AfroditeVoidTypeClass;

#define AFRODITE_TYPE_ELLIPSIS_TYPE (afrodite_ellipsis_type_get_type ())
#define AFRODITE_ELLIPSIS_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_ELLIPSIS_TYPE, AfroditeEllipsisType))
#define AFRODITE_ELLIPSIS_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_ELLIPSIS_TYPE, AfroditeEllipsisTypeClass))
#define AFRODITE_IS_ELLIPSIS_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_ELLIPSIS_TYPE))
#define AFRODITE_IS_ELLIPSIS_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_ELLIPSIS_TYPE))
#define AFRODITE_ELLIPSIS_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_ELLIPSIS_TYPE, AfroditeEllipsisTypeClass))

typedef struct _AfroditeEllipsisType AfroditeEllipsisType;
typedef struct _AfroditeEllipsisTypeClass AfroditeEllipsisTypeClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))

#define AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS (afrodite_utils_symbols_predefined_symbols_get_type ())
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbols))
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsClass))
#define AFRODITE_UTILS_SYMBOLS_IS_PREDEFINED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS))
#define AFRODITE_UTILS_SYMBOLS_IS_PREDEFINED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS))
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsClass))

typedef struct _AfroditeUtilsSymbolsPredefinedSymbols AfroditeUtilsSymbolsPredefinedSymbols;
typedef struct _AfroditeUtilsSymbolsPredefinedSymbolsClass AfroditeUtilsSymbolsPredefinedSymbolsClass;
typedef struct _AfroditeUtilsSymbolsPredefinedSymbolsPrivate AfroditeUtilsSymbolsPredefinedSymbolsPrivate;
#define _afrodite_utils_symbols_predefined_symbols_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_utils_symbols_predefined_symbols_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AFRODITE_TYPE_COMPARE_MODE (afrodite_compare_mode_get_type ())

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))

#define AFRODITE_TYPE_QUERY_OPTIONS (afrodite_query_options_get_type ())
#define AFRODITE_QUERY_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_QUERY_OPTIONS, AfroditeQueryOptions))
#define AFRODITE_QUERY_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_QUERY_OPTIONS, AfroditeQueryOptionsClass))
#define AFRODITE_IS_QUERY_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_QUERY_OPTIONS))
#define AFRODITE_IS_QUERY_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_QUERY_OPTIONS))
#define AFRODITE_QUERY_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_QUERY_OPTIONS, AfroditeQueryOptionsClass))

typedef struct _AfroditeQueryOptions AfroditeQueryOptions;
typedef struct _AfroditeQueryOptionsClass AfroditeQueryOptionsClass;
typedef struct _AfroditeQueryOptionsPrivate AfroditeQueryOptionsPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	AFRODITE_MEMBER_BINDING_INSTANCE = 1,
	AFRODITE_MEMBER_BINDING_CLASS = 1 << 1,
	AFRODITE_MEMBER_BINDING_STATIC = 1 << 2,
	AFRODITE_MEMBER_BINDING_ANY = (AFRODITE_MEMBER_BINDING_INSTANCE | AFRODITE_MEMBER_BINDING_CLASS) | AFRODITE_MEMBER_BINDING_STATIC
} AfroditeMemberBinding;

struct _AfroditeSymbol {
	GObject parent_instance;
	AfroditeSymbolPrivate * priv;
	ValaList* resolve_targets;
	AfroditeMemberBinding binding;
	gboolean is_virtual;
	gboolean is_abstract;
	gboolean overrides;
	gint _static_child_count;
	gint _creation_method_child_count;
};

struct _AfroditeSymbolClass {
	GObjectClass parent_class;
};

typedef enum  {
	AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE = 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL = 1 << 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED = 1 << 2,
	AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC = 1 << 3,
	AFRODITE_SYMBOL_ACCESSIBILITY_ANY = ((AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC
} AfroditeSymbolAccessibility;

struct _AfroditeSymbolPrivate {
	AfroditeSymbol* _parent;
	ValaList* _children;
	GStaticRecMutex __lock_resolve_targets;
	AfroditeSymbol* _generic_parent;
	char* _name;
	char* _fully_qualified_name;
	AfroditeDataType* _return_type;
	char* _type_name;
	ValaList* _source_references;
	ValaList* _parameters;
	ValaList* _local_variables;
	ValaList* _base_types;
	ValaList* _generic_type_arguments;
	AfroditeSymbolAccessibility _access;
	char* _info;
	char* _des;
	char* _markup_des;
	char* _display_name;
	AfroditeDataType* _symbol_type;
	ValaList* _specialized_symbols;
};

struct _AfroditeUtilsSymbolsPredefinedSymbols {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeUtilsSymbolsPredefinedSymbolsPrivate * priv;
	AfroditeDataType* signal_type;
};

struct _AfroditeUtilsSymbolsPredefinedSymbolsClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeUtilsSymbolsPredefinedSymbols *self);
};

typedef enum  {
	AFRODITE_COMPARE_MODE_EXACT,
	AFRODITE_COMPARE_MODE_START_WITH
} AfroditeCompareMode;

struct _AfroditeQueryOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeQueryOptionsPrivate * priv;
	gboolean all_symbols;
	gboolean only_creation_methods;
	gboolean only_static_factories;
	gboolean only_error_domains;
	gboolean exclude_creation_methods;
	gboolean exclude_code_node;
	AfroditeSymbolAccessibility access;
	gboolean auto_member_binding_mode;
	AfroditeMemberBinding binding;
	AfroditeCompareMode compare_mode;
};

struct _AfroditeQueryOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeQueryOptions *self);
};


extern AfroditeVoidType* afrodite_symbol_VOID;
AfroditeVoidType* afrodite_symbol_VOID = NULL;
extern AfroditeEllipsisType* afrodite_symbol_ELLIPSIS;
AfroditeEllipsisType* afrodite_symbol_ELLIPSIS = NULL;
static gpointer afrodite_symbol_parent_class = NULL;

GType afrodite_symbol_get_type (void) G_GNUC_CONST;
GType afrodite_member_binding_get_type (void) G_GNUC_CONST;
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_reference_ref (gpointer instance);
void afrodite_source_reference_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_reference (GValue* value, gpointer v_object);
void afrodite_value_take_source_reference (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_reference (const GValue* value);
GType afrodite_source_reference_get_type (void) G_GNUC_CONST;
GType afrodite_symbol_accessibility_get_type (void) G_GNUC_CONST;
#define AFRODITE_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_SYMBOL, AfroditeSymbolPrivate))
enum  {
	AFRODITE_SYMBOL_DUMMY_PROPERTY,
	AFRODITE_SYMBOL_PARENT,
	AFRODITE_SYMBOL_CHILDREN,
	AFRODITE_SYMBOL_GENERIC_PARENT,
	AFRODITE_SYMBOL_NAME,
	AFRODITE_SYMBOL_FULLY_QUALIFIED_NAME,
	AFRODITE_SYMBOL_RETURN_TYPE,
	AFRODITE_SYMBOL_TYPE_NAME,
	AFRODITE_SYMBOL_SOURCE_REFERENCES,
	AFRODITE_SYMBOL_PARAMETERS,
	AFRODITE_SYMBOL_LOCAL_VARIABLES,
	AFRODITE_SYMBOL_BASE_TYPES,
	AFRODITE_SYMBOL_GENERIC_TYPE_ARGUMENTS,
	AFRODITE_SYMBOL_ACCESS,
	AFRODITE_SYMBOL_SYMBOL_TYPE,
	AFRODITE_SYMBOL_STATIC_CHILD_COUNT,
	AFRODITE_SYMBOL_CREATION_METHOD_CHILD_COUNT,
	AFRODITE_SYMBOL_HAS_CHILDREN,
	AFRODITE_SYMBOL_HAS_RESOLVE_TARGETS,
	AFRODITE_SYMBOL_HAS_PARAMETERS,
	AFRODITE_SYMBOL_HAS_GENERIC_TYPE_ARGUMENTS,
	AFRODITE_SYMBOL_HAS_LOCAL_VARIABLES,
	AFRODITE_SYMBOL_HAS_BASE_TYPES,
	AFRODITE_SYMBOL_HAS_SOURCE_REFERENCES,
	AFRODITE_SYMBOL_HAS_STATIC_CHILD,
	AFRODITE_SYMBOL_HAS_CREATION_METHOD_CHILD,
	AFRODITE_SYMBOL_IS_STATIC,
	AFRODITE_SYMBOL_DESCRIPTION,
	AFRODITE_SYMBOL_MARKUP_DESCRIPTION,
	AFRODITE_SYMBOL_INFO,
	AFRODITE_SYMBOL_DISPLAY_NAME,
	AFRODITE_SYMBOL_ACCESS_STRING,
	AFRODITE_SYMBOL_BINDING_STRING
};
AfroditeVoidType* afrodite_void_type_new (void);
AfroditeVoidType* afrodite_void_type_construct (GType object_type);
GType afrodite_void_type_get_type (void) G_GNUC_CONST;
AfroditeEllipsisType* afrodite_ellipsis_type_new (void);
AfroditeEllipsisType* afrodite_ellipsis_type_construct (GType object_type);
GType afrodite_ellipsis_type_get_type (void) G_GNUC_CONST;
AfroditeSymbol* afrodite_symbol_new (const char* fully_qualified_name, const char* type_name);
AfroditeSymbol* afrodite_symbol_construct (GType object_type, const char* fully_qualified_name, const char* type_name);
void afrodite_symbol_set_name (AfroditeSymbol* self, const char* value);
void afrodite_symbol_set_fully_qualified_name (AfroditeSymbol* self, const char* value);
void afrodite_symbol_set_type_name (AfroditeSymbol* self, const char* value);
const char* afrodite_symbol_get_type_name (AfroditeSymbol* self);
gpointer afrodite_utils_symbols_predefined_symbols_ref (gpointer instance);
void afrodite_utils_symbols_predefined_symbols_unref (gpointer instance);
GParamSpec* afrodite_utils_symbols_param_spec_predefined_symbols (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_utils_symbols_value_set_predefined_symbols (GValue* value, gpointer v_object);
void afrodite_utils_symbols_value_take_predefined_symbols (GValue* value, gpointer v_object);
gpointer afrodite_utils_symbols_value_get_predefined_symbols (const GValue* value);
GType afrodite_utils_symbols_predefined_symbols_get_type (void) G_GNUC_CONST;
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_get_predefined (void);
void afrodite_symbol_add_child (AfroditeSymbol* self, AfroditeSymbol* child);
ValaList* afrodite_symbol_get_children (AfroditeSymbol* self);
void afrodite_symbol_set_children (AfroditeSymbol* self, ValaList* value);
void afrodite_symbol_set_parent (AfroditeSymbol* self, AfroditeSymbol* value);
gboolean afrodite_symbol_get_is_static (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_static_child (AfroditeSymbol* self);
gint afrodite_symbol_get_static_child_count (AfroditeSymbol* self);
void afrodite_symbol_set_static_child_count (AfroditeSymbol* self, gint value);
gboolean afrodite_symbol_get_has_creation_method_child (AfroditeSymbol* self);
gint afrodite_symbol_get_creation_method_child_count (AfroditeSymbol* self);
void afrodite_symbol_set_creation_method_child_count (AfroditeSymbol* self, gint value);
void afrodite_symbol_remove_child (AfroditeSymbol* self, AfroditeSymbol* child);
AfroditeSymbol* afrodite_symbol_lookup_child (AfroditeSymbol* self, const char* name);
gboolean afrodite_symbol_get_has_children (AfroditeSymbol* self);
const char* afrodite_symbol_get_name (AfroditeSymbol* self);
GType afrodite_compare_mode_get_type (void) G_GNUC_CONST;
AfroditeDataType* afrodite_symbol_lookup_datatype_for_variable (AfroditeSymbol* self, AfroditeCompareMode mode, const char* name, AfroditeSymbolAccessibility access);
gboolean afrodite_symbol_get_has_local_variables (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_local_variables (AfroditeSymbol* self);
static gboolean afrodite_symbol_compare_symbol_names (const char* name1, const char* name2, AfroditeCompareMode mode);
const char* afrodite_data_type_get_name (AfroditeDataType* self);
gboolean afrodite_symbol_get_has_parameters (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_parameters (AfroditeSymbol* self);
AfroditeSymbolAccessibility afrodite_symbol_get_access (AfroditeSymbol* self);
AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_base_types (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_base_types (AfroditeSymbol* self);
AfroditeSymbol* afrodite_data_type_get_symbol (AfroditeDataType* self);
AfroditeDataType* afrodite_symbol_scope_lookup_datatype_for_variable (AfroditeSymbol* self, AfroditeCompareMode mode, const char* name);
AfroditeSymbol* afrodite_symbol_get_parent (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_source_references (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_source_references (AfroditeSymbol* self);
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
AfroditeSourceFile* afrodite_source_reference_get_file (AfroditeSourceReference* self);
gboolean afrodite_source_file_get_has_using_directives (AfroditeSourceFile* self);
ValaList* afrodite_source_file_get_using_directives (AfroditeSourceFile* self);
gboolean afrodite_data_type_get_unresolved (AfroditeDataType* self);
void afrodite_symbol_add_resolve_target (AfroditeSymbol* self, AfroditeSymbol* resolve_target);
void afrodite_symbol_remove_resolve_target (AfroditeSymbol* self, AfroditeSymbol* resolve_target);
void afrodite_symbol_add_parameter (AfroditeSymbol* self, AfroditeDataType* par);
void afrodite_symbol_set_parameters (AfroditeSymbol* self, ValaList* value);
void afrodite_symbol_remove_parameter (AfroditeSymbol* self, AfroditeDataType* par);
void afrodite_symbol_add_generic_type_argument (AfroditeSymbol* self, AfroditeSymbol* sym);
ValaList* afrodite_symbol_get_generic_type_arguments (AfroditeSymbol* self);
void afrodite_symbol_set_generic_type_arguments (AfroditeSymbol* self, ValaList* value);
void afrodite_symbol_remove_generic_type_argument (AfroditeSymbol* self, AfroditeSymbol* sym);
void afrodite_symbol_add_local_variable (AfroditeSymbol* self, AfroditeDataType* variable);
void afrodite_symbol_set_local_variables (AfroditeSymbol* self, ValaList* value);
void afrodite_symbol_remove_local_variable (AfroditeSymbol* self, AfroditeDataType* variable);
AfroditeDataType* afrodite_symbol_lookup_local_variable (AfroditeSymbol* self, const char* name);
void afrodite_symbol_add_base_type (AfroditeSymbol* self, AfroditeDataType* type);
void afrodite_symbol_set_base_types (AfroditeSymbol* self, ValaList* value);
void afrodite_symbol_remove_base_type (AfroditeSymbol* self, AfroditeDataType* type);
void afrodite_symbol_add_source_reference (AfroditeSymbol* self, AfroditeSourceReference* reference);
void afrodite_symbol_set_source_references (AfroditeSymbol* self, ValaList* value);
void afrodite_symbol_remove_source_reference (AfroditeSymbol* self, AfroditeSourceReference* reference);
AfroditeSourceReference* afrodite_symbol_lookup_source_reference_filename (AfroditeSymbol* self, const char* filename);
const char* afrodite_source_file_get_filename (AfroditeSourceFile* self);
AfroditeSourceReference* afrodite_symbol_lookup_source_reference_sourcefile (AfroditeSymbol* self, AfroditeSourceFile* source);
void afrodite_symbol_destroy (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_resolve_targets (AfroditeSymbol* self);
void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value);
gpointer afrodite_query_options_ref (gpointer instance);
void afrodite_query_options_unref (gpointer instance);
GParamSpec* afrodite_param_spec_query_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_query_options (GValue* value, gpointer v_object);
void afrodite_value_take_query_options (GValue* value, gpointer v_object);
gpointer afrodite_value_get_query_options (const GValue* value);
GType afrodite_query_options_get_type (void) G_GNUC_CONST;
gboolean afrodite_symbol_check_options (AfroditeSymbol* self, AfroditeQueryOptions* options);
char* afrodite_symbol_build_info (AfroditeSymbol* self);
AfroditeSymbol* afrodite_symbol_get_default_constructor (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_generic_type_arguments (AfroditeSymbol* self);
const char* afrodite_symbol_get_description (AfroditeSymbol* self);
char* afrodite_data_type_get_description (AfroditeDataType* self);
const char* afrodite_symbol_get_display_name (AfroditeSymbol* self);
static char* afrodite_symbol_build_description (AfroditeSymbol* self, gboolean markup);
char* afrodite_symbol_get_access_string (AfroditeSymbol* self);
char* afrodite_symbol_get_binding_string (AfroditeSymbol* self);
AfroditeSymbol* afrodite_symbol_copy (AfroditeSymbol* self);
const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self);
AfroditeDataType* afrodite_data_type_copy (AfroditeDataType* self);
void afrodite_symbol_set_return_type (AfroditeSymbol* self, AfroditeDataType* value);
void afrodite_symbol_set_access (AfroditeSymbol* self, AfroditeSymbolAccessibility value);
void afrodite_symbol_specialize_generic_symbol (AfroditeSymbol* self, ValaList* types);
static void afrodite_symbol_resolve_generic_type (AfroditeSymbol* self, AfroditeSymbol* symbol, const char* generic_type_name, AfroditeDataType* type);
const char* afrodite_data_type_get_type_name (AfroditeDataType* self);
void afrodite_symbol_add_specialized_symbol (AfroditeSymbol* self, AfroditeSymbol* item);
void afrodite_symbol_set_generic_parent (AfroditeSymbol* self, AfroditeSymbol* value);
void afrodite_utils_trace (const char* format, ...);
void afrodite_data_type_set_type_name (AfroditeDataType* self, const char* value);
void afrodite_data_type_set_name (AfroditeDataType* self, const char* value);
AfroditeSymbol* afrodite_symbol_get_generic_parent (AfroditeSymbol* self);
AfroditeDataType* afrodite_symbol_get_symbol_type (AfroditeSymbol* self);
const char* afrodite_symbol_get_markup_description (AfroditeSymbol* self);
const char* afrodite_symbol_get_info (AfroditeSymbol* self);
void afrodite_symbol_set_display_name (AfroditeSymbol* self, const char* value);
static void afrodite_symbol_finalize (GObject* obj);
static void afrodite_symbol_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void afrodite_symbol_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gpointer _afrodite_data_type_ref0 (gpointer self) {
	return self ? afrodite_data_type_ref (self) : NULL;
}


AfroditeSymbol* afrodite_symbol_construct (GType object_type, const char* fully_qualified_name, const char* type_name) {
	AfroditeSymbol * self;
	gboolean _tmp2_ = FALSE;
	self = (AfroditeSymbol*) g_object_new (object_type, NULL);
	if (fully_qualified_name != NULL) {
		gint parts_length1;
		gint _parts_size_;
		char** _tmp1_;
		char** _tmp0_;
		char** parts;
		parts = (_tmp1_ = _tmp0_ = g_strsplit (fully_qualified_name, ".", 0), parts_length1 = _vala_array_length (_tmp0_), _parts_size_ = parts_length1, _tmp1_);
		afrodite_symbol_set_name (self, parts[parts_length1 - 1]);
		afrodite_symbol_set_fully_qualified_name (self, fully_qualified_name);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	if (type_name != NULL) {
		_tmp2_ = g_str_has_prefix (type_name, "Vala");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp3_;
		afrodite_symbol_set_type_name (self, _tmp3_ = string_substring (type_name, (glong) 4, -1));
		_g_free0 (_tmp3_);
	} else {
		afrodite_symbol_set_type_name (self, type_name);
	}
	if (_vala_strcmp0 (self->priv->_type_name, "Signal") == 0) {
		AfroditeUtilsSymbolsPredefinedSymbols* _tmp4_;
		AfroditeDataType* _tmp5_;
		self->priv->_symbol_type = (_tmp5_ = _afrodite_data_type_ref0 ((_tmp4_ = afrodite_utils_symbols_get_predefined ())->signal_type), _afrodite_data_type_unref0 (self->priv->_symbol_type), _tmp5_);
		_afrodite_utils_symbols_predefined_symbols_unref0 (_tmp4_);
	}
	return self;
}


AfroditeSymbol* afrodite_symbol_new (const char* fully_qualified_name, const char* type_name) {
	return afrodite_symbol_construct (AFRODITE_TYPE_SYMBOL, fully_qualified_name, type_name);
}


void afrodite_symbol_add_child (AfroditeSymbol* self, AfroditeSymbol* child) {
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	if (self->priv->_children == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_symbol_set_children (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_children, child);
	afrodite_symbol_set_parent (child, self);
	if (afrodite_symbol_get_is_static (child)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = afrodite_symbol_get_has_static_child (child);
	}
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = afrodite_symbol_get_static_child_count (self);
		afrodite_symbol_set_static_child_count (self, _tmp2_ + 1);
		_tmp2_;
	}
	if (_vala_strcmp0 (child->priv->_type_name, "CreationMethod") == 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = afrodite_symbol_get_has_creation_method_child (child);
	}
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = afrodite_symbol_get_creation_method_child_count (self);
		afrodite_symbol_set_creation_method_child_count (self, _tmp4_ + 1);
		_tmp4_;
	}
}


void afrodite_symbol_remove_child (AfroditeSymbol* self, AfroditeSymbol* child) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_children, child);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_children) == 0) {
		afrodite_symbol_set_children (self, NULL);
	}
	if (self->_static_child_count > 0) {
		gboolean _tmp1_ = FALSE;
		if (afrodite_symbol_get_is_static (child)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = afrodite_symbol_get_has_static_child (child);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp2_;
		_tmp2_ = afrodite_symbol_get_static_child_count (self);
		afrodite_symbol_set_static_child_count (self, _tmp2_ - 1);
		_tmp2_;
	}
	if (self->_creation_method_child_count > 0) {
		gboolean _tmp4_ = FALSE;
		if (_vala_strcmp0 (child->priv->_type_name, "CreationMethod") == 0) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = afrodite_symbol_get_has_creation_method_child (child);
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint _tmp5_;
		_tmp5_ = afrodite_symbol_get_creation_method_child_count (self);
		afrodite_symbol_set_creation_method_child_count (self, _tmp5_ + 1);
		_tmp5_;
	}
}


AfroditeSymbol* afrodite_symbol_lookup_child (AfroditeSymbol* self, const char* name) {
	AfroditeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (afrodite_symbol_get_has_children (self)) {
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) self->priv->_children);
			while (TRUE) {
				AfroditeSymbol* s;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSymbol*) vala_iterator_get (_s_it);
				if (_vala_strcmp0 (s->priv->_name, name) == 0) {
					result = s;
					_vala_collection_object_unref0 (_s_it);
					return result;
				}
				_g_object_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
	}
	result = NULL;
	return result;
}


AfroditeDataType* afrodite_symbol_lookup_datatype_for_variable (AfroditeSymbol* self, AfroditeCompareMode mode, const char* name, AfroditeSymbolAccessibility access) {
	AfroditeDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (afrodite_symbol_get_has_local_variables (self)) {
		{
			ValaIterator* _d_it;
			_d_it = vala_iterable_iterator ((ValaIterable*) self->priv->_local_variables);
			while (TRUE) {
				AfroditeDataType* d;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (AfroditeDataType*) vala_iterator_get (_d_it);
				if (afrodite_symbol_compare_symbol_names (afrodite_data_type_get_name (d), name, mode)) {
					result = d;
					_vala_collection_object_unref0 (_d_it);
					return result;
				}
				_afrodite_data_type_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
	}
	if (afrodite_symbol_get_has_parameters (self)) {
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) self->priv->_parameters);
			while (TRUE) {
				AfroditeDataType* type;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				if (afrodite_symbol_compare_symbol_names (afrodite_data_type_get_name (type), name, mode)) {
					result = type;
					_vala_collection_object_unref0 (_type_it);
					return result;
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
	}
	if (afrodite_symbol_get_has_children (self)) {
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) self->priv->_children);
			while (TRUE) {
				AfroditeSymbol* s;
				gboolean _tmp0_ = FALSE;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSymbol*) vala_iterator_get (_s_it);
				if ((afrodite_symbol_get_access (s) & access) != 0) {
					_tmp0_ = afrodite_symbol_compare_symbol_names (s->priv->_name, name, mode);
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					result = _afrodite_data_type_ref0 (s->priv->_return_type);
					_g_object_unref0 (s);
					_vala_collection_object_unref0 (_s_it);
					return result;
				}
				_g_object_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
	}
	if (afrodite_symbol_get_has_base_types (self)) {
		{
			ValaIterator* _d_it;
			_d_it = vala_iterable_iterator ((ValaIterable*) self->priv->_base_types);
			while (TRUE) {
				AfroditeDataType* d;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (AfroditeDataType*) vala_iterator_get (_d_it);
				if (afrodite_data_type_get_symbol (d) != NULL) {
					AfroditeDataType* r;
					r = afrodite_symbol_lookup_datatype_for_variable (afrodite_data_type_get_symbol (d), mode, name, (AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED);
					if (r != NULL) {
						result = d;
						_afrodite_data_type_unref0 (r);
						_vala_collection_object_unref0 (_d_it);
						return result;
					}
					_afrodite_data_type_unref0 (r);
				}
				_afrodite_data_type_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
	}
	result = NULL;
	return result;
}


AfroditeDataType* afrodite_symbol_scope_lookup_datatype_for_variable (AfroditeSymbol* self, AfroditeCompareMode mode, const char* name) {
	AfroditeDataType* result = NULL;
	AfroditeDataType* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = afrodite_symbol_lookup_datatype_for_variable (self, mode, name, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	if (_result_ == NULL) {
		if (self->priv->_parent != NULL) {
			AfroditeDataType* _tmp0_;
			_result_ = (_tmp0_ = afrodite_symbol_scope_lookup_datatype_for_variable (self->priv->_parent, mode, name), _afrodite_data_type_unref0 (_result_), _tmp0_);
		}
		if (_result_ == NULL) {
			if (afrodite_symbol_get_has_source_references (self)) {
				{
					ValaIterator* _s_it;
					_s_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_references);
					while (TRUE) {
						AfroditeSourceReference* s;
						if (!vala_iterator_next (_s_it)) {
							break;
						}
						s = (AfroditeSourceReference*) vala_iterator_get (_s_it);
						if (afrodite_source_file_get_has_using_directives (afrodite_source_reference_get_file (s))) {
							{
								ValaIterator* _u_it;
								_u_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_using_directives (afrodite_source_reference_get_file (s)));
								while (TRUE) {
									AfroditeDataType* u;
									if (!vala_iterator_next (_u_it)) {
										break;
									}
									u = (AfroditeDataType*) vala_iterator_get (_u_it);
									if (!afrodite_data_type_get_unresolved (u)) {
										AfroditeDataType* _tmp1_;
										_result_ = (_tmp1_ = afrodite_symbol_lookup_datatype_for_variable (afrodite_data_type_get_symbol (u), mode, name, AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC), _afrodite_data_type_unref0 (_result_), _tmp1_);
										if (_result_ != NULL) {
											_afrodite_data_type_unref0 (u);
											break;
										}
									}
									_afrodite_data_type_unref0 (u);
								}
								_vala_collection_object_unref0 (_u_it);
							}
						}
						if (_result_ != NULL) {
							_afrodite_source_reference_unref0 (s);
							break;
						}
						_afrodite_source_reference_unref0 (s);
					}
					_vala_collection_object_unref0 (_s_it);
				}
			}
		}
	}
	result = _result_;
	return result;
}


static gboolean afrodite_symbol_compare_symbol_names (const char* name1, const char* name2, AfroditeCompareMode mode) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (mode == AFRODITE_COMPARE_MODE_START_WITH) {
		_tmp1_ = name1 != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = name2 != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = g_str_has_prefix (name1, name2);
		return result;
	} else {
		result = _vala_strcmp0 (name1, name2) == 0;
		return result;
	}
}


void afrodite_symbol_add_resolve_target (AfroditeSymbol* self, AfroditeSymbol* resolve_target) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resolve_target != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_resolve_targets);
		{
			if (self->resolve_targets == NULL) {
				ValaList* _tmp0_;
				self->resolve_targets = (_tmp0_ = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), _vala_collection_object_unref0 (self->resolve_targets), _tmp0_);
			}
			vala_collection_add ((ValaCollection*) self->resolve_targets, resolve_target);
		}
		__finally0:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_resolve_targets);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void afrodite_symbol_remove_resolve_target (AfroditeSymbol* self, AfroditeSymbol* resolve_target) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resolve_target != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_resolve_targets);
		{
			vala_collection_remove ((ValaCollection*) self->resolve_targets, resolve_target);
			if (vala_collection_get_size ((ValaCollection*) self->resolve_targets) == 0) {
				ValaList* _tmp0_;
				self->resolve_targets = (_tmp0_ = NULL, _vala_collection_object_unref0 (self->resolve_targets), _tmp0_);
			}
		}
		__finally1:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_resolve_targets);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void afrodite_symbol_add_parameter (AfroditeSymbol* self, AfroditeDataType* par) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (par != NULL);
	if (self->priv->_parameters == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_symbol_set_parameters (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_DATA_TYPE, (GBoxedCopyFunc) afrodite_data_type_ref, afrodite_data_type_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_parameters, par);
}


void afrodite_symbol_remove_parameter (AfroditeSymbol* self, AfroditeDataType* par) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (par != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_parameters, par);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_parameters) == 0) {
		afrodite_symbol_set_parameters (self, NULL);
	}
}


void afrodite_symbol_add_generic_type_argument (AfroditeSymbol* self, AfroditeSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (self->priv->_generic_type_arguments == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_symbol_set_generic_type_arguments (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_generic_type_arguments, sym);
}


void afrodite_symbol_remove_generic_type_argument (AfroditeSymbol* self, AfroditeSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_generic_type_arguments, sym);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_generic_type_arguments) == 0) {
		afrodite_symbol_set_generic_type_arguments (self, NULL);
	}
}


void afrodite_symbol_add_local_variable (AfroditeSymbol* self, AfroditeDataType* variable) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	if (self->priv->_local_variables == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_symbol_set_local_variables (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_DATA_TYPE, (GBoxedCopyFunc) afrodite_data_type_ref, afrodite_data_type_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_local_variables, variable);
}


void afrodite_symbol_remove_local_variable (AfroditeSymbol* self, AfroditeDataType* variable) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_local_variables, variable);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_local_variables) == 0) {
		afrodite_symbol_set_local_variables (self, NULL);
	}
}


AfroditeDataType* afrodite_symbol_lookup_local_variable (AfroditeSymbol* self, const char* name) {
	AfroditeDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (afrodite_symbol_get_has_local_variables (self)) {
		{
			ValaIterator* _d_it;
			_d_it = vala_iterable_iterator ((ValaIterable*) self->priv->_local_variables);
			while (TRUE) {
				AfroditeDataType* d;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (AfroditeDataType*) vala_iterator_get (_d_it);
				if (_vala_strcmp0 (afrodite_data_type_get_name (d), name) == 0) {
					result = d;
					_vala_collection_object_unref0 (_d_it);
					return result;
				}
				_afrodite_data_type_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
	}
	result = NULL;
	return result;
}


void afrodite_symbol_add_base_type (AfroditeSymbol* self, AfroditeDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (self->priv->_base_types == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_symbol_set_base_types (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_DATA_TYPE, (GBoxedCopyFunc) afrodite_data_type_ref, afrodite_data_type_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_base_types, type);
}


void afrodite_symbol_remove_base_type (AfroditeSymbol* self, AfroditeDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_base_types, type);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_base_types) == 0) {
		afrodite_symbol_set_base_types (self, NULL);
	}
}


void afrodite_symbol_add_source_reference (AfroditeSymbol* self, AfroditeSourceReference* reference) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (reference != NULL);
	if (self->priv->_source_references == NULL) {
		ValaArrayList* _tmp0_;
		afrodite_symbol_set_source_references (self, (ValaList*) (_tmp0_ = vala_array_list_new (AFRODITE_TYPE_SOURCE_REFERENCE, (GBoxedCopyFunc) afrodite_source_reference_ref, afrodite_source_reference_unref, g_direct_equal)));
		_vala_collection_object_unref0 (_tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_source_references, reference);
}


void afrodite_symbol_remove_source_reference (AfroditeSymbol* self, AfroditeSourceReference* reference) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (reference != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->_source_references, reference);
	if (vala_collection_get_size ((ValaCollection*) self->priv->_source_references) == 0) {
		afrodite_symbol_set_source_references (self, NULL);
	}
}


AfroditeSourceReference* afrodite_symbol_lookup_source_reference_filename (AfroditeSymbol* self, const char* filename) {
	AfroditeSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	if (afrodite_symbol_get_has_source_references (self)) {
		{
			ValaIterator* _reference_it;
			_reference_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_references);
			while (TRUE) {
				AfroditeSourceReference* reference;
				if (!vala_iterator_next (_reference_it)) {
					break;
				}
				reference = (AfroditeSourceReference*) vala_iterator_get (_reference_it);
				if (_vala_strcmp0 (afrodite_source_file_get_filename (afrodite_source_reference_get_file (reference)), filename) == 0) {
					result = reference;
					_vala_collection_object_unref0 (_reference_it);
					return result;
				}
				_afrodite_source_reference_unref0 (reference);
			}
			_vala_collection_object_unref0 (_reference_it);
		}
	}
	result = NULL;
	return result;
}


AfroditeSourceReference* afrodite_symbol_lookup_source_reference_sourcefile (AfroditeSymbol* self, AfroditeSourceFile* source) {
	AfroditeSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	if (afrodite_symbol_get_has_source_references (self)) {
		{
			ValaIterator* _reference_it;
			_reference_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_references);
			while (TRUE) {
				AfroditeSourceReference* reference;
				if (!vala_iterator_next (_reference_it)) {
					break;
				}
				reference = (AfroditeSourceReference*) vala_iterator_get (_reference_it);
				if (afrodite_source_reference_get_file (reference) == source) {
					result = reference;
					_vala_collection_object_unref0 (_reference_it);
					return result;
				}
				_afrodite_source_reference_unref0 (reference);
			}
			_vala_collection_object_unref0 (_reference_it);
		}
	}
	result = NULL;
	return result;
}


/**
 * This function break circular references of symbol instances
 *
 * This is a workaround for bug: https://bugzilla.gnome.org/show_bug.cgi?id=615830
 *
 * I've a better patch for this, but is seems to introduce a lot of instability
 * on the afrodite engine. See: 
 */
void afrodite_symbol_destroy (AfroditeSymbol* self) {
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (afrodite_symbol_get_has_children (self)) {
		ValaList* _tmp0_;
		vala_collection_clear ((ValaCollection*) self->priv->_children);
		self->priv->_children = (_tmp0_ = NULL, _vala_collection_object_unref0 (self->priv->_children), _tmp0_);
	}
	while (TRUE) {
		AfroditeSymbol* target;
		gboolean _tmp1_ = FALSE;
		if (!afrodite_symbol_get_has_resolve_targets (self)) {
			break;
		}
		target = (AfroditeSymbol*) vala_list_get (self->resolve_targets, 0);
		if (target->priv->_return_type != NULL) {
			_tmp1_ = afrodite_data_type_get_symbol (target->priv->_return_type) == self;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			afrodite_data_type_set_symbol (target->priv->_return_type, NULL);
		}
		if (afrodite_symbol_get_has_parameters (target)) {
			{
				ValaIterator* _type_it;
				_type_it = vala_iterable_iterator ((ValaIterable*) target->priv->_parameters);
				while (TRUE) {
					AfroditeDataType* type;
					if (!vala_iterator_next (_type_it)) {
						break;
					}
					type = (AfroditeDataType*) vala_iterator_get (_type_it);
					if (afrodite_data_type_get_symbol (type) == self) {
						afrodite_data_type_set_symbol (type, NULL);
					}
					_afrodite_data_type_unref0 (type);
				}
				_vala_collection_object_unref0 (_type_it);
			}
		}
		if (afrodite_symbol_get_has_local_variables (target)) {
			{
				ValaIterator* _type_it;
				_type_it = vala_iterable_iterator ((ValaIterable*) target->priv->_local_variables);
				while (TRUE) {
					AfroditeDataType* type;
					if (!vala_iterator_next (_type_it)) {
						break;
					}
					type = (AfroditeDataType*) vala_iterator_get (_type_it);
					if (afrodite_data_type_get_symbol (type) == self) {
						afrodite_data_type_set_symbol (type, NULL);
					}
					_afrodite_data_type_unref0 (type);
				}
				_vala_collection_object_unref0 (_type_it);
			}
		}
		afrodite_symbol_remove_resolve_target (self, target);
		_g_object_unref0 (target);
	}
	if (self->priv->_parent != NULL) {
		_tmp2_ = afrodite_symbol_get_has_children (self->priv->_parent);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		afrodite_symbol_remove_child (self->priv->_parent, self);
	}
}


gboolean afrodite_symbol_check_options (AfroditeSymbol* self, AfroditeQueryOptions* options) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_name != NULL) {
		_tmp0_ = g_str_has_prefix (self->priv->_name, "*");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (options->exclude_code_node) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->_name == NULL) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_str_has_prefix (self->priv->_name, "!");
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	if (options->all_symbols) {
		result = TRUE;
		return result;
	}
	if ((afrodite_symbol_get_access (self) & options->access) != 0) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		if (options->only_static_factories) {
			gboolean _tmp4_ = FALSE;
			if (!afrodite_symbol_get_is_static (self)) {
				_tmp4_ = !afrodite_symbol_get_has_static_child (self);
			} else {
				_tmp4_ = FALSE;
			}
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = FALSE;
			return result;
		}
		if (options->only_creation_methods) {
			_tmp7_ = _vala_strcmp0 (self->priv->_type_name, "CreationMethod") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = _vala_strcmp0 (self->priv->_type_name, "ErrorDomain") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = !afrodite_symbol_get_has_creation_method_child (self);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = FALSE;
			return result;
		}
		if (options->exclude_creation_methods) {
			_tmp8_ = _vala_strcmp0 (self->priv->_type_name, "CreationMethod") == 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			result = FALSE;
			return result;
		}
		if (_vala_strcmp0 (self->priv->_type_name, "Destructor") == 0) {
			result = FALSE;
			return result;
		}
		if ((self->binding & options->binding) == 0) {
			result = FALSE;
			return result;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


char* afrodite_symbol_build_info (AfroditeSymbol* self) {
	char* result = NULL;
	gint param_count;
	char* params;
	char* generic_args;
	GString* sb;
	char* return_type_descr;
	char* type_name_descr;
	const char* _tmp9_;
	const char* _tmp10_;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (_vala_strcmp0 (self->priv->_type_name, "Class") == 0) {
		AfroditeSymbol* s;
		s = afrodite_symbol_get_default_constructor (self);
		if (s != NULL) {
			result = afrodite_symbol_build_info (s);
			_g_object_unref0 (s);
			return result;
		}
		_g_object_unref0 (s);
	}
	param_count = 0;
	params = NULL;
	generic_args = NULL;
	sb = g_string_new ("");
	if (afrodite_symbol_get_has_generic_type_arguments (self)) {
		char* _tmp0_;
		g_string_append (sb, "&lt;");
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) self->priv->_generic_type_arguments);
			while (TRUE) {
				AfroditeSymbol* s;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSymbol*) vala_iterator_get (_s_it);
				g_string_append_printf (sb, "%s, ", afrodite_symbol_get_description (s));
				_g_object_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
		g_string_truncate (sb, (gsize) (sb->len - 2));
		g_string_append (sb, "&gt;");
		generic_args = (_tmp0_ = g_strdup (sb->str), _g_free0 (generic_args), _tmp0_);
		g_string_truncate (sb, (gsize) 0);
	} else {
		char* _tmp1_;
		generic_args = (_tmp1_ = g_strdup (""), _g_free0 (generic_args), _tmp1_);
	}
	if (afrodite_symbol_get_has_parameters (self)) {
		char* sep;
		char* _tmp5_;
		param_count = vala_collection_get_size ((ValaCollection*) self->priv->_parameters);
		sep = NULL;
		if (param_count > 2) {
			char* _tmp2_;
			sep = (_tmp2_ = g_strdup ("\n"), _g_free0 (sep), _tmp2_);
		} else {
			char* _tmp3_;
			sep = (_tmp3_ = g_strdup (" "), _g_free0 (sep), _tmp3_);
		}
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) self->priv->_parameters);
			while (TRUE) {
				AfroditeDataType* type;
				char* _tmp4_;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				g_string_append_printf (sb, "%s,%s", _tmp4_ = afrodite_data_type_get_description (type), sep);
				_g_free0 (_tmp4_);
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
		g_string_truncate (sb, (gsize) (sb->len - 2));
		params = (_tmp5_ = g_strdup (sb->str), _g_free0 (params), _tmp5_);
		g_string_truncate (sb, (gsize) 0);
		_g_free0 (sep);
	} else {
		char* _tmp6_;
		params = (_tmp6_ = g_strdup (""), _g_free0 (params), _tmp6_);
	}
	return_type_descr = g_strdup ("");
	type_name_descr = g_strdup (self->priv->_type_name);
	if (self->priv->_return_type != NULL) {
		if (_vala_strcmp0 (self->priv->_type_name, "CreationMethod") == 0) {
			char* _tmp7_;
			type_name_descr = (_tmp7_ = g_strdup (_ ("Class")), _g_free0 (type_name_descr), _tmp7_);
		} else {
			char* _tmp8_;
			return_type_descr = (_tmp8_ = afrodite_data_type_get_description (self->priv->_return_type), _g_free0 (return_type_descr), _tmp8_);
		}
	}
	_tmp9_ = NULL;
	if (param_count > 2) {
		_tmp9_ = "\n";
	} else {
		_tmp9_ = " ";
	}
	_tmp10_ = NULL;
	if (param_count > 2) {
		_tmp10_ = "\n";
	} else {
		_tmp10_ = "";
	}
	g_string_append_printf (sb, "%s: %s\n\n%s%s<b>%s</b> %s (%s%s)", type_name_descr, afrodite_symbol_get_display_name (self), return_type_descr, _tmp9_, afrodite_symbol_get_display_name (self), generic_args, _tmp10_, params);
	if (self->priv->_type_name != NULL) {
		_tmp11_ = !g_str_has_suffix (self->priv->_type_name, "Method");
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		g_string_truncate (sb, (gsize) (sb->len - 3));
	}
	result = g_strdup (sb->str);
	_g_free0 (type_name_descr);
	_g_free0 (return_type_descr);
	_g_string_free0 (sb);
	_g_free0 (generic_args);
	_g_free0 (params);
	return result;
}


static char* afrodite_symbol_build_description (AfroditeSymbol* self, gboolean markup) {
	char* result = NULL;
	GString* sb;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	sb = g_string_new ("");
	if (_vala_strcmp0 (self->priv->_type_name, "EnumValue") != 0) {
		char* _tmp0_;
		char* _tmp1_;
		gboolean _tmp2_;
		g_string_append (sb, _tmp0_ = afrodite_symbol_get_access_string (self));
		_g_free0 (_tmp0_);
		g_string_append (sb, " ");
		if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = afrodite_symbol_get_binding_string (self), "") != 0, _g_free0 (_tmp1_), _tmp2_)) {
			char* _tmp3_;
			g_string_append (sb, _tmp3_ = afrodite_symbol_get_binding_string (self));
			_g_free0 (_tmp3_);
			g_string_append (sb, " ");
		}
	}
	if (self->priv->_return_type != NULL) {
		if (_vala_strcmp0 (self->priv->_type_name, "Constructor") == 0) {
			g_string_append (sb, "constructor: ");
		} else {
			char* _tmp4_;
			g_string_append_printf (sb, "%s ", _tmp4_ = afrodite_data_type_get_description (self->priv->_return_type));
			_g_free0 (_tmp4_);
		}
	}
	if (markup) {
		_tmp6_ = self->priv->_type_name != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (_vala_strcmp0 (self->priv->_type_name, "Property") == 0) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = g_str_has_suffix (self->priv->_type_name, "Method");
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = g_str_has_suffix (self->priv->_type_name, "Signal");
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = _vala_strcmp0 (self->priv->_type_name, "Field") == 0;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = _vala_strcmp0 (self->priv->_type_name, "Constructor") == 0;
		}
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		char* _tmp11_;
		g_string_append_printf (sb, "%s", _tmp11_ = g_strdup_printf ("<b>%s</b>", afrodite_symbol_get_display_name (self)));
		_g_free0 (_tmp11_);
	} else {
		g_string_append (sb, afrodite_symbol_get_display_name (self));
	}
	if (afrodite_symbol_get_has_generic_type_arguments (self)) {
		g_string_append (sb, "&lt;");
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) self->priv->_generic_type_arguments);
			while (TRUE) {
				AfroditeSymbol* s;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSymbol*) vala_iterator_get (_s_it);
				g_string_append_printf (sb, "%s, ", s->priv->_name);
				_g_object_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
		g_string_truncate (sb, (gsize) (sb->len - 2));
		g_string_append (sb, "&gt;");
	}
	if (self->priv->_type_name != NULL) {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		if (afrodite_symbol_get_has_parameters (self)) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = g_str_has_suffix (self->priv->_type_name, "Method");
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = g_str_has_suffix (self->priv->_type_name, "Signal");
		}
		_tmp12_ = _tmp13_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_string_append (sb, " (");
	}
	if (afrodite_symbol_get_has_parameters (self)) {
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) self->priv->_parameters);
			while (TRUE) {
				AfroditeDataType* type;
				char* _tmp15_;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				g_string_append_printf (sb, "%s, ", _tmp15_ = afrodite_data_type_get_description (type));
				_g_free0 (_tmp15_);
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
		g_string_truncate (sb, (gsize) (sb->len - 2));
	}
	if (self->priv->_type_name != NULL) {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		if (afrodite_symbol_get_has_parameters (self)) {
			_tmp18_ = TRUE;
		} else {
			_tmp18_ = g_str_has_suffix (self->priv->_type_name, "Method");
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = g_str_has_suffix (self->priv->_type_name, "Signal");
		}
		_tmp16_ = _tmp17_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		g_string_append (sb, ")");
	}
	if (afrodite_symbol_get_has_base_types (self)) {
		g_string_append (sb, " : ");
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) self->priv->_base_types);
			while (TRUE) {
				AfroditeDataType* type;
				char* _tmp19_;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				g_string_append_printf (sb, "%s, ", _tmp19_ = afrodite_data_type_get_description (type));
				_g_free0 (_tmp19_);
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
		g_string_truncate (sb, (gsize) (sb->len - 2));
	}
	result = g_strdup (sb->str);
	_g_string_free0 (sb);
	return result;
}


AfroditeSymbol* afrodite_symbol_get_default_constructor (AfroditeSymbol* self) {
	AfroditeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (afrodite_symbol_get_has_children (self)) {
		{
			ValaIterator* _s_it;
			_s_it = vala_iterable_iterator ((ValaIterable*) self->priv->_children);
			while (TRUE) {
				AfroditeSymbol* s;
				if (!vala_iterator_next (_s_it)) {
					break;
				}
				s = (AfroditeSymbol*) vala_iterator_get (_s_it);
				if (_vala_strcmp0 (s->priv->_name, "new") == 0) {
					result = s;
					_vala_collection_object_unref0 (_s_it);
					return result;
				}
				_g_object_unref0 (s);
			}
			_vala_collection_object_unref0 (_s_it);
		}
	}
	result = NULL;
	return result;
}


AfroditeSymbol* afrodite_symbol_copy (AfroditeSymbol* self) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* res;
	AfroditeDataType* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = afrodite_symbol_new (self->priv->_fully_qualified_name, self->priv->_type_name);
	afrodite_symbol_set_type_name (res, self->priv->_type_name);
	afrodite_symbol_set_parent (res, self->priv->_parent);
	afrodite_symbol_set_name (res, self->priv->_name);
	afrodite_symbol_set_fully_qualified_name (res, self->priv->_fully_qualified_name);
	if (self->priv->_return_type != NULL) {
		AfroditeDataType* _tmp0_;
		afrodite_symbol_set_return_type (res, _tmp0_ = afrodite_data_type_copy (self->priv->_return_type));
		_afrodite_data_type_unref0 (_tmp0_);
	}
	afrodite_symbol_set_access (res, afrodite_symbol_get_access (self));
	res->binding = self->binding;
	res->is_virtual = self->is_virtual;
	res->is_abstract = self->is_abstract;
	res->overrides = self->overrides;
	res->priv->_symbol_type = (_tmp1_ = _afrodite_data_type_ref0 (self->priv->_symbol_type), _afrodite_data_type_unref0 (res->priv->_symbol_type), _tmp1_);
	res->_static_child_count = self->_static_child_count;
	res->_creation_method_child_count = self->_creation_method_child_count;
	if (afrodite_symbol_get_has_children (self)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_children);
			while (TRUE) {
				AfroditeSymbol* item;
				AfroditeSymbol* s;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeSymbol*) vala_iterator_get (_item_it);
				s = afrodite_symbol_copy (item);
				afrodite_symbol_add_child (res, s);
				_g_object_unref0 (s);
				_g_object_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (afrodite_symbol_get_has_source_references (self)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_references);
			while (TRUE) {
				AfroditeSourceReference* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeSourceReference*) vala_iterator_get (_item_it);
				afrodite_symbol_add_source_reference (res, item);
				_afrodite_source_reference_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (afrodite_symbol_get_has_parameters (self)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_parameters);
			while (TRUE) {
				AfroditeDataType* item;
				AfroditeDataType* _tmp2_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				afrodite_symbol_add_parameter (res, _tmp2_ = afrodite_data_type_copy (item));
				_afrodite_data_type_unref0 (_tmp2_);
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (afrodite_symbol_get_has_local_variables (self)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_local_variables);
			while (TRUE) {
				AfroditeDataType* item;
				AfroditeDataType* _tmp3_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				afrodite_symbol_add_local_variable (res, _tmp3_ = afrodite_data_type_copy (item));
				_afrodite_data_type_unref0 (_tmp3_);
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (afrodite_symbol_get_has_base_types (self)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_base_types);
			while (TRUE) {
				AfroditeDataType* item;
				AfroditeDataType* d;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				d = afrodite_data_type_copy (item);
				afrodite_symbol_add_base_type (res, d);
				_afrodite_data_type_unref0 (d);
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (self->priv->_generic_type_arguments != NULL) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_generic_type_arguments);
			while (TRUE) {
				AfroditeSymbol* item;
				AfroditeSymbol* _tmp4_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeSymbol*) vala_iterator_get (_item_it);
				afrodite_symbol_add_generic_type_argument (res, _tmp4_ = afrodite_symbol_copy (item));
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	result = res;
	return result;
}


void afrodite_symbol_specialize_generic_symbol (AfroditeSymbol* self, ValaList* types) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (types != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				AfroditeSymbol* _tmp1_;
				char* _tmp2_;
				char* _tmp3_;
				char* name;
				AfroditeDataType* _tmp6_;
				AfroditeSymbol* _tmp7_;
				AfroditeDataType* _tmp8_;
				AfroditeSymbol* _tmp9_;
				AfroditeDataType* _tmp10_;
				AfroditeSymbol* _tmp11_;
				AfroditeDataType* _tmp12_;
				char* _tmp13_;
				char* _tmp14_;
				char* _tmp15_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < vala_collection_get_size ((ValaCollection*) types))) {
					break;
				}
				if (vala_collection_get_size ((ValaCollection*) self->priv->_generic_type_arguments) <= i) {
					break;
				}
				_tmp3_ = (_tmp2_ = g_strdup ((_tmp1_ = (AfroditeSymbol*) vala_list_get (self->priv->_generic_type_arguments, i))->priv->_fully_qualified_name), _g_object_unref0 (_tmp1_), _tmp2_);
				if (_tmp3_ == NULL) {
					AfroditeSymbol* _tmp4_;
					char* _tmp5_;
					_tmp3_ = (_tmp5_ = g_strdup ((_tmp4_ = (AfroditeSymbol*) vala_list_get (self->priv->_generic_type_arguments, i))->priv->_name), _g_free0 (_tmp3_), _tmp5_);
					_g_object_unref0 (_tmp4_);
				}
				name = g_strdup (_tmp3_);
				afrodite_symbol_resolve_generic_type (self, self, name, _tmp6_ = (AfroditeDataType*) vala_list_get (types, i));
				_afrodite_data_type_unref0 (_tmp6_);
				afrodite_symbol_set_fully_qualified_name (_tmp7_ = (AfroditeSymbol*) vala_list_get (self->priv->_generic_type_arguments, i), afrodite_data_type_get_type_name (_tmp8_ = (AfroditeDataType*) vala_list_get (types, i)));
				_afrodite_data_type_unref0 (_tmp8_);
				_g_object_unref0 (_tmp7_);
				afrodite_symbol_set_name (_tmp9_ = (AfroditeSymbol*) vala_list_get (self->priv->_generic_type_arguments, i), afrodite_data_type_get_type_name (_tmp10_ = (AfroditeDataType*) vala_list_get (types, i)));
				_afrodite_data_type_unref0 (_tmp10_);
				_g_object_unref0 (_tmp9_);
				afrodite_symbol_set_return_type (_tmp11_ = (AfroditeSymbol*) vala_list_get (self->priv->_generic_type_arguments, i), _tmp12_ = (AfroditeDataType*) vala_list_get (types, i));
				_afrodite_data_type_unref0 (_tmp12_);
				_g_object_unref0 (_tmp11_);
				self->priv->_des = (_tmp13_ = NULL, _g_free0 (self->priv->_des), _tmp13_);
				self->priv->_info = (_tmp14_ = NULL, _g_free0 (self->priv->_info), _tmp14_);
				self->priv->_markup_des = (_tmp15_ = NULL, _g_free0 (self->priv->_markup_des), _tmp15_);
				_g_free0 (name);
				_g_free0 (_tmp3_);
			}
		}
	}
}


void afrodite_symbol_add_specialized_symbol (AfroditeSymbol* self, AfroditeSymbol* item) {
	g_return_if_fail (self != NULL);
	if (self->priv->_specialized_symbols == NULL) {
		ValaList* _tmp0_;
		self->priv->_specialized_symbols = (_tmp0_ = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->_specialized_symbols), _tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->_specialized_symbols, item);
	afrodite_symbol_set_generic_parent (item, self);
}


static void afrodite_symbol_resolve_generic_type (AfroditeSymbol* self, AfroditeSymbol* symbol, const char* generic_type_name, AfroditeDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (generic_type_name != NULL);
	g_return_if_fail (type != NULL);
	if (symbol->priv->_return_type != NULL) {
		afrodite_utils_trace ("symbol.vala:903: symbol %s return type %s generic type %s, resolved wi" \
"th %s", symbol->priv->_fully_qualified_name, afrodite_data_type_get_type_name (symbol->priv->_return_type), generic_type_name, afrodite_data_type_get_type_name (type));
		if (_vala_strcmp0 (afrodite_data_type_get_type_name (symbol->priv->_return_type), generic_type_name) == 0) {
			afrodite_symbol_set_return_type (symbol, type);
		}
	}
	if (afrodite_symbol_get_has_children (symbol)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) symbol->priv->_children);
			while (TRUE) {
				AfroditeSymbol* item;
				gboolean _tmp0_ = FALSE;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeSymbol*) vala_iterator_get (_item_it);
				if (item->priv->_return_type != NULL) {
					_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (item->priv->_return_type), generic_type_name) == 0;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					afrodite_symbol_set_return_type (item, type);
				}
				if (afrodite_symbol_get_has_parameters (item)) {
					{
						ValaIterator* _par_it;
						_par_it = vala_iterable_iterator ((ValaIterable*) item->priv->_parameters);
						while (TRUE) {
							AfroditeDataType* par;
							if (!vala_iterator_next (_par_it)) {
								break;
							}
							par = (AfroditeDataType*) vala_iterator_get (_par_it);
							if (_vala_strcmp0 (afrodite_data_type_get_type_name (par), generic_type_name) == 0) {
								afrodite_data_type_set_type_name (par, afrodite_data_type_get_type_name (type));
								afrodite_data_type_set_name (par, afrodite_data_type_get_name (type));
								afrodite_data_type_set_symbol (par, afrodite_data_type_get_symbol (type));
							}
							_afrodite_data_type_unref0 (par);
						}
						_vala_collection_object_unref0 (_par_it);
					}
				}
				if (afrodite_symbol_get_has_children (item)) {
					afrodite_symbol_resolve_generic_type (self, item, generic_type_name, type);
				}
				_g_object_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (afrodite_symbol_get_has_local_variables (symbol)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) symbol->priv->_local_variables);
			while (TRUE) {
				AfroditeDataType* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				if (_vala_strcmp0 (afrodite_data_type_get_type_name (item), generic_type_name) == 0) {
					afrodite_data_type_set_type_name (item, afrodite_data_type_get_type_name (type));
					afrodite_data_type_set_symbol (item, afrodite_data_type_get_symbol (type));
				}
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	if (afrodite_symbol_get_has_parameters (symbol)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) symbol->priv->_parameters);
			while (TRUE) {
				AfroditeDataType* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				if (_vala_strcmp0 (afrodite_data_type_get_type_name (item), generic_type_name) == 0) {
					afrodite_data_type_set_type_name (item, afrodite_data_type_get_type_name (type));
					afrodite_data_type_set_name (item, afrodite_data_type_get_type_name (type));
					afrodite_data_type_set_symbol (item, afrodite_data_type_get_symbol (type));
				}
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
}


AfroditeSymbol* afrodite_symbol_get_parent (AfroditeSymbol* self) {
	AfroditeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent;
	return result;
}


void afrodite_symbol_set_parent (AfroditeSymbol* self, AfroditeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_parent = value;
	g_object_notify ((GObject *) self, "parent");
}


ValaList* afrodite_symbol_get_children (AfroditeSymbol* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_children;
	return result;
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


void afrodite_symbol_set_children (AfroditeSymbol* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_children = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_children), _tmp0_);
	g_object_notify ((GObject *) self, "children");
}


AfroditeSymbol* afrodite_symbol_get_generic_parent (AfroditeSymbol* self) {
	AfroditeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_generic_parent;
	return result;
}


void afrodite_symbol_set_generic_parent (AfroditeSymbol* self, AfroditeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_generic_parent = value;
	g_object_notify ((GObject *) self, "generic-parent");
}


const char* afrodite_symbol_get_name (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void afrodite_symbol_set_name (AfroditeSymbol* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_fully_qualified_name;
	return result;
}


void afrodite_symbol_set_fully_qualified_name (AfroditeSymbol* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_fully_qualified_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_fully_qualified_name), _tmp0_);
	g_object_notify ((GObject *) self, "fully-qualified-name");
}


AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self) {
	AfroditeDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_return_type;
	return result;
}


void afrodite_symbol_set_return_type (AfroditeSymbol* self, AfroditeDataType* value) {
	AfroditeDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_return_type = (_tmp0_ = _afrodite_data_type_ref0 (value), _afrodite_data_type_unref0 (self->priv->_return_type), _tmp0_);
	g_object_notify ((GObject *) self, "return-type");
}


const char* afrodite_symbol_get_type_name (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_name;
	return result;
}


void afrodite_symbol_set_type_name (AfroditeSymbol* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_type_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_type_name), _tmp0_);
	g_object_notify ((GObject *) self, "type-name");
}


ValaList* afrodite_symbol_get_source_references (AfroditeSymbol* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_references;
	return result;
}


void afrodite_symbol_set_source_references (AfroditeSymbol* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_references = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_source_references), _tmp0_);
	g_object_notify ((GObject *) self, "source-references");
}


ValaList* afrodite_symbol_get_parameters (AfroditeSymbol* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parameters;
	return result;
}


void afrodite_symbol_set_parameters (AfroditeSymbol* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_parameters = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_parameters), _tmp0_);
	g_object_notify ((GObject *) self, "parameters");
}


ValaList* afrodite_symbol_get_local_variables (AfroditeSymbol* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_local_variables;
	return result;
}


void afrodite_symbol_set_local_variables (AfroditeSymbol* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_local_variables = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_local_variables), _tmp0_);
	g_object_notify ((GObject *) self, "local-variables");
}


ValaList* afrodite_symbol_get_base_types (AfroditeSymbol* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_types;
	return result;
}


void afrodite_symbol_set_base_types (AfroditeSymbol* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_base_types = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_base_types), _tmp0_);
	g_object_notify ((GObject *) self, "base-types");
}


ValaList* afrodite_symbol_get_generic_type_arguments (AfroditeSymbol* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_generic_type_arguments;
	return result;
}


void afrodite_symbol_set_generic_type_arguments (AfroditeSymbol* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_generic_type_arguments = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_generic_type_arguments), _tmp0_);
	g_object_notify ((GObject *) self, "generic-type-arguments");
}


AfroditeSymbolAccessibility afrodite_symbol_get_access (AfroditeSymbol* self) {
	AfroditeSymbolAccessibility result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_access;
	return result;
}


void afrodite_symbol_set_access (AfroditeSymbol* self, AfroditeSymbolAccessibility value) {
	g_return_if_fail (self != NULL);
	self->priv->_access = value;
	g_object_notify ((GObject *) self, "access");
}


AfroditeDataType* afrodite_symbol_get_symbol_type (AfroditeSymbol* self) {
	AfroditeDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_symbol_type == NULL) {
		result = self->priv->_return_type;
		return result;
	}
	result = self->priv->_symbol_type;
	return result;
}


gint afrodite_symbol_get_static_child_count (AfroditeSymbol* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->_static_child_count;
	return result;
}


void afrodite_symbol_set_static_child_count (AfroditeSymbol* self, gint value) {
	gint delta;
	g_return_if_fail (self != NULL);
	delta = value - self->_static_child_count;
	self->_static_child_count = value;
	if (self->priv->_parent != NULL) {
		afrodite_symbol_set_static_child_count (self->priv->_parent, afrodite_symbol_get_static_child_count (self->priv->_parent) + delta);
	}
	g_object_notify ((GObject *) self, "static-child-count");
}


gint afrodite_symbol_get_creation_method_child_count (AfroditeSymbol* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->_creation_method_child_count;
	return result;
}


void afrodite_symbol_set_creation_method_child_count (AfroditeSymbol* self, gint value) {
	gint delta;
	g_return_if_fail (self != NULL);
	delta = value - self->_creation_method_child_count;
	self->_creation_method_child_count = value;
	if (self->priv->_parent != NULL) {
		afrodite_symbol_set_creation_method_child_count (self->priv->_parent, afrodite_symbol_get_creation_method_child_count (self->priv->_parent) + delta);
	}
	g_object_notify ((GObject *) self, "creation-method-child-count");
}


gboolean afrodite_symbol_get_has_children (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_children != NULL;
	return result;
}


gboolean afrodite_symbol_get_has_resolve_targets (AfroditeSymbol* self) {
	gboolean result;
	gboolean res = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_resolve_targets);
		{
			res = self->resolve_targets != NULL;
		}
		__finally2:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_resolve_targets);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = res;
	return result;
}


gboolean afrodite_symbol_get_has_parameters (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_parameters != NULL;
	return result;
}


gboolean afrodite_symbol_get_has_generic_type_arguments (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_generic_type_arguments != NULL;
	return result;
}


gboolean afrodite_symbol_get_has_local_variables (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_local_variables != NULL;
	return result;
}


gboolean afrodite_symbol_get_has_base_types (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_base_types != NULL;
	return result;
}


gboolean afrodite_symbol_get_has_source_references (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_source_references != NULL;
	return result;
}


gboolean afrodite_symbol_get_has_static_child (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_static_child_count > 0;
	return result;
}


gboolean afrodite_symbol_get_has_creation_method_child (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_creation_method_child_count > 0;
	return result;
}


gboolean afrodite_symbol_get_is_static (AfroditeSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->binding & AFRODITE_MEMBER_BINDING_STATIC) != 0;
	return result;
}


const char* afrodite_symbol_get_description (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_des == NULL) {
		char* _tmp0_;
		self->priv->_des = (_tmp0_ = afrodite_symbol_build_description (self, FALSE), _g_free0 (self->priv->_des), _tmp0_);
	}
	result = self->priv->_des;
	return result;
}


const char* afrodite_symbol_get_markup_description (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_markup_des == NULL) {
		char* _tmp0_;
		self->priv->_markup_des = (_tmp0_ = afrodite_symbol_build_description (self, TRUE), _g_free0 (self->priv->_markup_des), _tmp0_);
	}
	result = self->priv->_markup_des;
	return result;
}


const char* afrodite_symbol_get_info (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_info == NULL) {
		char* _tmp0_;
		self->priv->_info = (_tmp0_ = afrodite_symbol_build_info (self), _g_free0 (self->priv->_info), _tmp0_);
	}
	result = self->priv->_info;
	return result;
}


const char* afrodite_symbol_get_display_name (AfroditeSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_display_name == NULL) {
		result = self->priv->_name;
		return result;
	}
	result = self->priv->_display_name;
	return result;
}


void afrodite_symbol_set_display_name (AfroditeSymbol* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_display_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_display_name), _tmp0_);
	g_object_notify ((GObject *) self, "display-name");
}


char* afrodite_symbol_get_access_string (AfroditeSymbol* self) {
	char* result;
	char* res;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	switch (afrodite_symbol_get_access (self)) {
		case AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE:
		{
			char* _tmp0_;
			res = (_tmp0_ = g_strdup ("private"), _g_free0 (res), _tmp0_);
			break;
		}
		case AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL:
		{
			char* _tmp1_;
			res = (_tmp1_ = g_strdup ("internal"), _g_free0 (res), _tmp1_);
			break;
		}
		case AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED:
		{
			char* _tmp2_;
			res = (_tmp2_ = g_strdup ("protected"), _g_free0 (res), _tmp2_);
			break;
		}
		case AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC:
		{
			char* _tmp3_;
			res = (_tmp3_ = g_strdup ("public"), _g_free0 (res), _tmp3_);
			break;
		}
		default:
		{
			char* _tmp4_;
			res = (_tmp4_ = g_strdup ("unknown"), _g_free0 (res), _tmp4_);
			break;
		}
	}
	result = res;
	return result;
}


char* afrodite_symbol_get_binding_string (AfroditeSymbol* self) {
	char* result;
	char* res;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	switch (self->binding) {
		case AFRODITE_MEMBER_BINDING_CLASS:
		{
			char* _tmp0_;
			res = (_tmp0_ = g_strdup ("class"), _g_free0 (res), _tmp0_);
			break;
		}
		case AFRODITE_MEMBER_BINDING_INSTANCE:
		{
			char* _tmp1_;
			res = (_tmp1_ = g_strdup (""), _g_free0 (res), _tmp1_);
			break;
		}
		case AFRODITE_MEMBER_BINDING_STATIC:
		{
			char* _tmp2_;
			res = (_tmp2_ = g_strdup ("static"), _g_free0 (res), _tmp2_);
			break;
		}
		default:
		{
			char* _tmp3_;
			res = (_tmp3_ = g_strdup ("unknown"), _g_free0 (res), _tmp3_);
			break;
		}
	}
	result = res;
	return result;
}


static void afrodite_symbol_class_init (AfroditeSymbolClass * klass) {
	afrodite_symbol_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AfroditeSymbolPrivate));
	G_OBJECT_CLASS (klass)->get_property = afrodite_symbol_get_property;
	G_OBJECT_CLASS (klass)->set_property = afrodite_symbol_set_property;
	G_OBJECT_CLASS (klass)->finalize = afrodite_symbol_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_PARENT, g_param_spec_object ("parent", "parent", "parent", AFRODITE_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_CHILDREN, vala_param_spec_collection_object ("children", "children", "children", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_GENERIC_PARENT, g_param_spec_object ("generic-parent", "generic-parent", "generic-parent", AFRODITE_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_FULLY_QUALIFIED_NAME, g_param_spec_string ("fully-qualified-name", "fully-qualified-name", "fully-qualified-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_RETURN_TYPE, afrodite_param_spec_data_type ("return-type", "return-type", "return-type", AFRODITE_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_TYPE_NAME, g_param_spec_string ("type-name", "type-name", "type-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_SOURCE_REFERENCES, vala_param_spec_collection_object ("source-references", "source-references", "source-references", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_PARAMETERS, vala_param_spec_collection_object ("parameters", "parameters", "parameters", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_LOCAL_VARIABLES, vala_param_spec_collection_object ("local-variables", "local-variables", "local-variables", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_BASE_TYPES, vala_param_spec_collection_object ("base-types", "base-types", "base-types", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_GENERIC_TYPE_ARGUMENTS, vala_param_spec_collection_object ("generic-type-arguments", "generic-type-arguments", "generic-type-arguments", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_ACCESS, g_param_spec_flags ("access", "access", "access", AFRODITE_TYPE_SYMBOL_ACCESSIBILITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_SYMBOL_TYPE, afrodite_param_spec_data_type ("symbol-type", "symbol-type", "symbol-type", AFRODITE_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_STATIC_CHILD_COUNT, g_param_spec_int ("static-child-count", "static-child-count", "static-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_CREATION_METHOD_CHILD_COUNT, g_param_spec_int ("creation-method-child-count", "creation-method-child-count", "creation-method-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_CHILDREN, g_param_spec_boolean ("has-children", "has-children", "has-children", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_RESOLVE_TARGETS, g_param_spec_boolean ("has-resolve-targets", "has-resolve-targets", "has-resolve-targets", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_PARAMETERS, g_param_spec_boolean ("has-parameters", "has-parameters", "has-parameters", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_GENERIC_TYPE_ARGUMENTS, g_param_spec_boolean ("has-generic-type-arguments", "has-generic-type-arguments", "has-generic-type-arguments", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_LOCAL_VARIABLES, g_param_spec_boolean ("has-local-variables", "has-local-variables", "has-local-variables", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_BASE_TYPES, g_param_spec_boolean ("has-base-types", "has-base-types", "has-base-types", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_SOURCE_REFERENCES, g_param_spec_boolean ("has-source-references", "has-source-references", "has-source-references", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_STATIC_CHILD, g_param_spec_boolean ("has-static-child", "has-static-child", "has-static-child", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_HAS_CREATION_METHOD_CHILD, g_param_spec_boolean ("has-creation-method-child", "has-creation-method-child", "has-creation-method-child", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_IS_STATIC, g_param_spec_boolean ("is-static", "is-static", "is-static", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_MARKUP_DESCRIPTION, g_param_spec_string ("markup-description", "markup-description", "markup-description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_INFO, g_param_spec_string ("info", "info", "info", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_ACCESS_STRING, g_param_spec_string ("access-string", "access-string", "access-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_SYMBOL_BINDING_STRING, g_param_spec_string ("binding-string", "binding-string", "binding-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	afrodite_symbol_VOID = afrodite_void_type_new ();
	afrodite_symbol_ELLIPSIS = afrodite_ellipsis_type_new ();
}


static void afrodite_symbol_instance_init (AfroditeSymbol * self) {
	self->priv = AFRODITE_SYMBOL_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_resolve_targets);
	self->resolve_targets = NULL;
	self->priv->_access = AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL;
	self->binding = AFRODITE_MEMBER_BINDING_INSTANCE;
	self->is_virtual = FALSE;
	self->is_abstract = FALSE;
	self->overrides = FALSE;
	self->_static_child_count = 0;
	self->_creation_method_child_count = 0;
	self->priv->_info = NULL;
	self->priv->_des = NULL;
	self->priv->_markup_des = NULL;
	self->priv->_display_name = NULL;
	self->priv->_symbol_type = NULL;
	self->priv->_specialized_symbols = NULL;
}


static void afrodite_symbol_finalize (GObject* obj) {
	AfroditeSymbol * self;
	self = AFRODITE_SYMBOL (obj);
	{
		if (self->priv->_specialized_symbols != NULL) {
			ValaList* _tmp0_;
			vala_collection_clear ((ValaCollection*) self->priv->_specialized_symbols);
			self->priv->_specialized_symbols = (_tmp0_ = NULL, _vala_collection_object_unref0 (self->priv->_specialized_symbols), _tmp0_);
		}
	}
	_vala_collection_object_unref0 (self->priv->_children);
	g_static_rec_mutex_free (&self->priv->__lock_resolve_targets);
	_vala_collection_object_unref0 (self->resolve_targets);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_fully_qualified_name);
	_afrodite_data_type_unref0 (self->priv->_return_type);
	_g_free0 (self->priv->_type_name);
	_vala_collection_object_unref0 (self->priv->_source_references);
	_vala_collection_object_unref0 (self->priv->_parameters);
	_vala_collection_object_unref0 (self->priv->_local_variables);
	_vala_collection_object_unref0 (self->priv->_base_types);
	_vala_collection_object_unref0 (self->priv->_generic_type_arguments);
	_g_free0 (self->priv->_info);
	_g_free0 (self->priv->_des);
	_g_free0 (self->priv->_markup_des);
	_g_free0 (self->priv->_display_name);
	_afrodite_data_type_unref0 (self->priv->_symbol_type);
	_vala_collection_object_unref0 (self->priv->_specialized_symbols);
	G_OBJECT_CLASS (afrodite_symbol_parent_class)->finalize (obj);
}


GType afrodite_symbol_get_type (void) {
	static volatile gsize afrodite_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_symbol_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeSymbol), 0, (GInstanceInitFunc) afrodite_symbol_instance_init, NULL };
		GType afrodite_symbol_type_id;
		afrodite_symbol_type_id = g_type_register_static (G_TYPE_OBJECT, "AfroditeSymbol", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_symbol_type_id__volatile, afrodite_symbol_type_id);
	}
	return afrodite_symbol_type_id__volatile;
}


static void afrodite_symbol_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AfroditeSymbol * self;
	self = AFRODITE_SYMBOL (object);
	switch (property_id) {
		case AFRODITE_SYMBOL_PARENT:
		g_value_set_object (value, afrodite_symbol_get_parent (self));
		break;
		case AFRODITE_SYMBOL_CHILDREN:
		vala_value_set_collection_object (value, afrodite_symbol_get_children (self));
		break;
		case AFRODITE_SYMBOL_GENERIC_PARENT:
		g_value_set_object (value, afrodite_symbol_get_generic_parent (self));
		break;
		case AFRODITE_SYMBOL_NAME:
		g_value_set_string (value, afrodite_symbol_get_name (self));
		break;
		case AFRODITE_SYMBOL_FULLY_QUALIFIED_NAME:
		g_value_set_string (value, afrodite_symbol_get_fully_qualified_name (self));
		break;
		case AFRODITE_SYMBOL_RETURN_TYPE:
		afrodite_value_set_data_type (value, afrodite_symbol_get_return_type (self));
		break;
		case AFRODITE_SYMBOL_TYPE_NAME:
		g_value_set_string (value, afrodite_symbol_get_type_name (self));
		break;
		case AFRODITE_SYMBOL_SOURCE_REFERENCES:
		vala_value_set_collection_object (value, afrodite_symbol_get_source_references (self));
		break;
		case AFRODITE_SYMBOL_PARAMETERS:
		vala_value_set_collection_object (value, afrodite_symbol_get_parameters (self));
		break;
		case AFRODITE_SYMBOL_LOCAL_VARIABLES:
		vala_value_set_collection_object (value, afrodite_symbol_get_local_variables (self));
		break;
		case AFRODITE_SYMBOL_BASE_TYPES:
		vala_value_set_collection_object (value, afrodite_symbol_get_base_types (self));
		break;
		case AFRODITE_SYMBOL_GENERIC_TYPE_ARGUMENTS:
		vala_value_set_collection_object (value, afrodite_symbol_get_generic_type_arguments (self));
		break;
		case AFRODITE_SYMBOL_ACCESS:
		g_value_set_flags (value, afrodite_symbol_get_access (self));
		break;
		case AFRODITE_SYMBOL_SYMBOL_TYPE:
		afrodite_value_set_data_type (value, afrodite_symbol_get_symbol_type (self));
		break;
		case AFRODITE_SYMBOL_STATIC_CHILD_COUNT:
		g_value_set_int (value, afrodite_symbol_get_static_child_count (self));
		break;
		case AFRODITE_SYMBOL_CREATION_METHOD_CHILD_COUNT:
		g_value_set_int (value, afrodite_symbol_get_creation_method_child_count (self));
		break;
		case AFRODITE_SYMBOL_HAS_CHILDREN:
		g_value_set_boolean (value, afrodite_symbol_get_has_children (self));
		break;
		case AFRODITE_SYMBOL_HAS_RESOLVE_TARGETS:
		g_value_set_boolean (value, afrodite_symbol_get_has_resolve_targets (self));
		break;
		case AFRODITE_SYMBOL_HAS_PARAMETERS:
		g_value_set_boolean (value, afrodite_symbol_get_has_parameters (self));
		break;
		case AFRODITE_SYMBOL_HAS_GENERIC_TYPE_ARGUMENTS:
		g_value_set_boolean (value, afrodite_symbol_get_has_generic_type_arguments (self));
		break;
		case AFRODITE_SYMBOL_HAS_LOCAL_VARIABLES:
		g_value_set_boolean (value, afrodite_symbol_get_has_local_variables (self));
		break;
		case AFRODITE_SYMBOL_HAS_BASE_TYPES:
		g_value_set_boolean (value, afrodite_symbol_get_has_base_types (self));
		break;
		case AFRODITE_SYMBOL_HAS_SOURCE_REFERENCES:
		g_value_set_boolean (value, afrodite_symbol_get_has_source_references (self));
		break;
		case AFRODITE_SYMBOL_HAS_STATIC_CHILD:
		g_value_set_boolean (value, afrodite_symbol_get_has_static_child (self));
		break;
		case AFRODITE_SYMBOL_HAS_CREATION_METHOD_CHILD:
		g_value_set_boolean (value, afrodite_symbol_get_has_creation_method_child (self));
		break;
		case AFRODITE_SYMBOL_IS_STATIC:
		g_value_set_boolean (value, afrodite_symbol_get_is_static (self));
		break;
		case AFRODITE_SYMBOL_DESCRIPTION:
		g_value_set_string (value, afrodite_symbol_get_description (self));
		break;
		case AFRODITE_SYMBOL_MARKUP_DESCRIPTION:
		g_value_set_string (value, afrodite_symbol_get_markup_description (self));
		break;
		case AFRODITE_SYMBOL_INFO:
		g_value_set_string (value, afrodite_symbol_get_info (self));
		break;
		case AFRODITE_SYMBOL_DISPLAY_NAME:
		g_value_set_string (value, afrodite_symbol_get_display_name (self));
		break;
		case AFRODITE_SYMBOL_ACCESS_STRING:
		g_value_take_string (value, afrodite_symbol_get_access_string (self));
		break;
		case AFRODITE_SYMBOL_BINDING_STRING:
		g_value_take_string (value, afrodite_symbol_get_binding_string (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void afrodite_symbol_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AfroditeSymbol * self;
	self = AFRODITE_SYMBOL (object);
	switch (property_id) {
		case AFRODITE_SYMBOL_PARENT:
		afrodite_symbol_set_parent (self, g_value_get_object (value));
		break;
		case AFRODITE_SYMBOL_CHILDREN:
		afrodite_symbol_set_children (self, vala_value_get_collection_object (value));
		break;
		case AFRODITE_SYMBOL_GENERIC_PARENT:
		afrodite_symbol_set_generic_parent (self, g_value_get_object (value));
		break;
		case AFRODITE_SYMBOL_NAME:
		afrodite_symbol_set_name (self, g_value_get_string (value));
		break;
		case AFRODITE_SYMBOL_FULLY_QUALIFIED_NAME:
		afrodite_symbol_set_fully_qualified_name (self, g_value_get_string (value));
		break;
		case AFRODITE_SYMBOL_RETURN_TYPE:
		afrodite_symbol_set_return_type (self, afrodite_value_get_data_type (value));
		break;
		case AFRODITE_SYMBOL_TYPE_NAME:
		afrodite_symbol_set_type_name (self, g_value_get_string (value));
		break;
		case AFRODITE_SYMBOL_SOURCE_REFERENCES:
		afrodite_symbol_set_source_references (self, vala_value_get_collection_object (value));
		break;
		case AFRODITE_SYMBOL_PARAMETERS:
		afrodite_symbol_set_parameters (self, vala_value_get_collection_object (value));
		break;
		case AFRODITE_SYMBOL_LOCAL_VARIABLES:
		afrodite_symbol_set_local_variables (self, vala_value_get_collection_object (value));
		break;
		case AFRODITE_SYMBOL_BASE_TYPES:
		afrodite_symbol_set_base_types (self, vala_value_get_collection_object (value));
		break;
		case AFRODITE_SYMBOL_GENERIC_TYPE_ARGUMENTS:
		afrodite_symbol_set_generic_type_arguments (self, vala_value_get_collection_object (value));
		break;
		case AFRODITE_SYMBOL_ACCESS:
		afrodite_symbol_set_access (self, g_value_get_flags (value));
		break;
		case AFRODITE_SYMBOL_STATIC_CHILD_COUNT:
		afrodite_symbol_set_static_child_count (self, g_value_get_int (value));
		break;
		case AFRODITE_SYMBOL_CREATION_METHOD_CHILD_COUNT:
		afrodite_symbol_set_creation_method_child_count (self, g_value_get_int (value));
		break;
		case AFRODITE_SYMBOL_DISPLAY_NAME:
		afrodite_symbol_set_display_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




