/* valadynamicmethod.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALADYNAMICMETHOD_H__
#define __VALA_VALADYNAMICMETHOD_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <vala/valamethod.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valamethodcall.h>

G_BEGIN_DECLS


#define VALA_TYPE_DYNAMIC_METHOD (vala_dynamic_method_get_type ())
#define VALA_DYNAMIC_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod))
#define VALA_DYNAMIC_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethodClass))
#define VALA_IS_DYNAMIC_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DYNAMIC_METHOD))
#define VALA_IS_DYNAMIC_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DYNAMIC_METHOD))
#define VALA_DYNAMIC_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethodClass))

typedef struct _ValaDynamicMethod ValaDynamicMethod;
typedef struct _ValaDynamicMethodClass ValaDynamicMethodClass;
typedef struct _ValaDynamicMethodPrivate ValaDynamicMethodPrivate;

/**
 * Represents a late bound method.
 */
struct _ValaDynamicMethod {
	ValaMethod parent_instance;
	ValaDynamicMethodPrivate * priv;
};

struct _ValaDynamicMethodClass {
	ValaMethodClass parent_class;
};


ValaDynamicMethod* vala_dynamic_method_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDynamicMethod* vala_dynamic_method_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDataType* vala_dynamic_method_get_dynamic_type (ValaDynamicMethod* self);
void vala_dynamic_method_set_dynamic_type (ValaDynamicMethod* self, ValaDataType* value);
ValaMethodCall* vala_dynamic_method_get_invocation (ValaDynamicMethod* self);
void vala_dynamic_method_set_invocation (ValaDynamicMethod* self, ValaMethodCall* value);
GType vala_dynamic_method_get_type (void);


G_END_DECLS

#endif
