/* valagasyncmodule.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valagasyncmodule.h>
#include <ccode/valaccodestruct.h>
#include <vala/valasymbol.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valamember.h>
#include <vala/valatypesymbol.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valadatatype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <vala/valalocalvariable.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valamemberaccess.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodememberaccess.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodefragment.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valacodevisitor.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valastatement.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaccodemethodmodule.h>
#include <gobject/valagerrormodule.h>




static char* string_substring (const char* self, glong offset, glong len);
enum  {
	VALA_GASYNC_MODULE_DUMMY_PROPERTY
};
static ValaCCodeStruct* vala_gasync_module_generate_data_struct (ValaGAsyncModule* self, ValaMethod* m);
static ValaCCodeFunction* vala_gasync_module_generate_free_function (ValaGAsyncModule* self, ValaMethod* m);
static ValaCCodeFunction* vala_gasync_module_generate_async_function (ValaGAsyncModule* self, ValaMethod* m);
static void vala_gasync_module_append_struct (ValaGAsyncModule* self, ValaCCodeStruct* structure);
static void vala_gasync_module_append_function (ValaGAsyncModule* self, ValaCCodeFunction* function);
static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static ValaCCodeFunction* vala_gasync_module_generate_finish_function (ValaGAsyncModule* self, ValaMethod* m);
static ValaCCodeFunction* vala_gasync_module_generate_ready_function (ValaGAsyncModule* self, ValaMethod* m);
static void vala_gasync_module_append_async_virtual_function (ValaGAsyncModule* self, ValaMethod* m);
static void vala_gasync_module_append_finish_virtual_function (ValaGAsyncModule* self, ValaMethod* m);
static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt);
static ValaCCodeStatement* vala_gasync_module_real_return_with_exception (ValaGErrorModule* base, ValaCCodeExpression* error_expr);
static void vala_gasync_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt);
static gpointer vala_gasync_module_parent_class = NULL;



static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGAsyncModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGAsyncModule*) vala_gsignal_module_construct (object_type, codegen, next);
	return self;
}


ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gasync_module_construct (VALA_TYPE_GASYNC_MODULE, codegen, next);
}


static ValaCCodeStruct* vala_gasync_module_generate_data_struct (ValaGAsyncModule* self, ValaMethod* m) {
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* dataname;
	char* _tmp3;
	ValaCCodeStruct* _tmp4;
	ValaCCodeStruct* data;
	ValaCCodeStruct* _tmp12;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	dataname = (_tmp2 = g_strconcat (_tmp1 = vala_symbol_lower_case_to_camel_case (_tmp0 = vala_method_get_cname (m)), "Data", NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	_tmp4 = NULL;
	data = (_tmp4 = vala_ccode_struct_new (_tmp3 = g_strconcat ("_", dataname, NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
	vala_ccode_struct_add_field (data, "int", "state");
	vala_ccode_struct_add_field (data, "GAsyncResult*", "res");
	vala_ccode_struct_add_field (data, "GSimpleAsyncResult*", "_async_result");
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaTypeSymbol* _tmp5;
		ValaTypeSymbol* type_sym;
		char* _tmp7;
		char* _tmp6;
		_tmp5 = NULL;
		type_sym = (_tmp5 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_ccode_struct_add_field (data, _tmp7 = g_strconcat (_tmp6 = vala_typesymbol_get_cname (type_sym, FALSE), "*", NULL), "self");
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
		(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
	}
	{
		GeeList* _tmp8;
		GeeIterator* _tmp9;
		GeeIterator* _param_it;
		_tmp8 = NULL;
		_tmp9 = NULL;
		_param_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_method_get_parameters (m))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			char* _tmp10;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp10 = NULL;
			vala_ccode_struct_add_field (data, _tmp10 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)), vala_symbol_get_name ((ValaSymbol*) param));
			_tmp10 = (g_free (_tmp10), NULL);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		char* _tmp11;
		_tmp11 = NULL;
		vala_ccode_struct_add_field (data, _tmp11 = vala_data_type_get_cname (vala_method_get_return_type (m)), "result");
		_tmp11 = (g_free (_tmp11), NULL);
	}
	_tmp12 = NULL;
	return (_tmp12 = data, dataname = (g_free (dataname), NULL), _tmp12);
}


static ValaCCodeFunction* vala_gasync_module_generate_free_function (ValaGAsyncModule* self, ValaMethod* m) {
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* dataname;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeFunction* _tmp5;
	ValaCCodeFunction* freefunc;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* freeblock;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeFunctionCall* freecall;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeExpressionStatement* _tmp21;
	ValaCCodeFunction* _tmp22;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	dataname = (_tmp2 = g_strconcat (_tmp1 = vala_symbol_lower_case_to_camel_case (_tmp0 = vala_method_get_cname (m)), "Data", NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	freefunc = (_tmp5 = vala_ccode_function_new (_tmp4 = g_strconcat (_tmp3 = vala_method_get_real_cname (m), "_data_free", NULL), "void"), _tmp4 = (g_free (_tmp4), NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp5);
	vala_ccode_function_set_modifiers (freefunc, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (freefunc, _tmp6 = vala_ccode_formal_parameter_new ("_data", "gpointer"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	freeblock = vala_ccode_block_new ();
	vala_ccode_function_set_block (freefunc, freeblock);
	_tmp7 = NULL;
	_tmp8 = NULL;
	datadecl = (_tmp8 = vala_ccode_declaration_new (_tmp7 = g_strconcat (dataname, "*", NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("data", (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("_data")))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_block_add_statement (freeblock, (ValaCCodeNode*) datadecl);
	if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m))) {
		ValaLocalVariable* v;
		ValaMemberAccess* ma;
		ValaMethod* _tmp12;
		ValaMethod* _tmp11;
		ValaCCodeExpression* _tmp13;
		ValaCCodeExpression* _tmp14;
		ValaCCodeExpression* unref_expr;
		ValaCCodeExpressionStatement* _tmp15;
		ValaMethod* _tmp16;
		/* this is very evil. */
		v = vala_local_variable_new (vala_method_get_return_type (m), "result", NULL, NULL);
		ma = vala_member_access_new_simple ("result", NULL);
		vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) v);
		_tmp12 = NULL;
		_tmp11 = NULL;
		((ValaCCodeBaseModule*) self)->current_method = (_tmp12 = (_tmp11 = m, (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp12);
		_tmp13 = NULL;
		_tmp14 = NULL;
		unref_expr = (_tmp14 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, _tmp13 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "result"), vala_method_get_return_type (m), (ValaExpression*) ma), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
		_tmp15 = NULL;
		vala_ccode_block_add_statement (freeblock, (ValaCCodeNode*) (_tmp15 = vala_ccode_expression_statement_new (unref_expr)));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		_tmp16 = NULL;
		((ValaCCodeBaseModule*) self)->current_method = (_tmp16 = NULL, (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp16);
		(v == NULL) ? NULL : (v = (vala_code_node_unref (v), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		(unref_expr == NULL) ? NULL : (unref_expr = (vala_ccode_node_unref (unref_expr), NULL));
	}
	_tmp17 = NULL;
	_tmp18 = NULL;
	freecall = (_tmp18 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("g_slice_free"))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp18);
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (freecall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new (dataname)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (freecall, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("data")));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp21 = NULL;
	vala_ccode_block_add_statement (freeblock, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) freecall)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	return (_tmp22 = freefunc, dataname = (g_free (dataname), NULL), (freeblock == NULL) ? NULL : (freeblock = (vala_ccode_node_unref (freeblock), NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), (freecall == NULL) ? NULL : (freecall = (vala_ccode_node_unref (freecall), NULL)), _tmp22);
}


static ValaCCodeFunction* vala_gasync_module_generate_async_function (ValaGAsyncModule* self, ValaMethod* m) {
	ValaCCodeBlock* asyncblock;
	gboolean _tmp0;
	char* _tmp16;
	char* _tmp15;
	char* _tmp17;
	char* dataname;
	char* _tmp19;
	char* _tmp18;
	ValaCCodeFunction* _tmp20;
	ValaCCodeFunction* asyncfunc;
	GeeHashMap* cparam_map;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp23;
	char* _tmp24;
	ValaCCodeDeclaration* _tmp25;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp26;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeFunctionCall* create_result;
	ValaClass* _tmp33;
	ValaSymbol* _tmp32;
	ValaClass* cl;
	gboolean _tmp34;
	gboolean _tmp35;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeIdentifier* _tmp42;
	char* _tmp41;
	char* _tmp40;
	ValaCCodeExpressionStatement* _tmp46;
	ValaCCodeAssignment* _tmp45;
	ValaCCodeMemberAccess* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeFunctionCall* _tmp48;
	ValaCCodeFunctionCall* set_op_res_call;
	ValaCCodeMemberAccess* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeIdentifier* _tmp51;
	ValaCCodeIdentifier* _tmp54;
	char* _tmp53;
	char* _tmp52;
	ValaCCodeExpressionStatement* _tmp55;
	ValaCCodeIdentifier* _tmp70;
	char* _tmp69;
	char* _tmp68;
	ValaCCodeFunctionCall* _tmp71;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp72;
	ValaCCodeExpressionStatement* _tmp73;
	ValaCCodeFormalParameter* _tmp74;
	ValaCCodeFormalParameter* _tmp75;
	gboolean _tmp76;
	gboolean _tmp77;
	ValaCCodeFunction* _tmp78;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	asyncblock = vala_ccode_block_new ();
	_tmp0 = FALSE;
	if (vala_method_get_overrides (m)) {
		_tmp0 = TRUE;
	} else {
		gboolean _tmp1;
		gboolean _tmp2;
		_tmp1 = FALSE;
		_tmp2 = FALSE;
		if (vala_method_get_base_interface_method (m) != NULL) {
			_tmp2 = !vala_method_get_is_abstract (m);
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			_tmp1 = !vala_method_get_is_virtual (m);
		} else {
			_tmp1 = FALSE;
		}
		_tmp0 = _tmp1;
	}
	/* logic copied from valaccodemethodmodule*/
	if (_tmp0) {
		ValaMethod* base_method;
		ValaObjectType* base_expression_type;
		ValaObjectTypeSymbol* _tmp8;
		ValaSymbol* _tmp7;
		ValaObjectTypeSymbol* type_symbol;
		ValaObjectType* self_target_type;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeExpression* _tmp10;
		ValaCCodeExpression* cself;
		char* _tmp12;
		char* _tmp11;
		ValaCCodeDeclaration* _tmp13;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp14;
		base_method = NULL;
		if (vala_method_get_overrides (m)) {
			ValaMethod* _tmp4;
			ValaMethod* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			base_method = (_tmp4 = (_tmp3 = vala_method_get_base_method (m), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp4);
		} else {
			ValaMethod* _tmp6;
			ValaMethod* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			base_method = (_tmp6 = (_tmp5 = vala_method_get_base_interface_method (m), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp6);
		}
		base_expression_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method)));
		_tmp8 = NULL;
		_tmp7 = NULL;
		type_symbol = (_tmp8 = (_tmp7 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_OBJECT_TYPE_SYMBOL (_tmp7) ? ((ValaObjectTypeSymbol*) _tmp7) : NULL), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
		self_target_type = vala_object_type_new (type_symbol);
		_tmp9 = NULL;
		_tmp10 = NULL;
		cself = (_tmp10 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("base")), (ValaDataType*) base_expression_type, (ValaDataType*) self_target_type, NULL), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp13 = NULL;
		cdecl_ = (_tmp13 = vala_ccode_declaration_new (_tmp12 = g_strdup_printf ("%s *", _tmp11 = vala_typesymbol_get_cname ((ValaTypeSymbol*) type_symbol, FALSE))), _tmp12 = (g_free (_tmp12), NULL), _tmp11 = (g_free (_tmp11), NULL), _tmp13);
		_tmp14 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new ("self", cself)));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) cdecl_);
		(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
		(base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL));
		(type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL));
		(self_target_type == NULL) ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL));
		(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	}
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp17 = NULL;
	dataname = (_tmp17 = g_strconcat (_tmp16 = vala_symbol_lower_case_to_camel_case (_tmp15 = vala_method_get_cname (m)), "Data", NULL), _tmp16 = (g_free (_tmp16), NULL), _tmp15 = (g_free (_tmp15), NULL), _tmp17);
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp20 = NULL;
	asyncfunc = (_tmp20 = vala_ccode_function_new (_tmp19 = g_strconcat (_tmp18 = vala_method_get_real_cname (m), "_async", NULL), "void"), _tmp19 = (g_free (_tmp19), NULL), _tmp18 = (g_free (_tmp18), NULL), _tmp20);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp21 = NULL;
	_tmp22 = NULL;
	dataalloc = (_tmp22 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp22);
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (dataalloc, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (dataname)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp24 = NULL;
	_tmp25 = NULL;
	datadecl = (_tmp25 = vala_ccode_declaration_new (_tmp24 = g_strconcat (dataname, "*", NULL)), _tmp24 = (g_free (_tmp24), NULL), _tmp25);
	_tmp26 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp26 = vala_ccode_variable_declarator_new ("data", NULL)));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) datadecl);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) dataalloc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp30 = NULL;
	_tmp31 = NULL;
	create_result = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("g_simple_async_result_new"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
	_tmp33 = NULL;
	_tmp32 = NULL;
	cl = (_tmp33 = (_tmp32 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_CLASS (_tmp32) ? ((ValaClass*) _tmp32) : NULL), (_tmp33 == NULL) ? NULL : vala_code_node_ref (_tmp33));
	_tmp34 = FALSE;
	_tmp35 = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp35 = cl != NULL;
	} else {
		_tmp35 = FALSE;
	}
	if (_tmp35) {
		_tmp34 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp34 = FALSE;
	}
	if (_tmp34) {
		ValaCCodeIdentifier* _tmp36;
		_tmp36 = NULL;
		vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("self")));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	} else {
		ValaCCodeConstant* _tmp37;
		_tmp37 = NULL;
		vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp37 = vala_ccode_constant_new ("NULL")));
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	}
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("callback")));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("user_data")));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new (_tmp41 = g_strconcat (_tmp40 = vala_method_get_real_cname (m), "_async", NULL))));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp41 = (g_free (_tmp41), NULL);
	_tmp40 = (g_free (_tmp40), NULL);
	_tmp46 = NULL;
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp46 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp45 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new ("data")), "_async_result")), (ValaCCodeExpression*) create_result, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp47 = NULL;
	_tmp48 = NULL;
	set_op_res_call = (_tmp48 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new ("g_simple_async_result_set_op_res_gpointer"))), (_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)), _tmp48);
	_tmp50 = NULL;
	_tmp49 = NULL;
	vala_ccode_function_call_add_argument (set_op_res_call, (ValaCCodeExpression*) (_tmp50 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new ("data")), "_async_result")));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	_tmp51 = NULL;
	vala_ccode_function_call_add_argument (set_op_res_call, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("data")));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	_tmp54 = NULL;
	_tmp53 = NULL;
	_tmp52 = NULL;
	vala_ccode_function_call_add_argument (set_op_res_call, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new (_tmp53 = g_strconcat (_tmp52 = vala_method_get_real_cname (m), "_data_free", NULL))));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	_tmp53 = (g_free (_tmp53), NULL);
	_tmp52 = (g_free (_tmp52), NULL);
	_tmp55 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp55 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_op_res_call)));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpressionStatement* _tmp60;
		ValaCCodeAssignment* _tmp59;
		ValaCCodeIdentifier* _tmp58;
		ValaCCodeMemberAccess* _tmp57;
		ValaCCodeIdentifier* _tmp56;
		_tmp60 = NULL;
		_tmp59 = NULL;
		_tmp58 = NULL;
		_tmp57 = NULL;
		_tmp56 = NULL;
		vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp60 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("data")), "self")), (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("self")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
		(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
		(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
		(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	}
	{
		GeeList* _tmp61;
		GeeIterator* _tmp62;
		GeeIterator* _param_it;
		_tmp61 = NULL;
		_tmp62 = NULL;
		_param_it = (_tmp62 = gee_iterable_iterator ((GeeIterable*) (_tmp61 = vala_method_get_parameters (m))), (_tmp61 == NULL) ? NULL : (_tmp61 = (gee_collection_object_unref (_tmp61), NULL)), _tmp62);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				ValaCCodeExpressionStatement* _tmp67;
				ValaCCodeAssignment* _tmp66;
				ValaCCodeIdentifier* _tmp65;
				ValaCCodeMemberAccess* _tmp64;
				ValaCCodeIdentifier* _tmp63;
				_tmp67 = NULL;
				_tmp66 = NULL;
				_tmp65 = NULL;
				_tmp64 = NULL;
				_tmp63 = NULL;
				vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp67 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp66 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new ("data")), vala_symbol_get_name ((ValaSymbol*) param))), (ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
				(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
				(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
				(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
				(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp71 = NULL;
	ccall = (_tmp71 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new (_tmp69 = g_strconcat (_tmp68 = vala_method_get_real_cname (m), "_co", NULL)))), (_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)), _tmp69 = (g_free (_tmp69), NULL), _tmp68 = (g_free (_tmp68), NULL), _tmp71);
	_tmp72 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("data")));
	(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
	_tmp73 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp73 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	_tmp74 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp74 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	_tmp75 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp75 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, (GeeMap*) cparam_map, asyncfunc, NULL, NULL, NULL, 1);
	_tmp76 = FALSE;
	_tmp77 = FALSE;
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		_tmp77 = vala_method_get_base_method (m) == NULL;
	} else {
		_tmp77 = FALSE;
	}
	if (_tmp77) {
		_tmp76 = vala_method_get_base_interface_method (m) == NULL;
	} else {
		_tmp76 = FALSE;
	}
	if (_tmp76) {
		vala_ccode_function_set_modifiers (asyncfunc, vala_ccode_function_get_modifiers (asyncfunc) | VALA_CCODE_MODIFIERS_STATIC);
	}
	vala_ccode_function_set_block (asyncfunc, asyncblock);
	_tmp78 = NULL;
	return (_tmp78 = asyncfunc, (asyncblock == NULL) ? NULL : (asyncblock = (vala_ccode_node_unref (asyncblock), NULL)), dataname = (g_free (dataname), NULL), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (dataalloc == NULL) ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), (create_result == NULL) ? NULL : (create_result = (vala_ccode_node_unref (create_result), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (set_op_res_call == NULL) ? NULL : (set_op_res_call = (vala_ccode_node_unref (set_op_res_call), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp78);
}


static void vala_gasync_module_append_struct (ValaGAsyncModule* self, ValaCCodeStruct* structure) {
	char* _tmp0;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeVariableDeclarator* typename;
	char* _tmp2;
	ValaCCodeTypeDefinition* _tmp3;
	ValaCCodeTypeDefinition* typedef_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	typename = (_tmp1 = vala_ccode_variable_declarator_new (_tmp0 = string_substring (vala_ccode_struct_get_name (structure), (glong) 1, -1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	typedef_ = (_tmp3 = vala_ccode_type_definition_new (_tmp2 = g_strconcat ("struct ", vala_ccode_struct_get_name (structure), NULL), (ValaCCodeDeclarator*) typename), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_declaration, (ValaCCodeNode*) typedef_);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_definition, (ValaCCodeNode*) structure);
	(typename == NULL) ? NULL : (typename = (vala_ccode_node_unref (typename), NULL));
	(typedef_ == NULL) ? NULL : (typedef_ = (vala_ccode_node_unref (typedef_), NULL));
}


static void vala_gasync_module_append_function (ValaGAsyncModule* self, ValaCCodeFunction* function) {
	ValaCCodeBlock* _tmp0;
	ValaCCodeBlock* block;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	_tmp0 = NULL;
	block = (_tmp0 = vala_ccode_function_get_block (function), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	vala_ccode_function_set_block (function, NULL);
	if ((vala_ccode_function_get_modifiers (function) & VALA_CCODE_MODIFIERS_STATIC) != 0) {
		ValaCCodeFunction* _tmp1;
		_tmp1 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp1 = vala_ccode_function_copy (function)));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	} else {
		ValaCCodeFunction* _tmp2;
		_tmp2 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp2 = vala_ccode_function_copy (function)));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	}
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
}


static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaGAsyncModule * self;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (m != NULL);
	if (vala_method_get_coroutine (m)) {
		gboolean _tmp7;
		((ValaCCodeBaseModule*) self)->gio_h_needed = TRUE;
		/* append the synchronous version*/
		vala_method_set_coroutine (m, FALSE);
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
		vala_method_set_coroutine (m, TRUE);
		if (!vala_method_get_is_abstract (m)) {
			ValaCCodeStruct* data;
			ValaCCodeFunction* _tmp0;
			ValaCCodeFunction* _tmp1;
			ValaCCodeFunction* _tmp2;
			ValaCCodeFunction* _tmp3;
			ValaCCodeStruct* _tmp5;
			ValaCCodeStruct* _tmp4;
			ValaCCodeStruct* _tmp6;
			data = vala_gasync_module_generate_data_struct (self, m);
			vala_gasync_module_append_struct (self, data);
			_tmp0 = NULL;
			vala_gasync_module_append_function (self, _tmp0 = vala_gasync_module_generate_free_function (self, m));
			(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
			_tmp1 = NULL;
			vala_gasync_module_append_function (self, _tmp1 = vala_gasync_module_generate_async_function (self, m));
			(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
			_tmp2 = NULL;
			vala_gasync_module_append_function (self, _tmp2 = vala_gasync_module_generate_finish_function (self, m));
			(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
			_tmp3 = NULL;
			vala_gasync_module_append_function (self, _tmp3 = vala_gasync_module_generate_ready_function (self, m));
			(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
			/* append the _co function*/
			_tmp5 = NULL;
			_tmp4 = NULL;
			((ValaCCodeBaseModule*) self)->closure_struct = (_tmp5 = (_tmp4 = data, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4)), (((ValaCCodeBaseModule*) self)->closure_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->closure_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->closure_struct), NULL)), _tmp5);
			VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
			_tmp6 = NULL;
			((ValaCCodeBaseModule*) self)->closure_struct = (_tmp6 = NULL, (((ValaCCodeBaseModule*) self)->closure_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->closure_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->closure_struct), NULL)), _tmp6);
			(data == NULL) ? NULL : (data = (vala_ccode_node_unref (data), NULL));
		}
		_tmp7 = FALSE;
		if (vala_method_get_is_abstract (m)) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_method_get_is_virtual (m);
		}
		if (_tmp7) {
			vala_gasync_module_append_async_virtual_function (self, m);
			vala_gasync_module_append_finish_virtual_function (self, m);
		}
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
	}
}


static ValaCCodeFunction* vala_gasync_module_generate_finish_function (ValaGAsyncModule* self, ValaMethod* m) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* finishfunc;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* finishblock;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFunction* _tmp4;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	finishfunc = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strconcat (_tmp0 = vala_method_get_real_cname (m), "_finish", NULL), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	finishblock = vala_ccode_block_new ();
	_tmp3 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp3 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, (GeeMap*) cparam_map, finishfunc, NULL, NULL, NULL, 2);
	vala_ccode_function_set_block (finishfunc, finishblock);
	_tmp4 = NULL;
	return (_tmp4 = finishfunc, (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (finishblock == NULL) ? NULL : (finishblock = (vala_ccode_node_unref (finishblock), NULL)), _tmp4);
}


static ValaCCodeFunction* vala_gasync_module_generate_ready_function (ValaGAsyncModule* self, ValaMethod* m) {
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* dataname;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeFunction* _tmp5;
	ValaCCodeFunction* readyfunc;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeBlock* readyblock;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp10;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp11;
	ValaCCodeExpressionStatement* _tmp15;
	ValaCCodeAssignment* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeExpressionStatement* _tmp20;
	ValaCCodeAssignment* _tmp19;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeMemberAccess* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeIdentifier* _tmp23;
	char* _tmp22;
	char* _tmp21;
	ValaCCodeFunctionCall* _tmp24;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeExpressionStatement* _tmp26;
	ValaCCodeFunction* _tmp27;
	ValaCCodeFunction* _tmp28;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	/* generate ready callback handler*/
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	dataname = (_tmp2 = g_strconcat (_tmp1 = vala_symbol_lower_case_to_camel_case (_tmp0 = vala_method_get_cname (m)), "Data", NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	readyfunc = (_tmp5 = vala_ccode_function_new (_tmp4 = g_strconcat (_tmp3 = vala_method_get_cname (m), "_ready", NULL), "void"), _tmp4 = (g_free (_tmp4), NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp5);
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (readyfunc, _tmp6 = vala_ccode_formal_parameter_new ("source_object", "GObject*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (readyfunc, _tmp7 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp8 = NULL;
	vala_ccode_function_add_parameter (readyfunc, _tmp8 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	readyblock = vala_ccode_block_new ();
	_tmp9 = NULL;
	_tmp10 = NULL;
	datadecl = (_tmp10 = vala_ccode_declaration_new (_tmp9 = g_strconcat (dataname, "*", NULL)), _tmp9 = (g_free (_tmp9), NULL), _tmp10);
	_tmp11 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new ("data", NULL)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) datadecl);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp15 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp20 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("data")), "res")), (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("res")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp24 = NULL;
	ccall = (_tmp24 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (_tmp22 = g_strconcat (_tmp21 = vala_method_get_real_cname (m), "_co", NULL)))), (_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)), _tmp22 = (g_free (_tmp22), NULL), _tmp21 = (g_free (_tmp21), NULL), _tmp24);
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("data")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp26 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	vala_ccode_function_set_modifiers (readyfunc, vala_ccode_function_get_modifiers (readyfunc) | VALA_CCODE_MODIFIERS_STATIC);
	_tmp27 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp27 = vala_ccode_function_copy (readyfunc)));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	vala_ccode_function_set_block (readyfunc, readyblock);
	_tmp28 = NULL;
	return (_tmp28 = readyfunc, dataname = (g_free (dataname), NULL), (readyblock == NULL) ? NULL : (readyblock = (vala_ccode_node_unref (readyblock), NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp28);
}


static void vala_gasync_module_append_async_virtual_function (ValaGAsyncModule* self, ValaMethod* m) {
	GeeHashMap* cparam_map;
	GeeHashMap* carg_map;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaVoidType* _tmp4;
	ValaCCodeDeclaration* vdecl;
	char* _tmp5;
	ValaCCodeFunctionDeclarator* _tmp6;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFunction* fake;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp0 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp0 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp1 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("callback")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("user_data")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, (ValaDataType*) (_tmp4 = vala_void_type_new (NULL)), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_async", 1);
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL));
	vdecl = vala_ccode_declaration_new ("void");
	_tmp5 = NULL;
	_tmp6 = NULL;
	vdeclarator = (_tmp6 = vala_ccode_function_declarator_new (_tmp5 = g_strconcat (vala_method_get_vfunc_name (m), "_async", NULL)), _tmp5 = (g_free (_tmp5), NULL), _tmp6);
	vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
	vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
	fake = vala_ccode_function_new ("fake", "void");
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, (GeeMap*) cparam_map, fake, vdeclarator, NULL, NULL, 1);
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(fake == NULL) ? NULL : (fake = (vala_ccode_node_unref (fake), NULL));
}


static void vala_gasync_module_append_finish_virtual_function (ValaGAsyncModule* self, ValaMethod* m) {
	GeeHashMap* cparam_map;
	GeeHashMap* carg_map;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeIdentifier* _tmp1;
	char* _tmp2;
	ValaCCodeDeclaration* _tmp3;
	ValaCCodeDeclaration* vdecl;
	char* _tmp4;
	ValaCCodeFunctionDeclarator* _tmp5;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFunction* fake;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp0 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp0 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("res")));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, vala_method_get_return_type (m), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_finish", 2);
	_tmp2 = NULL;
	_tmp3 = NULL;
	vdecl = (_tmp3 = vala_ccode_declaration_new (_tmp2 = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	vdeclarator = (_tmp5 = vala_ccode_function_declarator_new (_tmp4 = g_strconcat (vala_method_get_vfunc_name (m), "_finish", NULL)), _tmp4 = (g_free (_tmp4), NULL), _tmp5);
	vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
	vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
	fake = vala_ccode_function_new ("fake", "void");
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, (GeeMap*) cparam_map, fake, vdeclarator, NULL, NULL, 2);
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(fake == NULL) ? NULL : (fake = (vala_ccode_node_unref (fake), NULL));
}


static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt) {
	ValaGAsyncModule * self;
	ValaCCodeExpressionStatement* _tmp19;
	gboolean _tmp20;
	ValaCCodeFragment* cfrag;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_yield_statement_get_yield_expression (stmt) == NULL) {
		ValaCCodeFragment* cfrag;
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* idle_call;
		ValaCCodeCastExpression* _tmp5;
		ValaCCodeIdentifier* _tmp4;
		char* _tmp3;
		char* _tmp2;
		ValaCCodeIdentifier* _tmp6;
		gint state;
		ValaCCodeExpressionStatement* _tmp7;
		ValaCCodeExpressionStatement* _tmp13;
		ValaCCodeAssignment* _tmp12;
		ValaCCodeConstant* _tmp11;
		char* _tmp10;
		ValaCCodeMemberAccess* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeReturnStatement* _tmp15;
		ValaCCodeConstant* _tmp14;
		ValaCCodeCaseStatement* _tmp18;
		ValaCCodeConstant* _tmp17;
		char* _tmp16;
		/* should be replaced by a simple return FALSE; when we have
		     void idle () yields;
		 working in the .vapi*/
		cfrag = vala_ccode_fragment_new ();
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		_tmp0 = NULL;
		_tmp1 = NULL;
		idle_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_idle_add"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = g_strconcat (_tmp2 = vala_method_get_real_cname (((ValaCCodeBaseModule*) self)->current_method), "_co", NULL))), "GSourceFunc")));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("data")));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
		_tmp7 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp7 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) idle_call)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new (_tmp10 = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		_tmp10 = (g_free (_tmp10), NULL);
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp15 = NULL;
		_tmp14 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp15 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("FALSE")))));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp18 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new (_tmp16 = g_strdup_printf ("%i", state))))));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		_tmp16 = (g_free (_tmp16), NULL);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
		(idle_call == NULL) ? NULL : (idle_call = (vala_ccode_node_unref (idle_call), NULL));
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp19 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))))));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp20 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt));
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	/* free temporary objects */
	if (gee_collection_get_size ((GeeCollection*) GEE_LIST (((ValaCCodeBaseModule*) self)->temp_vars)) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp23;
			ValaCCodeExpression* _tmp22;
			ValaCCodeIdentifier* _tmp21;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp23 = NULL;
			_tmp22 = NULL;
			_tmp21 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new (_tmp22 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static ValaCCodeStatement* vala_gasync_module_real_return_with_exception (ValaGErrorModule* base, ValaCCodeExpression* error_expr) {
	ValaGAsyncModule * self;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* set_error;
	ValaCCodeMemberAccess* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeExpressionStatement* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeFunctionCall* _tmp7;
	ValaCCodeFunctionCall* free_error;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeFragment* free_locals;
	ValaCCodeStatement* _tmp9;
	ValaCCodeStatement* _tmp10;
	self = (ValaGAsyncModule*) base;
	g_return_val_if_fail (error_expr != NULL, NULL);
	if (!vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method)) {
		return VALA_GERROR_MODULE_CLASS (vala_gasync_module_parent_class)->return_with_exception ((ValaGErrorModule*) VALA_GSIGNAL_MODULE (self), error_expr);
	}
	block = vala_ccode_block_new ();
	_tmp1 = NULL;
	_tmp2 = NULL;
	set_error = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("g_simple_async_result_set_from_error"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (set_error, (ValaCCodeExpression*) (_tmp4 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("data")), "_async_result")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	vala_ccode_function_call_add_argument (set_error, error_expr);
	_tmp5 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_error)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	_tmp7 = NULL;
	free_error = (_tmp7 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("g_error_free"))), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7);
	vala_ccode_function_call_add_argument (free_error, error_expr);
	_tmp8 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp8 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free_error)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	free_locals = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_locals, FALSE);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) free_locals);
	_tmp9 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp9 = vala_ccode_method_module_complete_async ((ValaCCodeMethodModule*) self)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	return (_tmp10 = (ValaCCodeStatement*) block, (set_error == NULL) ? NULL : (set_error = (vala_ccode_node_unref (set_error), NULL)), (free_error == NULL) ? NULL : (free_error = (vala_ccode_node_unref (free_error), NULL)), (free_locals == NULL) ? NULL : (free_locals = (vala_ccode_node_unref (free_locals), NULL)), _tmp10);
}


static void vala_gasync_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt) {
	ValaGAsyncModule * self;
	gboolean _tmp0;
	ValaCCodeBlock* result_block;
	ValaCCodeFragment* free_locals;
	ValaCCodeStatement* _tmp4;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	}
	if (_tmp0) {
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_return_statement ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), stmt);
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	result_block = vala_ccode_block_new ();
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) result_block);
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeMemberAccess* _tmp2;
		ValaCCodeMemberAccess* result_var;
		ValaCCodeAssignment* assign_result;
		ValaCCodeExpressionStatement* _tmp3;
		_tmp1 = NULL;
		_tmp2 = NULL;
		result_var = (_tmp2 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("data")), "result"), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
		assign_result = vala_ccode_assignment_new ((ValaCCodeExpression*) result_var, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp3 = NULL;
		vala_ccode_block_add_statement (result_block, (ValaCCodeNode*) (_tmp3 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign_result)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_return_statement_get_return_expression (stmt)->temp_vars);
		(result_var == NULL) ? NULL : (result_var = (vala_ccode_node_unref (result_var), NULL));
		(assign_result == NULL) ? NULL : (assign_result = (vala_ccode_node_unref (assign_result), NULL));
	}
	free_locals = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_locals, FALSE);
	vala_ccode_block_add_statement (result_block, (ValaCCodeNode*) free_locals);
	_tmp4 = NULL;
	vala_ccode_block_add_statement (result_block, (ValaCCodeNode*) (_tmp4 = vala_ccode_method_module_complete_async ((ValaCCodeMethodModule*) self)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(result_block == NULL) ? NULL : (result_block = (vala_ccode_node_unref (result_block), NULL));
	(free_locals == NULL) ? NULL : (free_locals = (vala_ccode_node_unref (free_locals), NULL));
}


static void vala_gasync_module_class_init (ValaGAsyncModuleClass * klass) {
	vala_gasync_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_gasync_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->visit_yield_statement = vala_gasync_module_real_visit_yield_statement;
	VALA_GERROR_MODULE_CLASS (klass)->return_with_exception = vala_gasync_module_real_return_with_exception;
	VALA_CCODE_MODULE_CLASS (klass)->visit_return_statement = vala_gasync_module_real_visit_return_statement;
}


static void vala_gasync_module_instance_init (ValaGAsyncModule * self) {
}


GType vala_gasync_module_get_type (void) {
	static GType vala_gasync_module_type_id = 0;
	if (vala_gasync_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGAsyncModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gasync_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGAsyncModule), 0, (GInstanceInitFunc) vala_gasync_module_instance_init, NULL };
		vala_gasync_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGAsyncModule", &g_define_type_info, 0);
	}
	return vala_gasync_module_type_id;
}




