/* dbus.c generated by valac, the Vala compiler
 * generated from dbus.vala, do not modify */

/* doclet.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <valagee.h>
#include <valadoc.h>
#include <glib/gstdio.h>

#define GTKDOC_DBUS_TYPE_PARAMETER (gtkdoc_dbus_parameter_get_type ())
#define GTKDOC_DBUS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter))
#define GTKDOC_DBUS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))
#define GTKDOC_DBUS_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))

typedef struct _GtkdocDBusParameter GtkdocDBusParameter;
typedef struct _GtkdocDBusParameterClass GtkdocDBusParameterClass;
typedef struct _GtkdocDBusParameterPrivate GtkdocDBusParameterPrivate;
typedef enum  {
	GTKDOC_DBUS_PARAMETER_DIRECTION_NONE,
	GTKDOC_DBUS_PARAMETER_DIRECTION_IN,
	GTKDOC_DBUS_PARAMETER_DIRECTION_OUT
} GtkdocDBusParameterDirection;

#define GTKDOC_DBUS_PARAMETER_TYPE_DIRECTION (gtkdoc_dbus_parameter_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocDBusParamSpecParameter GtkdocDBusParamSpecParameter;

#define GTKDOC_DBUS_TYPE_MEMBER (gtkdoc_dbus_member_get_type ())
#define GTKDOC_DBUS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember))
#define GTKDOC_DBUS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))
#define GTKDOC_DBUS_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))

typedef struct _GtkdocDBusMember GtkdocDBusMember;
typedef struct _GtkdocDBusMemberClass GtkdocDBusMemberClass;
typedef struct _GtkdocDBusMemberPrivate GtkdocDBusMemberPrivate;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;

#define GTKDOC_DBUS_TYPE_INTERFACE (gtkdoc_dbus_interface_get_type ())
#define GTKDOC_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface))
#define GTKDOC_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))
#define GTKDOC_DBUS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))

typedef struct _GtkdocDBusInterface GtkdocDBusInterface;
typedef struct _GtkdocDBusInterfaceClass GtkdocDBusInterfaceClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_gcomment_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_gcomment_unref (var), NULL)))
#define _gtkdoc_dbus_interface_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_interface_unref (var), NULL)))
#define _gtkdoc_dbus_parameter_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_parameter_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocDBusParamSpecMember GtkdocDBusParamSpecMember;
typedef struct _GtkdocDBusInterfacePrivate GtkdocDBusInterfacePrivate;

#define GTKDOC_TYPE_TEXT_WRITER (gtkdoc_text_writer_get_type ())
#define GTKDOC_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter))
#define GTKDOC_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))
#define GTKDOC_IS_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_IS_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_TEXT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))

typedef struct _GtkdocTextWriter GtkdocTextWriter;
typedef struct _GtkdocTextWriterClass GtkdocTextWriterClass;
typedef struct _GtkdocTextWriterPrivate GtkdocTextWriterPrivate;
#define _gtkdoc_text_writer_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_text_writer_unref (var), NULL)))
#define _gtkdoc_dbus_member_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_member_unref (var), NULL)))
typedef struct _GtkdocDBusParamSpecInterface GtkdocDBusParamSpecInterface;

struct _GtkdocDBusParameter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar* signature;
	GtkdocDBusParameterDirection direction;
	GtkdocDBusParameterPrivate * priv;
};

struct _GtkdocDBusParameterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusParameter *self);
};

struct _GtkdocDBusParamSpecParameter {
	GParamSpec parent_instance;
};

struct _GtkdocDBusMember {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	ValaList* parameters;
	GtkdocGComment* comment;
	GtkdocDBusInterface* iface;
	GtkdocDBusMemberPrivate * priv;
};

struct _GtkdocDBusMemberClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusMember *self);
};

struct _GtkdocDBusParamSpecMember {
	GParamSpec parent_instance;
};

struct _GtkdocDBusInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* package_name;
	gchar* name;
	gchar* purpose;
	gchar* description;
	ValaList* methods;
	ValaList* signals;
	GtkdocDBusInterfacePrivate * priv;
};

struct _GtkdocDBusInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusInterface *self);
};

struct _GtkdocTextWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* filename;
	gchar* mode;
	GtkdocTextWriterPrivate * priv;
};

struct _GtkdocTextWriterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocTextWriter *self);
};

struct _GtkdocDBusParamSpecInterface {
	GParamSpec parent_instance;
};

static gpointer gtkdoc_dbus_parameter_parent_class = NULL;
static gpointer gtkdoc_dbus_member_parent_class = NULL;
static gpointer gtkdoc_dbus_interface_parent_class = NULL;

gpointer gtkdoc_dbus_parameter_ref (gpointer instance);
void gtkdoc_dbus_parameter_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_parameter (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_parameter (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_parameter (const GValue* value);
GType gtkdoc_dbus_parameter_get_type (void) G_GNUC_CONST;
GType gtkdoc_dbus_parameter_direction_get_type (void) G_GNUC_CONST;
const gchar* gtkdoc_dbus_parameter_direction_to_string (GtkdocDBusParameterDirection self);
GtkdocDBusParameter* gtkdoc_dbus_parameter_new (const gchar* name,
                                                const gchar* signature,
                                                GtkdocDBusParameterDirection direction);
GtkdocDBusParameter* gtkdoc_dbus_parameter_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* signature,
                                                      GtkdocDBusParameterDirection direction);
gchar* gtkdoc_dbus_parameter_to_string (GtkdocDBusParameter* self);
static void gtkdoc_dbus_parameter_finalize (GtkdocDBusParameter * obj);
gpointer gtkdoc_dbus_member_ref (gpointer instance);
void gtkdoc_dbus_member_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_member (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_dbus_value_set_member (GValue* value,
                                   gpointer v_object);
void gtkdoc_dbus_value_take_member (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_dbus_value_get_member (const GValue* value);
GType gtkdoc_dbus_member_get_type (void) G_GNUC_CONST;
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
gpointer gtkdoc_dbus_interface_ref (gpointer instance);
void gtkdoc_dbus_interface_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_interface (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_interface (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_interface (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_interface (const GValue* value);
GType gtkdoc_dbus_interface_get_type (void) G_GNUC_CONST;
GtkdocDBusMember* gtkdoc_dbus_member_new (const gchar* name);
GtkdocDBusMember* gtkdoc_dbus_member_construct (GType object_type,
                                                const gchar* name);
void gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                       GtkdocDBusParameter* parameter);
gchar* gtkdoc_dbus_member_get_docbook_id (GtkdocDBusMember* self);
gchar* gtkdoc_to_docbook_id (const gchar* name);
gchar* gtkdoc_dbus_member_to_string (GtkdocDBusMember* self,
                                     gint indent,
                                     gboolean link);
gchar* gtkdoc_dbus_interface_get_docbook_id (GtkdocDBusInterface* self);
static void gtkdoc_dbus_member_finalize (GtkdocDBusMember * obj);
GtkdocDBusInterface* gtkdoc_dbus_interface_new (const gchar* package_name,
                                                const gchar* name,
                                                const gchar* purpose,
                                                const gchar* description);
GtkdocDBusInterface* gtkdoc_dbus_interface_construct (GType object_type,
                                                      const gchar* package_name,
                                                      const gchar* name,
                                                      const gchar* purpose,
                                                      const gchar* description);
void gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
void gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
gboolean gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                                      ValadocSettings* settings,
                                      ValadocErrorReporter* reporter);
gpointer gtkdoc_text_writer_ref (gpointer instance);
void gtkdoc_text_writer_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_value_set_text_writer (GValue* value,
                                   gpointer v_object);
void gtkdoc_value_take_text_writer (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_value_get_text_writer (const GValue* value);
GType gtkdoc_text_writer_get_type (void) G_GNUC_CONST;
GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename,
                                          const gchar* mode);
GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type,
                                                const gchar* filename,
                                                const gchar* mode);
gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self);
void gtkdoc_text_writer_write_line (GtkdocTextWriter* self,
                                    const gchar* line);
gchar* gtkdoc_dbus_interface_to_string (GtkdocDBusInterface* self,
                                        ValadocErrorReporter* reporter);
void gtkdoc_text_writer_close (GtkdocTextWriter* self);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
static void gtkdoc_dbus_interface_finalize (GtkdocDBusInterface * obj);

const gchar*
gtkdoc_dbus_parameter_direction_to_string (GtkdocDBusParameterDirection self)
{
	const gchar* result = NULL;
	switch (self) {
		case GTKDOC_DBUS_PARAMETER_DIRECTION_NONE:
		{
			result = "";
			return result;
		}
		case GTKDOC_DBUS_PARAMETER_DIRECTION_IN:
		{
			result = "in";
			return result;
		}
		case GTKDOC_DBUS_PARAMETER_DIRECTION_OUT:
		{
			result = "out";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
gtkdoc_dbus_parameter_direction_get_type (void)
{
	static volatile gsize gtkdoc_dbus_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_parameter_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{GTKDOC_DBUS_PARAMETER_DIRECTION_NONE, "GTKDOC_DBUS_PARAMETER_DIRECTION_NONE", "none"}, {GTKDOC_DBUS_PARAMETER_DIRECTION_IN, "GTKDOC_DBUS_PARAMETER_DIRECTION_IN", "in"}, {GTKDOC_DBUS_PARAMETER_DIRECTION_OUT, "GTKDOC_DBUS_PARAMETER_DIRECTION_OUT", "out"}, {0, NULL, NULL}};
		GType gtkdoc_dbus_parameter_direction_type_id;
		gtkdoc_dbus_parameter_direction_type_id = g_enum_register_static ("GtkdocDBusParameterDirection", values);
		g_once_init_leave (&gtkdoc_dbus_parameter_direction_type_id__volatile, gtkdoc_dbus_parameter_direction_type_id);
	}
	return gtkdoc_dbus_parameter_direction_type_id__volatile;
}

GtkdocDBusParameter*
gtkdoc_dbus_parameter_construct (GType object_type,
                                 const gchar* name,
                                 const gchar* signature,
                                 GtkdocDBusParameterDirection direction)
{
	GtkdocDBusParameter* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	self = (GtkdocDBusParameter*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (signature);
	_g_free0 (self->signature);
	self->signature = _tmp1_;
	self->direction = direction;
	return self;
}

GtkdocDBusParameter*
gtkdoc_dbus_parameter_new (const gchar* name,
                           const gchar* signature,
                           GtkdocDBusParameterDirection direction)
{
	return gtkdoc_dbus_parameter_construct (GTKDOC_DBUS_TYPE_PARAMETER, name, signature, direction);
}

gchar*
gtkdoc_dbus_parameter_to_string (GtkdocDBusParameter* self)
{
	gchar* result = NULL;
	GtkdocDBusParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->direction;
	if (_tmp0_ == GTKDOC_DBUS_PARAMETER_DIRECTION_NONE) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->signature;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup_printf ("<parameter><type>'%s'</type> %s</parameter>", _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		GtkdocDBusParameterDirection _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = self->direction;
		_tmp5_ = gtkdoc_dbus_parameter_direction_to_string (_tmp4_);
		_tmp6_ = self->signature;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("<parameter>%s <type>'%s'</type> %s</parameter>", _tmp5_, _tmp6_, _tmp7_);
		result = _tmp8_;
		return result;
	}
}

static void
gtkdoc_dbus_value_parameter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_dbus_value_parameter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_parameter_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_dbus_value_parameter_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_parameter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_dbus_value_parameter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_dbus_value_parameter_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusParameter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_parameter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_dbus_value_parameter_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GtkdocDBusParameter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_parameter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GtkdocDBusParamSpecParameter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_PARAMETER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_dbus_value_get_parameter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_dbus_value_set_parameter (GValue* value,
                                 gpointer v_object)
{
	GtkdocDBusParameter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_PARAMETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_parameter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_parameter_unref (old);
	}
}

void
gtkdoc_dbus_value_take_parameter (GValue* value,
                                  gpointer v_object)
{
	GtkdocDBusParameter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_PARAMETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_parameter_unref (old);
	}
}

static void
gtkdoc_dbus_parameter_class_init (GtkdocDBusParameterClass * klass,
                                  gpointer klass_data)
{
	gtkdoc_dbus_parameter_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusParameterClass *) klass)->finalize = gtkdoc_dbus_parameter_finalize;
}

static void
gtkdoc_dbus_parameter_instance_init (GtkdocDBusParameter * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
gtkdoc_dbus_parameter_finalize (GtkdocDBusParameter * obj)
{
	GtkdocDBusParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->signature);
}

GType
gtkdoc_dbus_parameter_get_type (void)
{
	static volatile gsize gtkdoc_dbus_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_parameter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_parameter_init, gtkdoc_dbus_value_parameter_free_value, gtkdoc_dbus_value_parameter_copy_value, gtkdoc_dbus_value_parameter_peek_pointer, "p", gtkdoc_dbus_value_parameter_collect_value, "p", gtkdoc_dbus_value_parameter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusParameter), 0, (GInstanceInitFunc) gtkdoc_dbus_parameter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_dbus_parameter_type_id;
		gtkdoc_dbus_parameter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusParameter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_dbus_parameter_type_id__volatile, gtkdoc_dbus_parameter_type_id);
	}
	return gtkdoc_dbus_parameter_type_id__volatile;
}

gpointer
gtkdoc_dbus_parameter_ref (gpointer instance)
{
	GtkdocDBusParameter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_dbus_parameter_unref (gpointer instance)
{
	GtkdocDBusParameter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_PARAMETER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GtkdocDBusMember*
gtkdoc_dbus_member_construct (GType object_type,
                              const gchar* name)
{
	GtkdocDBusMember* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocDBusMember*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

GtkdocDBusMember*
gtkdoc_dbus_member_new (const gchar* name)
{
	return gtkdoc_dbus_member_construct (GTKDOC_DBUS_TYPE_MEMBER, name);
}

void
gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                  GtkdocDBusParameter* parameter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	_tmp0_ = self->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, parameter);
}

gchar*
gtkdoc_dbus_member_get_docbook_id (GtkdocDBusMember* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = gtkdoc_to_docbook_id (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
gtkdoc_dbus_member_to_string (GtkdocDBusMember* self,
                              gint indent,
                              gboolean link)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	ValaList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GString* _tmp44_;
	GString* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (link) {
		GString* _tmp1_;
		GtkdocDBusInterface* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = builder;
		_tmp2_ = self->iface;
		_tmp3_ = gtkdoc_dbus_interface_get_docbook_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtkdoc_dbus_member_get_docbook_id (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = self->name;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strnfill ((gsize) (indent - _tmp10_), ' ');
		_tmp12_ = _tmp11_;
		g_string_append_printf (_tmp1_, "\n<link linkend=\"%s-%s\">%s</link>%s(", _tmp4_, _tmp6_, _tmp7_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		GString* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = builder;
		_tmp14_ = self->name;
		_tmp15_ = self->name;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strnfill ((gsize) (indent - _tmp17_), ' ');
		_tmp19_ = _tmp18_;
		g_string_append_printf (_tmp13_, "\n%s%s(", _tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->parameters;
	_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		GString* _tmp23_;
		ValaList* _tmp24_;
		gpointer _tmp25_;
		GtkdocDBusParameter* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = builder;
		_tmp24_ = self->parameters;
		_tmp25_ = vala_list_get (_tmp24_, 0);
		_tmp26_ = (GtkdocDBusParameter*) _tmp25_;
		_tmp27_ = gtkdoc_dbus_parameter_to_string (_tmp26_);
		_tmp28_ = _tmp27_;
		g_string_append (_tmp23_, _tmp28_);
		_g_free0 (_tmp28_);
		_gtkdoc_dbus_parameter_unref0 (_tmp26_);
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				ValaList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				GString* _tmp34_;
				GString* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GString* _tmp38_;
				ValaList* _tmp39_;
				gpointer _tmp40_;
				GtkdocDBusParameter* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = self->parameters;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				if (!(i < _tmp33_)) {
					break;
				}
				_tmp34_ = builder;
				g_string_append (_tmp34_, ",\n");
				_tmp35_ = builder;
				_tmp36_ = g_strnfill ((gsize) (indent + 1), ' ');
				_tmp37_ = _tmp36_;
				g_string_append (_tmp35_, _tmp37_);
				_g_free0 (_tmp37_);
				_tmp38_ = builder;
				_tmp39_ = self->parameters;
				_tmp40_ = vala_list_get (_tmp39_, i);
				_tmp41_ = (GtkdocDBusParameter*) _tmp40_;
				_tmp42_ = gtkdoc_dbus_parameter_to_string (_tmp41_);
				_tmp43_ = _tmp42_;
				g_string_append (_tmp38_, _tmp43_);
				_g_free0 (_tmp43_);
				_gtkdoc_dbus_parameter_unref0 (_tmp41_);
			}
		}
	}
	_tmp44_ = builder;
	g_string_append_c (_tmp44_, ')');
	_tmp45_ = builder;
	_tmp46_ = _tmp45_->str;
	_tmp47_ = g_strdup (_tmp46_);
	result = _tmp47_;
	_g_string_free0 (builder);
	return result;
}

static void
gtkdoc_dbus_value_member_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_dbus_value_member_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_member_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_dbus_value_member_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_member_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_dbus_value_member_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_dbus_value_member_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusMember * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_member_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_dbus_value_member_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GtkdocDBusMember ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_member_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_dbus_param_spec_member (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GtkdocDBusParamSpecMember* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_MEMBER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_dbus_value_get_member (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_dbus_value_set_member (GValue* value,
                              gpointer v_object)
{
	GtkdocDBusMember * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_MEMBER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_member_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_member_unref (old);
	}
}

void
gtkdoc_dbus_value_take_member (GValue* value,
                               gpointer v_object)
{
	GtkdocDBusMember * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_MEMBER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_member_unref (old);
	}
}

static void
gtkdoc_dbus_member_class_init (GtkdocDBusMemberClass * klass,
                               gpointer klass_data)
{
	gtkdoc_dbus_member_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusMemberClass *) klass)->finalize = gtkdoc_dbus_member_finalize;
}

static void
gtkdoc_dbus_member_instance_init (GtkdocDBusMember * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_PARAMETER, (GBoxedCopyFunc) gtkdoc_dbus_parameter_ref, (GDestroyNotify) gtkdoc_dbus_parameter_unref, _tmp0_);
	self->parameters = (ValaList*) _tmp1_;
	self->ref_count = 1;
}

static void
gtkdoc_dbus_member_finalize (GtkdocDBusMember * obj)
{
	GtkdocDBusMember * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_vala_iterable_unref0 (self->parameters);
	_gtkdoc_gcomment_unref0 (self->comment);
	_gtkdoc_dbus_interface_unref0 (self->iface);
}

GType
gtkdoc_dbus_member_get_type (void)
{
	static volatile gsize gtkdoc_dbus_member_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_member_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_member_init, gtkdoc_dbus_value_member_free_value, gtkdoc_dbus_value_member_copy_value, gtkdoc_dbus_value_member_peek_pointer, "p", gtkdoc_dbus_value_member_collect_value, "p", gtkdoc_dbus_value_member_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusMemberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_member_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusMember), 0, (GInstanceInitFunc) gtkdoc_dbus_member_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_dbus_member_type_id;
		gtkdoc_dbus_member_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusMember", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_dbus_member_type_id__volatile, gtkdoc_dbus_member_type_id);
	}
	return gtkdoc_dbus_member_type_id__volatile;
}

gpointer
gtkdoc_dbus_member_ref (gpointer instance)
{
	GtkdocDBusMember * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_dbus_member_unref (gpointer instance)
{
	GtkdocDBusMember * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_MEMBER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GtkdocDBusInterface*
gtkdoc_dbus_interface_construct (GType object_type,
                                 const gchar* package_name,
                                 const gchar* name,
                                 const gchar* purpose,
                                 const gchar* description)
{
	GtkdocDBusInterface* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (package_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (purpose != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (GtkdocDBusInterface*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (package_name);
	_g_free0 (self->package_name);
	self->package_name = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = g_strdup (purpose);
	_g_free0 (self->purpose);
	self->purpose = _tmp2_;
	_tmp3_ = g_strdup (description);
	_g_free0 (self->description);
	self->description = _tmp3_;
	return self;
}

GtkdocDBusInterface*
gtkdoc_dbus_interface_new (const gchar* package_name,
                           const gchar* name,
                           const gchar* purpose,
                           const gchar* description)
{
	return gtkdoc_dbus_interface_construct (GTKDOC_DBUS_TYPE_INTERFACE, package_name, name, purpose, description);
}

static gpointer
_gtkdoc_dbus_interface_ref0 (gpointer self)
{
	return self ? gtkdoc_dbus_interface_ref (self) : NULL;
}

void
gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                  GtkdocDBusMember* member)
{
	GtkdocDBusInterface* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (member != NULL);
	_tmp0_ = _gtkdoc_dbus_interface_ref0 (self);
	_gtkdoc_dbus_interface_unref0 (member->iface);
	member->iface = _tmp0_;
	_tmp1_ = self->methods;
	vala_collection_add ((ValaCollection*) _tmp1_, member);
}

void
gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                  GtkdocDBusMember* member)
{
	GtkdocDBusInterface* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (member != NULL);
	_tmp0_ = _gtkdoc_dbus_interface_ref0 (self);
	_gtkdoc_dbus_interface_unref0 (member->iface);
	member->iface = _tmp0_;
	_tmp1_ = self->signals;
	vala_collection_add ((ValaCollection*) _tmp1_, member);
}

gchar*
gtkdoc_dbus_interface_get_docbook_id (GtkdocDBusInterface* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = gtkdoc_to_docbook_id (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                             ValadocSettings* settings,
                             ValadocErrorReporter* reporter)
{
	gboolean result = FALSE;
	gchar* xml_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* xml_file = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkdocTextWriter* writer = NULL;
	const gchar* _tmp11_;
	GtkdocTextWriter* _tmp12_;
	GtkdocTextWriter* _tmp13_;
	GtkdocTextWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkdocTextWriter* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = settings->path;
	_tmp1_ = g_build_filename (_tmp0_, "xml", NULL);
	xml_dir = _tmp1_;
	_tmp2_ = xml_dir;
	g_mkdir_with_parents (_tmp2_, 0777);
	_tmp3_ = xml_dir;
	_tmp4_ = self->name;
	_tmp5_ = gtkdoc_to_docbook_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s.xml", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp3_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	xml_file = _tmp10_;
	_tmp11_ = xml_file;
	_tmp12_ = gtkdoc_text_writer_new (_tmp11_, "w");
	writer = _tmp12_;
	_tmp13_ = writer;
	if (!gtkdoc_text_writer_open (_tmp13_)) {
		GtkdocTextWriter* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = writer;
		_tmp15_ = _tmp14_->filename;
		valadoc_error_reporter_simple_error (reporter, "GtkDoc", "unable to open '%s' for writing", _tmp15_);
		result = FALSE;
		_gtkdoc_text_writer_unref0 (writer);
		_g_free0 (xml_file);
		_g_free0 (xml_dir);
		return result;
	}
	_tmp16_ = writer;
	_tmp17_ = gtkdoc_dbus_interface_to_string (self, reporter);
	_tmp18_ = _tmp17_;
	gtkdoc_text_writer_write_line (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = writer;
	gtkdoc_text_writer_close (_tmp19_);
	result = TRUE;
	_gtkdoc_text_writer_unref0 (writer);
	_g_free0 (xml_file);
	_g_free0 (xml_dir);
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

gchar*
gtkdoc_dbus_interface_to_string (GtkdocDBusInterface* self,
                                 ValadocErrorReporter* reporter)
{
	gchar* result = NULL;
	gint method_indent = 0;
	gint signal_indent = 0;
	GString* builder = NULL;
	GString* _tmp22_;
	gchar* docbook_id = NULL;
	gchar* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	ValaList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	ValaList* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	GString* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	ValaList* _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	ValaList* _tmp102_;
	gint _tmp103_;
	gint _tmp104_;
	GString* _tmp132_;
	GString* _tmp133_;
	const gchar* _tmp134_;
	gchar* _tmp135_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	method_indent = 0;
	{
		ValaList* _method_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _method_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _method_index = 0;
		_tmp0_ = self->methods;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_method_list = _tmp1_;
		_tmp2_ = _method_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_method_size = _tmp4_;
		_method_index = -1;
		while (TRUE) {
			GtkdocDBusMember* method = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			GtkdocDBusMember* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_method_index = _method_index + 1;
			if (!(_method_index < _method_size)) {
				break;
			}
			_tmp5_ = _method_list;
			_tmp6_ = vala_list_get (_tmp5_, _method_index);
			method = (GtkdocDBusMember*) _tmp6_;
			_tmp7_ = method;
			_tmp8_ = _tmp7_->name;
			_tmp9_ = strlen (_tmp8_);
			_tmp10_ = _tmp9_;
			method_indent = MAX (method_indent, (gint) _tmp10_);
			_gtkdoc_dbus_member_unref0 (method);
		}
		_vala_iterable_unref0 (_method_list);
	}
	method_indent = method_indent + 5;
	signal_indent = 0;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _sig_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _sig_index = 0;
		_tmp11_ = self->signals;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_sig_list = _tmp12_;
		_tmp13_ = _sig_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_sig_size = _tmp15_;
		_sig_index = -1;
		while (TRUE) {
			GtkdocDBusMember* sig = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GtkdocDBusMember* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp16_ = _sig_list;
			_tmp17_ = vala_list_get (_tmp16_, _sig_index);
			sig = (GtkdocDBusMember*) _tmp17_;
			_tmp18_ = sig;
			_tmp19_ = _tmp18_->name;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			signal_indent = MAX (signal_indent, (gint) _tmp21_);
			_gtkdoc_dbus_member_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	signal_indent = signal_indent + 5;
	_tmp22_ = g_string_new ("");
	builder = _tmp22_;
	_tmp23_ = gtkdoc_dbus_interface_get_docbook_id (self);
	docbook_id = _tmp23_;
	_tmp24_ = builder;
	g_string_append (_tmp24_, "<?xml version=\"1.0\"?><!DOCTYPE refentry PUBLIC \"-//OASIS//DTD DocBo" \
"ok XML V4.3//EN\" \"http://www.oasis-open.org/docbook/xml/4.3/docbookx" \
".dtd\"");
	_tmp26_ = self->purpose;
	_tmp25_ = _tmp26_;
	if (_tmp25_ == NULL) {
		_tmp25_ = "";
	}
	_tmp27_ = builder;
	_tmp28_ = docbook_id;
	_tmp29_ = docbook_id;
	_tmp30_ = self->name;
	_tmp31_ = self->package_name;
	_tmp32_ = g_utf8_strup (_tmp31_, (gssize) -1);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->name;
	g_string_append_printf (_tmp27_, "\n" \
"[<!ENTITY %% local.common.attrib \"xmlns:xi  CDATA  #FIXED 'http://www" \
".w3.org/2003/XInclude'\">]>\n" \
"<refentry id=\"docs-%s\">\n" \
"<refmeta>\n" \
"<refentrytitle role=\"top_of_page\" id=\"docs-%s.top_of_page\">%s</ref" \
"entrytitle>\n" \
"<manvolnum>3</manvolnum>\n" \
"<refmiscinfo>\n" \
"%s D-Bus API\n" \
"</refmiscinfo>\n" \
"</refmeta>\n" \
"<refnamediv>\n" \
"<refname>%s</refname>\n" \
"<refpurpose>%s</refpurpose>\n" \
"</refnamediv>", _tmp28_, _tmp29_, _tmp30_, _tmp33_, _tmp34_, _tmp25_);
	_g_free0 (_tmp33_);
	_tmp35_ = self->methods;
	_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ > 0) {
		GString* _tmp38_;
		const gchar* _tmp39_;
		GString* _tmp51_;
		_tmp38_ = builder;
		_tmp39_ = docbook_id;
		g_string_append_printf (_tmp38_, "\n" \
"<refsynopsisdiv id=\"docs-%s.synopsis\" role=\"synopsis\">\n" \
"<title role=\"synopsis.title\">Methods</title>\n" \
"<synopsis>", _tmp39_);
		{
			ValaList* _method_list = NULL;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			gint _method_size = 0;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _method_index = 0;
			_tmp40_ = self->methods;
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_method_list = _tmp41_;
			_tmp42_ = _method_list;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			_method_size = _tmp44_;
			_method_index = -1;
			while (TRUE) {
				GtkdocDBusMember* method = NULL;
				ValaList* _tmp45_;
				gpointer _tmp46_;
				GString* _tmp47_;
				GtkdocDBusMember* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_method_index = _method_index + 1;
				if (!(_method_index < _method_size)) {
					break;
				}
				_tmp45_ = _method_list;
				_tmp46_ = vala_list_get (_tmp45_, _method_index);
				method = (GtkdocDBusMember*) _tmp46_;
				_tmp47_ = builder;
				_tmp48_ = method;
				_tmp49_ = gtkdoc_dbus_member_to_string (_tmp48_, method_indent, TRUE);
				_tmp50_ = _tmp49_;
				g_string_append (_tmp47_, _tmp50_);
				_g_free0 (_tmp50_);
				_gtkdoc_dbus_member_unref0 (method);
			}
			_vala_iterable_unref0 (_method_list);
		}
		_tmp51_ = builder;
		g_string_append (_tmp51_, "</synopsis></refsynopsisdiv>");
	}
	_tmp52_ = self->signals;
	_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
	_tmp54_ = _tmp53_;
	if (_tmp54_ > 0) {
		GString* _tmp55_;
		const gchar* _tmp56_;
		GString* _tmp68_;
		_tmp55_ = builder;
		_tmp56_ = docbook_id;
		g_string_append_printf (_tmp55_, "\n" \
"<refsynopsisdiv id=\"docs-%s.signals\" role=\"signal_proto\">\n" \
"<title role=\"signal_proto.title\">Signals</title>\n" \
"<synopsis>", _tmp56_);
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp57_;
			ValaList* _tmp58_;
			gint _sig_size = 0;
			ValaList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _sig_index = 0;
			_tmp57_ = self->signals;
			_tmp58_ = _vala_iterable_ref0 (_tmp57_);
			_sig_list = _tmp58_;
			_tmp59_ = _sig_list;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_sig_size = _tmp61_;
			_sig_index = -1;
			while (TRUE) {
				GtkdocDBusMember* sig = NULL;
				ValaList* _tmp62_;
				gpointer _tmp63_;
				GString* _tmp64_;
				GtkdocDBusMember* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp62_ = _sig_list;
				_tmp63_ = vala_list_get (_tmp62_, _sig_index);
				sig = (GtkdocDBusMember*) _tmp63_;
				_tmp64_ = builder;
				_tmp65_ = sig;
				_tmp66_ = gtkdoc_dbus_member_to_string (_tmp65_, signal_indent, TRUE);
				_tmp67_ = _tmp66_;
				g_string_append (_tmp64_, _tmp67_);
				_g_free0 (_tmp67_);
				_gtkdoc_dbus_member_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp68_ = builder;
		g_string_append (_tmp68_, "</synopsis></refsynopsisdiv>");
	}
	_tmp69_ = builder;
	_tmp70_ = docbook_id;
	_tmp71_ = self->description;
	g_string_append_printf (_tmp69_, "\n" \
"<refsect1 id=\"docs-%s.description\" role=\"desc\">\n" \
"<title role=\"desc.title\">Description</title>\n" \
"%s\n" \
"</refsect1>", _tmp70_, _tmp71_);
	_tmp72_ = self->methods;
	_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
	_tmp74_ = _tmp73_;
	if (_tmp74_ > 0) {
		GString* _tmp75_;
		const gchar* _tmp76_;
		GString* _tmp101_;
		_tmp75_ = builder;
		_tmp76_ = docbook_id;
		g_string_append_printf (_tmp75_, "\n" \
"<refsect1 id=\"docs-%s.details\" role=\"details\">\n" \
"<title role=\"details.title\">Details</title>", _tmp76_);
		{
			ValaList* _method_list = NULL;
			ValaList* _tmp77_;
			ValaList* _tmp78_;
			gint _method_size = 0;
			ValaList* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			gint _method_index = 0;
			_tmp77_ = self->methods;
			_tmp78_ = _vala_iterable_ref0 (_tmp77_);
			_method_list = _tmp78_;
			_tmp79_ = _method_list;
			_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
			_tmp81_ = _tmp80_;
			_method_size = _tmp81_;
			_method_index = -1;
			while (TRUE) {
				GtkdocDBusMember* method = NULL;
				ValaList* _tmp82_;
				gpointer _tmp83_;
				gchar* _tmp84_ = NULL;
				GtkdocDBusMember* _tmp85_;
				GtkdocGComment* _tmp86_;
				GString* _tmp91_;
				const gchar* _tmp92_;
				GtkdocDBusMember* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				GtkdocDBusMember* _tmp96_;
				const gchar* _tmp97_;
				GtkdocDBusMember* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				_method_index = _method_index + 1;
				if (!(_method_index < _method_size)) {
					break;
				}
				_tmp82_ = _method_list;
				_tmp83_ = vala_list_get (_tmp82_, _method_index);
				method = (GtkdocDBusMember*) _tmp83_;
				_tmp85_ = method;
				_tmp86_ = _tmp85_->comment;
				if (_tmp86_ != NULL) {
					GtkdocDBusMember* _tmp87_;
					GtkdocGComment* _tmp88_;
					gchar* _tmp89_;
					_tmp87_ = method;
					_tmp88_ = _tmp87_->comment;
					_tmp89_ = gtkdoc_gcomment_to_docbook (_tmp88_, reporter);
					_g_free0 (_tmp84_);
					_tmp84_ = _tmp89_;
				} else {
					gchar* _tmp90_;
					_tmp90_ = g_strdup ("");
					_g_free0 (_tmp84_);
					_tmp84_ = _tmp90_;
				}
				_tmp91_ = builder;
				_tmp92_ = docbook_id;
				_tmp93_ = method;
				_tmp94_ = gtkdoc_dbus_member_get_docbook_id (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = method;
				_tmp97_ = _tmp96_->name;
				_tmp98_ = method;
				_tmp99_ = gtkdoc_dbus_member_to_string (_tmp98_, method_indent, FALSE);
				_tmp100_ = _tmp99_;
				g_string_append_printf (_tmp91_, "\n" \
"<refsect2 id=\"%s-%s\" role=\"function\">\n" \
"<title>%s ()</title>\n" \
"<programlisting>%s\n" \
"</programlisting>\n" \
"%s\n" \
"</refsect2>", _tmp92_, _tmp95_, _tmp97_, _tmp100_, _tmp84_);
				_g_free0 (_tmp100_);
				_g_free0 (_tmp95_);
				_g_free0 (_tmp84_);
				_gtkdoc_dbus_member_unref0 (method);
			}
			_vala_iterable_unref0 (_method_list);
		}
		_tmp101_ = builder;
		g_string_append (_tmp101_, "</refsect1>");
	}
	_tmp102_ = self->signals;
	_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
	_tmp104_ = _tmp103_;
	if (_tmp104_ > 0) {
		GString* _tmp105_;
		const gchar* _tmp106_;
		GString* _tmp131_;
		_tmp105_ = builder;
		_tmp106_ = docbook_id;
		g_string_append_printf (_tmp105_, "\n" \
"<refsect1 id=\"docs-%s.signal-details\" role=\"signals\">\n" \
"<title role=\"signals.title\">Signal Details</title>", _tmp106_);
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp107_;
			ValaList* _tmp108_;
			gint _sig_size = 0;
			ValaList* _tmp109_;
			gint _tmp110_;
			gint _tmp111_;
			gint _sig_index = 0;
			_tmp107_ = self->signals;
			_tmp108_ = _vala_iterable_ref0 (_tmp107_);
			_sig_list = _tmp108_;
			_tmp109_ = _sig_list;
			_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
			_tmp111_ = _tmp110_;
			_sig_size = _tmp111_;
			_sig_index = -1;
			while (TRUE) {
				GtkdocDBusMember* sig = NULL;
				ValaList* _tmp112_;
				gpointer _tmp113_;
				gchar* _tmp114_ = NULL;
				GtkdocDBusMember* _tmp115_;
				GtkdocGComment* _tmp116_;
				GString* _tmp121_;
				const gchar* _tmp122_;
				GtkdocDBusMember* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_;
				GtkdocDBusMember* _tmp126_;
				const gchar* _tmp127_;
				GtkdocDBusMember* _tmp128_;
				gchar* _tmp129_;
				gchar* _tmp130_;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp112_ = _sig_list;
				_tmp113_ = vala_list_get (_tmp112_, _sig_index);
				sig = (GtkdocDBusMember*) _tmp113_;
				_tmp115_ = sig;
				_tmp116_ = _tmp115_->comment;
				if (_tmp116_ != NULL) {
					GtkdocDBusMember* _tmp117_;
					GtkdocGComment* _tmp118_;
					gchar* _tmp119_;
					_tmp117_ = sig;
					_tmp118_ = _tmp117_->comment;
					_tmp119_ = gtkdoc_gcomment_to_docbook (_tmp118_, reporter);
					_g_free0 (_tmp114_);
					_tmp114_ = _tmp119_;
				} else {
					gchar* _tmp120_;
					_tmp120_ = g_strdup ("");
					_g_free0 (_tmp114_);
					_tmp114_ = _tmp120_;
				}
				_tmp121_ = builder;
				_tmp122_ = docbook_id;
				_tmp123_ = sig;
				_tmp124_ = gtkdoc_dbus_member_get_docbook_id (_tmp123_);
				_tmp125_ = _tmp124_;
				_tmp126_ = sig;
				_tmp127_ = _tmp126_->name;
				_tmp128_ = sig;
				_tmp129_ = gtkdoc_dbus_member_to_string (_tmp128_, signal_indent, FALSE);
				_tmp130_ = _tmp129_;
				g_string_append_printf (_tmp121_, "\n" \
"<refsect2 id=\"%s-%s\" role=\"signal\">\n" \
"<title>The <literal>%s</literal> signal</title>\n" \
"<programlisting>%s\n" \
"</programlisting>\n" \
"%s\n" \
"</refsect2>", _tmp122_, _tmp125_, _tmp127_, _tmp130_, _tmp114_);
				_g_free0 (_tmp130_);
				_g_free0 (_tmp125_);
				_g_free0 (_tmp114_);
				_gtkdoc_dbus_member_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp131_ = builder;
		g_string_append (_tmp131_, "</refsect1>");
	}
	_tmp132_ = builder;
	g_string_append (_tmp132_, "</refentry>");
	_tmp133_ = builder;
	_tmp134_ = _tmp133_->str;
	_tmp135_ = g_strdup (_tmp134_);
	result = _tmp135_;
	_g_free0 (docbook_id);
	_g_string_free0 (builder);
	return result;
}

static void
gtkdoc_dbus_value_interface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_dbus_value_interface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_interface_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_dbus_value_interface_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_interface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_dbus_value_interface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_dbus_value_interface_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusInterface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_interface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_dbus_value_interface_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GtkdocDBusInterface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_interface_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_dbus_param_spec_interface (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GtkdocDBusParamSpecInterface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_INTERFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_dbus_value_get_interface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_dbus_value_set_interface (GValue* value,
                                 gpointer v_object)
{
	GtkdocDBusInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_interface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_interface_unref (old);
	}
}

void
gtkdoc_dbus_value_take_interface (GValue* value,
                                  gpointer v_object)
{
	GtkdocDBusInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_interface_unref (old);
	}
}

static void
gtkdoc_dbus_interface_class_init (GtkdocDBusInterfaceClass * klass,
                                  gpointer klass_data)
{
	gtkdoc_dbus_interface_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusInterfaceClass *) klass)->finalize = gtkdoc_dbus_interface_finalize;
}

static void
gtkdoc_dbus_interface_instance_init (GtkdocDBusInterface * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_MEMBER, (GBoxedCopyFunc) gtkdoc_dbus_member_ref, (GDestroyNotify) gtkdoc_dbus_member_unref, _tmp0_);
	self->methods = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_DBUS_TYPE_MEMBER, (GBoxedCopyFunc) gtkdoc_dbus_member_ref, (GDestroyNotify) gtkdoc_dbus_member_unref, _tmp2_);
	self->signals = (ValaList*) _tmp3_;
	self->ref_count = 1;
}

static void
gtkdoc_dbus_interface_finalize (GtkdocDBusInterface * obj)
{
	GtkdocDBusInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface);
	g_signal_handlers_destroy (self);
	_g_free0 (self->package_name);
	_g_free0 (self->name);
	_g_free0 (self->purpose);
	_g_free0 (self->description);
	_vala_iterable_unref0 (self->methods);
	_vala_iterable_unref0 (self->signals);
}

GType
gtkdoc_dbus_interface_get_type (void)
{
	static volatile gsize gtkdoc_dbus_interface_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_interface_init, gtkdoc_dbus_value_interface_free_value, gtkdoc_dbus_value_interface_copy_value, gtkdoc_dbus_value_interface_peek_pointer, "p", gtkdoc_dbus_value_interface_collect_value, "p", gtkdoc_dbus_value_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusInterface), 0, (GInstanceInitFunc) gtkdoc_dbus_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_dbus_interface_type_id;
		gtkdoc_dbus_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_dbus_interface_type_id__volatile, gtkdoc_dbus_interface_type_id);
	}
	return gtkdoc_dbus_interface_type_id__volatile;
}

gpointer
gtkdoc_dbus_interface_ref (gpointer instance)
{
	GtkdocDBusInterface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_dbus_interface_unref (gpointer instance)
{
	GtkdocDBusInterface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_INTERFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

