/* valaccodemethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEMETHODBINDING_H__
#define __GOBJECT_VALACCODEMETHODBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valamethod.h>
#include <vala/valadatatype.h>
#include <gee/map.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <gobject/valaccodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_METHOD_BINDING (vala_ccode_method_binding_get_type ())
#define VALA_CCODE_METHOD_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBinding))
#define VALA_CCODE_METHOD_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingClass))
#define VALA_IS_CCODE_METHOD_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_BINDING))
#define VALA_IS_CCODE_METHOD_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_BINDING))
#define VALA_CCODE_METHOD_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingClass))

typedef struct _ValaCCodeMethodBindingPrivate ValaCCodeMethodBindingPrivate;

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodBinding {
	ValaCCodeBinding parent_instance;
	ValaCCodeMethodBindingPrivate * priv;
};

struct _ValaCCodeMethodBindingClass {
	ValaCCodeBindingClass parent_class;
};


char* vala_ccode_method_binding_get_custom_creturn_type (ValaCCodeMethodBinding* self);
ValaCCodeMethodBinding* vala_ccode_method_binding_new (ValaCCodeGenerator* codegen, ValaMethod* method);
void vala_ccode_method_binding_generate_cparameters (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* creturn_type, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator);
ValaMethod* vala_ccode_method_binding_get_method (ValaCCodeMethodBinding* self);
void vala_ccode_method_binding_set_method (ValaCCodeMethodBinding* self, ValaMethod* value);
gboolean vala_ccode_method_binding_get_has_wrapper (ValaCCodeMethodBinding* self);
GType vala_ccode_method_binding_get_type (void);


G_END_DECLS

#endif
