/* valaccodestruct.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODESTRUCT_H__
#define __CCODE_VALACCODESTRUCT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_STRUCT (vala_ccode_struct_get_type ())
#define VALA_CCODE_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT, ValaCCodeStruct))
#define VALA_CCODE_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructClass))
#define VALA_IS_CCODE_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT))
#define VALA_IS_CCODE_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT))
#define VALA_CCODE_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructClass))

typedef struct _ValaCCodeStruct ValaCCodeStruct;
typedef struct _ValaCCodeStructClass ValaCCodeStructClass;
typedef struct _ValaCCodeStructPrivate ValaCCodeStructPrivate;

/**
 * Represents a struct declaration in the C code.
 */
struct _ValaCCodeStruct {
	ValaCCodeNode parent_instance;
	ValaCCodeStructPrivate * priv;
};

struct _ValaCCodeStructClass {
	ValaCCodeNodeClass parent_class;
};


ValaCCodeStruct* vala_ccode_struct_new (const char* name);
void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl);
void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name);
const char* vala_ccode_struct_get_name (ValaCCodeStruct* self);
void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value);
GType vala_ccode_struct_get_type (void);


G_END_DECLS

#endif
