/* valaccodeassignment.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeassignment.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeAssignmentPrivate {
	ValaCCodeExpression* _left;
	ValaCCodeAssignmentOperator _operator;
	ValaCCodeExpression* _right;
};

#define VALA_CCODE_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ASSIGNMENT, ValaCCodeAssignmentPrivate))
enum  {
	VALA_CCODE_ASSIGNMENT_DUMMY_PROPERTY,
	VALA_CCODE_ASSIGNMENT_LEFT,
	VALA_CCODE_ASSIGNMENT_OPERATOR,
	VALA_CCODE_ASSIGNMENT_RIGHT
};
static void vala_ccode_assignment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_assignment_set_left (ValaCCodeAssignment* self, ValaCCodeExpression* value);
static void vala_ccode_assignment_set_right (ValaCCodeAssignment* self, ValaCCodeExpression* value);
static gpointer vala_ccode_assignment_parent_class = NULL;
static void vala_ccode_assignment_finalize (GObject * obj);



ValaCCodeAssignment* vala_ccode_assignment_new (ValaCCodeExpression* l, ValaCCodeExpression* r, ValaCCodeAssignmentOperator op) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeAssignment * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (l), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (r), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "left";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, l);
	__params_it++;
	__params_it->name = "right";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, r);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_ASSIGNMENT, __params_it - __params, __params);
	vala_ccode_assignment_set_operator (self, op);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_assignment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeAssignment * self;
	self = VALA_CCODE_ASSIGNMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_left), writer);
	vala_ccode_writer_write_string (writer, " ");
	if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR) {
		vala_ccode_writer_write_string (writer, "|");
	} else {
		if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND) {
			vala_ccode_writer_write_string (writer, "&");
		} else {
			if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
				vala_ccode_writer_write_string (writer, "^");
			} else {
				if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_ADD) {
					vala_ccode_writer_write_string (writer, "+");
				} else {
					if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_SUB) {
						vala_ccode_writer_write_string (writer, "-");
					} else {
						if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_MUL) {
							vala_ccode_writer_write_string (writer, "*");
						} else {
							if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_DIV) {
								vala_ccode_writer_write_string (writer, "/");
							} else {
								if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT) {
									vala_ccode_writer_write_string (writer, "%");
								} else {
									if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
										vala_ccode_writer_write_string (writer, "<<");
									} else {
										if (self->priv->_operator == VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
											vala_ccode_writer_write_string (writer, ">>");
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	vala_ccode_writer_write_string (writer, "= ");
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_right), writer);
}


ValaCCodeExpression* vala_ccode_assignment_get_left (ValaCCodeAssignment* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT (self), NULL);
	return self->priv->_left;
}


static void vala_ccode_assignment_set_left (ValaCCodeAssignment* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_left = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_left == NULL ? NULL : (self->priv->_left = (g_object_unref (self->priv->_left), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "left");
}


ValaCCodeAssignmentOperator vala_ccode_assignment_get_operator (ValaCCodeAssignment* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT (self), 0);
	return self->priv->_operator;
}


void vala_ccode_assignment_set_operator (ValaCCodeAssignment* self, ValaCCodeAssignmentOperator value) {
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT (self));
	self->priv->_operator = value;
	g_object_notify (((GObject *) (self)), "operator");
}


ValaCCodeExpression* vala_ccode_assignment_get_right (ValaCCodeAssignment* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT (self), NULL);
	return self->priv->_right;
}


static void vala_ccode_assignment_set_right (ValaCCodeAssignment* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_right = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_right == NULL ? NULL : (self->priv->_right = (g_object_unref (self->priv->_right), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "right");
}


static void vala_ccode_assignment_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignment * self;
	self = VALA_CCODE_ASSIGNMENT (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_LEFT:
		g_value_set_object (value, vala_ccode_assignment_get_left (self));
		break;
		case VALA_CCODE_ASSIGNMENT_OPERATOR:
		g_value_set_enum (value, vala_ccode_assignment_get_operator (self));
		break;
		case VALA_CCODE_ASSIGNMENT_RIGHT:
		g_value_set_object (value, vala_ccode_assignment_get_right (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignment * self;
	self = VALA_CCODE_ASSIGNMENT (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_LEFT:
		vala_ccode_assignment_set_left (self, g_value_get_object (value));
		break;
		case VALA_CCODE_ASSIGNMENT_OPERATOR:
		vala_ccode_assignment_set_operator (self, g_value_get_enum (value));
		break;
		case VALA_CCODE_ASSIGNMENT_RIGHT:
		vala_ccode_assignment_set_right (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_class_init (ValaCCodeAssignmentClass * klass) {
	vala_ccode_assignment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeAssignmentPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_assignment_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_assignment_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_assignment_finalize;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_assignment_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ASSIGNMENT_LEFT, g_param_spec_object ("left", "left", "left", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ASSIGNMENT_OPERATOR, g_param_spec_enum ("operator", "operator", "operator", VALA_TYPE_CCODE_ASSIGNMENT_OPERATOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ASSIGNMENT_RIGHT, g_param_spec_object ("right", "right", "right", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vala_ccode_assignment_instance_init (ValaCCodeAssignment * self) {
	self->priv = VALA_CCODE_ASSIGNMENT_GET_PRIVATE (self);
}


static void vala_ccode_assignment_finalize (GObject * obj) {
	ValaCCodeAssignment * self;
	self = VALA_CCODE_ASSIGNMENT (obj);
	(self->priv->_left == NULL ? NULL : (self->priv->_left = (g_object_unref (self->priv->_left), NULL)));
	(self->priv->_right == NULL ? NULL : (self->priv->_right = (g_object_unref (self->priv->_right), NULL)));
	G_OBJECT_CLASS (vala_ccode_assignment_parent_class)->finalize (obj);
}


GType vala_ccode_assignment_get_type (void) {
	static GType vala_ccode_assignment_type_id = 0;
	if (vala_ccode_assignment_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignment), 0, (GInstanceInitFunc) vala_ccode_assignment_instance_init };
		vala_ccode_assignment_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeAssignment", &g_define_type_info, 0);
	}
	return vala_ccode_assignment_type_id;
}



GType vala_ccode_assignment_operator_get_type (void) {
	static GType vala_ccode_assignment_operator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_assignment_operator_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_ADD, "VALA_CCODE_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_SUB, "VALA_CCODE_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_MUL, "VALA_CCODE_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_DIV, "VALA_CCODE_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT, "VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		vala_ccode_assignment_operator_type_id = g_enum_register_static ("ValaCCodeAssignmentOperator", values);
	}
	return vala_ccode_assignment_operator_type_id;
}




