/* valaunresolvedtype.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#include <vala/valaunresolvedtype.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>
#include <vala/valamemberaccess.h>
#include <vala/valareport.h>

struct _ValaUnresolvedTypePrivate {
	char* _namespace_name;
	char* _type_name;
	gint _array_rank;
	gint _pointer_level;
	gboolean _transfers_ownership;
	gboolean _takes_ownership;
	gboolean _is_weak;
	gboolean _is_ref;
	gboolean _is_out;
	gboolean _nullable;
};
#define VALA_UNRESOLVED_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypePrivate))
enum  {
	VALA_UNRESOLVED_TYPE_DUMMY_PROPERTY,
	VALA_UNRESOLVED_TYPE_NAMESPACE_NAME,
	VALA_UNRESOLVED_TYPE_TYPE_NAME,
	VALA_UNRESOLVED_TYPE_ARRAY_RANK,
	VALA_UNRESOLVED_TYPE_POINTER_LEVEL,
	VALA_UNRESOLVED_TYPE_TRANSFERS_OWNERSHIP,
	VALA_UNRESOLVED_TYPE_TAKES_OWNERSHIP,
	VALA_UNRESOLVED_TYPE_IS_WEAK,
	VALA_UNRESOLVED_TYPE_IS_REF,
	VALA_UNRESOLVED_TYPE_IS_OUT,
	VALA_UNRESOLVED_TYPE_NULLABLE
};
static ValaDataType* vala_unresolved_type_real_copy (ValaDataType* base);
static gpointer vala_unresolved_type_parent_class = NULL;
static void vala_unresolved_type_dispose (GObject * obj);


ValaUnresolvedType* vala_unresolved_type_new (void) {
	ValaUnresolvedType * self;
	self = g_object_newv (VALA_TYPE_UNRESOLVED_TYPE, 0, NULL);
	return self;
}


/**
 * Creates a new type reference.
 *
 * @param ns        optional namespace name
 * @param type_name type symbol name
 * @param source    reference to source code
 * @return          newly created type reference
 */
ValaUnresolvedType* vala_unresolved_type_new_from_name (const char* ns, const char* type, ValaSourceReference* source) {
	ValaUnresolvedType * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_UNRESOLVED_TYPE, 0, NULL);
	vala_unresolved_type_set_namespace_name (self, ns);
	vala_unresolved_type_set_type_name (self, type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


/**
 * Creates a new type reference from a code expression.
 *
 * @param expr   member access expression
 * @param source reference to source code
 * @return       newly created type reference
 */
ValaUnresolvedType* vala_unresolved_type_new_from_expression (ValaExpression* expr) {
	char* ns;
	char* type_name;
	gpointer _tmp5;
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	ns = NULL;
	type_name = NULL;
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaUnresolvedType* type_ref;
		ValaMemberAccess* _tmp0;
		ValaMemberAccess* ma;
		type_ref = NULL;
		_tmp0 = NULL;
		ma = (_tmp0 = VALA_MEMBER_ACCESS (expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_member_access_get_inner (ma) != NULL) {
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (ma))) {
				ValaMemberAccess* _tmp1;
				ValaMemberAccess* simple;
				ValaUnresolvedType* _tmp2;
				_tmp1 = NULL;
				simple = (_tmp1 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp2 = NULL;
				type_ref = (_tmp2 = vala_unresolved_type_new_from_name (vala_member_access_get_member_name (simple), vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), _tmp2);
				(simple == NULL ? NULL : (simple = (g_object_unref (simple), NULL)));
			}
		} else {
			ValaUnresolvedType* _tmp3;
			_tmp3 = NULL;
			type_ref = (_tmp3 = vala_unresolved_type_new_from_name (NULL, vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), _tmp3);
		}
		if (type_ref != NULL) {
			GeeCollection* type_args;
			ValaUnresolvedType* _tmp4;
			type_args = vala_member_access_get_type_arguments (ma);
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = type_args;
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaDataType* arg;
					arg = gee_iterator_get (arg_it);
					{
						vala_data_type_add_type_argument (VALA_DATA_TYPE (type_ref), arg);
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
					}
				}
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			_tmp4 = NULL;
			return (_tmp4 = type_ref, (type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), _tmp4);
		}
		(type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	}
	vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Type reference must be simple name or member access expression");
	return (_tmp5 = NULL, (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), _tmp5);
}


static ValaDataType* vala_unresolved_type_real_copy (ValaDataType* base) {
	ValaUnresolvedType * self;
	ValaUnresolvedType* result;
	self = VALA_UNRESOLVED_TYPE (base);
	result = vala_unresolved_type_new ();
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_unresolved_type_set_transfers_ownership (result, vala_unresolved_type_get_transfers_ownership (self));
	vala_unresolved_type_set_takes_ownership (result, vala_unresolved_type_get_takes_ownership (self));
	vala_unresolved_type_set_is_out (result, vala_unresolved_type_get_is_out (self));
	vala_unresolved_type_set_nullable (result, vala_unresolved_type_get_nullable (self));
	vala_unresolved_type_set_namespace_name (result, vala_unresolved_type_get_namespace_name (self));
	vala_unresolved_type_set_type_name (result, vala_unresolved_type_get_type_name (self));
	vala_unresolved_type_set_array_rank (result, vala_unresolved_type_get_array_rank (self));
	vala_unresolved_type_set_pointer_level (result, vala_unresolved_type_get_pointer_level (self));
	vala_unresolved_type_set_is_ref (result, vala_unresolved_type_get_is_ref (self));
	vala_unresolved_type_set_is_weak (result, vala_unresolved_type_get_is_weak (self));
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaDataType* arg;
			arg = gee_iterator_get (arg_it);
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


char* vala_unresolved_type_get_namespace_name (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), NULL);
	return self->priv->_namespace_name;
}


void vala_unresolved_type_set_namespace_name (ValaUnresolvedType* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_namespace_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_namespace_name = (g_free (self->priv->_namespace_name), NULL)), _tmp2);
}


char* vala_unresolved_type_get_type_name (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), NULL);
	return self->priv->_type_name;
}


void vala_unresolved_type_set_type_name (ValaUnresolvedType* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp2);
}


gint vala_unresolved_type_get_array_rank (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), 0);
	return self->priv->_array_rank;
}


void vala_unresolved_type_set_array_rank (ValaUnresolvedType* self, gint value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_array_rank = value;
}


gint vala_unresolved_type_get_pointer_level (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), 0);
	return self->priv->_pointer_level;
}


void vala_unresolved_type_set_pointer_level (ValaUnresolvedType* self, gint value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_pointer_level = value;
}


gboolean vala_unresolved_type_get_transfers_ownership (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_transfers_ownership;
}


void vala_unresolved_type_set_transfers_ownership (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_transfers_ownership = value;
}


gboolean vala_unresolved_type_get_takes_ownership (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_takes_ownership;
}


void vala_unresolved_type_set_takes_ownership (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_takes_ownership = value;
}


gboolean vala_unresolved_type_get_is_weak (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_is_weak;
}


void vala_unresolved_type_set_is_weak (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_is_weak = value;
}


gboolean vala_unresolved_type_get_is_ref (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_is_ref;
}


void vala_unresolved_type_set_is_ref (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_is_ref = value;
}


gboolean vala_unresolved_type_get_is_out (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_is_out;
}


void vala_unresolved_type_set_is_out (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_is_out = value;
}


gboolean vala_unresolved_type_get_nullable (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), FALSE);
	return self->priv->_nullable;
}


void vala_unresolved_type_set_nullable (ValaUnresolvedType* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	self->priv->_nullable = value;
}


static void vala_unresolved_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (object);
	switch (property_id) {
		case VALA_UNRESOLVED_TYPE_NAMESPACE_NAME:
		g_value_set_string (value, vala_unresolved_type_get_namespace_name (self));
		break;
		case VALA_UNRESOLVED_TYPE_TYPE_NAME:
		g_value_set_string (value, vala_unresolved_type_get_type_name (self));
		break;
		case VALA_UNRESOLVED_TYPE_ARRAY_RANK:
		g_value_set_int (value, vala_unresolved_type_get_array_rank (self));
		break;
		case VALA_UNRESOLVED_TYPE_POINTER_LEVEL:
		g_value_set_int (value, vala_unresolved_type_get_pointer_level (self));
		break;
		case VALA_UNRESOLVED_TYPE_TRANSFERS_OWNERSHIP:
		g_value_set_boolean (value, vala_unresolved_type_get_transfers_ownership (self));
		break;
		case VALA_UNRESOLVED_TYPE_TAKES_OWNERSHIP:
		g_value_set_boolean (value, vala_unresolved_type_get_takes_ownership (self));
		break;
		case VALA_UNRESOLVED_TYPE_IS_WEAK:
		g_value_set_boolean (value, vala_unresolved_type_get_is_weak (self));
		break;
		case VALA_UNRESOLVED_TYPE_IS_REF:
		g_value_set_boolean (value, vala_unresolved_type_get_is_ref (self));
		break;
		case VALA_UNRESOLVED_TYPE_IS_OUT:
		g_value_set_boolean (value, vala_unresolved_type_get_is_out (self));
		break;
		case VALA_UNRESOLVED_TYPE_NULLABLE:
		g_value_set_boolean (value, vala_unresolved_type_get_nullable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (object);
	switch (property_id) {
		case VALA_UNRESOLVED_TYPE_NAMESPACE_NAME:
		vala_unresolved_type_set_namespace_name (self, g_value_get_string (value));
		break;
		case VALA_UNRESOLVED_TYPE_TYPE_NAME:
		vala_unresolved_type_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_UNRESOLVED_TYPE_ARRAY_RANK:
		vala_unresolved_type_set_array_rank (self, g_value_get_int (value));
		break;
		case VALA_UNRESOLVED_TYPE_POINTER_LEVEL:
		vala_unresolved_type_set_pointer_level (self, g_value_get_int (value));
		break;
		case VALA_UNRESOLVED_TYPE_TRANSFERS_OWNERSHIP:
		vala_unresolved_type_set_transfers_ownership (self, g_value_get_boolean (value));
		break;
		case VALA_UNRESOLVED_TYPE_TAKES_OWNERSHIP:
		vala_unresolved_type_set_takes_ownership (self, g_value_get_boolean (value));
		break;
		case VALA_UNRESOLVED_TYPE_IS_WEAK:
		vala_unresolved_type_set_is_weak (self, g_value_get_boolean (value));
		break;
		case VALA_UNRESOLVED_TYPE_IS_REF:
		vala_unresolved_type_set_is_ref (self, g_value_get_boolean (value));
		break;
		case VALA_UNRESOLVED_TYPE_IS_OUT:
		vala_unresolved_type_set_is_out (self, g_value_get_boolean (value));
		break;
		case VALA_UNRESOLVED_TYPE_NULLABLE:
		vala_unresolved_type_set_nullable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_type_class_init (ValaUnresolvedTypeClass * klass) {
	vala_unresolved_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaUnresolvedTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_unresolved_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_unresolved_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_unresolved_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_unresolved_type_real_copy;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_NAMESPACE_NAME, g_param_spec_string ("namespace-name", "namespace-name", "namespace-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_TYPE_NAME, g_param_spec_string ("type-name", "type-name", "type-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_ARRAY_RANK, g_param_spec_int ("array-rank", "array-rank", "array-rank", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_POINTER_LEVEL, g_param_spec_int ("pointer-level", "pointer-level", "pointer-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_TRANSFERS_OWNERSHIP, g_param_spec_boolean ("transfers-ownership", "transfers-ownership", "transfers-ownership", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_TAKES_OWNERSHIP, g_param_spec_boolean ("takes-ownership", "takes-ownership", "takes-ownership", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_IS_WEAK, g_param_spec_boolean ("is-weak", "is-weak", "is-weak", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_IS_REF, g_param_spec_boolean ("is-ref", "is-ref", "is-ref", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_IS_OUT, g_param_spec_boolean ("is-out", "is-out", "is-out", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_NULLABLE, g_param_spec_boolean ("nullable", "nullable", "nullable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_unresolved_type_init (ValaUnresolvedType * self) {
	self->priv = VALA_UNRESOLVED_TYPE_GET_PRIVATE (self);
}


static void vala_unresolved_type_dispose (GObject * obj) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (obj);
	(self->priv->_namespace_name = (g_free (self->priv->_namespace_name), NULL));
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	G_OBJECT_CLASS (vala_unresolved_type_parent_class)->dispose (obj);
}


GType vala_unresolved_type_get_type (void) {
	static GType vala_unresolved_type_type_id = 0;
	if (G_UNLIKELY (vala_unresolved_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnresolvedTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unresolved_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnresolvedType), 0, (GInstanceInitFunc) vala_unresolved_type_init };
		vala_unresolved_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaUnresolvedType", &g_define_type_info, 0);
	}
	return vala_unresolved_type_type_id;
}




