/* valamemberinitializer.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAMEMBERINITIALIZER_H__
#define __VALA_VALAMEMBERINITIALIZER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_MEMBER_INITIALIZER (vala_member_initializer_get_type ())
#define VALA_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer))
#define VALA_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))
#define VALA_IS_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_IS_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_MEMBER_INITIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))

typedef struct _ValaMemberInitializerPrivate ValaMemberInitializerPrivate;

/**
 * Represents a member initializer, i.e. an element of an object initializer, in
 * the source code.
 */
struct _ValaMemberInitializer {
	ValaCodeNode parent_instance;
	ValaMemberInitializerPrivate * priv;
};
struct _ValaMemberInitializerClass {
	ValaCodeNodeClass parent_class;
};

ValaMemberInitializer* vala_member_initializer_new (const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
char* vala_member_initializer_get_name (ValaMemberInitializer* self);
void vala_member_initializer_set_name (ValaMemberInitializer* self, const char* value);
ValaExpression* vala_member_initializer_get_initializer (ValaMemberInitializer* self);
void vala_member_initializer_set_initializer (ValaMemberInitializer* self, ValaExpression* value);
ValaSymbol* vala_member_initializer_get_symbol_reference (ValaMemberInitializer* self);
void vala_member_initializer_set_symbol_reference (ValaMemberInitializer* self, ValaSymbol* value);
GType vala_member_initializer_get_type (void);

G_END_DECLS

#endif
