/* valaccodeelementaccessbinding.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeelementaccessbinding.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <vala/valamethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeelementaccess.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodegenerator.h>

struct _ValaCCodeElementAccessBindingPrivate {
	ValaElementAccess* _element_access;
};
#define VALA_CCODE_ELEMENT_ACCESS_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, ValaCCodeElementAccessBindingPrivate))
enum  {
	VALA_CCODE_ELEMENT_ACCESS_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS
};
static void vala_ccode_element_access_binding_real_emit (ValaCodeBinding* base);
static gpointer vala_ccode_element_access_binding_parent_class = NULL;
static void vala_ccode_element_access_binding_dispose (GObject * obj);


ValaCCodeElementAccessBinding* vala_ccode_element_access_binding_new (ValaCodeGenerator* codegen, ValaElementAccess* element_access) {
	ValaCCodeElementAccessBinding * self;
	g_return_val_if_fail (codegen == NULL || VALA_IS_CODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (element_access == NULL || VALA_IS_ELEMENT_ACCESS (element_access), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, 0, NULL);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), VALA_CCODE_GENERATOR (codegen));
	vala_ccode_element_access_binding_set_element_access (self, element_access);
	return self;
}


static void vala_ccode_element_access_binding_real_emit (ValaCodeBinding* base) {
	ValaCCodeElementAccessBinding * self;
	ValaElementAccess* _tmp0;
	ValaElementAccess* expr;
	GeeList* indices;
	gint rank;
	ValaTypesymbol* _tmp1;
	ValaTypesymbol* container_type;
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp4;
	ValaExpression* _tmp3;
	ValaCCodeExpression* _tmp5;
	ValaCCodeExpression* cindex;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = vala_ccode_element_access_binding_get_element_access (self), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size (GEE_COLLECTION (indices));
	_tmp1 = NULL;
	container_type = (_tmp1 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	ccontainer = (_tmp2 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	cindex = (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp3 = gee_list_get (((GeeList*) indices), 0))))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
	if (container_type == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
		ValaCCodeIdentifier* _tmp6;
		ValaCCodeFunctionCall* _tmp7;
		ValaCCodeFunctionCall* coffsetcall;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeFunctionCall* _tmp9;
		ValaCCodeFunctionCall* ccall;
		/* access to unichar in a string*/
		_tmp6 = NULL;
		_tmp7 = NULL;
		coffsetcall = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
		vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
		vala_ccode_function_call_add_argument (coffsetcall, cindex);
		_tmp8 = NULL;
		_tmp9 = NULL;
		ccall = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_utf8_get_char")))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (coffsetcall));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
		(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	} else {
		if (container_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type) || vala_typesymbol_is_subtype_of (container_type, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type))) {
			ValaMethod* get_method;
			GeeCollection* get_params;
			GeeIterator* get_params_it;
			ValaFormalParameter* get_param;
			ValaCCodeIdentifier* _tmp12;
			char* _tmp11;
			ValaCCodeFunctionCall* _tmp13;
			ValaCCodeFunctionCall* get_ccall;
			ValaCCodeCastExpression* _tmp16;
			char* _tmp15;
			char* _tmp14;
			ValaCCodeExpression* _tmp17;
			get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (container_type)), "get"));
			get_params = vala_method_get_parameters (get_method);
			get_params_it = gee_iterable_iterator (GEE_ITERABLE (get_params));
			gee_iterator_next (get_params_it);
			get_param = gee_iterator_get (get_params_it);
			if (vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (get_param)) != NULL) {
				ValaDataType* index_type;
				ValaCCodeExpression* _tmp10;
				index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (get_method), vala_formal_parameter_get_type_reference (get_param), VALA_CODE_NODE (expr));
				_tmp10 = NULL;
				cindex = (_tmp10 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp10);
				(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
			}
			_tmp12 = NULL;
			_tmp11 = NULL;
			_tmp13 = NULL;
			get_ccall = (_tmp13 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ((_tmp11 = vala_method_get_cname (get_method)))))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_cast_expression_new (ccontainer, (_tmp15 = g_strconcat ((_tmp14 = vala_typesymbol_get_cname (container_type, FALSE)), "*", NULL))))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			(_tmp15 = (g_free (_tmp15), NULL));
			(_tmp14 = (g_free (_tmp14), NULL));
			vala_ccode_function_call_add_argument (get_ccall, cindex);
			_tmp17 = NULL;
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), (_tmp17 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (get_ccall), vala_expression_get_static_type (VALA_EXPRESSION (expr)))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
			(get_params == NULL ? NULL : (get_params = (g_object_unref (get_params), NULL)));
			(get_params_it == NULL ? NULL : (get_params_it = (g_object_unref (get_params_it), NULL)));
			(get_param == NULL ? NULL : (get_param = (g_object_unref (get_param), NULL)));
			(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
		} else {
			ValaCCodeElementAccess* _tmp24;
			{
				gint i;
				i = 0;
				for (i = 1; i < rank; i++) {
					ValaCCodeExpression* _tmp19;
					ValaCCodeParenthesizedExpression* _tmp18;
					ValaCCodeBinaryExpression* _tmp20;
					ValaCCodeBinaryExpression* cmul;
					ValaCCodeExpression* _tmp23;
					ValaCCodeParenthesizedExpression* _tmp22;
					ValaExpression* _tmp21;
					/* access to element in an array*/
					_tmp19 = NULL;
					_tmp18 = NULL;
					_tmp20 = NULL;
					cmul = (_tmp20 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_parenthesized_expression_new (cindex))), (_tmp19 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_element_access_get_container (expr), i + 1))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp20);
					_tmp23 = NULL;
					_tmp22 = NULL;
					_tmp21 = NULL;
					cindex = (_tmp23 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (cmul), VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp21 = gee_list_get (((GeeList*) indices), i)))))))))), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp23);
					(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
					(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					(cmul == NULL ? NULL : (cmul = (g_object_unref (cmul), NULL)));
				}
			}
			_tmp24 = NULL;
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_element_access_new (ccontainer, cindex))));
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self))));
	vala_ccode_generator_visit_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_EXPRESSION (expr));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


ValaElementAccess* vala_ccode_element_access_binding_get_element_access (ValaCCodeElementAccessBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS_BINDING (self), NULL);
	return self->priv->_element_access;
}


void vala_ccode_element_access_binding_set_element_access (ValaCCodeElementAccessBinding* self, ValaElementAccess* value) {
	ValaElementAccess* _tmp2;
	ValaElementAccess* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_access = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_element_access == NULL ? NULL : (self->priv->_element_access = (g_object_unref (self->priv->_element_access), NULL))), _tmp2);
}


static void vala_ccode_element_access_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeElementAccessBinding * self;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS:
		g_value_set_object (value, vala_ccode_element_access_binding_get_element_access (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_element_access_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeElementAccessBinding * self;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS:
		vala_ccode_element_access_binding_set_element_access (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_element_access_binding_class_init (ValaCCodeElementAccessBindingClass * klass) {
	vala_ccode_element_access_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeElementAccessBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_element_access_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_element_access_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_element_access_binding_dispose;
	VALA_CODE_BINDING_CLASS (klass)->emit = vala_ccode_element_access_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS, g_param_spec_object ("element-access", "element-access", "element-access", VALA_TYPE_ELEMENT_ACCESS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_element_access_binding_init (ValaCCodeElementAccessBinding * self) {
	self->priv = VALA_CCODE_ELEMENT_ACCESS_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_element_access_binding_dispose (GObject * obj) {
	ValaCCodeElementAccessBinding * self;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (obj);
	(self->priv->_element_access == NULL ? NULL : (self->priv->_element_access = (g_object_unref (self->priv->_element_access), NULL)));
	G_OBJECT_CLASS (vala_ccode_element_access_binding_parent_class)->dispose (obj);
}


GType vala_ccode_element_access_binding_get_type (void) {
	static GType vala_ccode_element_access_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_element_access_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeElementAccessBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_element_access_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeElementAccessBinding), 0, (GInstanceInitFunc) vala_ccode_element_access_binding_init };
		vala_ccode_element_access_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeElementAccessBinding", &g_define_type_info, 0);
	}
	return vala_ccode_element_access_binding_type_id;
}




