/* valainstancecast.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAINSTANCECAST_H__
#define __VALAINSTANCECAST_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>

G_BEGIN_DECLS


#define VALA_TYPE_INSTANCE_CAST (vala_instance_cast_get_type ())
#define VALA_INSTANCE_CAST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INSTANCE_CAST, ValaInstanceCast))
#define VALA_INSTANCE_CAST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastClass))
#define VALA_IS_INSTANCE_CAST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INSTANCE_CAST))
#define VALA_IS_INSTANCE_CAST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INSTANCE_CAST))
#define VALA_INSTANCE_CAST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastClass))

typedef struct _ValaInstanceCast ValaInstanceCast;
typedef struct _ValaInstanceCastClass ValaInstanceCastClass;
typedef struct _ValaInstanceCastPrivate ValaInstanceCastPrivate;

/**
 * Represents a runtime checked object instance cast expression in the C code.
 */
struct _ValaInstanceCast {
	ValaCCodeFunctionCall parent;
	ValaInstanceCastPrivate * priv;
};
struct _ValaInstanceCastClass {
	ValaCCodeFunctionCallClass parent;
};

ValaInstanceCast* vala_instance_cast_new (ValaCCodeExpression* expr, ValaDataType* type);
ValaDataType* vala_instance_cast_get_type_reference (ValaInstanceCast* self);
void vala_instance_cast_set_type_reference (ValaInstanceCast* self, ValaDataType* value);
ValaCCodeExpression* vala_instance_cast_get_inner (ValaInstanceCast* self);
void vala_instance_cast_set_inner (ValaInstanceCast* self, ValaCCodeExpression* value);
GType vala_instance_cast_get_type (void);

G_END_DECLS

#endif
