/* map.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "map.h"



GeeSet* gee_map_get_keys (GeeMap* self)
{
	return GEE_MAP_GET_INTERFACE (self)->get_keys (self);
}


GeeCollection* gee_map_get_values (GeeMap* self)
{
	return GEE_MAP_GET_INTERFACE (self)->get_values (self);
}


gboolean gee_map_contains (GeeMap* self, gpointer key)
{
	return GEE_MAP_GET_INTERFACE (self)->contains (self, key);
}


gpointer gee_map_get (GeeMap* self, gpointer key)
{
	GEE_MAP_GET_INTERFACE (self)->get (self, key);
}


void gee_map_set (GeeMap* self, gpointer key, gpointer value)
{
	GEE_MAP_GET_INTERFACE (self)->set (self, key, value);
}


gboolean gee_map_remove (GeeMap* self, gpointer key)
{
	return GEE_MAP_GET_INTERFACE (self)->remove (self, key);
}


void gee_map_clear (GeeMap* self)
{
	GEE_MAP_GET_INTERFACE (self)->clear (self);
}


gint gee_map_get_size (GeeMap* self)
{
	gint value;
	g_object_get (G_OBJECT (self), "size", &value, NULL);
	return value;
}


static void gee_map_base_init (GeeMapIface * iface)
{
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_int ("size", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gee_map_get_type (void)
{
	static GType gee_map_type_id = 0;
	if (G_UNLIKELY (gee_map_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeMapIface), (GBaseInitFunc) gee_map_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL };
		gee_map_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeMap", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_map_type_id, G_TYPE_OBJECT);
	}
	return gee_map_type_id;
}




