/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISUTOOLS_H
#define VISUTOOLS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#ifndef DEBUG
/**
 * DEBUG:
 *
 * For developpers: use this macro to test if debug mode is on.
 */
  #define DEBUG 0
#endif
/**
 * DBG_fprintf:
 *
 * For developpers: use this macro instead of fprintf.
 */
#define DBG_fprintf if(DEBUG) (void)fprintf

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


#define V_SIM_NAME          PACKAGE
#define V_SIM_VERSION       VERSION
#define V_SIM_WEB_SITE      "http://inac.cea.fr/L_Sim/V_Sim"

/**
 * MAX_LINE_LENGTH
 *
 * This is the maximum number of characters read on a
 * line of an input file.
 */
#define MAX_LINE_LENGTH 256

/**
 * voidDataFunc:
 * @data: a pointer to some user defined object.
 *
 * These methods are used when no specific argument is required except
 * a user-defined object and when void is the return type.
 */
typedef void (*voidDataFunc)(gpointer data);

/**
 * VisuToolsInitFunc:
 *
 * These methods are used by V_Sim to initialise some part of the
 * program. They are called once on start-up.
 */
typedef void (*VisuToolsInitFunc)();

/**
 * Property_struct:
 * @name: a pointer to a string, only used when DEBUG is on ;
 * @data: a pointer to an allocated memory area ;
 * @freeFunc: a destroy functon (can be NULL).
 *
 * This container can be used in hashtable to store whatever kind of
 * data that requires specific free functions.
 */
struct Property_struct
{
  /* A convenient debug pointer on the name. */
  const gchar *name;

  /* This is a pointer to the data stored. */
  gpointer data;
  
  /* This method is called when the table is freed. */
  GDestroyNotify freeFunc;
};
/**
 * Property:
 *
 * A convenient name for #Property_struct.
 */
typedef struct Property_struct Property;
/**
 * freeProperty:
 * @prop: a #Property.
 *
 * It calls @freeFunc of @prop on its @data field (see #Property), if
 * @freeFunc is not NULL. Then the #Property itself is g_free().
 */
void freeProperty(gpointer prop);

/**
 * getValidPath:
 * @pathList: a pointer to a GList with all the possible path,
 * @fileName: a string,
 * @accessMode: a value from R_OK, W_OK and X_OK as described in unistd.h.
 *
 * @pathList contains a list of directories (first is most prefered)
 * and fileName is the file name which one likes have informations on. This routine
 * look for the first directory where fileName can be writen or read (depending
 * on accessMode parameter). The pointer to the GList indicates at the end the
 * first valid entry in the GList.
 *
 * Returns: the first valid complete path (from @pathList plus @fileName)
 * if one can be found depnding on @accessMode or NULL if none found.
 */
gchar* getValidPath(GList **pathList, char *fileName, int accessMode);

/**
 * visuWaitFunction:
 *
 * This function must be called in a blocking loop to update
 * different things like the gtk for example.
 */
void visuWaitFunction();

/**
 * fModulo:
 * @a: a float ;
 * @b: an int.
 * 
 * This function is just like a%b except it works with a float @a argument. 
 * @a can be negative, but the return value of the function is always positive.
 *
 * Returns: the new float value after the modulo.
*/
float fModulo(float a, int b);

/**
 * normalize_path:
 * @path: a string, NULL terminated.
 *
 * This function normalizes the path, i.e. it removes all . and .. It should
 * work also on Windows. It must take an absolute path as argument, if not it is converted
 * assuming the current working directory.
 *
 * Returns: a newly created string.
 */
gchar* normalize_path(const gchar* path);

#if GLIB_MINOR_VERSION < 5
/**
 * g_file_set_contents:
 * @fileName: a string ;
 * @str: a string ;
 * @len: a length or -1 ;
 * @error: a location for an error.
 *
 * Compiled only if Glib is lower than 2.5.
 *
 * Returns: TRUE on success.
 */
gboolean g_file_set_contents(const gchar *fileName, const gchar *str,
			     gsize len, GError **error);
#endif

G_END_DECLS

#endif
