/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "support.h"
#include "gtk_interactive.h"
#include "visu_gtk.h"
#include "visu_pickMesure.h"
#include "gtk_main.h"
#include "gtk_pick.h"
#include "visu_object.h"
#include "gtk_renderingWindowWidget.h"
#include "renderingBackend/visu_windowInterface.h"
#include "extraFunctions/dataNode.h"
#include "extensions/extInfos.h"

/* The ids of the column used in the data treeview.
   This treeview is made on a list with NB_COLUMN_BASE + n * NB_COLUMN_DATA,
   where n is the number of data associated per node. */
enum
  {
    COLUMN_BASE_NUMBER,
    COLUMN_BASE_ELEMENT,
    NB_COLUMN_BASE
  };
enum
  {
    COLUMN_DATA_LABEL,
    COLUMN_DATA_EDITABLE,
    COLUMN_DATA_COLOR,
    NB_COLUMN_DATA
  };

/* The ids of the columns used in the combobox that identify
   each data node. */
enum
  {
    COLUMN_COMBO_LABEL,
    COLUMN_COMBO_STOCK,
    COLUMN_COMBO_POINTER,
    NB_COLUMN_COMBO
  };

/* This enum represent the possibilities for the informations drawing. */
typedef enum
  {
    DRAW_NEVER,
    DRAW_SELECTED,
    DRAW_ALWAYS
  } DrawItem;
static GtkWidget *comboDraw;

/* Treeview used to print data of nodes. */
static GtkListStore *listDataNode;
static GtkWidget *treeviewDataNode;
#define GTK_PICKOBSERVE_EDITABLE_NODE   "blue"
#define GTK_PICKOBSERVE_UNEDITABLE_NODE "black"
static GList *selectedRow;
static gulong selectedRowSignal;

/* Draw data widgets. */
static GtkWidget *radioDrawNever, *radioDrawSelected, *radioDrawAlways;
static GtkListStore *listComboInfos;

/* The pick viewport. */
static GtkWidget *labelPickOut, *labelPickError;

/* Local callbacks. */
static void onEditedPick(GtkCellRendererText *cellrenderertext,
			 gchar *path, gchar *text, gpointer user_data);
static void onNodePropertyUsed(DataNode* data, VisuData *dataObj, gpointer user_data);
static void onNodePropertyUnused(DataNode* data, VisuData *dataObj,
				 gpointer user_data);
static void onNodePropertyChanged(DataNode* data, VisuData *dataObj,
				  gpointer user_data);
static void onRadioDrawInfos(GtkToggleButton *togglebutton, gpointer user_data);
static void onDrawDistanceChecked(GtkToggleButton* button, gpointer data);
static void onEraseDistanceClicked(GtkButton *button, gpointer user_data);
static void onVisuDataChanged(GObject *obj, VisuData *dataObj, gpointer bool);
static void onNodeRemoved(VisuData *visuData, int *nodeNumbers, gpointer data);
static void onComboInfosChanged(GtkComboBox *combo, gpointer data);
static gboolean onTreeviewInfosKey(GtkWidget *widget, GdkEventKey *event,
				   gpointer user_data);
static void onSelectionChanged(GtkTreeSelection *tree, gpointer data);

/* Local routines. */
static void getIterPick(VisuNode *node, GtkTreeIter *iter);
static void addNodeToList(VisuNode *node);
static void drawDataOnNode(VisuData *data, DrawItem item);
static gboolean addNodeAtIter(VisuNode *node, GtkTreeIter *iter);
static void populateComboInfos(VisuData *dataObj);


/********************/
/* Public routines. */
/********************/
void gtkPickBuild_interface(GtkMain *main)
{
  int i, j, nb, nbData;
  GList *tmpLst;
  GType *dataTypes;
  GtkTreeViewColumn *column;
  GtkCellRenderer *renderer;
  const gchar *title;
  GtkWidget *label, *wd;
  gchar *markup;
  RenderingWindow *window;
  VisuData *dataObj;
  gboolean visible;

  /* Get the current VisuData object. */
  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  dataObj = renderingWindowGet_visuData(window);

  /* Create the liststore used for the DataNode. */
  selectedRow = (GList*)0;
  tmpLst = nodeDataGet_list();
  nbData = g_list_length(tmpLst);
  nb = nbData * NB_COLUMN_DATA + NB_COLUMN_BASE;
  dataTypes = g_malloc(sizeof(GType) * nb);
  dataTypes[COLUMN_BASE_NUMBER] = G_TYPE_UINT;
  dataTypes[COLUMN_BASE_ELEMENT] = G_TYPE_STRING;
  for (i = NB_COLUMN_BASE; tmpLst; tmpLst = g_list_next(tmpLst))
    {
      /* The string to put on screen. */
      dataTypes[i + COLUMN_DATA_LABEL] = G_TYPE_STRING;
      /* Wether this string is editable or not. */
      dataTypes[i + COLUMN_DATA_EDITABLE] = G_TYPE_BOOLEAN;
      /* Give the color used to render the string. */
      dataTypes[i + COLUMN_DATA_COLOR] = G_TYPE_STRING;
      i += NB_COLUMN_DATA;
    }
  listDataNode = gtk_list_store_newv(nb, dataTypes);
  g_free(dataTypes);
  treeviewDataNode = lookup_widget(main->interactiveDialog, "treeviewNodeData");
  gtk_tree_view_set_model(GTK_TREE_VIEW(treeviewDataNode),
			  GTK_TREE_MODEL(listDataNode));
  g_signal_connect(G_OBJECT(treeviewDataNode), "key-press-event",
		   G_CALLBACK(onTreeviewInfosKey), (gpointer)0);
  selectedRowSignal = g_signal_connect
    (G_OBJECT(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeviewDataNode))),
     "changed", G_CALLBACK(onSelectionChanged), (gpointer)0);
  gtk_tree_selection_set_mode
    (gtk_tree_view_get_selection(GTK_TREE_VIEW(treeviewDataNode)),
     GTK_SELECTION_MULTIPLE);

  /* Create the list for the combobox of data node. */
  listComboInfos = gtk_list_store_new(NB_COLUMN_COMBO, G_TYPE_STRING,
				      G_TYPE_STRING, G_TYPE_POINTER);
  /* Building headers. */
  /* Id colum. */
  renderer = gtk_cell_renderer_text_new();
  g_object_set(G_OBJECT(renderer), "scale", 0.75, NULL);
  label = gtk_label_new("");
  title = _("Id");
  markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>", title);
  gtk_label_set_markup(GTK_LABEL(label), markup);
  gtk_widget_show(label);
  g_free(markup);
  column = gtk_tree_view_column_new_with_attributes(_("Node"), renderer,
						    "text", COLUMN_BASE_NUMBER, NULL);
  gtk_tree_view_column_set_widget(column, label);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeviewDataNode), column);
  /* Element column. */
  renderer = gtk_cell_renderer_text_new();
  g_object_set(G_OBJECT(renderer), "scale", 0.75, NULL);
  label = gtk_label_new("");
  title = _("Type");
  markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>", title);
  gtk_label_set_markup(GTK_LABEL(label), markup);
  gtk_widget_show(label);
  g_free(markup);
  column = gtk_tree_view_column_new_with_attributes(_("Node"), renderer,
						    "text", COLUMN_BASE_ELEMENT, NULL);
  gtk_tree_view_column_set_widget(column, label);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeviewDataNode), column);

  i = NB_COLUMN_BASE;
  for (tmpLst = nodeDataGet_list(); tmpLst; tmpLst = g_list_next(tmpLst))
    {
      j = (i - NB_COLUMN_BASE) / NB_COLUMN_DATA;
      visible = nodeDataGet_used(DATA_NODE(tmpLst->data), dataObj);
      renderer = gtk_cell_renderer_text_new();
      g_signal_connect(G_OBJECT(renderer), "edited",
		       G_CALLBACK(onEditedPick), GINT_TO_POINTER(j));
      g_object_set(G_OBJECT(renderer), "scale", 0.75, NULL);
      title = nodeDataGet_label(DATA_NODE(tmpLst->data));
      label = gtk_label_new("");
      markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>", title);
      gtk_label_set_markup(GTK_LABEL(label), markup);
      gtk_widget_show(label);
      g_free(markup);
      column = gtk_tree_view_column_new_with_attributes
	("", renderer,
	 "markup", i + COLUMN_DATA_LABEL,
	 "editable", i + COLUMN_DATA_EDITABLE,
	 "foreground", i + COLUMN_DATA_COLOR, NULL);
/*       g_object_set(G_OBJECT(column), "editable-set", TRUE, NULL); */
      gtk_tree_view_column_set_widget(column, label);
      gtk_tree_view_append_column(GTK_TREE_VIEW(treeviewDataNode), column);

      g_signal_connect(G_OBJECT(tmpLst->data), "propertyUsed",
		       G_CALLBACK(onNodePropertyUsed), (gpointer)0);
      g_signal_connect(G_OBJECT(tmpLst->data), "propertyUnused",
		       G_CALLBACK(onNodePropertyUnused), (gpointer)0);
      g_signal_connect(G_OBJECT(tmpLst->data), "valueChanged",
		       G_CALLBACK(onNodePropertyChanged), (gpointer)0);

      i += NB_COLUMN_DATA;
    }

  /* Set the names and load the widgets. */
  comboDraw = lookup_widget(main->interactiveDialog, "comboboxShowInfos");
  gtk_combo_box_set_model(GTK_COMBO_BOX(comboDraw), GTK_TREE_MODEL(listComboInfos));
  gtk_cell_layout_clear(GTK_CELL_LAYOUT(comboDraw));
  renderer = gtk_cell_renderer_pixbuf_new();
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(comboDraw), renderer, FALSE);
  gtk_cell_layout_add_attribute(GTK_CELL_LAYOUT(comboDraw), renderer, "stock-id",
				COLUMN_COMBO_STOCK);
  renderer = gtk_cell_renderer_text_new();
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(comboDraw), renderer, FALSE);
  gtk_cell_layout_add_attribute(GTK_CELL_LAYOUT(comboDraw), renderer, "markup",
				COLUMN_COMBO_LABEL);
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboDraw), 0);
  g_signal_connect(G_OBJECT(comboDraw), "changed",
		   G_CALLBACK(onComboInfosChanged), (gpointer)0);
  labelPickOut = lookup_widget(main->interactiveDialog, "pickInfo");
  labelPickError = lookup_widget(main->interactiveDialog, "pickComment");
  gtk_widget_set_name(labelPickError, "label_error");
  wd = lookup_widget(main->interactiveDialog, "viewportPick");
  gtk_widget_set_name(wd, "message_viewport");
  wd = lookup_widget(main->interactiveDialog, "checkDrawDistance");
  gtk_widget_set_name(wd, "message_radio");
  radioDrawNever = lookup_widget(main->interactiveDialog, "radioDrawNever");
  gtk_widget_set_name(radioDrawNever, "message_radio");
  g_signal_connect(G_OBJECT(radioDrawNever), "toggled",
		   G_CALLBACK(onRadioDrawInfos), GINT_TO_POINTER(DRAW_NEVER));
  radioDrawSelected = lookup_widget(main->interactiveDialog, "radioDrawSelected");
  gtk_widget_set_name(radioDrawSelected, "message_radio");
  g_signal_connect(G_OBJECT(radioDrawSelected), "toggled",
		   G_CALLBACK(onRadioDrawInfos), GINT_TO_POINTER(DRAW_SELECTED));
  radioDrawAlways = lookup_widget(main->interactiveDialog, "radioDrawAlways");
  gtk_widget_set_name(radioDrawAlways, "message_radio");
  g_signal_connect(G_OBJECT(radioDrawAlways), "toggled",
		   G_CALLBACK(onRadioDrawInfos), GINT_TO_POINTER(DRAW_ALWAYS));


  wd = lookup_widget(main->interactiveDialog, "checkDrawDistance");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(onDrawDistanceChecked), (gpointer)0);
  wd = lookup_widget(main->interactiveDialog, "buttonEraseDistances");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onEraseDistanceClicked), (gpointer)0);

  g_signal_connect(VISU_INSTANCE, "dataReadyForRendering",
		   G_CALLBACK(onVisuDataChanged), (gpointer)0);

  if (dataObj)
    onVisuDataChanged((GObject*)0, dataObj, (gpointer)0);
}
void gtkPickUpdate_informations(PickMesure *pickMesure)
{
  gchar *infos, *errors;
  PickMesureType type;
  GList *lst, *tmpLst;
  VisuNode *node;

  g_return_if_fail(pickMesure);

  if (pickMesureGet_newsAvailable(pickMesure, &type))
    {
      switch (type)
	{
	case PICK_SELECTED:
	  /* Add the clicked node to the listStore. */
	  node = pickMesureGet_selectedNode(pickMesure);
	  if (node)
	    addNodeToList(node);
	case PICK_REFERENCE_1:
	case PICK_REFERENCE_2:
	  infos = pickMesureGet_infos(pickMesure);
	  errors = pickMesureGet_errors(pickMesure);
	  if (infos)
	    gtk_label_set_text(GTK_LABEL(labelPickOut), infos);
	  if (errors)
	    gtk_label_set_text(GTK_LABEL(labelPickError), errors);
	  break;
	case PICK_REGION:
	  /* We first empty the list. */
	  gtk_list_store_clear(listDataNode);
	  /* We add the new elements. */
	  lst = pickMesureGet_regionNodes(pickMesure);
	  tmpLst = lst;
	  while (tmpLst)
	    {
	      addNodeToList((VisuNode*)tmpLst->data);
	      tmpLst = g_list_next(tmpLst);
	    }
	  g_list_free(lst);
	  break;
	default:
	  g_warning("Not a pick event!");
	}
    }
}
void gtkPick_onClose()
{
  gtk_label_set_text(GTK_LABEL(labelPickOut), "");
  gtk_label_set_text(GTK_LABEL(labelPickError), "");
}
GList* gtkPickGet_nodeSelection()
{
  GList *lst;
  gboolean validIter;
  GtkTreeIter iter;
  unsigned int currentNodeId;

  lst = (GList*)0;
  validIter = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(listDataNode), &iter);
  while (validIter)
    {
      gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
			 COLUMN_BASE_NUMBER, &currentNodeId, -1);
      lst = g_list_prepend(lst, GINT_TO_POINTER((int)(currentNodeId - 1)));
      validIter = gtk_tree_model_iter_next(GTK_TREE_MODEL(listDataNode), &iter);
    }
  return lst;
}


/*********************/
/* Private routines. */
/*********************/
static void getIterPick(VisuNode *node, GtkTreeIter *iter)
{
  gboolean validIter, found;
  unsigned int currentNodeId;

  g_return_if_fail(node && iter);

  /* Search if @node is already in the tree. */
  found = FALSE;
  validIter = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(listDataNode), iter);
  while (validIter)
    {
      gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), iter,
			 COLUMN_BASE_NUMBER, &currentNodeId, -1);
      if (node->number + 1 == currentNodeId)
	{
	  found = TRUE;
	  validIter = FALSE;
	}
      else
	validIter = gtk_tree_model_iter_next(GTK_TREE_MODEL(listDataNode), iter);
    }
  if (!found)
    gtk_list_store_append(listDataNode, iter);

}
static void populateComboInfos(VisuData *dataObj)
{
  gchar *markup;
  const gchar *title;
  GtkTreeIter iter;
  GList *tmpLst;
  gint i, n;
  gboolean visibility, set;

  DBG_fprintf(stderr, "Gtk Pick: rebuild the data combo list.\n");

  n = gtk_combo_box_get_active(GTK_COMBO_BOX(comboDraw));

  gtk_list_store_clear(listComboInfos);

  title = _("Id");
  markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>", title);
  gtk_list_store_append(listComboInfos, &iter);
  gtk_list_store_set(listComboInfos, &iter,
		     COLUMN_COMBO_LABEL, markup,
		     COLUMN_COMBO_POINTER, GINT_TO_POINTER(1),
		     -1);
  g_free(markup);

  title = _("Type");
  markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>", title);
  gtk_list_store_append(listComboInfos, &iter);
  gtk_list_store_set(listComboInfos, &iter,
		     COLUMN_COMBO_LABEL, markup,
		     COLUMN_COMBO_POINTER, GINT_TO_POINTER(2),
		     -1);
  g_free(markup);

  i = NB_COLUMN_BASE;
  for (tmpLst = nodeDataGet_list(); tmpLst; tmpLst = g_list_next(tmpLst))
    {
      visibility = nodeDataGet_used(DATA_NODE(tmpLst->data), dataObj);
      if (visibility)
	{
	  title = nodeDataGet_label(DATA_NODE(tmpLst->data));
	  markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>", title);

	  gtk_list_store_append(listComboInfos, &iter);
	  gtk_list_store_set(listComboInfos, &iter,
			     COLUMN_COMBO_LABEL, markup,
			     COLUMN_COMBO_POINTER, tmpLst->data,
			     -1);
	  if (nodeDataGet_editable(DATA_NODE(tmpLst->data)))
	    gtk_list_store_set(listComboInfos, &iter,
			       COLUMN_COMBO_STOCK, GTK_STOCK_EDIT,
			       -1);
	  DBG_fprintf(stderr, " | add '%s'\n", title);
	  g_free(markup);
	}
      /* Update the column visibility. */
      g_object_set(G_OBJECT(gtk_tree_view_get_column(GTK_TREE_VIEW(treeviewDataNode),
						     i)), "visible", visibility,
		   NULL);
      i += 1;
    }
  set = (n >= 0 && n < gtk_tree_model_iter_n_children(GTK_TREE_MODEL(listComboInfos),
						      (GtkTreeIter*)0));
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboDraw), (set)?n:0);
}
static gboolean addNodeAtIter(VisuNode *node, GtkTreeIter *iter)
{
  GList *tmpLst;
  gchar *values, *label, *color;
  int i;
  gboolean editable;
  GtkTreePath *path;
  RenderingWindow *window;
  VisuData *dataObj;

  /* Get the current VisuData object. */
  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  dataObj = renderingWindowGet_visuData(window);

  /* Store the base data. */
  gtk_list_store_set(listDataNode, iter,
		     COLUMN_BASE_NUMBER, node->number + 1, 
		     COLUMN_BASE_ELEMENT,
		     dataObj->fromIntToVisuElement[node->posElement]->name,
		     -1);
  /* Store the additional data informations. */
  i = NB_COLUMN_BASE;
  for (tmpLst = nodeDataGet_list(); tmpLst; tmpLst = g_list_next(tmpLst))
    {
      editable = nodeDataGet_editable((DataNode*)tmpLst->data);
      label = nodeDataGet_valueAsString((DataNode*)tmpLst->data,
					dataObj, node);
      if (!label)
	{
	  values = _("<i>None</i>");
	  editable = FALSE;
	}
      else
	values = label;
      if (editable)
	color = GTK_PICKOBSERVE_EDITABLE_NODE;
      else
	color = GTK_PICKOBSERVE_UNEDITABLE_NODE;
      gtk_list_store_set(listDataNode, iter,
			 i + COLUMN_DATA_LABEL, values,
			 i + COLUMN_DATA_EDITABLE, editable,
			 i + COLUMN_DATA_COLOR, color, -1);
      if (label)
	g_free(label);
      i += NB_COLUMN_DATA;
    }
  /* Update the selection. */
/*   gtk_tree_selection_select_iter(gtk_tree_view_get_selection */
/* 				 (GTK_TREE_VIEW(treeviewDataNode)), iter); */
  path = gtk_tree_model_get_path(GTK_TREE_MODEL(listDataNode), iter);
  gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(treeviewDataNode), path,
			       NULL, FALSE, 0., 0.);
  gtk_tree_path_free(path);

  /* If daw informations is DRAW_SELECTED, update the list. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawSelected)))
    {
      drawDataOnNode(dataObj, DRAW_SELECTED);
      return TRUE;
    }
  else
    return FALSE;
}
static void addNodeToList(VisuNode *node)
{
  GtkTreeIter iter;

  getIterPick(node, &iter);
  if (addNodeAtIter(node, &iter))
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void drawDataOnNode(VisuData *data, DrawItem item)
{
  int method, i;
  GtkTreeIter iter;
  gpointer infos;
  gboolean valid;
  int *nodes;

  /* We get what data to draw. */
  valid = gtk_combo_box_get_active_iter(GTK_COMBO_BOX(comboDraw), &iter);
  g_return_if_fail(valid);

  gtk_tree_model_get(GTK_TREE_MODEL(listComboInfos), &iter,
		     COLUMN_COMBO_POINTER, &infos,
		     -1);
  method = GPOINTER_TO_INT(infos);

  /* We build the list of elements to be drawn in DRAW_SELECTED mode. */
  if (item == DRAW_SELECTED)
    {
      nodes = g_malloc(sizeof(int) * 
		       (gtk_tree_model_iter_n_children(GTK_TREE_MODEL(listDataNode),
						       (GtkTreeIter*)0) + 1));
      i = 0;
      valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(listDataNode), &iter);
      while (valid)
	{
	  gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
			     COLUMN_BASE_NUMBER, nodes + i,
			     -1);
	  nodes[i] -= 1;
	  i += 1;
	  valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(listDataNode), &iter);
	}
      nodes[i] = -1;
    }
  else
    nodes = (int*)0;

  extInfosSet_used(data, (item != DRAW_NEVER));

  /* If item is not DRAW_NEVER, we update the OpenGL list. */
  if (item != DRAW_NEVER)
    {
      switch (method)
	{
	case 1:
	  extInfosSet_number(data, nodes);
	  break;
	case 2:
	  extInfosSet_element(data, nodes);
	  break;
	default:
	  extInfosSet_data(data, DATA_NODE(infos), nodes);
	}
    }
}


/*************/
/* Callbacks */
/*************/
static void onEditedPick(GtkCellRendererText *cellrenderertext _U_,
			 gchar *path, gchar *text, gpointer user_data)
{
  gboolean valid;
  GtkTreeIter iter;
  gchar *label;
  GList *lst;
  DataNode *data;
  RenderingWindow *window;
  VisuData *dataObj;
  gint number;

  valid = gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(listDataNode),
						  &iter, path);
  if (!valid)
    {
      g_warning("Wrong 'path' argument for 'onEditedPick'.");
      return;
    }

  gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
		     COLUMN_BASE_NUMBER, &number, -1);

  DBG_fprintf(stderr, "Gtk Pick: edited value on the fly.\n");
  lst = nodeDataGet_list();
  data = (DataNode*)g_list_nth_data(lst, GPOINTER_TO_INT(user_data));
  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  dataObj = renderingWindowGet_visuData(window);
  valid = nodeDataSet_valueAsString
    (data, dataObj,visuDataGet_nodeFromNumber(dataObj, number - 1), text, &label);
  if (!valid)
    visuGtkRaise_warning(_("Reading values"),
			 _("Wrong format. Impossible to parse the data associated"
			   " to the selected node."), (GtkWindow*)0);
  /* Change the value of the text in the list store. */
  gtk_list_store_set(listDataNode, &iter,
		     GPOINTER_TO_INT(user_data) * NB_COLUMN_DATA + NB_COLUMN_BASE,
		     label, -1);
  g_free(label);
}
static void onNodePropertyUsed(DataNode* data _U_, VisuData *dataObj,
			       gpointer user_data _U_)
{
  RenderingWindow *window;
  VisuData *current;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  current = renderingWindowGet_visuData(window);
  DBG_fprintf(stderr, "Gtk Pick: caught 'PropertyUsed' for %p (current %p).\n",
	      (gpointer)dataObj, (gpointer)current);
  if (current == dataObj)
    /* We update the combo for properties. */
    populateComboInfos(dataObj);
}
static void onNodePropertyUnused(DataNode* data _U_, VisuData *dataObj,
				 gpointer user_data _U_)
{
  RenderingWindow *window;
  VisuData *current;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  current = renderingWindowGet_visuData(window);
  DBG_fprintf(stderr, "Gtk Pick: caught 'PropertyUnused' for %p (current %p).\n",
	      (gpointer)dataObj, (gpointer)current);
  if (current == dataObj)
    /* We update the combo for properties. */
    populateComboInfos(dataObj);
}
static void onNodePropertyChanged(DataNode* data, VisuData *dataObj,
				  gpointer user_data _U_)
{
  GtkTreeIter iter;
  gboolean valid;
  int i, nodeId;
  GList *tmpLst;
  gchar *label, *values;
  VisuNode *node;
  gpointer infos;

  DBG_fprintf(stderr, "Gtk Pick: caught the 'valueChanged' signal.\n");

  valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(listDataNode), &iter);
  while (valid)
    {
      gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
			 COLUMN_BASE_NUMBER, &nodeId, -1);
      node = visuDataGet_nodeFromNumber(dataObj, nodeId - 1);
      g_return_if_fail(node);

      /* Store the additional data informations. */
      tmpLst = nodeDataGet_list();
      i = NB_COLUMN_BASE + NB_COLUMN_DATA * g_list_index(tmpLst, data);
      label = nodeDataGet_valueAsString(data, dataObj, node);
      if (!label)
	values = _("<i>None</i>");
      else
	values = label;
      gtk_list_store_set(listDataNode, &iter,
			 i + COLUMN_DATA_LABEL, values, -1);
      if (label)
	g_free(label);

      valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(listDataNode), &iter);
    }

  /* We rebuild the list for the drawn data if the dataNode match the current one. */
  /* We get what data to draw. */
  valid = gtk_combo_box_get_active_iter(GTK_COMBO_BOX(comboDraw), &iter);
  g_return_if_fail(valid);

  gtk_tree_model_get(GTK_TREE_MODEL(listComboInfos), &iter,
		     COLUMN_COMBO_POINTER, &infos,
		     -1);
  if (infos == (gpointer)data &&
      !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawNever)))
    {
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawSelected)))
	drawDataOnNode(dataObj, DRAW_SELECTED);
      else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawAlways)))
	drawDataOnNode(dataObj, DRAW_ALWAYS);
    }
}
static void onComboInfosChanged(GtkComboBox *combo _U_, gpointer data _U_)
{
  RenderingWindow *window;
  VisuData *dataObj;

  window = visuRenderingWindowGet_current();
  dataObj = renderingWindowGet_visuData(window);
  g_return_if_fail(dataObj);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawNever)))
    drawDataOnNode(dataObj, DRAW_NEVER);
  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawSelected)))
    drawDataOnNode(dataObj, DRAW_SELECTED);
  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawAlways)))
    drawDataOnNode(dataObj, DRAW_ALWAYS);
  g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onRadioDrawInfos(GtkToggleButton *togglebutton, gpointer user_data)
{
  RenderingWindow *window;
  VisuData *data;

  if (!gtk_toggle_button_get_active(togglebutton))
    return;

  window = visuRenderingWindowGet_current();
  data = renderingWindowGet_visuData(window);
  g_return_if_fail(data);

  drawDataOnNode(data, GPOINTER_TO_INT(user_data));
  g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onDrawDistanceChecked(GtkToggleButton* button, gpointer data _U_)
{
  RenderingWindow *window;
  PickMesure *pickMesure;

  window = visuRenderingWindowGet_current();
  pickMesure = (PickMesure*)visuDataGet_property(renderingWindowGet_visuData(window),
						 "pickMesure_data");
  g_return_if_fail(pickMesure);
  pickMesureSet_storeDistance(pickMesure, gtk_toggle_button_get_active(button));
}
static void onEraseDistanceClicked(GtkButton *button _U_, gpointer user_data _U_)
{
  RenderingWindow *window;
  PickMesure *pickMesure;

  window = visuRenderingWindowGet_current();
  pickMesure = (PickMesure*)visuDataGet_property(renderingWindowGet_visuData(window),
						 "pickMesure_data");
  g_return_if_fail(pickMesure);
  DBG_fprintf(stderr, "Gtk Pick: clicked on 'erase all distances' button.\n");
  if (pickMesureRemove_allDistanceMarks(pickMesure))
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onVisuDataChanged(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  GtkTreeIter iter, removedIter;
  gboolean valid, removed;
  int number;
  VisuNode *node;

  if (dataObj)
    {
      DBG_fprintf(stderr, "Gtk Pick: caught 'dataReadyForRendering' signal.\n");

      g_signal_connect(G_OBJECT(dataObj), "NodePopulationDecrease",
		       G_CALLBACK(onNodeRemoved), (gpointer)0);

      /* Rebuild the combo of properties. */
      populateComboInfos(dataObj);

      /* Try to match the selected nodes to new ones in the new visuData. */
      valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(listDataNode), &iter);
      while (valid)
	{
	  removed = FALSE;
	  gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
			     COLUMN_BASE_NUMBER, &number,
			     -1);
	  node = visuDataGet_nodeFromNumber(dataObj, number - 1);
	  if (node)
	    addNodeAtIter(node, &iter);
	  else
	    {
	      removed = TRUE;
	      removedIter = iter;
	    }

	  valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(listDataNode), &iter);
	  if (removed)
	    gtk_list_store_remove(listDataNode, &removedIter);
	}
    }
  else
    {
      /* Clear the node data. */  
      gtk_list_store_clear(listDataNode);
      /* Clear the combobox of properties. */
      gtk_list_store_clear(listComboInfos);
    }
}
static void onNodeRemoved(VisuData *visuData, int *nodeNumbers, gpointer data _U_)
{
  GtkTreeIter iter, removeIter;
  gboolean valid;
  int number, i;
  gboolean found;

  DBG_fprintf(stderr, "Gtk Pick: caught the 'NodePopulationDecrease' signal.\n");

  valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(listDataNode), &iter);
  while (valid)
    {
      gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
			 0, &number,
			 -1);
      found = FALSE;
      for (i = 0; !found && nodeNumbers[i] >= 0; i++)
	if (number == (nodeNumbers[i] + 1))
	  {
	    removeIter = iter;
	    found = TRUE;
	  }
			 
      valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(listDataNode), &iter);
      if (found)
	gtk_list_store_remove(listDataNode, &removeIter);
    };
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawNever)))
    drawDataOnNode(visuData, DRAW_NEVER);
  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawSelected)))
    drawDataOnNode(visuData, DRAW_SELECTED);
  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawAlways)))
    drawDataOnNode(visuData, DRAW_ALWAYS);
}
static gboolean onTreeviewInfosKey(GtkWidget *widget, GdkEventKey *event,
				   gpointer user_data _U_)
{
  RenderingWindow *window;
  VisuData *data;
  GList *selectedPaths, *tmpLst;
  GtkTreeIter iter, *iterCpy;
  GtkTreeModel *model;
  gboolean valid;

  DBG_fprintf(stderr, "Gtk Pick: key pressed on treeview '%d'.\n", event->keyval);
  
  if (event->keyval != GDK_Delete && event->keyval != GDK_BackSpace)
    return FALSE;

  selectedPaths = gtk_tree_selection_get_selected_rows
    (gtk_tree_view_get_selection(GTK_TREE_VIEW(widget)), &model);

  /* Transform all paths to iters in the list. */
  tmpLst = selectedPaths;
  while (tmpLst)
    {
      DBG_fprintf(stderr, " | remove path '%s'.\n",
		  gtk_tree_path_to_string((GtkTreePath*)tmpLst->data));

      valid = gtk_tree_model_get_iter(model, &iter, (GtkTreePath*)tmpLst->data);
      g_return_val_if_fail(valid, FALSE);

      gtk_tree_path_free((GtkTreePath*)tmpLst->data);
      iterCpy = gtk_tree_iter_copy(&iter);
      /* Replace the path with the tree iter. */
      tmpLst->data = (gpointer)iterCpy;

      tmpLst = g_list_next(tmpLst);
    };
  /* Then remove all iters. */
  g_signal_handler_block(G_OBJECT(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeviewDataNode))), selectedRowSignal);
  tmpLst = selectedPaths;
  while (tmpLst && tmpLst->next)
    {
      gtk_list_store_remove(listDataNode, (GtkTreeIter*)tmpLst->data);
      gtk_tree_iter_free((GtkTreeIter*)tmpLst->data);
      tmpLst = g_list_next(tmpLst);
    };
  g_signal_handler_unblock(G_OBJECT(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeviewDataNode))), selectedRowSignal);
  if (tmpLst)
    {
      gtk_list_store_remove(listDataNode, (GtkTreeIter*)tmpLst->data);
      gtk_tree_iter_free((GtkTreeIter*)tmpLst->data);
    }
  g_list_free(selectedPaths);
  
  /* If the draw informations is on selected nodes, we need to redraw. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioDrawSelected)))
    {
      window = RENDERING_WINDOW(visuRenderingWindowGet_current());
      data = renderingWindowGet_visuData(window);
      g_return_val_if_fail(data, FALSE);

      drawDataOnNode(data, DRAW_SELECTED);

      g_idle_add(visuObjectRedraw, (gpointer)0);
    }
  return FALSE;
}
static void onSelectionChanged(GtkTreeSelection *tree, gpointer data _U_)
{
  GList *tmpLst, *list;
  RenderingWindow *window;
  VisuData *dataObj;
  PickMesure *mesureData;
  GtkTreeIter iter;
  gboolean validIter;
  int nodeId;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  dataObj = renderingWindowGet_visuData(window);
  mesureData = (PickMesure*)visuDataGet_property(dataObj, "pickMesure_data");

  /* De-highlight previously selected rows. */
  tmpLst = selectedRow;
  while(tmpLst)
    {
      pickMesureSet_highlight(mesureData, GPOINTER_TO_INT(tmpLst->data), FALSE);
      tmpLst = g_list_next(tmpLst);
    }
  g_list_free(selectedRow);
  selectedRow = (GList*)0;

  /* Highlight the newly selected rows. */
  tmpLst = list = gtk_tree_selection_get_selected_rows(tree, NULL);
  while(tmpLst)
    {
      validIter = gtk_tree_model_get_iter(GTK_TREE_MODEL(listDataNode), &iter,
					  (GtkTreePath*)tmpLst->data);
      gtk_tree_path_free((GtkTreePath*)tmpLst->data);
      g_return_if_fail(validIter);

      gtk_tree_model_get(GTK_TREE_MODEL(listDataNode), &iter,
			 COLUMN_BASE_NUMBER, &nodeId,
			 -1);
      selectedRow = g_list_prepend(selectedRow, GINT_TO_POINTER(nodeId - 1));
      pickMesureSet_highlight(mesureData, nodeId - 1, TRUE);
      tmpLst = g_list_next(tmpLst);
    }
  g_list_free(list);

  g_idle_add(visuObjectRedraw, (gpointer)0);
}
