/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "visu_nodes.h"

#include <stdlib.h>

#include "visu_tools.h"


int visuNodeSet_visibility(VisuNode* node, gboolean visibility)
{
  g_return_val_if_fail(node, 0);

  if (node->rendered == (int)visibility)
    return 0;
  node->rendered = (int)visibility;
  return 1;
}
gboolean visuNodeGet_visibility(VisuNode* node)
{
  g_return_val_if_fail(node, FALSE);

  if (node->rendered)
    return TRUE;
  else
    return FALSE;
}

void visuNodeSet_newValues(VisuNode *node, double x, double y, double z, 
			   int number, int rendered, int posEle, int posNod)
{
  int k;

  g_return_if_fail(node);

  node->x = x;
  node->y = y;
  node->z = z;
  for (k = 0; k < 3; k++)
    node->translation[k] = 0.;
  node->number = number;
  node->rendered = rendered;
  node->posElement = posEle;
  node->posNode = posNod;
}
