/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_DUMP_H
#define VISU_DUMP_H


#include <glib.h>
#include <glib-object.h>

#include "visu_tools.h"
#include "coreTools/toolFileFormat.h"
#include "visu_data.h"

/**
 * writeDumpFunc:
 * @format: a #FileFormat object, corresponding to the write method ;
 * @buffer: a GString to store some error (not NULL) ;
 * @fileName: a string that defined the file to write to ;
 * @width: an integer ;
 * @height: an integer.
 * @dataObj: the #VisuData to be exported ;
 * @image: the data to be written ;
 * @functionWait: a method to call periodically during the dump ;
 * @data: some pointer on object to be passed to the wait function.
 *
 * This is a prototype of a method implemented by a dumping extension that is called
 * when the current rendering must be dumped to a file.
 *
 * Returns: 0 if everything goes right.
 */
typedef int (*writeDumpFunc) (FileFormat *format, GString *buffer,
			      char* fileName, int width, int height,
			      VisuData *dataObj, guchar* image,
			      voidDataFunc functionWait, gpointer data);

/**
 * DumpType_struct
 * @bitmap: TRUE if the the format requires to export the view into a bitmap ;
 * @fileType: a #FileFormat ;
 * @writeFunc: a pointer to a write func.
 *
 * This structure is used to store a dumping extension. Such an extension is characterized
 * by its #FileFormat and a method that can write a file from the current rendered data.
 */
struct DumpType_struct
{
  gboolean bitmap;
  FileFormat *fileType;
  writeDumpFunc writeFunc;
};
/**
 * DumpType:
 *
 * Common name for #DumpType_struct structures.
 */
typedef struct DumpType_struct DumpType;

/**
 * initDumpModuleFunc:
 *
 * This protoype defines initializing function for dumping extension.
 * Create such a funcction an add its name in the list #listInitDumpModuleFunc
 * defined in dumpModules/externalDumpModules.h thus the new dumping extension
 * will be initialized on startup.
 *
 * Returns: a newly allocated #DumpType.
 */
typedef DumpType* (*initDumpModuleFunc) ();

/**
 * getAllDumpModules:
 *
 * All dumping extensions are stored in an opaque way in V_Sim. But they
 * can be listed by a call to this method.
 *
 * Returns: a list of all the known dumping extensions. This list
 *          is own by V_Sim and should be considered read-only.
 */
GList* getAllDumpModules();
/**
 * getNbDumpModules:
 * 
 * A convinient way to know how dumping extensions are registered.
 *
 * Returns: the number of known dumping extensions.
 */
int getNbDumpModules();

/**
 * abortDump:
 * @obj: an object ;
 * @data: some data.
 *
 * Does nothing for the moment.
 */
void abortDump(GObject *obj, gpointer data);

/**
 * initDumpModule
 *
 * This method is used to initialized the system of dumping extension.
 * It should not be called after startup process is finished.
 *
 * Returns: 0 if everything ran smoothly.
 */
int initDumpModule();


/****************/
/* Private area */
/****************/

GList *allDumpModuleList;
int nbDumpModules;

#endif
