/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef TOOLCONFIGFILE_H
#define TOOLCONFIGFILE_H

#include <visu_elements.h>

/**
 * CONFIG_FILE_ERROR:
 *
 * Domain used to parse config files.
 */
GQuark CONFIG_FILE_ERROR;
/**
 * toolConfigFileError:
 * @CONFIG_FILE_ERROR_EMPTY_LINE: error when reading the file, found an empty line,
 *                                where something should have been.
 * @CONFIG_FILE_ERROR_BAD_ELEMENT_NAME: error when reading a #VisuElement name.
 * @CONFIG_FILE_ERROR_MAX_ELEMENT: error because too much #VisuElement have been created.
 * @CONFIG_FILE_ERROR_CREATED_ELEMENT: error when creating a new #VisuElement.
 * @CONFIG_FILE_ERROR_VALUE: error of file format, values read are out of bounds.
 * @CONFIG_FILE_ERROR_READ: error of file format (can't read variables...).
 * @CONFIG_FILE_ERROR_MISSING: error of file format (missing variables...).
 *
 * Possible errors when parsing a config file.
 */
typedef enum
  {
    CONFIG_FILE_ERROR_EMPTY_LINE,
    CONFIG_FILE_ERROR_BAD_ELEMENT_NAME,
    CONFIG_FILE_ERROR_MAX_ELEMENT,
    CONFIG_FILE_ERROR_CREATED_ELEMENT,
    CONFIG_FILE_ERROR_VALUE,
    CONFIG_FILE_ERROR_READ,
    CONFIG_FILE_ERROR_MISSING
  } toolConfigFileError;

/**
 * configFileRead_floatFromTokens:
 * @tokens: array of tokens resulting from a call to g_strsplit() with " " as separator ;
 * @position: IN, the position of the beginning in @tokens ; OUT, one token
 *            after the last read ;
 * @values: allocated area to store read values ;
 * @size: the number of floating point values to be read ;
 * @lineId: the number of the line of the config
 *          file which the @line argument is taken from ;
 * @error: a location to store a possible reading error.
 *
 * Read @size floating point values from @tokens, store them in @values and returns
 * the new head in @tokens.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_floatFromTokens(gchar **tokens, int *position, float *values,
					guint size, int lineId, GError **error);
/**
 * configFileRead_float:
 * @line: string where values are read from ;
 * @position: the number of the line of the config
 *            file which the @line argument is taken from ;
 * @values: allocated area to store read values ;
 * @size: the number of floating point values to be read ;
 * @error: a location to store a possible reading error.
 *
 * Read @size floating point values from @line and store them in @values.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_float(gchar *line, int position, float *values,
			      guint size, GError **error);
/**
 * configFileRead_floatWithElement:
 * @line: string where values are read from ;
 * @position: the number of the line of the config
 *            file which the @line argument is taken from ;
 * @values: allocated area to store read values ;
 * @size: the number of floating point values to be read ;
 * @ele: a pointer to a #VisuElement location ;
 * @error: a location to store a possible reading error.
 *
 * Same as configFileRead_float() but begins by reading an element
 * at the begining of the line.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_floatWithElement(gchar *line, int position, float *values,
					 guint size, VisuElement **ele, GError **error);


/**
 * configFileRead_booleanFromTokens:
 * @tokens: array of tokens resulting from a call to g_strsplit() with " " as separator ;
 * @position: IN, the position of the beginning in @tokens ; OUT, one token
 *            after the last read ;
 * @values: allocated area to store read values ;
 * @size: the number of floating point values to be read ;
 * @lineId: the number of the line of the config
 *          file which the @line argument is taken from ;
 * @error: a location to store a possible reading error.
 *
 * Read @size boolean values from @tokens, store them in @values and returns
 * the new head in @tokens.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_booleanFromTokens(gchar **tokens, int *position, gboolean *values,
					  guint size, int lineId, GError **error);
/**
 * configFileRead_boolean:
 * @line: string where values are read from ;
 * @position: the number of the line of the config
 *            file which the @line argument is taken from ;
 * @values: allocated area to store read values ;
 * @size: the number of boolean values to be read ;
 * @error: a location to store a possible reading error.
 *
 * Read @size boolean values from @line and store them in @values.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_boolean(gchar *line, int position, gboolean *values,
				guint size, GError **error);
/**
 * configFileRead_booleanWithElement:
 * @line: string where values are read from ;
 * @position: the number of the line of the config
 *            file which the @line argument is taken from ;
 * @values: allocated area to store read values ;
 * @size: the number of boolean values to be read ;
 * @ele: a pointer to a #VisuElement location ;
 * @error: a location to store a possible reading error.
 *
 * Same as configFileRead_boolean() but begins by reading an element
 * at the begining of the line.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_booleanWithElement(gchar *line, int position, gboolean *values,
					   guint size, VisuElement **ele, GError **error);



/**
 * configFileRead_stringFromTokens:
 * @tokens: array of tokens resulting from a call to g_strsplit() with " " as separator ;
 * @position: IN, the position of the beginning in @tokens ; OUT, one token
 *            after the last read ;
 * @values: a location to point on a gchar** ;
 * @size: the number of floating point values to be read ;
 * @lineId: the number of the line of the config
 *          file which the @line argument is taken from ;
 * @error: a location to store a possible reading error.
 *
 * Read @size strings from @tokens, store them in @values and returns
 * the new head in @tokens.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_stringFromTokens(gchar **tokens, int *position, gchar ***values,
					 guint size, int lineId, GError **error);
/**
 * configFileRead_string:
 * @line: string where values are read from ;
 * @position: the number of the line of the config
 *            file which the @line argument is taken from ;
 * @values: a location to point on a gchar** ;
 * @size: the number of strings to be read ;
 * @error: a location to store a possible reading error.
 *
 * Read @size strings from @line and @values points on them.
 *
 * Returns: TRUE if no error occured, then @values point on an allocated
 *          memory area that is NULL terminated and that must be freed
 *          with g_strfreev().
 */
gboolean configFileRead_string(gchar *line, int position, gchar ***values,
			       guint size, GError **error);
/**
 * configFileRead_stringWithElement:
 * @line: string where values are read from ;
 * @position: the number of the line of the config
 *            file which the @line argument is taken from ;
 * @values: a location to point on a gchar** ;
 * @size: the number of strings to be read ;
 * @ele: a pointer to a #VisuElement location ;
 * @error: a location to store a possible reading error.
 *
 * Same as configFileRead_string() but begins by reading an element
 * at the begining of the line.
 *
 * Returns: TRUE if no error occured, then @values point on an allocated
 *          memory area that is NULL terminated and that must be freed
 *          with g_strfreev().
 */
gboolean configFileRead_stringWithElement(gchar *line, int position, gchar ***values,
					  guint size, VisuElement **ele, GError **error);


/**
 * configFileRead_elementFromTokens:
 * @tokens: array of tokens resulting from a call to g_strsplit() with " " as separator ;
 * @position: IN, the position of the beginning in @tokens ; OUT, one token
 *            after the last read ;
 * @values: allocated area to store read values ;
 * @size: the number of floating point values to be read ;
 * @lineId: the number of the line of the config
 *          file which the @line argument is taken from ;
 * @error: a location to store a possible reading error.
 *
 * Read @size #VisuElement from @tokens, store them in @values and returns
 * the new head in @tokens.
 *
 * Returns: TRUE if no error occured.
 */
gboolean configFileRead_elementFromTokens(gchar **tokens, int *position, VisuElement **values,
					  guint size, int lineId, GError **error);

#endif
