-- UUAGC 0.9.5 (ErrorMessages.ag)
module ErrorMessages where

import UU.Scanner.Position(Pos)
import Pretty
import DepTypes(Trace)
import CodeSyntax
import CommonTypes
-- Error -------------------------------------------------------
{-
   alternatives:
      alternative ChildAsLocal:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child var            : {Name}
      alternative CustomError:
         child isWarning      : {Bool}
         child pos            : {Pos}
         child mesg           : {PP_Doc}
      alternative CyclicSet:
         child name           : {Name}
      alternative DirectCirc:
         child nt             : {Nonterminal}
         child o_visit        : {Bool}
         child cyclic         : {[((Name,Name),[String],[String])]}
      alternative DupAlt:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child occ1           : {Constructor}
      alternative DupChild:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child name           : {Name}
         child occ1           : {Name}
      alternative DupInhAttr:
         child nt             : {Nonterminal}
         child attr           : {Name}
         child occ1           : {Name}
      alternative DupRule:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child field          : {Name}
         child attr           : {Name}
         child occ1           : {Name}
      alternative DupSet:
         child name           : {Nonterminal}
         child occ1           : {Nonterminal}
      alternative DupSig:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child attr           : {Name}
      alternative DupSynAttr:
         child nt             : {Nonterminal}
         child attr           : {Name}
         child occ1           : {Name}
      alternative DupSynonym:
         child nt             : {Nonterminal}
         child occ1           : {Nonterminal}
      alternative ErroneousOrder:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child order          : {Dependency}
      alternative InducedCirc:
         child nt             : {Nonterminal}
         child cinter         : {CInterface}
         child cyclic         : {[((Name,Name),[String],[String])]}
      alternative InstCirc:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child attr           : {Name}
         child o_visit        : {Bool}
         child path           : {[String]}
      alternative LocalCirc:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child attr           : {Name}
         child o_visit        : {Bool}
         child path           : {[String]}
      alternative MissingInstSig:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child attr           : {Name}
      alternative MissingRule:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child field          : {Name}
         child attr           : {Name}
      alternative MissingTypeSig:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child attr           : {Name}
      alternative ParserError:
         child pos            : {Pos}
         child problem        : {String}
         child action         : {String}
      alternative SuperfluousRule:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child field          : {Name}
         child attr           : {Name}
      alternative UndefAlt:
         child nt             : {Nonterminal}
         child con            : {Constructor}
      alternative UndefAttr:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child field          : {Name}
         child attr           : {Name}
      alternative UndefChild:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child name           : {Name}
      alternative UndefLocal:
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child var            : {Name}
      alternative UndefNont:
         child nt             : {Nonterminal}
-}
data Error = ChildAsLocal (Nonterminal) (Constructor) (Name)
           | CustomError (Bool) (Pos) (PP_Doc)
           | CyclicSet (Name)
           | DirectCirc (Nonterminal) (Bool) ([((Name,Name),[String],[String])])
           | DupAlt (Nonterminal) (Constructor) (Constructor)
           | DupChild (Nonterminal) (Constructor) (Name) (Name)
           | DupInhAttr (Nonterminal) (Name) (Name)
           | DupRule (Nonterminal) (Constructor) (Name) (Name) (Name)
           | DupSet (Nonterminal) (Nonterminal)
           | DupSig (Nonterminal) (Constructor) (Name)
           | DupSynAttr (Nonterminal) (Name) (Name)
           | DupSynonym (Nonterminal) (Nonterminal)
           | ErroneousOrder (Nonterminal) (Constructor) (Dependency)
           | InducedCirc (Nonterminal) (CInterface) ([((Name,Name),[String],[String])])
           | InstCirc (Nonterminal) (Constructor) (Name) (Bool) ([String])
           | LocalCirc (Nonterminal) (Constructor) (Name) (Bool) ([String])
           | MissingInstSig (Nonterminal) (Constructor) (Name)
           | MissingRule (Nonterminal) (Constructor) (Name) (Name)
           | MissingTypeSig (Nonterminal) (Constructor) (Name)
           | ParserError (Pos) (String) (String)
           | SuperfluousRule (Nonterminal) (Constructor) (Name) (Name)
           | UndefAlt (Nonterminal) (Constructor)
           | UndefAttr (Nonterminal) (Constructor) (Name) (Name)
           | UndefChild (Nonterminal) (Constructor) (Name)
           | UndefLocal (Nonterminal) (Constructor) (Name)
           | UndefNont (Nonterminal)
-- Errors ------------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : Error
         child tl             : Errors
      alternative Nil:
-}
type Errors = [Error]
