# μTox [![Build Status](https://travis-ci.org/uTox/uTox.svg?branch=develop)](https://travis-ci.org/uTox/uTox) [![Build status](https://ci.appveyor.com/api/projects/status/bswtxxs4e93rdw2u/branch/appveyor-ci?svg=true)](https://ci.appveyor.com/project/redmanmale/utox)  [![Coverage](https://img.shields.io/badge/coverage-0.01%25-red.svg)](#) [![IRC](https://img.shields.io/badge/freenode-%23utox-brightgreen.svg)](https://webchat.freenode.net/?channels=#utox)

The lightweight [Tox](https://github.com/TokTok/toxcore) client.

[**TokTok Site**](http://toktok.github.io/) **|** [**Installing**](docs/INSTALL.md) **|** [**Changelog**](CHANGELOG.md) **|** [**Compiling**](docs/BUILD.md) **|** [**Toxcore Spec**](https://toktok.github.io/spec)

You shouldn't have to choose a new client for every device: So µTox works everywhere! On every major system **Windows**, **macOS**, **Linux**, **Android**, **FreeBSD**, **NetBSD**, **OpenBSD**, and even **DragonFlyBSD**.

## Downloads
- **Windows**
  - [32bit Version](https://build.tox.chat/view/uTox/job/uTox_build_windows_x86_debug/lastSuccessfulBuild/artifact/utox_windows_x86_debug.zip)
  - [64bit Version](https://build.tox.chat/view/uTox/job/uTox_build_windows_x86-64_release/lastSuccessfulBuild/artifact/utox_windows_x86-64.zip)
  - [Windows XP Version](https://build.tox.chat/job/uTox-nightly-FOR-WIN-XP_build_windows_x86_debug/lastSuccessfulBuild/artifact/utox_nightly.zip)
- **Linux/Posix**
  - [static x86-64](https://build.tox.chat/view/uTox/job/uTox_build_linux_x86-64_release/lastSuccessfulBuild/artifact/utox_linux_x86-64.tar.xz)
  - [static x86](https://build.tox.chat/view/uTox/job/uTox_build_linux_x86_release/lastSuccessfulBuild/artifact/utox_linux_x86.tar.xz)
- **macOS**
  - [Last Updated .dmg](https://github.com/uTox/uTox/releases/download/v0.16.1/uTox-0.16.1.dmg) (*could be out of date, check the version list below*)
  - [Version List](https://github.com/uTox/uTox/releases)
- **Android**
  - [uTox Android on Google Play](https://play.google.com/apps/testing/tox.client.utox) **You should use [Antox](https://play.google.com/store/apps/details?id=chat.tox.antox&hl=en)
  - [Direct apk](https://build.tox.chat/view/uTox/job/uTox_build_android_armhf_release/lastSuccessfulBuild/artifact/uTox.apk) (You may need to uninstall the previous version.)

## Features
- Avatars
- Secure person to person conversations:
  - Video (Webcam or Desktop sharing)
  - Audio
  - Text
    - Chat History
  - Screenshots
- Group chats
  - New API support ready.
- File transfers, with inline images support
- Tox URI support (clickable Tox links)
- Emoticons

Just like Toxcore, µTox is still alpha software, so you may encounter bugs, or maybe a crash or two. µTox also needs your help, if you do encounter any bugs or problems please [open an issue](https://github.com/uTox/uTox/issues/new).

## Screenshots
μTox running on Windows 10

![μTox on Windows 10](images/utox-windows10.png "μTox running on Windows 10")

μTox running on macOS:

![μTox on macOS](images/utox-osx.png "μTox running on macOS")

μTox running on Linux (Ubuntu)

![μTox on Linux](images/utox-linux.png "μTox running on Linux (Ubuntu)")

## Team
GitLab | IRC | Email | Fingerprint
--- | --- | --- | ---
@cebe | CeBe | mail@cebe.cc | `E592 6050 AE9C 234A FF84 96FE BE4F 41DE 1DEE EED0`
@endoffile78 | e0f/endoffile | endoffile78@yahoo.com | `7AED 9A17 0C81 E601 DA4E EE27 9043 0614 21EF 90FA`
@TheGrayHatter | grayhatter | greg@grayhatter.com | `9D1D 5990 88E2 23DD 9900 7DE2 AEA1 0D4E A053 0876`
@robinlinden | robinli | dev@robinlinden.eu | `B700 8FF1 2C07 9BF6 E6EA 19D1 601A 604B 7E60 5776`
@dkmoz | dkmoz | dkmoz@airmail.cc | `E28E 7252 B1E7 FCFE D358  CF8E 3763 B3A7 93AA FA0F`
@redmanmale | redmanmale | redmanmale@gmail.com | `BCEE 99DC A339 ABF9 CC36  428D 61A9 B9AF D2E5 3885`
@ | avoidr | avoidr@firemail.cc | `A251 56FC 7AFB 5C03 65A0  407E 6F5D D1C5 371D E665`
